import QtQuick
import QtQuick.Controls

PentobiDialog {
    id: root

    footer: PentobiDialogButtonBox { ButtonClose { } }

    Item {
        implicitWidth:
            Math.max(Math.min(column.implicitWidth, maxContentWidth),
                     minContentWidth)
        implicitHeight: column.implicitHeight

        Column {
            id: column

            anchors.fill: parent
            spacing: 0.5 * font.pixelSize
            leftPadding: spacing
            rightPadding: leftPadding

            Image {
                source: "qrc:icon/pentobi-48.png"
                width: 48; height: 48
                sourceSize { width: 192; height: 192 }
                anchors.horizontalCenter: parent.horizontalCenter
            }
            Label {
                //: The argument is the application version.
                text: "<h3>" + qsTr("Pentobi %1").arg(Qt.application.version)
                font { bold: true }
                anchors.horizontalCenter: parent.horizontalCenter
            }
            Label {
                text: qsTr("Computer opponent for the board game Blokus")
                wrapMode: Text.Wrap
                horizontalAlignment: Text.AlignHCenter
                width: Math.min(implicitWidth, maxContentWidth)
                anchors.horizontalCenter: parent.horizontalCenter
            }
            Label {
                text: "<a href=\"https://pentobi.sourceforge.io\" style=\"text-decoration:none\">pentobi.sourceforge.io</a>"
                textFormat: Text.RichText
                elide: Qt.ElideRight
                width: Math.min(implicitWidth, maxContentWidth)
                anchors.horizontalCenter: parent.horizontalCenter
                onLinkActivated: Qt.openUrlExternally(link)

                MouseArea {
                    enabled: isDesktop
                    anchors.fill: parent
                    hoverEnabled: true
                    acceptedButtons: Qt.NoButton
                    cursorShape: containsMouse ? Qt.PointingHandCursor : Qt.ArrowCursor
                }
            }
            Label {
                text: qsTr("Copyright © 2011–%1 Markus Enzenberger").arg(2023)
                font.pixelSize: 0.9 * root.font.pixelSize
                opacity: 0.8
                wrapMode: Text.Wrap
                horizontalAlignment: Text.AlignHCenter
                width: Math.min(implicitWidth, maxContentWidth)
                anchors.horizontalCenter: parent.horizontalCenter
            }
        }
    }
}
