% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmDSdata.R
\docType{class}
\name{dmDSdata-class}
\alias{dmDSdata-class}
\alias{counts,dmDSdata-method}
\alias{samples}
\alias{samples,dmDSdata-method}
\alias{names,dmDSdata-method}
\alias{length,dmDSdata-method}
\alias{[,dmDSdata,ANY-method}
\alias{[,dmDSdata-method}
\title{dmDSdata object}
\usage{
\S4method{counts}{dmDSdata}(object)

samples(x, ...)

\S4method{samples}{dmDSdata}(x)

\S4method{names}{dmDSdata}(x)

\S4method{length}{dmDSdata}(x)

\S4method{[}{dmDSdata,ANY}(x, i, j)
}
\arguments{
\item{object, x}{dmDSdata object.}

\item{...}{Other parameters that can be defined by methods using this 
generic.}

\item{i, j}{Parameters used for subsetting.}
}
\value{
\itemize{ \item \code{counts(object)}: Get a data frame with counts. \item 
\code{samples(x)}: Get a data frame with the sample information. \item 
\code{names(x)}: Get the gene names. \item \code{length(x)}: Get the number 
of genes. \item \code{x[i, j]}: Get a subset of dmDSdata object that consists
of counts for genes i and samples j. }
}
\description{
dmDSdata contains expression, in counts, of genomic features such as exons or
transcripts and sample information needed for the differential 
exon/transcript usage (DEU or DTU) analysis. It can be created with function 
\code{\link{dmDSdata}}.
}
\section{Slots}{

\describe{
\item{\code{counts}}{\code{\linkS4class{MatrixList}} of expression, in counts, of 
genomic features. Rows correspond to genomic features, such as exons or 
transcripts. Columns correspond to samples. MatrixList is partitioned in a 
way that each of the matrices in a list contains counts for a single gene.}

\item{\code{samples}}{Data frame with information about samples. It must contain 
\code{sample_id} variable with unique sample names and other covariates 
that desribe samples and are needed for the differential analysis.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmDSdata object 
# --------------------------------------------------------------------------
## Get kallisto transcript counts from the 'PasillaTranscriptExpr' package

library(PasillaTranscriptExpr)
\donttest{
data_dir  <- system.file("extdata", package = "PasillaTranscriptExpr")

## Load metadata
pasilla_metadata <- read.table(file.path(data_dir, "metadata.txt"), 
header = TRUE, as.is = TRUE)

## Load counts
pasilla_counts <- read.table(file.path(data_dir, "counts.txt"), 
header = TRUE, as.is = TRUE)

## Create a pasilla_samples data frame
pasilla_samples <- data.frame(sample_id = pasilla_metadata$SampleName, 
  group = pasilla_metadata$condition)
levels(pasilla_samples$group)

## Create a dmDSdata object
d <- dmDSdata(counts = pasilla_counts, samples = pasilla_samples)

## Use a subset of genes, which is defined in the following file
gene_id_subset <- readLines(file.path(data_dir, "gene_id_subset.txt"))

d <- d[names(d) \%in\% gene_id_subset, ]
}
}
\seealso{
\code{\linkS4class{dmDSprecision}}, \code{\linkS4class{dmDSfit}},
  \code{\linkS4class{dmDStest}}
}
\author{
Malgorzata Nowicka
}
