% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_has_any}
\alias{ansi_has_any}
\title{Check if a string has some ANSI styling}
\usage{
ansi_has_any(string, sgr = TRUE, csi = TRUE, link = TRUE)
}
\arguments{
\item{string}{The string to check. It can also be a character
vector.}

\item{sgr}{Whether to look for SGR (styling) control sequences.}

\item{csi}{Whether to look for non-SGR control sequences.}

\item{link}{Whether to look for ANSI hyperlinks.}
}
\value{
Logical vector, \code{TRUE} for the strings that have some
ANSI styling.
}
\description{
Check if a string has some ANSI styling
}
\examples{
## The second one has style if ANSI colors are supported
ansi_has_any("foobar")
ansi_has_any(col_red("foobar"))
}
\seealso{
Other low level ANSI functions: 
\code{\link{ansi_hide_cursor}()},
\code{\link{ansi_regex}()},
\code{\link{ansi_string}()},
\code{\link{ansi_strip}()}
}
\concept{low level ANSI functions}
