% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candlestick.R, R/plotters.R
\name{dyCandlestick}
\alias{dyCandlestick}
\alias{Plotters}
\alias{dyBarChart}
\alias{dyStackedBarChart}
\alias{dyMultiColumn}
\alias{dyBarSeries}
\alias{dyStemSeries}
\alias{dyShadow}
\alias{dyFilledLine}
\alias{dyErrorFill}
\alias{dyMultiColumnGroup}
\alias{dyCandlestickGroup}
\alias{dyStackedBarGroup}
\alias{dyStackedLineGroup}
\alias{dyStackedRibbonGroup}
\title{Employ a dygraph plotter on a series, a group of series, or the whole dygraph}
\usage{
dyCandlestick(dygraph, compress = FALSE)

dyBarChart(dygraph)

dyStackedBarChart(dygraph)

dyMultiColumn(dygraph)

dyBarSeries(dygraph, name, ...)

dyStemSeries(dygraph, name, ...)

dyShadow(dygraph, name, ...)

dyFilledLine(dygraph, name, ...)

dyErrorFill(dygraph, name, ...)

dyMultiColumnGroup(dygraph, name, ...)

dyCandlestickGroup(dygraph, name, ...)

dyStackedBarGroup(dygraph, name, ...)

dyStackedLineGroup(dygraph, name, ...)

dyStackedRibbonGroup(dygraph, name, ...)
}
\arguments{
\item{dygraph}{Dygraph to add plotter to}

\item{compress}{(For dyCandlestick) If true, compress data yearly, quarterly, monthly, weekly or daily
according to overall amount of bars and/or current zoom level.}

\item{name}{name - or chrarcter vector of names - of (the) series within the data set}

\item{...}{additional options to pass to dySeries}
}
\value{
A dygraph with the specified plotter(s) employed.
}
\description{
Plotters provide variuos ways to customize how your data appears
on the dygraph.  Series-based plotters allow users to mix-and-match different plotters on a 
per-series or (with dyGroup) a per-group basis.  See \code{\link{dyPlotter}} for additional detail.
}
\section{Available plotters}{



Currently the dygraphs package provides the following plotters:

\describe{
   \item{dyBarChart()}{Draws a bar plot rather than a line plot. If the provided dygraph
features more than one series, dyBarChart will call dyMultiColumn instead.}

   \item{dyStackedBarChart()}{Draws a bar chart stacking all the underlying series.}

   \item{dyMultiColumn()}{Draws multiple column bar chart.} 
   \item{dyBarSeries()}{Draws a single set of bars for just the provided series.}

   \item{dyStemSeries()}{Draws a single set of stems for just the provided series.}

   \item{dyShadow()}{An extraction of the _fillplotter from dygraph-combined-dev.js, 
   drawing the filled area without the line.}

   \item{dyFilledLIne()}{An extraction of the _fillplotter and _lineplotter combo 
   from dygraph-combined-dev.js. dyFilledLine allows users to fill only a single series.}

   \item{dyMultiColumnGroup()}{The multicolumn plotter, but on a subset of the series, leaving 
   the others for other plotters.}

   \item{dyCandlestick()}{Draw a candlestick chart.}

   \item{dyCandleStickGroup()}{Employed on the provided series, 
   but still plotting the others.}
   
   \item{dyStackerBarGroup()}{Return the data group as stacked bars}

   \item{dyStackerRibbonGroup()}{Return the data group as stacked ribbons}

}
}

\examples{
## The following two examples will results in the same dygraph:

dygraph(mdeaths) \%>\% 
  dyBarChart()
 
lungDeaths <- cbind(mdeaths, fdeaths)
dygraph(lungDeaths) \%>\%
  dyMultiColumn()
  

## Per-series plotters:

lungDeaths <- cbind(mdeaths, fdeaths)
dygraph(lungDeaths) \%>\%
  dyBarSeries('fdeaths')

lungDeaths <- cbind(mdeaths, fdeaths)
dygraph(lungDeaths) \%>\%
  dyStemSeries('fdeaths')
  
lungDeaths <- cbind(mdeaths, fdeaths)
dygraph(lungDeaths) \%>\%
  dyShadow('fdeaths')

lungDeaths <- cbind(mdeaths, fdeaths)
dygraph(lungDeaths) \%>\%
  dyFilledLine('fdeaths')

## A bunch of different plotters together:

lungDeaths <- cbind(fdeaths, mdeaths, ldeaths, foo = fdeaths/2, bar = fdeaths/3)
dygraph(lungDeaths) \%>\%
  dyRangeSelector() \%>\%
  dyBarSeries('bar') \%>\% 
  dyStemSeries('mdeaths') \%>\% 
  dyShadow('foo') \%>\% 
  dyFilledLine('fdeaths')

## Group-based plotters:
  

## Candlestick plotters:
  
library(xts)
data(sample_matrix)
library(dygraphs)
dygraph(sample_matrix) \%>\%
  dyCandlestick()
  
sample<-data.frame(sample_matrix)
sample_2<-sample*2
names(sample_2)<-c('O', 'H', 'L', 'C')
sample<-cbind(sample, sample_2)
dygraph(sample) \%>\% 
  dyOptions(stackedGraph = TRUE) \%>\% 
  dyCandlestickGroup(c('Open', 'High', 'Low', 'Close')) \%>\% 
  dyCandlestickGroup(c('O', 'H', 'L', 'C'))

## Stacked Bar and Ribbon Graphs:  

dygraph(lungDeaths) \%>\% 
  dySeries('mdeaths', axis = 'y2') \%>\%
  dyAxis('y', valueRange = c(-100, 1000)) \%>\% 
  dyStackedBarGroup(c('ldeaths', 'fdeaths'))
  
lungDeaths <- cbind(ldeaths, fdeaths, mdeaths, 
                    additive = rep.int(200, length(ldeaths)),
                    line = rep.int(3000, length(ldeaths)))
dygraph(lungDeaths) \%>\% 
  dySeries('line', strokePattern = 'dashed') \%>\% 
  dySeries('ldeaths', stepPlot = TRUE) \%>\% 
  dyStackedBarGroup(c('additive', 'mdeaths')) \%>\% 
  dyStackedRibbonGroup(c('fdeaths', 'ldeaths'))
}
