% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.R, R/zxx.R
\name{scale_colour_discrete}
\alias{scale_colour_discrete}
\alias{scale_fill_discrete}
\alias{scale_color_discrete}
\title{Discrete colour scales}
\usage{
scale_colour_discrete(
  ...,
  palette = NULL,
  aesthetics = "colour",
  na.value = "grey50",
  type = getOption("ggplot2.discrete.colour")
)

scale_fill_discrete(
  ...,
  palette = NULL,
  aesthetics = "fill",
  na.value = "grey50",
  type = getOption("ggplot2.discrete.fill")
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{palette}{One of the following:
\itemize{
\item \code{NULL} for the default palette stored in the theme.
\item a character vector of colours.
\item a single string naming a palette.
\item a palette function that when called with a single integer argument (the
number of levels in the scale) returns the values that they should take.
}}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{na.value}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} The preferred mechanism for
setting the default palette is by using the theme. For example:
\code{theme(palette.colour.discrete = "Okabe-Ito")}.}
}
\description{
The default discrete colour scale.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point()

# You can use the scale to give a palette directly
p + scale_colour_discrete(palette = scales::pal_brewer(palette = "Dark2"))

# The default colours are encoded into the theme
p + theme(palette.colour.discrete = scales::pal_grey())

# You can globally set default colour palette via the theme
old <- update_theme(palette.colour.discrete = scales::pal_viridis())

# Plot now shows new global default
p

# Restoring the previous theme
theme_set(old)
}
\seealso{
\code{\link[=discrete_scale]{discrete_scale()}}

The \href{https://ggplot2-book.org/scales-colour#sec-colour-discrete}{discrete colour scales section} of the online ggplot2 book.

Other colour scales: 
\code{\link{scale_alpha}()},
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_continuous}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_identity}()},
\code{\link{scale_colour_manual}()},
\code{\link{scale_colour_steps}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{colour scales}
