/*
 * sma -- Sendmail log analyser
 *
 * Copyright (c) 2000 - 2003 Jarkko Turkulainen. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JARKKO TURKULAINEN ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JARKKO TURKULAINEN BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Date: 2002/09/12 11:36:00 $
 */


#include "sma.h"

int isspace(int);

void
init(FILE *conf) {
	char buff[1024];
	char *str1, *str2;
	int k, i, lines;

 	lines = 0;
	while (fgets(buff, 1024, conf)) {
		lines++;

		/* null-terminate: */
		buff[strlen(buff)-1] = '\0'; 

		/* skip leading white space: */
		for ( i = 0 ; isspace(buff[i]) ; i++) 
			;
		
		/* empty line? */
		if (!strlen(&buff[i])) 
			continue;

		/* comment? */
		if (!strncmp("#", &buff[i], 1)) 
			continue;

		/* fetch key and value: */

		k = 0;
		str1 = get_string(&buff[i]);
		i += strlen(&buff[i])+1;
		for ( ; isspace(buff[i]) ; i++ )
			;
		k = 1;
		str2 = get_string(&buff[i]);

		/* if not found... */
		if (!strlen(str2)) {
			if (!qflag)	
				fprintf(stderr, "%s: config file parse"
					" error, line %d\n", pname, lines);
		/* Parse configuration keys */
		} else {
			if (!strncmp(str1, "EnvelopePairs", 13)) {
				epnum = atoi(str2);
        	        } else if (!strncmp(str1, "EnvelopeSenders", 15)) {
				if (!lflag) {
					lrflag = 1;
					lnum = atoi(str2);
				}
        	        } else if (!strncmp(str1, "EnvelopeRecipients", 18)) {
				if (!lflag) {
					lrflag = 1;
					lrnum = atoi(str2);
				}
			} else if (!strncmp(str1, "RelayPairs", 10)) {
				rpnum = atoi(str2);
        	        } else if (!strncmp(str1, "RelaySenders", 12)) {
				if (!rflag) {
					rrflag = 1;
					rnum = atoi(str2);
				}
        	        } else if (!strncmp(str1, "RelayRecipients", 15)) {
				if (!rflag) {
					rrflag = 1;
					rrnum = atoi(str2);
				}
        	        } else if (!strncmp(str1, "Comment", 7)) {
				if (!Cflag)
					if (!(Cchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "BounceAddress", 13)) {
				 	if (!(bechar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "ShowUsers", 9)) {
				if (strncmp(str2, "yes", 3) && !dflag)
					dflag = 1;
        	        } else if (!strncmp(str1, "Format", 6)) {
				if (!Oflag) {
					Oflag = 1;
					if (!(Ochar = strdup(str2)))
						error_memory();
				}
        	        } else if (!strncmp(str1, "HostName", 8)) {
				if (!Hflag)
					if(!(Hchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "BgColor", 7)) {
				if (!bflag)
					if (!(bchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "TbColor", 7)) {
					if (!(tbchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "Debug", 5)) {
				if (!strncmp(str2, "yes", 3) && !vflag)
					vflag = 1;
        	        } else if (!strncmp(str1, "PrintTime", 9)) {
				if (strncmp(str2, "yes", 3) && !nflag)
					nflag = 1;
        	        } else if (!strncmp(str1, "PrintGeneralInfo", 16)) {
				if (!strncmp(str2, "no", 3))
					pgflag = 0;
        	        } else if (!strncmp(str1, "PrintStatus", 11)) {
					stnum = atoi(str2);
        	        } else if (!strncmp(str1, "PrintRuleset", 12)) {
					rsnum = atoi(str2);
        	        } else if (!strncmp(str1, "RulesetRelays", 13)) {
					rsrnum = atoi(str2);
        	        } else if (!strncmp(str1, "OutFile", 7)) {
				if (!oflag)
					if (!(ochar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "Sorting", 7)) {
				if (strncmp(str2, "number", 6) && !sflag)
					sflag = 1;
        	        } else if (!strncmp(str1, "Silent", 6)) {
				if (!strncmp(str2, "yes", 3) && !qflag)
					qflag = 1;
        	        } else if (!strncmp(str1, "SyslogTag", 9)) {
				if (!Lflag)
				 	if (!(Lchar = strdup(str2)))	
						error_memory();
        	        } else if (!strncmp(str1, "EnvelopeSenderFilter", 20)) {
				 	if (!(sef = strdup(str2)))	
						error_memory();
        	        } else if (!strncmp(str1, "EnvelopeRecipientFilter", 23)) {
				 	if (!(ref = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "RelaySenderFilter", 17)) {
				 	if (!(srf = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "RelayRecipientFilter", 20)) {
				 	if (!(rrf = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "StartTime", 9)) {
				if (!Dflag)
				 	if (!(sstring = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "EndTime", 7)) {
				if (!Dflag)
				 	if (!(estring = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "PictureURL", 10)) {
					if (!(puchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "PictureALT", 10)) {
					if (!(pachar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "PictureParameters", 17)) {
					if (!(ppchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "PictureLink", 11)) {
					if (!(plchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "HeaderText", 10)) {
					if (!(htchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "FooterText", 10)) {
					if (!(ftchar = strdup(str2)))
						error_memory();
        	        } else if (!strncmp(str1, "CaseSensitive", 13)) {
				if (!strncmp(str2, "yes", 3))
					csflag = 1;
				else
					csflag = 0;
			} else if (!strncmp(str1, "ClogFormat", 10)) {
				if (!(cfchar = strdup(str2)))
					error_memory();
        	        } else if (!strncmp(str1, "ClogSentOnly", 12)) {
				if (!strncmp(str2, "yes", 3))
					clsflag = 1;
				else
					clsflag = 0;
        	        } else if (!strncmp(str1, "IncludeAscii", 12)) {
				if (!strncmp(str2, "yes", 3) && !iflag)
					iflag = 1;
        	        } else if (!strncmp(str1, "HashTables", 10)) {
				if (!tflag) {
					if(!(tchar = strdup(str2)))
						error_memory();
					tflag = 1;
				}
			} else if (!strncmp(str1, "DowncaseAddresses", 17)) {
				if (!strncmp(str2, "yes", 3) && !dcaddrflag) {
					dcaddrflag = 1;
				}
			} else {
				if (!qflag)
				fprintf(stderr, "%s: unknown config parameter"
				" \"%s\", line %d\n", pname, str1, lines);
			}
		}
	}
}

/* 
 * Find string, strip off '"'s.
 */

char * 
get_string(char *str) {
	char *tmpstr;
	char *retstr;
	int c; 

	/* Malloc space for string: */
	if (!(tmpstr = malloc(strlen(str))))
		error_memory();

	/* check for '"': */
	if (*str != '"') c = 0;
	else c = 1;

	/* not '"': */
	if (!c) {
		retstr = str;
		free(tmpstr);
		while (*str++ != '\0') {
			if (isspace(*str)) {
				break;
			}
		}
		*str = '\0';

	/* starts with '"': */
	} else {
		retstr = tmpstr;
		while  (*str++ != '\0') {
			if (*str == '\\' && *(str+1) && *(str+1) == '"') {
				*tmpstr++ = *(str+1);			
				str++;
			} else if (*str == '"')
				break;
			else
				*tmpstr++ = *str;
		}
		*tmpstr = '\0';
	}
	return retstr;
}
