---
myst:
  html_meta:
    keywords: LaTeX, composition, document, création d'un document,
              création de fichier
---

# Comment créer un fichier à la volée ?

Que ce soit dans le cadre d'un travail collaboratif ou par exemple pour poser
une question (La)TeX avec
[ECM](/1_generalites/documentation/listes_de_discussion/comment_rediger_un_exemple_complet_minimal),
il est parfois nécessaire de fournir, en plus d'un fichier principal (`.tex`),
des fichiers externes (`.tex`, `.bib`, etc.) destinés à être insérés 
dans le fichier principal. Il peut alors être pratique que 
les fichiers externes soient créés à la volée lors de la compilation 
du fichier principal. C'est classiquement le cas pour créer un fichier `.bib` 
ou d’autres fichiers de données similaires à partir du fichier principal, 
de sorte à rendre autonome ce dernier. De même, cela peut être utile 
pour créer un fichier personnalisé de style (une extension) ou de classe, 
rendant ainsi encore le source autonome.

C'est ce que permet l'environnement `filecontents` dont la syntaxe est  :

```{noedit}
\begin{filecontents}[⟨option(s)⟩]{⟨nom de fichier⟩}
⟨texte⟩
\end{filecontents}
```

ou

```{noedit}
\begin{filecontents*}[⟨option(s)⟩]{⟨nom de fichier⟩}
⟨texte⟩
\end{filecontents*}
```

Ces instructions créent, par défaut dans le répertoire courant, un fichier 
nommé `⟨nom de fichier⟩` dont le contenu est `⟨texte⟩`. Par défaut un fichier
déjà existant n’est pas écrasé.

La version non étoilée de l’environnement `filecontent` préfixe le contenu 
du ficher créé d’une en-tête de commentaires TeX ; voir l’exemple ci-dessous. 
La version étoilée `filecontent*` n’inclut par l’en-tête.

Les options possibles sont :

- `force` ou `overwrite`: écrase le fichier s’il existe ;
- `noheader` : omet l’en-tête. Équivalent à utiliser `filecontents*` ;
- `nosearch` : vérifie uniquement si un fichier existe dans le répertoire
  courant, non dans le chemin complet de recherche.

Cet environnement peut être utilisé n’importe où dans le préambule, 
bien qu’il apparaisse souvent avant la commande `\documentclass`.

Par exemple, la compilation du fichier `test.tex` suivant :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \begin{filecontents}{JH.sty}
  \newcommand{\monnom}{Jim Hef{}feron}
  \end{filecontents}
  \usepackage{JH}

\begin{document}
Un article de \monnom.
\end{document}
```

produit le fichier `JH.sty` :

```{noedit}
%% LaTeX2e file `JH.sty'
%% generated by the `filecontents' environment
%% from source `test' on 2015/10/12.
%%
\newcommand{\monnom}{Jim Hef{}feron}
```

Un autre exemple, faisant usage de la commande 
[`\jobname`](/2_programmation/compilation/recuperer_le_nom_du_fichier_compile),
est le suivant :

```
% Fichier externe de bibliographie
\begin{filecontents}[noheader,force]{\jobname.bib}
@mvbook{knuth:ct,
  author         = {Knuth, Donald E.},
  title          = {Computers \& Typesetting},
  date           = {1984/1986},
  volumes        = 5,
  publisher      = {Addison-Wesley},
  location       = {Reading, Mass.},
  langid         = {english},
  langidopts     = {variant=american},
  sorttitle      = {Computers & Typesetting},
  indexsorttitle = {Computers & Typesetting},
}
\end{filecontents}

% Fichier externe de données à utiliser avec `pgfplots`
\begin{filecontents}[noheader,force]{donnees-\jobname.dat}
Temps Rep1 Rep2
0     1    1
1     10   0.1
2     100  0.01
\end{filecontents}

% Fichier principal
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[a4paper]{geometry}
  \usepackage{pgfplots}
  \usepackage{csquotes}
  \usepackage{biblatex}

  \pgfplotsset{compat=1.18}

  \addbibresource{\jobname.bib}

\begin{document}
\begin{tikzpicture}
  \begin{axis}
    \addplot table[
    x=Temps,y=Rep1
    ]{donnees-\jobname.dat};
  \end{axis}
\end{tikzpicture}

On pourra avec profit lire \autocite{knuth:ct}.

\printbibliography
\end{document}
```

Cette FAQ utilise souvent cette possibilité pour proposer des exemples complets
sans avoir à stocker des fichiers sur le serveur hébergeant cette FAQ (voir, 
par exemple, 
"[](/3_composition/annexes/bibliographie/references/configurer_la_commande)").

<!-- Le contenu de cette page est une reproduction quasi verbatim d'un extrait -->
<!-- de la traduction en français https://latexref.xyz/fr/ de -->
<!-- https://latexref.xyz dont la licence -->
<!-- (https://latexref.xyz/dev/#license) stipule que : -->
<!-- Ce document est un manuel de référence officieux pour LaTeX, un système de -->
<!-- préparation de documents, version « Août 2022 ». -->
<!--  -->
<!-- Ce manuel a été traduit du fichier LATEX.HLP v1.0a de la -->
<!-- bibliothèque d'aide VMS. La version prétraduction a été rédigée par -->
<!-- George D. Greenwade de l'université d'état Sam Houston, au Texas (USA). La version -->
<!-- LaTeX 2.09 a été rédigée par Stephen Gilmore. La version LaTeX2e a -->
<!-- été adaptée à partir de celle-ci par Torsten Martinsen. Karl Berry a -->
<!-- fait d'autres mises à jour et ajouts, et reconnaît avec gratitude avoir -->
<!-- utilisé comme matière de référence Hypertext Help with LaTeX, -->
<!-- de Sheldon Green, et LaTeX Command Summary (pour LaTeX2.09) -->
<!-- de L. Botway et C. Biemesderfer (publié par le TeX -->
<!-- Users Group en tant que TeXniques numéro 10). Nous savons également gré à -->
<!-- Martin Herbert Dietze d'avoir de plus utilisé de la matière apparaissant -->
<!-- dans son latex2e-reference. (À partir de ces références aucun -->
<!-- texte n'a été copié directement). -->
<!--  -->
<!-- Tous droits réservés (C) 2015-2022 Vincent Belaïche - traduction. -->
<!--  -->
<!-- Tous droits réservés (C) 2007-2022 Karl Berry.  -->
<!--  -->
<!-- Tous droits réservés (C) 1988, 1994, 2007 Stephen Gilmore.  -->
<!--  -->
<!-- Tous droits réservés (C) 1994, 1995, 1996 Torsten Martinsen. -->
<!--  -->
<!-- Ci-après se trouve la licence sous laquelle est distribuée ce manuel ; -->
<!-- une traduction en est donnée en annexe, voir License translation. -->
<!--  -->
<!-- Permission is granted to make and distribute verbatim copies of -->
<!-- this manual provided the copyright notice and this permission notice -->
<!-- are preserved on all copies. -->
<!-- Permission is granted to copy and distribute modified versions of this -->
<!-- manual under the conditions for verbatim copying, provided that the entire -->
<!-- resulting derived work is distributed under the terms of a permission -->
<!-- notice identical to this one. -->
<!-- Permission is granted to copy and distribute translations of this manual -->
<!-- into another language, under the above conditions for modified versions. -->


:::{sources}
- [filecontents: Écrire un fichier externe](https://latexref.xyz/fr/filecontents.html), sur
  le site du [Manuel de référence officieux de LaTeX2e](https://latexref.xyz/fr/)
:::