---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, arts et loisirs, arts, loisirs, 
              généalogie, arbre généalogique, mes ancêtres en LaTeX, 
              génétique humaine, diagramme de parenté
---

# Comment obtenir un arbre généalogique ?

Les arbres généalogiques sont bien utiles pour présenter 
les connexions génétiques et relationnelles entre les individus, 
dans un but clinique, sociologique ou légal. La dénomination "arbre" dérive
des diagrammes de familles historiques. Cependant, même la plus petite entité
familiale composée de deux parents et de quelques enfants n'est pas un arbre
au sens mathématique, mais un graphe plus général.

L'extension <ctanpkg:genealogytree>, basée sur l'extension <ctanpkg:tikz>, 
fournit un ensemble d'outils permettant de composer des arbres généalogiques 
(c'est-à-dire de dessiner un ensemble de graphes adaptés à la description 
de structures familiales). Il utilise un algorithme d'extraction automatique 
qui peut être personnalisé, par exemple, pour prioriser certaines arêtes.

En voici un exemple très simple (se limitant à deux générations), 
avec un léger paramétrage (ici la définition d'un style `important` pour mettre
en valeur une des feuilles de l'arbre généalogique).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[all]{genealogytree}

\begin{document}
\begin{figure}[h!]
\centering
\begin{tikzpicture}
\genealogytree[template=signpost,
  important/.style={box={colback=blue!10}},
]{
    parent{
    g[male]{Louis X Le Hutin}
    c[male]{Philippe V\\ Le Long}
    c[male]{Charles IV\\ Le Bel}
    p[male,important]{Philippe IV\\ Le Bel}
    p[female]{Jeanne I\iere\\ de Navarre}
  }
}
\end{tikzpicture}
\caption{La descendance de Philippe Le Bel}
\end{figure}
\end{document}
```

[La documentation](texdoc:genealogytree) de l'extension, en anglais, est 
très didactique et présente même des méthodes de construction pas à pas.


## Cas des diagrammes de parenté

Les diagrammes de parenté sont un outil courant en anthropologie 
pour représenter les systèmes de parenté. En effet selon les cultures 
et les langues, les relations de parenté ne sont pas conceptualisées 
et nommées de la même manière. Par exemple, dans les langues ryukyu, 
les frères et sœurs cadets son désignés par le même terme, sans distinction
de sexe. Et il existe des systèmes de parenté très différents, dont certains 
peuvent nous sembler "bizarres". À l’inverse, le fait qu’en français 
on ne distingue pas les grands-parents, oncles et tantes paternels de ceux 
du côté maternel paraitrait terriblement étrange à certaines cultures.

Pour réaliser un diagramme de parenté avec LaTeX, il ne semble pas exister
de solution "clef en main". Ce qui s’en rapprocherait le plus 
est <ctanpkg:genealogytree>, mais celui-ci ne prend pas en compte 
les spécificités des diagrammes de parenté.

Thomas Pellard propose une 
[solution détaillée](https://cipanglo.hypotheses.org/309)
sur son site [Cipanglossia](https://cipanglo.hypotheses.org/).


:::{sources}
- [Diagramme de parenté avec LaTeX](https://cipanglo.hypotheses.org/309).
:::