# biblatex-chicago package
# Matthew Bertucci 2022/07/03 for v3.18

#include:etoolbox
#include:nameref
#include:xstring
#include:biblatex

#keyvals:\usepackage/biblatex-chicago#c
authordate
notes
authordate-trad
authordate16
notes16
authordate-trad16
footmarkoff
cmsbreakurl
cmsnameparts
cmsnameparts=%<nametemplate%>
# options passed to biblatex package
backend=#bibtex,bibtex8,biber
style=%<file%>
bibstyle=%<file%>
citestyle=%<file%>
natbib#true,false
mcite#true,false
casechanger=#auto,latex2e,expl3
datamodel=%<model%>
sorting=#nty,nyt,nyvt,anyt,anyvt,ynt,ydnt,none,debug
sortcase#true,false
sortupper#true,false
sortlocale=
sortcites#true,false
sortsets#true,false
maxnames=%<integer%>
minnames=%<integer%>
maxbibnames=%<integer%>
minbibnames=%<integer%>
maxcitenames=%<integer%>
mincitenames=%<integer%>
maxsortnames=%<integer%>
minsortnames=%<integer%>
maxitems=%<integer%>
minitems=%<integer%>
autocite=#plain,inline,footnote,superscript
autopunct#true,false
language=#autobib,autocite,auto
clearlang#true,false
autolang=#none,hyphen,other,other*,langname
langhook=#captions,extras
block=#none,space,par,nbpar,ragged
locallabelwidth#true,false
notetype=#foot+end,footonly,endonly
hyperref=#true,false,auto,manual
backref#true,false
backrefstyle=#none,three,two,two+,three+,all+
backrefsetstyle=#setonly,memonly,setormem,setandmem,memandset,setplusmem
backreffloats#true,false
indexing=#true,false,cite,bib
loadfiles#true,false
refsection=#none,part,chapter,chapter+,section,section+,subsection,subsection+
refsegment=#none,part,chapter,chapter+,section,section+,subsection,subsection+
citereset=#none,part,chapter,chapter+,section,section+,subsection,subsection+
abbreviate#true,false
date=#year,short,long,terse,comp,ymd,iso
labeldate=#year,short,long,terse,comp,ymd,iso
eventdate=#year,short,long,terse,comp,ymd,iso
origdate=#year,short,long,terse,comp,ymd,iso
urldate=#year,short,long,terse,comp,ymd,iso
alldates=#year,short,long,terse,comp,iso
julian#true,false
gregorianstart=%<YYYY-MM-DD%>
datezeros#true,false
timezeros#true,false
timezones#true,false
seconds#true,false
dateabbrev#true,false
datecirca#true,false
dateuncertain#true,false
dateera=#astronomical,secular,christian
dateeraauto=%<integer%>
time=#12h,24h,24hcomp
labeltime=#12h,24h,24hcomp
eventtime=#12h,24h,24hcomp
origtime=#12h,24h,24hcomp
urltime=#12h,24h,24hcomp
alltimes=#12h,24h,24hcomp
dateusetime#true,false
labeldateusetime#true,false
eventdateusetime#true,false
origdateusetime#true,false
urldateusetime#true,false
alldatesusetime#true,false
defernumbers#true,false
punctfont#true,false
arxiv=#abs,ps,pdf,format
texencoding=
bibencoding=
safeinputenc#true,false
bibwarn#true,false
mincrossrefs=%<integer%>
minxrefs=%<integer%>
bibtexcaseprotection#true,false
isbn#true,false
url#true,false
doi=#true,false,only,onlynd
eprint#true,false
related#true,false
subentry#true,false
subentrycomp#true,false
dashed#true,false
mergedate=#false,minimum,basic,compact,maximum,true
ibidpage#true,false
citepages=#permit,suppress,omit,separate
strict#true,false
pagetracker=#true,false,page,spread
citecounter=#true,false,context
citetracker=#true,false,context,strict,constrict
ibidtracker=#true,false,context,strict,constrict
opcittracker=#true,false,context,strict,constrict
loccittracker=#true,false,context,strict,constrict
idemtracker=#true,false,context,strict,constrict
trackfloats#true,false
parentracker#true,false
maxparens=%<integer%>
giveninits#true,false
terseinits#true,false
labelalpha#true,false
maxalphanames=%<integer%>
minalphanames=%<integer%>
labelnumber#true,false
noroman#true,false
labeltitle#true,false
labeltitleyear#true,false
labeldateparts#true,false
singletitle#true,false
uniquetitle#true,false
uniquebaretitle#true,false
uniquework#true,false
uniqueprimaryauthor#true,false
uniquename=#true,false,init,full,allinit,allfull,mininit,minfull
uniquelist=#true,false,minyear
nohashothers#true,false
nosortothers#true,false
useauthor#true,false
useeditor#true,false
usetranslator#true,false
useprefix#true,false
indexing=#true,false,cite,bib
skipbib#true,false
skipbiblist#true,false
skiplab#true,false
dataonly#true,false
#endkeyvals

#keyvals:\usepackage/biblatex-chicago#c,\ExecuteBibliographyOptions#c
alwaysrange#true,false
decaderange#true,false
centuryrange#true,false
nodatebrackets#true,false
noyearbrackets#true,false
nodates#true,false
genallnames#true,false
annotation#true,false
bibannotesep=#none,space,comma,period,colon,semicolon,par,vpar,parbreak,vparbreak
citeannotesep=#none,space,comma,period,colon,semicolon,par,vpar,parbreak,vparbreak
formatbib=#max,min,minwo,annote,annotenp
entrybreak=%<integer%>
noibid#true,false
useibid#true,false
short#true,false
hidezeros#true,false
pagezeros#true,false
endnotesplit#true,false
noterefinterval=%<integer%>
noterefintro=%<string%>
fullnoterefs#true,false
noteref=#none,page,chapter,section,subsection,part
legalnotes#true,false
supranotes#true,false
noneshort#true,false
shorthandibid#true,false
shorthandfull#true,false
inheritshorthand#true,false
shorthandfirst#true,false
shorthandintro=#none,short,full
compresspages#true,false
compressyears#true,false
postnotepunct#true,false
usecompiler#true,false
juniorcomma#true,false
delayvolume#true,false
longcrossref#true,false
booklongxref#true,false
omitxrefdate#true,false
xrefurl#true,false
blogurl#true,false
journalabbrev#true,false
seriesabbrev#true,false
ordinalgb#true,false
notitle#true,false
urlnotes#true,false
urlstamp#true,false
numbermonth#true,false
bookpages#true,false
includeall#true,false
hidevolumes#true,false
addendum#true,false
bookseries#true,false
notefield#true,false
completenotes#true,false
nameaddon=#all,none,first
shortextrafield=%<field%>
shortextraformat=%<format%>
shortextrapunct=#none,space,comma,period,colon,semicolon
nameaddonformat=%<format%>
nameaddonsep=#space,none,colon,comma,period,semicolon
ptitleaddon=#none,space,comma,period,colon,semicolon
ctitleaddon=#none,space,comma,period,colon,semicolon
jtitleaddon=#none,space,comma,period,colon,semicolon
shorthandpunct=#none,space,comma,period,colon,semicolon,emdash,endash
#endkeyvals

\suppressbibfield{field1,field2,...}
\suppressbibfield[entrytype1,entrytype2,...]{field1,field2,...}

# from chicago-notes.bbx (default)
\lositemsep#*
\cmsunspecified{arg1}{arg2}#*
\cmscompressyears{arg}#*
\cmscompcenturies{arg}#*
\cmsformatextra#*
\cmsformatendextra#*
\cmsdateeraprintpre{arg}#*
\cmsdateeraprint{arg}#*
\ifrelatedloop#*

# from chicago-notes.cbx (default)
\citeincite{bibid}#C
\citeincite[postnote]{bibid}#C
\citeincite[prenote][postnote]{bibid}#C
\citeincites{bibid}{bibid}#C
\citeincites(pre){bibid}{bibid}#*C
\citeincites(pre)(post){bibid}{bibid}#C
\citeincites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\citeincites[pre]{bibid}[pre]{bibid}#*C
\citeincites[pre][post]{bibid}[pre][post]{bibid}#*C
\citeincites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\citejournal{bibid}#C
\citejournal[postnote]{bibid}#C
\citejournal[prenote][postnote]{bibid}#C
\citetitles{bibid}{bibid}#C
\citetitles(pre){bibid}{bibid}#*C
\citetitles(pre)(post){bibid}{bibid}#C
\citetitles(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\citetitles[pre]{bibid}[pre]{bibid}#*C
\citetitles[pre][post]{bibid}[pre][post]{bibid}#*C
\citetitles(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\fullciteincite{bibid}#C
\fullciteincite[postnote]{bibid}#C
\fullciteincite[prenote][postnote]{bibid}#C
\fullciteincites{bibid}{bibid}#C
\fullciteincites(pre){bibid}{bibid}#*C
\fullciteincites(pre)(post){bibid}{bibid}#C
\fullciteincites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\fullciteincites[pre]{bibid}[pre]{bibid}#*C
\fullciteincites[pre][post]{bibid}[pre][post]{bibid}#*C
\fullciteincites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\gentextcite{bibid}#C
\gentextcite[postnote]{bibid}#C
\gentextcite[prenote][postnote]{bibid}#C
\gentextcite[ending][prenote][postnote]{bibid}#C
\gentextcites{bibid}{bibid}#C
\gentextcites(pre){bibid}{bibid}#*C
\gentextcites[ending](pre){bibid}{bibid}#*C
\gentextcites(pre)(post){bibid}{bibid}#C
\gentextcites[ending](pre)(post){bibid}{bibid}#C
\gentextcites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\gentextcites[ending](pre)(post)[pre]{bibid}[pre]{bibid}#*C
\gentextcites[pre]{bibid}[pre]{bibid}#*C
\gentextcites[pre][post]{bibid}[pre][post]{bibid}#*C
\gentextcites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\gentextcites[ending](pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\Gentextcite{bibid}#C
\Gentextcite[postnote]{bibid}#C
\Gentextcite[prenote][postnote]{bibid}#C
\Gentextcite[ending][prenote][postnote]{bibid}#C
\Gentextcites{bibid}{bibid}#C
\Gentextcites(pre){bibid}{bibid}#*C
\Gentextcites[ending](pre){bibid}{bibid}#*C
\Gentextcites(pre)(post){bibid}{bibid}#C
\Gentextcites[ending](pre)(post){bibid}{bibid}#C
\Gentextcites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\Gentextcites[ending](pre)(post)[pre]{bibid}[pre]{bibid}#*C
\Gentextcites[pre]{bibid}[pre]{bibid}#*C
\Gentextcites[pre][post]{bibid}[pre][post]{bibid}#*C
\Gentextcites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\Gentextcites[ending](pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\headlesscite{bibid}#C
\headlesscite[postnote]{bibid}#C
\headlesscite[prenote][postnote]{bibid}#C
\headlesscites{bibid}{bibid}#C
\headlesscites(pre){bibid}{bibid}#*C
\headlesscites(pre)(post){bibid}{bibid}#C
\headlesscites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\headlesscites[pre]{bibid}[pre]{bibid}#*C
\headlesscites[pre][post]{bibid}[pre][post]{bibid}#*C
\headlesscites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\Headlesscite{bibid}#C
\Headlesscite[postnote]{bibid}#C
\Headlesscite[prenote][postnote]{bibid}#C
\Headlesscites{bibid}{bibid}#C
\Headlesscites(pre){bibid}{bibid}#*C
\Headlesscites(pre)(post){bibid}{bibid}#C
\Headlesscites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\Headlesscites[pre]{bibid}[pre]{bibid}#*C
\Headlesscites[pre][post]{bibid}[pre][post]{bibid}#*C
\Headlesscites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\headlessfullcite{bibid}#C
\headlessfullcite[postnote]{bibid}#C
\headlessfullcite[prenote][postnote]{bibid}#C
\headlessfullcites{bibid}{bibid}#C
\headlessfullcites(pre){bibid}{bibid}#*C
\headlessfullcites(pre)(post){bibid}{bibid}#C
\headlessfullcites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\headlessfullcites[pre]{bibid}[pre]{bibid}#*C
\headlessfullcites[pre][post]{bibid}[pre][post]{bibid}#*C
\headlessfullcites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\shortcite{bibid}#C
\shortcite[postnote]{bibid}#C
\shortcite[prenote][postnote]{bibid}#C
\shortcite*{bibid}#C
\shortcite*[postnote]{bibid}#C
\shortcite*[prenote][postnote]{bibid}#C
\Shortcite{bibid}#C
\Shortcite[postnote]{bibid}#C
\Shortcite[prenote][postnote]{bibid}#C
\Shortcite*{bibid}#C
\Shortcite*[postnote]{bibid}#C
\Shortcite*[prenote][postnote]{bibid}#C
\shorthandcite{bibid}#C
\shorthandcite[postnote]{bibid}#C
\shorthandcite[prenote][postnote]{bibid}#C
\shorthandcite*{bibid}#C
\shorthandcite*[postnote]{bibid}#C
\shorthandcite*[prenote][postnote]{bibid}#C
\shorthandrefcite{bibid}#C
\shorthandrefcite[postnote]{bibid}#C
\shorthandrefcite[prenote][postnote]{bibid}#C
\shortrefcite{bibid}#C
\shortrefcite[postnote]{bibid}#C
\shortrefcite[prenote][postnote]{bibid}#C
\Shortrefcite{bibid}#C
\Shortrefcite[postnote]{bibid}#C
\Shortrefcite[prenote][postnote]{bibid}#C
\surnamecite{bibid}#C
\surnamecite[postnote]{bibid}#C
\surnamecite[prenote][postnote]{bibid}#C
\surnamecites{bibid}{bibid}#C
\surnamecites(pre){bibid}{bibid}#*C
\surnamecites(pre)(post){bibid}{bibid}#C
\surnamecites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\surnamecites[pre]{bibid}[pre]{bibid}#*C
\surnamecites[pre][post]{bibid}[pre][post]{bibid}#*C
\surnamecites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#C
\runcite{bibid}#C
\runcite[postnote]{bibid}#C
\runcite[prenote][postnote]{bibid}#C
\headlessparencite{bibid}#*C
\headlessparencite[postnote]{bibid}#*C
\headlessparencite[prenote][postnote]{bibid}#*C
\headlessparencites{bibid}{bibid}#*C
\headlessparencites(pre){bibid}{bibid}#*C
\headlessparencites(pre)(post){bibid}{bibid}#*C
\headlessparencites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\headlessparencites[pre]{bibid}[pre]{bibid}#*C
\headlessparencites[pre][post]{bibid}[pre][post]{bibid}#*C
\headlessparencites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#*C
\headlessparenshortcite{bibid}#*C
\headlessparenshortcite[postnote]{bibid}#*C
\headlessparenshortcite[prenote][postnote]{bibid}#*C
\headlessparenshortcites{bibid}{bibid}#*C
\headlessparenshortcites(pre){bibid}{bibid}#*C
\headlessparenshortcites(pre)(post){bibid}{bibid}#*C
\headlessparenshortcites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\headlessparenshortcites[pre]{bibid}[pre]{bibid}#*C
\headlessparenshortcites[pre][post]{bibid}[pre][post]{bibid}#*C
\headlessparenshortcites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#*C
\foottextcite{bibid}#*C
\foottextcite[postnote]{bibid}#*C
\foottextcite[prenote][postnote]{bibid}#*C
\foottextcites{bibid}{bibid}#*C
\foottextcites(pre){bibid}{bibid}#*C
\foottextcites(pre)(post){bibid}{bibid}#*C
\foottextcites(pre)(post)[pre]{bibid}[pre]{bibid}#*C
\foottextcites[pre]{bibid}[pre]{bibid}#*C
\foottextcites[pre][post]{bibid}[pre][post]{bibid}#*C
\foottextcites(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#*C
\cmsnoopcite{bibid}#SC
\cmsnoopcite[postnote]{bibid}#SC
\cmsnoopcite[prenote][postnote]{bibid}#SC
\bibxrefcite{bibid}#SC
\bibxrefcite[postnote]{bibid}#SC
\bibxrefcite[prenote][postnote]{bibid}#SC
\bookbibxrefcite{bibid}#SC
\bookbibxrefcite[postnote]{bibid}#SC
\bookbibxrefcite[prenote][postnote]{bibid}#SC
\origfullcite{bibid}#SC
\origfullcite[postnote]{bibid}#SC
\origfullcite[prenote][postnote]{bibid}#SC
\origpublcite{bibid}#SC
\origpublcite[postnote]{bibid}#SC
\origpublcite[prenote][postnote]{bibid}#SC
\citeincitef{bibid}#SC
\citeincitef[postnote]{bibid}#SC
\citeincitef[prenote][postnote]{bibid}#SC
\citeincitefs{bibid}{bibid}#SC
\citeincitefs(pre){bibid}{bibid}#SC
\citeincitefs(pre)(post){bibid}{bibid}#SC
\citeincitefs(pre)(post)[pre]{bibid}[pre]{bibid}#SC
\citeincitefs[pre]{bibid}[pre]{bibid}#SC
\citeincitefs[pre][post]{bibid}[pre][post]{bibid}#SC
\citeincitefs(pre)(post)[pre][post]{bibid}[pre][post]{bibid}#SC

\reprint#*
\partcomp#*
\partedit{text}#*
\parteditandcomp#*
\parteditandtrans#*
\partedittransandcomp#*
\parttransandcomp#*
\parttrans#*

\begrelateddelimreviewof#*
\bibannotesep#*
\citeannotesep#*
\classicpunct#*
\cmsfwrap{text}#*
\cmshyper{text}#*
\cmsintrosection#*
\cmsnrpart#*
\cmspens{number}#*
\cmspref#*
\cmsrelhyper{text}#*
\cmsrelnamehyper{text}#*
\cmsshhyper{text}#*
\cmswrap{text}#*
\cmswrapf{text}#*
\ctitleaddonpunct#*
\docmslist{arg}#*
\editordelim#*
\encypunct#*
\forcmslist{arg1}{arg2}#*
\iffieldstart{true}{false}#*
\journalpagespunct#*
\jtitleaddonpunct#*
\letterdatelong#*
\mkbibcurdinal{arg}#*
\mkbibethgiven{text}#*
\mkbibethpap{text}#*
\mkbibethpat{text}#*
\mkibid{arg}#*
\mkjuridprefix{arg}#*
\multilangdelim#*
\multilocsdelim#*
\multipubsdelim#*
\nameaddonpunct#*
\nameadelim#*
\newcunit#*
\newcunitpunct#*
\postnotewrapper#*
\postvolpunct#*
\ptitleaddonpunct#*
\relateddelimshort#*
\reprintpunct#*
\shorthandpunct#*

#ifOption:strict
\splitfootnoterule#*
\pagefootnoterule#*
#endif
#ifOption:strict=true
\splitfootnoterule#*
\pagefootnoterule#*
#endif

# from cms-american.lbx (default)
\introductionname#*
\sectionname#*
\subsectionname#*
\forewordname#*
\notesname#*
\mkjuridordinal{arg}#*
\mkbibyeardivisiondateshort{arg1}{arg2}#*
\mkbibyeardivisiondatelong{arg1}{arg2}#*
\cmsmkdecade{arg1}{arg2}#*
\cmsmkcentury{arg}#*
\mkcmscentury{arg}#*

# commands shared with defaults not repeated in ifOption blocks below

## authordate option ##
#ifOption:authordate

#keyvals:\usepackage/biblatex-chicago#c,\ExecuteBibliographyOptions#c
avdate#true,false
cmsdate=#off,both,on
cmsorigdate#true,false
hypertitle#true,false
hypername#true,false
hyperall#true,false
cmslos#true,false
#endkeyvals

# from chicago-dates-common.cbx
\atcite{bibid}#C
\atcite[postnote]{bibid}#C
\atcite[prenote][postnote]{bibid}#C
\atpcite{bibid}#C
\atpcite[postnote]{bibid}#C
\atpcite[prenote][postnote]{bibid}#C
\parenfullcite{bibid}#C
\parenfullcite[postnote]{bibid}#C
\parenfullcite[prenote][postnote]{bibid}#C
\cmshypercite{bibid}#SC
\cmshypercite[postnote]{bibid}#SC
\cmshypercite[prenote][postnote]{bibid}#SC
\cmswraphy{arg}#*
\cbytypeeditor#*

# from chicago-authordate.bbx
\begrelateddelimmaintitle#*
\begrelateddelimmaintitlenc#*
#endif

## authordate-trad option ##
#ifOption:authordate-trad

#keyvals:\usepackage/biblatex-chicago#c,\ExecuteBibliographyOptions#c
avdate#true,false
cmsdate=#off,both,on
cmsorigdate#true,false
hypertitle#true,false
cmslos#true,false
headline#true,false
#endkeyvals

# from chicago-dates-common.cbx
\atcite{bibid}#C
\atcite[postnote]{bibid}#C
\atcite[prenote][postnote]{bibid}#C
\atpcite{bibid}#C
\atpcite[postnote]{bibid}#C
\atpcite[prenote][postnote]{bibid}#C
\parenfullcite{bibid}#C
\parenfullcite[postnote]{bibid}#C
\parenfullcite[prenote][postnote]{bibid}#C
\cmshypercite{bibid}#SC
\cmshypercite[postnote]{bibid}#SC
\cmshypercite[prenote][postnote]{bibid}#SC
\cmswraphy{arg}#*
\cbytypeeditor#*

# chicago-authordate-trad.bbx loads chicago-authordate.bbx
# from chicago-authordate.bbx
\begrelateddelimmaintitle#*
\begrelateddelimmaintitlenc#*
#endif
