/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by jextract

package org.apache.tomcat.util.openssl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.stream.Collectors;

import org.apache.tomcat.util.compat.JrePlatform;

import java.lang.foreign.*;
import static java.lang.foreign.ValueLayout.*;

@SuppressWarnings({"javadoc", "boxing"})
public class openssl_h {

    /*
     * On Mac OS SymbolLookup.libraryLookup() appears to ignore java.library.path which means the LibreSSL
     * library will be found which will then fail. Therefore, skip that lookup on Mac OS.
     */
    public static final boolean USE_SYSTEM_LOAD_LIBRARY = Boolean.getBoolean("org.apache.tomcat.util.openssl.USE_SYSTEM_LOAD_LIBRARY");
    public static final String LIBRARY_NAME = System.getProperty("org.apache.tomcat.util.openssl.LIBRARY_NAME",
            (JrePlatform.IS_MAC_OS) ? "ssl.48" : "ssl");

    openssl_h() {
        // Suppresses public default constructor, ensuring non-instantiability,
        // but allows generated subclasses in same package.
    }

    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS
            .withTargetLayout(MemoryLayout.sequenceLayout(java.lang.Long.MAX_VALUE, JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;

    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP;
    static {
        if (USE_SYSTEM_LOAD_LIBRARY) {
            System.loadLibrary(LIBRARY_NAME);
            SYMBOL_LOOKUP = SymbolLookup.loaderLookup().or(Linker.nativeLinker().defaultLookup());
        } else {
            SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName(LIBRARY_NAME), LIBRARY_ARENA)
                    .or(SymbolLookup.loaderLookup())
                    .or(Linker.nativeLinker().defaultLookup());
        }
    }

    static void traceDowncall(String name, Object... args) {
         String traceArgs = Arrays.stream(args)
                       .map(Object::toString)
                       .collect(Collectors.joining(", "));
         System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol)
            .orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MemoryLayout[] inferVariadicLayouts(Object[] varargs) {
        MemoryLayout[] result = new MemoryLayout[varargs.length];
        for (int i = 0; i < varargs.length; i++) {
            result[i] = variadicLayout(varargs[i].getClass());
        }
        return result;
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        } catch (ReflectiveOperationException ex) {
            throw new AssertionError(ex);
        }
    }

    static MethodHandle downcallHandleVariadic(String name, FunctionDescriptor baseDesc, MemoryLayout[] variadicLayouts) {
        FunctionDescriptor variadicDesc = baseDesc.appendArgumentLayouts(variadicLayouts);
        Linker.Option fva = Linker.Option.firstVariadicArg(baseDesc.argumentLayouts().size());
        return SYMBOL_LOOKUP.find(name)
                .map(addr -> Linker.nativeLinker().downcallHandle(addr, variadicDesc, fva)
                        .asSpreader(Object[].class, variadicLayouts.length))
                .orElse(null);
    }

    // Internals only below this point

    private static MemoryLayout variadicLayout(Class<?> c) {
        // apply default argument promotions per C spec
        // note that all primitives are boxed, since they are passed through an Object[]
        if (c == Boolean.class || c == Byte.class || c == Character.class || c == Short.class || c == Integer.class) {
            return JAVA_INT;
        } else if (c == Long.class) {
            return JAVA_LONG;
        } else if (c == Float.class || c == Double.class) {
            return JAVA_DOUBLE;
        } else if (MemorySegment.class.isAssignableFrom(c)) {
            return ADDRESS;
        }
        throw new IllegalArgumentException("Invalid type for ABI: " + c.getTypeName());
    }
    private static final int BIO_CLOSE = (int)1L;
    /**
     * {@snippet lang=c :
     * #define BIO_CLOSE 1
     * }
     */
    public static int BIO_CLOSE() {
        return BIO_CLOSE;
    }
    private static final int BIO_CTRL_RESET = (int)1L;
    /**
     * {@snippet lang=c :
     * #define BIO_CTRL_RESET 1
     * }
     */
    public static int BIO_CTRL_RESET() {
        return BIO_CTRL_RESET;
    }
    private static final int BIO_FP_READ = (int)2L;
    /**
     * {@snippet lang=c :
     * #define BIO_FP_READ 2
     * }
     */
    public static int BIO_FP_READ() {
        return BIO_FP_READ;
    }
    private static final int BIO_C_SET_FILENAME = (int)108L;
    /**
     * {@snippet lang=c :
     * #define BIO_C_SET_FILENAME 108
     * }
     */
    public static int BIO_C_SET_FILENAME() {
        return BIO_C_SET_FILENAME;
    }
    private static final int NID_info_access = (int)177L;
    /**
     * {@snippet lang=c :
     * #define NID_info_access 177
     * }
     */
    public static int NID_info_access() {
        return NID_info_access;
    }
    private static final int X509_FILETYPE_PEM = (int)1L;
    /**
     * {@snippet lang=c :
     * #define X509_FILETYPE_PEM 1
     * }
     */
    public static int X509_FILETYPE_PEM() {
        return X509_FILETYPE_PEM;
    }
    private static final int X509_L_FILE_LOAD = (int)1L;
    /**
     * {@snippet lang=c :
     * #define X509_L_FILE_LOAD 1
     * }
     */
    public static int X509_L_FILE_LOAD() {
        return X509_L_FILE_LOAD;
    }
    private static final int X509_L_ADD_DIR = (int)2L;
    /**
     * {@snippet lang=c :
     * #define X509_L_ADD_DIR 2
     * }
     */
    public static int X509_L_ADD_DIR() {
        return X509_L_ADD_DIR;
    }
    private static final int X509_V_OK = (int)0L;
    /**
     * {@snippet lang=c :
     * #define X509_V_OK 0
     * }
     */
    public static int X509_V_OK() {
        return X509_V_OK;
    }
    private static final int X509_V_ERR_CRL_HAS_EXPIRED = (int)12L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_CRL_HAS_EXPIRED 12
     * }
     */
    public static int X509_V_ERR_CRL_HAS_EXPIRED() {
        return X509_V_ERR_CRL_HAS_EXPIRED;
    }
    private static final int X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT = (int)18L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT 18
     * }
     */
    public static int X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT() {
        return X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT;
    }
    private static final int X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN = (int)19L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN 19
     * }
     */
    public static int X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN() {
        return X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN;
    }
    private static final int X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = (int)20L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY 20
     * }
     */
    public static int X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY() {
        return X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY;
    }
    private static final int X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE = (int)21L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE 21
     * }
     */
    public static int X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE() {
        return X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE;
    }
    private static final int X509_V_ERR_CERT_UNTRUSTED = (int)27L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_CERT_UNTRUSTED 27
     * }
     */
    public static int X509_V_ERR_CERT_UNTRUSTED() {
        return X509_V_ERR_CERT_UNTRUSTED;
    }
    private static final int X509_V_ERR_APPLICATION_VERIFICATION = (int)50L;
    /**
     * {@snippet lang=c :
     * #define X509_V_ERR_APPLICATION_VERIFICATION 50
     * }
     */
    public static int X509_V_ERR_APPLICATION_VERIFICATION() {
        return X509_V_ERR_APPLICATION_VERIFICATION;
    }
    private static final int X509_V_FLAG_CRL_CHECK = (int)4L;
    /**
     * {@snippet lang=c :
     * #define X509_V_FLAG_CRL_CHECK 4
     * }
     */
    public static int X509_V_FLAG_CRL_CHECK() {
        return X509_V_FLAG_CRL_CHECK;
    }
    private static final int X509_V_FLAG_CRL_CHECK_ALL = (int)8L;
    /**
     * {@snippet lang=c :
     * #define X509_V_FLAG_CRL_CHECK_ALL 8
     * }
     */
    public static int X509_V_FLAG_CRL_CHECK_ALL() {
        return X509_V_FLAG_CRL_CHECK_ALL;
    }
    private static final int PEM_R_NO_START_LINE = (int)108L;
    /**
     * {@snippet lang=c :
     * #define PEM_R_NO_START_LINE 108
     * }
     */
    public static int PEM_R_NO_START_LINE() {
        return PEM_R_NO_START_LINE;
    }
    private static final int SSL3_VERSION = (int)768L;
    /**
     * {@snippet lang=c :
     * #define SSL3_VERSION 768
     * }
     */
    public static int SSL3_VERSION() {
        return SSL3_VERSION;
    }
    private static final int TLS1_VERSION = (int)769L;
    /**
     * {@snippet lang=c :
     * #define TLS1_VERSION 769
     * }
     */
    public static int TLS1_VERSION() {
        return TLS1_VERSION;
    }
    private static final int TLS1_1_VERSION = (int)770L;
    /**
     * {@snippet lang=c :
     * #define TLS1_1_VERSION 770
     * }
     */
    public static int TLS1_1_VERSION() {
        return TLS1_1_VERSION;
    }
    private static final int TLS1_2_VERSION = (int)771L;
    /**
     * {@snippet lang=c :
     * #define TLS1_2_VERSION 771
     * }
     */
    public static int TLS1_2_VERSION() {
        return TLS1_2_VERSION;
    }
    private static final int TLS1_3_VERSION = (int)772L;
    /**
     * {@snippet lang=c :
     * #define TLS1_3_VERSION 772
     * }
     */
    public static int TLS1_3_VERSION() {
        return TLS1_3_VERSION;
    }
    private static final int SSL_SENT_SHUTDOWN = (int)1L;
    /**
     * {@snippet lang=c :
     * #define SSL_SENT_SHUTDOWN 1
     * }
     */
    public static int SSL_SENT_SHUTDOWN() {
        return SSL_SENT_SHUTDOWN;
    }
    private static final int SSL_RECEIVED_SHUTDOWN = (int)2L;
    /**
     * {@snippet lang=c :
     * #define SSL_RECEIVED_SHUTDOWN 2
     * }
     */
    public static int SSL_RECEIVED_SHUTDOWN() {
        return SSL_RECEIVED_SHUTDOWN;
    }
    private static final int SSL_OP_SINGLE_ECDH_USE = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_SINGLE_ECDH_USE 0
     * }
     */
    public static int SSL_OP_SINGLE_ECDH_USE() {
        return SSL_OP_SINGLE_ECDH_USE;
    }
    private static final int SSL_OP_SINGLE_DH_USE = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_SINGLE_DH_USE 0
     * }
     */
    public static int SSL_OP_SINGLE_DH_USE() {
        return SSL_OP_SINGLE_DH_USE;
    }
    private static final int SSL_OP_NO_SSLv2 = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_SSLv2 0
     * }
     */
    public static int SSL_OP_NO_SSLv2() {
        return SSL_OP_NO_SSLv2;
    }
    private static final int SSL_CONF_FLAG_FILE = (int)2L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_FLAG_FILE 2
     * }
     */
    public static int SSL_CONF_FLAG_FILE() {
        return SSL_CONF_FLAG_FILE;
    }
    private static final int SSL_CONF_FLAG_SERVER = (int)8L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_FLAG_SERVER 8
     * }
     */
    public static int SSL_CONF_FLAG_SERVER() {
        return SSL_CONF_FLAG_SERVER;
    }
    private static final int SSL_CONF_FLAG_SHOW_ERRORS = (int)16L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_FLAG_SHOW_ERRORS 16
     * }
     */
    public static int SSL_CONF_FLAG_SHOW_ERRORS() {
        return SSL_CONF_FLAG_SHOW_ERRORS;
    }
    private static final int SSL_CONF_FLAG_CERTIFICATE = (int)32L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_FLAG_CERTIFICATE 32
     * }
     */
    public static int SSL_CONF_FLAG_CERTIFICATE() {
        return SSL_CONF_FLAG_CERTIFICATE;
    }
    private static final int SSL_CONF_TYPE_UNKNOWN = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_TYPE_UNKNOWN 0
     * }
     */
    public static int SSL_CONF_TYPE_UNKNOWN() {
        return SSL_CONF_TYPE_UNKNOWN;
    }
    private static final int SSL_CONF_TYPE_FILE = (int)2L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_TYPE_FILE 2
     * }
     */
    public static int SSL_CONF_TYPE_FILE() {
        return SSL_CONF_TYPE_FILE;
    }
    private static final int SSL_CONF_TYPE_DIR = (int)3L;
    /**
     * {@snippet lang=c :
     * #define SSL_CONF_TYPE_DIR 3
     * }
     */
    public static int SSL_CONF_TYPE_DIR() {
        return SSL_CONF_TYPE_DIR;
    }
    private static final int SSL_SESS_CACHE_OFF = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_SESS_CACHE_OFF 0
     * }
     */
    public static int SSL_SESS_CACHE_OFF() {
        return SSL_SESS_CACHE_OFF;
    }
    private static final int SSL_SESS_CACHE_SERVER = (int)2L;
    /**
     * {@snippet lang=c :
     * #define SSL_SESS_CACHE_SERVER 2
     * }
     */
    public static int SSL_SESS_CACHE_SERVER() {
        return SSL_SESS_CACHE_SERVER;
    }
    private static final int SSL2_VERSION = (int)2L;
    /**
     * {@snippet lang=c :
     * #define SSL2_VERSION 2
     * }
     */
    public static int SSL2_VERSION() {
        return SSL2_VERSION;
    }
    private static final int SSL_TLSEXT_ERR_OK = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_TLSEXT_ERR_OK 0
     * }
     */
    public static int SSL_TLSEXT_ERR_OK() {
        return SSL_TLSEXT_ERR_OK;
    }
    private static final int SSL_TLSEXT_ERR_NOACK = (int)3L;
    /**
     * {@snippet lang=c :
     * #define SSL_TLSEXT_ERR_NOACK 3
     * }
     */
    public static int SSL_TLSEXT_ERR_NOACK() {
        return SSL_TLSEXT_ERR_NOACK;
    }
    private static final int SSL_CB_HANDSHAKE_DONE = (int)32L;
    /**
     * {@snippet lang=c :
     * #define SSL_CB_HANDSHAKE_DONE 32
     * }
     */
    public static int SSL_CB_HANDSHAKE_DONE() {
        return SSL_CB_HANDSHAKE_DONE;
    }
    private static final int SSL_VERIFY_NONE = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_VERIFY_NONE 0
     * }
     */
    public static int SSL_VERIFY_NONE() {
        return SSL_VERIFY_NONE;
    }
    private static final int SSL_VERIFY_PEER = (int)1L;
    /**
     * {@snippet lang=c :
     * #define SSL_VERIFY_PEER 1
     * }
     */
    public static int SSL_VERIFY_PEER() {
        return SSL_VERIFY_PEER;
    }
    private static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = (int)2L;
    /**
     * {@snippet lang=c :
     * #define SSL_VERIFY_FAIL_IF_NO_PEER_CERT 2
     * }
     */
    public static int SSL_VERIFY_FAIL_IF_NO_PEER_CERT() {
        return SSL_VERIFY_FAIL_IF_NO_PEER_CERT;
    }
    private static final int SSL_ERROR_NONE = (int)0L;
    /**
     * {@snippet lang=c :
     * #define SSL_ERROR_NONE 0
     * }
     */
    public static int SSL_ERROR_NONE() {
        return SSL_ERROR_NONE;
    }
    private static final int SSL_CTRL_SET_TMP_DH = (int)3L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_TMP_DH 3
     * }
     */
    public static int SSL_CTRL_SET_TMP_DH() {
        return SSL_CTRL_SET_TMP_DH;
    }
    private static final int SSL_CTRL_SET_TMP_ECDH = (int)4L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_TMP_ECDH 4
     * }
     */
    public static int SSL_CTRL_SET_TMP_ECDH() {
        return SSL_CTRL_SET_TMP_ECDH;
    }
    private static final int SSL_CTRL_SESS_NUMBER = (int)20L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_NUMBER 20
     * }
     */
    public static int SSL_CTRL_SESS_NUMBER() {
        return SSL_CTRL_SESS_NUMBER;
    }
    private static final int SSL_CTRL_SESS_CONNECT = (int)21L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_CONNECT 21
     * }
     */
    public static int SSL_CTRL_SESS_CONNECT() {
        return SSL_CTRL_SESS_CONNECT;
    }
    private static final int SSL_CTRL_SESS_CONNECT_GOOD = (int)22L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_CONNECT_GOOD 22
     * }
     */
    public static int SSL_CTRL_SESS_CONNECT_GOOD() {
        return SSL_CTRL_SESS_CONNECT_GOOD;
    }
    private static final int SSL_CTRL_SESS_CONNECT_RENEGOTIATE = (int)23L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_CONNECT_RENEGOTIATE 23
     * }
     */
    public static int SSL_CTRL_SESS_CONNECT_RENEGOTIATE() {
        return SSL_CTRL_SESS_CONNECT_RENEGOTIATE;
    }
    private static final int SSL_CTRL_SESS_ACCEPT = (int)24L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_ACCEPT 24
     * }
     */
    public static int SSL_CTRL_SESS_ACCEPT() {
        return SSL_CTRL_SESS_ACCEPT;
    }
    private static final int SSL_CTRL_SESS_ACCEPT_GOOD = (int)25L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_ACCEPT_GOOD 25
     * }
     */
    public static int SSL_CTRL_SESS_ACCEPT_GOOD() {
        return SSL_CTRL_SESS_ACCEPT_GOOD;
    }
    private static final int SSL_CTRL_SESS_ACCEPT_RENEGOTIATE = (int)26L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_ACCEPT_RENEGOTIATE 26
     * }
     */
    public static int SSL_CTRL_SESS_ACCEPT_RENEGOTIATE() {
        return SSL_CTRL_SESS_ACCEPT_RENEGOTIATE;
    }
    private static final int SSL_CTRL_SESS_HIT = (int)27L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_HIT 27
     * }
     */
    public static int SSL_CTRL_SESS_HIT() {
        return SSL_CTRL_SESS_HIT;
    }
    private static final int SSL_CTRL_SESS_CB_HIT = (int)28L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_CB_HIT 28
     * }
     */
    public static int SSL_CTRL_SESS_CB_HIT() {
        return SSL_CTRL_SESS_CB_HIT;
    }
    private static final int SSL_CTRL_SESS_MISSES = (int)29L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_MISSES 29
     * }
     */
    public static int SSL_CTRL_SESS_MISSES() {
        return SSL_CTRL_SESS_MISSES;
    }
    private static final int SSL_CTRL_SESS_TIMEOUTS = (int)30L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_TIMEOUTS 30
     * }
     */
    public static int SSL_CTRL_SESS_TIMEOUTS() {
        return SSL_CTRL_SESS_TIMEOUTS;
    }
    private static final int SSL_CTRL_SESS_CACHE_FULL = (int)31L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SESS_CACHE_FULL 31
     * }
     */
    public static int SSL_CTRL_SESS_CACHE_FULL() {
        return SSL_CTRL_SESS_CACHE_FULL;
    }
    private static final int SSL_CTRL_SET_SESS_CACHE_SIZE = (int)42L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_SESS_CACHE_SIZE 42
     * }
     */
    public static int SSL_CTRL_SET_SESS_CACHE_SIZE() {
        return SSL_CTRL_SET_SESS_CACHE_SIZE;
    }
    private static final int SSL_CTRL_GET_SESS_CACHE_SIZE = (int)43L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_GET_SESS_CACHE_SIZE 43
     * }
     */
    public static int SSL_CTRL_GET_SESS_CACHE_SIZE() {
        return SSL_CTRL_GET_SESS_CACHE_SIZE;
    }
    private static final int SSL_CTRL_SET_SESS_CACHE_MODE = (int)44L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_SESS_CACHE_MODE 44
     * }
     */
    public static int SSL_CTRL_SET_SESS_CACHE_MODE() {
        return SSL_CTRL_SET_SESS_CACHE_MODE;
    }
    private static final int SSL_CTRL_GET_SESS_CACHE_MODE = (int)45L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_GET_SESS_CACHE_MODE 45
     * }
     */
    public static int SSL_CTRL_GET_SESS_CACHE_MODE() {
        return SSL_CTRL_GET_SESS_CACHE_MODE;
    }
    private static final int SSL_CTRL_SET_TLSEXT_TICKET_KEYS = (int)59L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_TLSEXT_TICKET_KEYS 59
     * }
     */
    public static int SSL_CTRL_SET_TLSEXT_TICKET_KEYS() {
        return SSL_CTRL_SET_TLSEXT_TICKET_KEYS;
    }
    private static final int SSL_CTRL_CHAIN_CERT = (int)89L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_CHAIN_CERT 89
     * }
     */
    public static int SSL_CTRL_CHAIN_CERT() {
        return SSL_CTRL_CHAIN_CERT;
    }
    private static final int SSL_CTRL_SET_GROUPS = (int)91L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_GROUPS 91
     * }
     */
    public static int SSL_CTRL_SET_GROUPS() {
        return SSL_CTRL_SET_GROUPS;
    }
    private static final int SSL_CTRL_SET_DH_AUTO = (int)118L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_DH_AUTO 118
     * }
     */
    public static int SSL_CTRL_SET_DH_AUTO() {
        return SSL_CTRL_SET_DH_AUTO;
    }
    private static final int SSL_CTRL_SET_MIN_PROTO_VERSION = (int)123L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_MIN_PROTO_VERSION 123
     * }
     */
    public static int SSL_CTRL_SET_MIN_PROTO_VERSION() {
        return SSL_CTRL_SET_MIN_PROTO_VERSION;
    }
    private static final int SSL_CTRL_SET_MAX_PROTO_VERSION = (int)124L;
    /**
     * {@snippet lang=c :
     * #define SSL_CTRL_SET_MAX_PROTO_VERSION 124
     * }
     */
    public static int SSL_CTRL_SET_MAX_PROTO_VERSION() {
        return SSL_CTRL_SET_MAX_PROTO_VERSION;
    }
    private static final int ERR_REASON_MASK = (int)8388607L;
    /**
     * {@snippet lang=c :
     * #define ERR_REASON_MASK 8388607
     * }
     */
    public static int ERR_REASON_MASK() {
        return ERR_REASON_MASK;
    }
    private static final int OCSP_RESPONSE_STATUS_SUCCESSFUL = (int)0L;
    /**
     * {@snippet lang=c :
     * #define OCSP_RESPONSE_STATUS_SUCCESSFUL 0
     * }
     */
    public static int OCSP_RESPONSE_STATUS_SUCCESSFUL() {
        return OCSP_RESPONSE_STATUS_SUCCESSFUL;
    }
    private static final int V_OCSP_CERTSTATUS_GOOD = (int)0L;
    /**
     * {@snippet lang=c :
     * #define V_OCSP_CERTSTATUS_GOOD 0
     * }
     */
    public static int V_OCSP_CERTSTATUS_GOOD() {
        return V_OCSP_CERTSTATUS_GOOD;
    }
    private static final int V_OCSP_CERTSTATUS_REVOKED = (int)1L;
    /**
     * {@snippet lang=c :
     * #define V_OCSP_CERTSTATUS_REVOKED 1
     * }
     */
    public static int V_OCSP_CERTSTATUS_REVOKED() {
        return V_OCSP_CERTSTATUS_REVOKED;
    }
    private static final int V_OCSP_CERTSTATUS_UNKNOWN = (int)2L;
    /**
     * {@snippet lang=c :
     * #define V_OCSP_CERTSTATUS_UNKNOWN 2
     * }
     */
    public static int V_OCSP_CERTSTATUS_UNKNOWN() {
        return V_OCSP_CERTSTATUS_UNKNOWN;
    }

    private static MethodHandle OPENSSL_sk_num$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OPENSSL_sk_num"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int OPENSSL_sk_num(const OPENSSL_STACK *)
     * }
     */
    public static int OPENSSL_sk_num(MemorySegment x0) {
        var mh$ = OPENSSL_sk_num$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OPENSSL_sk_num", x0);
            }
            return (int) mh$.invokeExact(x0);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OPENSSL_sk_value$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OPENSSL_sk_value"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void *OPENSSL_sk_value(const OPENSSL_STACK *, int)
     * }
     */
    public static MemorySegment OPENSSL_sk_value(MemorySegment x0, int x1) {
        var mh$ = OPENSSL_sk_value$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OPENSSL_sk_value", x0, x1);
            }
            return (MemorySegment) mh$.invokeExact(x0, x1);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OpenSSL_version_num$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OpenSSL_version_num"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * unsigned long OpenSSL_version_num(void)
     * }
     */
    public static long OpenSSL_version_num() {
        var mh$ = OpenSSL_version_num$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OpenSSL_version_num");
            }
            return (long) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OpenSSL_version$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OpenSSL_version"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const char *OpenSSL_version(int type)
     * }
     */
    public static MemorySegment OpenSSL_version(int type) {
        var mh$ = OpenSSL_version$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OpenSSL_version", type);
            }
            return (MemorySegment) mh$.invokeExact(type);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle CRYPTO_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("CRYPTO_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void CRYPTO_free(void *ptr, const char *file, int line)
     * }
     */
    public static void CRYPTO_free(MemorySegment ptr, MemorySegment file, int line) {
        var mh$ = CRYPTO_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("CRYPTO_free", ptr, file, line);
            }
            mh$.invokeExact(ptr, file, line);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_ctrl_pending$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_ctrl_pending"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * size_t BIO_ctrl_pending(BIO *b)
     * }
     */
    public static long BIO_ctrl_pending(MemorySegment b) {
        var mh$ = BIO_ctrl_pending$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_ctrl_pending", b);
            }
            return (long) mh$.invokeExact(b);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_s_file$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_s_file"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const BIO_METHOD *BIO_s_file(void)
     * }
     */
    public static MemorySegment BIO_s_file() {
        var mh$ = BIO_s_file$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_s_file");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_new_file$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_new_file"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIO *BIO_new_file(const char *filename, const char *mode)
     * }
     */
    public static MemorySegment BIO_new_file(MemorySegment filename, MemorySegment mode) {
        var mh$ = BIO_new_file$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_new_file", filename, mode);
            }
            return (MemorySegment) mh$.invokeExact(filename, mode);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIO *BIO_new(const BIO_METHOD *type)
     * }
     */
    public static MemorySegment BIO_new(MemorySegment type) {
        var mh$ = BIO_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_new", type);
            }
            return (MemorySegment) mh$.invokeExact(type);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int BIO_free(BIO *a)
     * }
     */
    public static int BIO_free(MemorySegment a) {
        var mh$ = BIO_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_free", a);
            }
            return (int) mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_read$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_read"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int BIO_read(BIO *b, void *data, int dlen)
     * }
     */
    public static int BIO_read(MemorySegment b, MemorySegment data, int dlen) {
        var mh$ = BIO_read$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_read", b, data, dlen);
            }
            return (int) mh$.invokeExact(b, data, dlen);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_write$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_write"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int BIO_write(BIO *b, const void *data, int dlen)
     * }
     */
    public static int BIO_write(MemorySegment b, MemorySegment data, int dlen) {
        var mh$ = BIO_write$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_write", b, data, dlen);
            }
            return (int) mh$.invokeExact(b, data, dlen);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_ctrl$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_ctrl"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * long BIO_ctrl(BIO *bp, int cmd, long larg, void *parg)
     * }
     */
    public static long BIO_ctrl(MemorySegment bp, int cmd, long larg, MemorySegment parg) {
        var mh$ = BIO_ctrl$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_ctrl", bp, cmd, larg, parg);
            }
            return (long) mh$.invokeExact(bp, cmd, larg, parg);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_s_mem$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_s_mem"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const BIO_METHOD *BIO_s_mem(void)
     * }
     */
    public static MemorySegment BIO_s_mem() {
        var mh$ = BIO_s_mem$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_s_mem");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_s_bio$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_s_bio"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const BIO_METHOD *BIO_s_bio(void)
     * }
     */
    public static MemorySegment BIO_s_bio() {
        var mh$ = BIO_s_bio$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_s_bio");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BIO_new_bio_pair$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BIO_new_bio_pair"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int BIO_new_bio_pair(BIO **bio1, size_t writebuf1, BIO **bio2, size_t writebuf2)
     * }
     */
    public static int BIO_new_bio_pair(MemorySegment bio1, long writebuf1, MemorySegment bio2, long writebuf2) {
        var mh$ = BIO_new_bio_pair$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BIO_new_bio_pair", bio1, writebuf1, bio2, writebuf2);
            }
            return (int) mh$.invokeExact(bio1, writebuf1, bio2, writebuf2);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_new(void)
     * }
     */
    public static MemorySegment BN_new() {
        var mh$ = BN_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_new");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_set_word$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_set_word"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int BN_set_word(BIGNUM *a, unsigned long w)
     * }
     */
    public static int BN_set_word(MemorySegment a, long w) {
        var mh$ = BN_set_word$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_set_word", a, w);
            }
            return (int) mh$.invokeExact(a, w);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc2409_prime_768$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc2409_prime_768"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc2409_prime_768(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc2409_prime_768(MemorySegment bn) {
        var mh$ = BN_get_rfc2409_prime_768$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc2409_prime_768", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc2409_prime_1024$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc2409_prime_1024"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc2409_prime_1024(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc2409_prime_1024(MemorySegment bn) {
        var mh$ = BN_get_rfc2409_prime_1024$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc2409_prime_1024", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc3526_prime_1536$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc3526_prime_1536"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc3526_prime_1536(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc3526_prime_1536(MemorySegment bn) {
        var mh$ = BN_get_rfc3526_prime_1536$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc3526_prime_1536", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc3526_prime_2048$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc3526_prime_2048"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc3526_prime_2048(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc3526_prime_2048(MemorySegment bn) {
        var mh$ = BN_get_rfc3526_prime_2048$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc3526_prime_2048", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc3526_prime_3072$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc3526_prime_3072"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc3526_prime_3072(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc3526_prime_3072(MemorySegment bn) {
        var mh$ = BN_get_rfc3526_prime_3072$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc3526_prime_3072", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc3526_prime_4096$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc3526_prime_4096"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc3526_prime_4096(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc3526_prime_4096(MemorySegment bn) {
        var mh$ = BN_get_rfc3526_prime_4096$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc3526_prime_4096", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc3526_prime_6144$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc3526_prime_6144"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc3526_prime_6144(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc3526_prime_6144(MemorySegment bn) {
        var mh$ = BN_get_rfc3526_prime_6144$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc3526_prime_6144", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle BN_get_rfc3526_prime_8192$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("BN_get_rfc3526_prime_8192"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * BIGNUM *BN_get_rfc3526_prime_8192(BIGNUM *bn)
     * }
     */
    public static MemorySegment BN_get_rfc3526_prime_8192(MemorySegment bn) {
        var mh$ = BN_get_rfc3526_prime_8192$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("BN_get_rfc3526_prime_8192", bn);
            }
            return (MemorySegment) mh$.invokeExact(bn);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ASN1_STRING_length$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ASN1_STRING_length"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int ASN1_STRING_length(const ASN1_STRING *x)
     * }
     */
    public static int ASN1_STRING_length(MemorySegment x) {
        var mh$ = ASN1_STRING_length$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ASN1_STRING_length", x);
            }
            return (int) mh$.invokeExact(x);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ASN1_STRING_get0_data$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ASN1_STRING_get0_data"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const unsigned char *ASN1_STRING_get0_data(const ASN1_STRING *x)
     * }
     */
    public static MemorySegment ASN1_STRING_get0_data(MemorySegment x) {
        var mh$ = ASN1_STRING_get0_data$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ASN1_STRING_get0_data", x);
            }
            return (MemorySegment) mh$.invokeExact(x);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EVP_MD_get0_provider$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EVP_MD_get0_provider"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const OSSL_PROVIDER *EVP_MD_get0_provider(const EVP_MD *md)
     * }
     */
    public static MemorySegment EVP_MD_get0_provider(MemorySegment md) {
        var mh$ = EVP_MD_get0_provider$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EVP_MD_get0_provider", md);
            }
            return (MemorySegment) mh$.invokeExact(md);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EVP_MD_fetch$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EVP_MD_fetch"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * EVP_MD *EVP_MD_fetch(OSSL_LIB_CTX *ctx, const char *algorithm, const char *properties)
     * }
     */
    public static MemorySegment EVP_MD_fetch(MemorySegment ctx, MemorySegment algorithm, MemorySegment properties) {
        var mh$ = EVP_MD_fetch$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EVP_MD_fetch", ctx, algorithm, properties);
            }
            return (MemorySegment) mh$.invokeExact(ctx, algorithm, properties);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EVP_MD_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EVP_MD_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void EVP_MD_free(EVP_MD *md)
     * }
     */
    public static void EVP_MD_free(MemorySegment md) {
        var mh$ = EVP_MD_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EVP_MD_free", md);
            }
            mh$.invokeExact(md);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EVP_PKEY_get_base_id$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EVP_PKEY_get_base_id"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int EVP_PKEY_get_base_id(const EVP_PKEY *pkey)
     * }
     */
    public static int EVP_PKEY_get_base_id(MemorySegment pkey) {
        var mh$ = EVP_PKEY_get_base_id$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EVP_PKEY_get_base_id", pkey);
            }
            return (int) mh$.invokeExact(pkey);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EVP_PKEY_get_bits$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EVP_PKEY_get_bits"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int EVP_PKEY_get_bits(const EVP_PKEY *pkey)
     * }
     */
    public static int EVP_PKEY_get_bits(MemorySegment pkey) {
        var mh$ = EVP_PKEY_get_bits$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EVP_PKEY_get_bits", pkey);
            }
            return (int) mh$.invokeExact(pkey);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EVP_PKEY_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EVP_PKEY_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void EVP_PKEY_free(EVP_PKEY *pkey)
     * }
     */
    public static void EVP_PKEY_free(MemorySegment pkey) {
        var mh$ = EVP_PKEY_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EVP_PKEY_free", pkey);
            }
            mh$.invokeExact(pkey);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EC_GROUP_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EC_GROUP_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void EC_GROUP_free(EC_GROUP *group)
     * }
     */
    public static void EC_GROUP_free(MemorySegment group) {
        var mh$ = EC_GROUP_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EC_GROUP_free", group);
            }
            mh$.invokeExact(group);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EC_GROUP_get_curve_name$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EC_GROUP_get_curve_name"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int EC_GROUP_get_curve_name(const EC_GROUP *group)
     * }
     */
    public static int EC_GROUP_get_curve_name(MemorySegment group) {
        var mh$ = EC_GROUP_get_curve_name$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EC_GROUP_get_curve_name", group);
            }
            return (int) mh$.invokeExact(group);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle d2i_ECPKParameters$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("d2i_ECPKParameters"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * EC_GROUP *d2i_ECPKParameters(EC_GROUP **, const unsigned char **in, long len)
     * }
     */
    public static MemorySegment d2i_ECPKParameters(MemorySegment x0, MemorySegment in, long len) {
        var mh$ = d2i_ECPKParameters$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("d2i_ECPKParameters", x0, in, len);
            }
            return (MemorySegment) mh$.invokeExact(x0, in, len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EC_KEY_new_by_curve_name$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EC_KEY_new_by_curve_name"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * EC_KEY *EC_KEY_new_by_curve_name(int nid)
     * }
     */
    public static MemorySegment EC_KEY_new_by_curve_name(int nid) {
        var mh$ = EC_KEY_new_by_curve_name$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EC_KEY_new_by_curve_name", nid);
            }
            return (MemorySegment) mh$.invokeExact(nid);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle EC_KEY_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("EC_KEY_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void EC_KEY_free(EC_KEY *key)
     * }
     */
    public static void EC_KEY_free(MemorySegment key) {
        var mh$ = EC_KEY_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("EC_KEY_free", key);
            }
            mh$.invokeExact(key);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle DH_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("DH_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * DH *DH_new(void)
     * }
     */
    public static MemorySegment DH_new() {
        var mh$ = DH_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("DH_new");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle DH_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("DH_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void DH_free(DH *dh)
     * }
     */
    public static void DH_free(MemorySegment dh) {
        var mh$ = DH_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("DH_free", dh);
            }
            mh$.invokeExact(dh);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle DH_set0_pqg$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("DH_set0_pqg"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int DH_set0_pqg(DH *dh, BIGNUM *p, BIGNUM *q, BIGNUM *g)
     * }
     */
    public static int DH_set0_pqg(MemorySegment dh, MemorySegment p, MemorySegment q, MemorySegment g) {
        var mh$ = DH_set0_pqg$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("DH_set0_pqg", dh, p, q, g);
            }
            return (int) mh$.invokeExact(dh, p, q, g);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_set_flags$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_set_flags"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int X509_STORE_set_flags(X509_STORE *ctx, unsigned long flags)
     * }
     */
    public static int X509_STORE_set_flags(MemorySegment ctx, long flags) {
        var mh$ = X509_STORE_set_flags$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_set_flags", ctx, flags);
            }
            return (int) mh$.invokeExact(ctx, flags);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_get0_untrusted$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_get0_untrusted"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct stack_st_X509 *X509_STORE_CTX_get0_untrusted(const X509_STORE_CTX *ctx)
     * }
     */
    public static MemorySegment X509_STORE_CTX_get0_untrusted(MemorySegment ctx) {
        var mh$ = X509_STORE_CTX_get0_untrusted$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_get0_untrusted", ctx);
            }
            return (MemorySegment) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_add_lookup$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_add_lookup"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509_LOOKUP *X509_STORE_add_lookup(X509_STORE *v, X509_LOOKUP_METHOD *m)
     * }
     */
    public static MemorySegment X509_STORE_add_lookup(MemorySegment v, MemorySegment m) {
        var mh$ = X509_STORE_add_lookup$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_add_lookup", v, m);
            }
            return (MemorySegment) mh$.invokeExact(v, m);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_LOOKUP_hash_dir$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_LOOKUP_hash_dir"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509_LOOKUP_METHOD *X509_LOOKUP_hash_dir(void)
     * }
     */
    public static MemorySegment X509_LOOKUP_hash_dir() {
        var mh$ = X509_LOOKUP_hash_dir$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_LOOKUP_hash_dir");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_LOOKUP_file$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_LOOKUP_file"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509_LOOKUP_METHOD *X509_LOOKUP_file(void)
     * }
     */
    public static MemorySegment X509_LOOKUP_file() {
        var mh$ = X509_LOOKUP_file$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_LOOKUP_file");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_LOOKUP_ctrl$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_LOOKUP_ctrl"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int X509_LOOKUP_ctrl(X509_LOOKUP *ctx, int cmd, const char *argc, long argl, char **ret)
     * }
     */
    public static int X509_LOOKUP_ctrl(MemorySegment ctx, int cmd, MemorySegment argc, long argl, MemorySegment ret) {
        var mh$ = X509_LOOKUP_ctrl$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_LOOKUP_ctrl", ctx, cmd, argc, argl, ret);
            }
            return (int) mh$.invokeExact(ctx, cmd, argc, argl, ret);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_get_ex_data$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_get_ex_data"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void *X509_STORE_CTX_get_ex_data(const X509_STORE_CTX *ctx, int idx)
     * }
     */
    public static MemorySegment X509_STORE_CTX_get_ex_data(MemorySegment ctx, int idx) {
        var mh$ = X509_STORE_CTX_get_ex_data$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_get_ex_data", ctx, idx);
            }
            return (MemorySegment) mh$.invokeExact(ctx, idx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_get_error$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_get_error"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int X509_STORE_CTX_get_error(const X509_STORE_CTX *ctx)
     * }
     */
    public static int X509_STORE_CTX_get_error(MemorySegment ctx) {
        var mh$ = X509_STORE_CTX_get_error$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_get_error", ctx);
            }
            return (int) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_set_error$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_set_error"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void X509_STORE_CTX_set_error(X509_STORE_CTX *ctx, int s)
     * }
     */
    public static void X509_STORE_CTX_set_error(MemorySegment ctx, int s) {
        var mh$ = X509_STORE_CTX_set_error$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_set_error", ctx, s);
            }
            mh$.invokeExact(ctx, s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_get_error_depth$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_get_error_depth"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int X509_STORE_CTX_get_error_depth(const X509_STORE_CTX *ctx)
     * }
     */
    public static int X509_STORE_CTX_get_error_depth(MemorySegment ctx) {
        var mh$ = X509_STORE_CTX_get_error_depth$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_get_error_depth", ctx);
            }
            return (int) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_get_current_cert$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_get_current_cert"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509 *X509_STORE_CTX_get_current_cert(const X509_STORE_CTX *ctx)
     * }
     */
    public static MemorySegment X509_STORE_CTX_get_current_cert(MemorySegment ctx) {
        var mh$ = X509_STORE_CTX_get_current_cert$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_get_current_cert", ctx);
            }
            return (MemorySegment) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_STORE_CTX_get0_current_issuer$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_STORE_CTX_get0_current_issuer"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509 *X509_STORE_CTX_get0_current_issuer(const X509_STORE_CTX *ctx)
     * }
     */
    public static MemorySegment X509_STORE_CTX_get0_current_issuer(MemorySegment ctx) {
        var mh$ = X509_STORE_CTX_get0_current_issuer$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_STORE_CTX_get0_current_issuer", ctx);
            }
            return (MemorySegment) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle d2i_X509_bio$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("d2i_X509_bio"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509 *d2i_X509_bio(BIO *bp, X509 **x509)
     * }
     */
    public static MemorySegment d2i_X509_bio(MemorySegment bp, MemorySegment x509) {
        var mh$ = d2i_X509_bio$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("d2i_X509_bio", bp, x509);
            }
            return (MemorySegment) mh$.invokeExact(bp, x509);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern void X509_free(X509 *a)
     * }
     */
    public static void X509_free(MemorySegment a) {
        var mh$ = X509_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_free", a);
            }
            mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle d2i_X509$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("d2i_X509"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern X509 *d2i_X509(X509 **a, const unsigned char **in, long len)
     * }
     */
    public static MemorySegment d2i_X509(MemorySegment a, MemorySegment in, long len) {
        var mh$ = d2i_X509$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("d2i_X509", a, in, len);
            }
            return (MemorySegment) mh$.invokeExact(a, in, len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle i2d_X509$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("i2d_X509"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern int i2d_X509(const X509 *a, unsigned char **out)
     * }
     */
    public static int i2d_X509(MemorySegment a, MemorySegment out) {
        var mh$ = i2d_X509$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("i2d_X509", a, out);
            }
            return (int) mh$.invokeExact(a, out);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_get_ext_by_NID$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_get_ext_by_NID"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int X509_get_ext_by_NID(const X509 *x, int nid, int lastpos)
     * }
     */
    public static int X509_get_ext_by_NID(MemorySegment x, int nid, int lastpos) {
        var mh$ = X509_get_ext_by_NID$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_get_ext_by_NID", x, nid, lastpos);
            }
            return (int) mh$.invokeExact(x, nid, lastpos);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_get_ext$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_get_ext"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509_EXTENSION *X509_get_ext(const X509 *x, int loc)
     * }
     */
    public static MemorySegment X509_get_ext(MemorySegment x, int loc) {
        var mh$ = X509_get_ext$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_get_ext", x, loc);
            }
            return (MemorySegment) mh$.invokeExact(x, loc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_EXTENSION_get_data$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_EXTENSION_get_data"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * ASN1_OCTET_STRING *X509_EXTENSION_get_data(X509_EXTENSION *ne)
     * }
     */
    public static MemorySegment X509_EXTENSION_get_data(MemorySegment ne) {
        var mh$ = X509_EXTENSION_get_data$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_EXTENSION_get_data", ne);
            }
            return (MemorySegment) mh$.invokeExact(ne);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PEM_ASN1_read_bio$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PEM_ASN1_read_bio"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void *PEM_ASN1_read_bio(d2i_of_void *d2i, const char *name, BIO *bp, void **x, pem_password_cb *cb, void *u)
     * }
     */
    public static MemorySegment PEM_ASN1_read_bio(MemorySegment d2i, MemorySegment name, MemorySegment bp, MemorySegment x, MemorySegment cb, MemorySegment u) {
        var mh$ = PEM_ASN1_read_bio$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PEM_ASN1_read_bio", d2i, name, bp, x, cb, u);
            }
            return (MemorySegment) mh$.invokeExact(d2i, name, bp, x, cb, u);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PEM_read_bio_X509_AUX$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PEM_read_bio_X509_AUX"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern X509 *PEM_read_bio_X509_AUX(BIO *out, X509 **x, pem_password_cb *cb, void *u)
     * }
     */
    public static MemorySegment PEM_read_bio_X509_AUX(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        var mh$ = PEM_read_bio_X509_AUX$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PEM_read_bio_X509_AUX", out, x, cb, u);
            }
            return (MemorySegment) mh$.invokeExact(out, x, cb, u);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PEM_read_bio_ECPKParameters$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PEM_read_bio_ECPKParameters"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * EC_GROUP *PEM_read_bio_ECPKParameters(BIO *out, EC_GROUP **x, pem_password_cb *cb, void *u)
     * }
     */
    public static MemorySegment PEM_read_bio_ECPKParameters(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        var mh$ = PEM_read_bio_ECPKParameters$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PEM_read_bio_ECPKParameters", out, x, cb, u);
            }
            return (MemorySegment) mh$.invokeExact(out, x, cb, u);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PEM_read_bio_DHparams$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PEM_read_bio_DHparams"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * DH *PEM_read_bio_DHparams(BIO *out, DH **x, pem_password_cb *cb, void *u)
     * }
     */
    public static MemorySegment PEM_read_bio_DHparams(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        var mh$ = PEM_read_bio_DHparams$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PEM_read_bio_DHparams", out, x, cb, u);
            }
            return (MemorySegment) mh$.invokeExact(out, x, cb, u);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PEM_read_bio_PrivateKey$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PEM_read_bio_PrivateKey"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern EVP_PKEY *PEM_read_bio_PrivateKey(BIO *out, EVP_PKEY **x, pem_password_cb *cb, void *u)
     * }
     */
    public static MemorySegment PEM_read_bio_PrivateKey(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        var mh$ = PEM_read_bio_PrivateKey$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PEM_read_bio_PrivateKey", out, x, cb, u);
            }
            return (MemorySegment) mh$.invokeExact(out, x, cb, u);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PEM_read_bio_Parameters$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PEM_read_bio_Parameters"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * EVP_PKEY *PEM_read_bio_Parameters(BIO *bp, EVP_PKEY **x)
     * }
     */
    public static MemorySegment PEM_read_bio_Parameters(MemorySegment bp, MemorySegment x) {
        var mh$ = PEM_read_bio_Parameters$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PEM_read_bio_Parameters", bp, x);
            }
            return (MemorySegment) mh$.invokeExact(bp, x);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_get_options$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_get_options"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * uint64_t SSL_CTX_get_options(const SSL_CTX *ctx)
     * }
     */
    public static long SSL_CTX_get_options(MemorySegment ctx) {
        var mh$ = SSL_CTX_get_options$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_get_options", ctx);
            }
            return (long) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_options$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_options"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * uint64_t SSL_get_options(const SSL *s)
     * }
     */
    public static long SSL_get_options(MemorySegment s) {
        var mh$ = SSL_get_options$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_options", s);
            }
            return (long) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_clear_options$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_clear_options"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * uint64_t SSL_CTX_clear_options(SSL_CTX *ctx, uint64_t op)
     * }
     */
    public static long SSL_CTX_clear_options(MemorySegment ctx, long op) {
        var mh$ = SSL_CTX_clear_options$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_clear_options", ctx, op);
            }
            return (long) mh$.invokeExact(ctx, op);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_options$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_options"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * uint64_t SSL_CTX_set_options(SSL_CTX *ctx, uint64_t op)
     * }
     */
    public static long SSL_CTX_set_options(MemorySegment ctx, long op) {
        var mh$ = SSL_CTX_set_options$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_options", ctx, op);
            }
            return (long) mh$.invokeExact(ctx, op);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_options$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_options"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * uint64_t SSL_set_options(SSL *s, uint64_t op)
     * }
     */
    public static long SSL_set_options(MemorySegment s, long op) {
        var mh$ = SSL_set_options$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_options", s, op);
            }
            return (long) mh$.invokeExact(s, op);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_alpn_select_cb$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_alpn_select_cb"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_set_alpn_select_cb(SSL_CTX *ctx, SSL_CTX_alpn_select_cb_func cb, void *arg)
     * }
     */
    public static void SSL_CTX_set_alpn_select_cb(MemorySegment ctx, MemorySegment cb, MemorySegment arg) {
        var mh$ = SSL_CTX_set_alpn_select_cb$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_alpn_select_cb", ctx, cb, arg);
            }
            mh$.invokeExact(ctx, cb, arg);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get0_alpn_selected$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get0_alpn_selected"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_get0_alpn_selected(const SSL *ssl, const unsigned char **data, unsigned int *len)
     * }
     */
    public static void SSL_get0_alpn_selected(MemorySegment ssl, MemorySegment data, MemorySegment len) {
        var mh$ = SSL_get0_alpn_selected$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get0_alpn_selected", ssl, data, len);
            }
            mh$.invokeExact(ssl, data, len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_in_init$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_in_init"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_in_init(const SSL *s)
     * }
     */
    public static int SSL_in_init(MemorySegment s) {
        var mh$ = SSL_in_init$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_in_init", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set0_tmp_dh_pkey$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set0_tmp_dh_pkey"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_set0_tmp_dh_pkey(SSL_CTX *ctx, EVP_PKEY *dhpkey)
     * }
     */
    public static int SSL_CTX_set0_tmp_dh_pkey(MemorySegment ctx, MemorySegment dhpkey) {
        var mh$ = SSL_CTX_set0_tmp_dh_pkey$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set0_tmp_dh_pkey", ctx, dhpkey);
            }
            return (int) mh$.invokeExact(ctx, dhpkey);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_cipher_list$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_cipher_list"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_set_cipher_list(SSL_CTX *, const char *str)
     * }
     */
    public static int SSL_CTX_set_cipher_list(MemorySegment x0, MemorySegment str) {
        var mh$ = SSL_CTX_set_cipher_list$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_cipher_list", x0, str);
            }
            return (int) mh$.invokeExact(x0, str);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * SSL_CTX *SSL_CTX_new(const SSL_METHOD *meth)
     * }
     */
    public static MemorySegment SSL_CTX_new(MemorySegment meth) {
        var mh$ = SSL_CTX_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_new", meth);
            }
            return (MemorySegment) mh$.invokeExact(meth);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_free(SSL_CTX *)
     * }
     */
    public static void SSL_CTX_free(MemorySegment x0) {
        var mh$ = SSL_CTX_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_free", x0);
            }
            mh$.invokeExact(x0);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_timeout$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_timeout"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * long SSL_CTX_set_timeout(SSL_CTX *ctx, long t)
     * }
     */
    public static long SSL_CTX_set_timeout(MemorySegment ctx, long t) {
        var mh$ = SSL_CTX_set_timeout$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_timeout", ctx, t);
            }
            return (long) mh$.invokeExact(ctx, t);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_get_timeout$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_get_timeout"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * long SSL_CTX_get_timeout(const SSL_CTX *ctx)
     * }
     */
    public static long SSL_CTX_get_timeout(MemorySegment ctx) {
        var mh$ = SSL_CTX_get_timeout$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_get_timeout", ctx);
            }
            return (long) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_get_cert_store$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_get_cert_store"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509_STORE *SSL_CTX_get_cert_store(const SSL_CTX *)
     * }
     */
    public static MemorySegment SSL_CTX_get_cert_store(MemorySegment x0) {
        var mh$ = SSL_CTX_get_cert_store$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_get_cert_store", x0);
            }
            return (MemorySegment) mh$.invokeExact(x0);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_current_cipher$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_current_cipher"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const SSL_CIPHER *SSL_get_current_cipher(const SSL *s)
     * }
     */
    public static MemorySegment SSL_get_current_cipher(MemorySegment s) {
        var mh$ = SSL_get_current_cipher$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_current_cipher", s);
            }
            return (MemorySegment) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CIPHER_get_name$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CIPHER_get_name"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const char *SSL_CIPHER_get_name(const SSL_CIPHER *c)
     * }
     */
    public static MemorySegment SSL_CIPHER_get_name(MemorySegment c) {
        var mh$ = SSL_CIPHER_get_name$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CIPHER_get_name", c);
            }
            return (MemorySegment) mh$.invokeExact(c);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CIPHER_get_kx_nid$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CIPHER_get_kx_nid"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CIPHER_get_kx_nid(const SSL_CIPHER *c)
     * }
     */
    public static int SSL_CIPHER_get_kx_nid(MemorySegment c) {
        var mh$ = SSL_CIPHER_get_kx_nid$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CIPHER_get_kx_nid", c);
            }
            return (int) mh$.invokeExact(c);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CIPHER_get_auth_nid$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CIPHER_get_auth_nid"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CIPHER_get_auth_nid(const SSL_CIPHER *c)
     * }
     */
    public static int SSL_CIPHER_get_auth_nid(MemorySegment c) {
        var mh$ = SSL_CIPHER_get_auth_nid$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CIPHER_get_auth_nid", c);
            }
            return (int) mh$.invokeExact(c);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_pending$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_pending"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_pending(const SSL *s)
     * }
     */
    public static int SSL_pending(MemorySegment s) {
        var mh$ = SSL_pending$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_pending", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_bio$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_bio"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_set_bio(SSL *s, BIO *rbio, BIO *wbio)
     * }
     */
    public static void SSL_set_bio(MemorySegment s, MemorySegment rbio, MemorySegment wbio) {
        var mh$ = SSL_set_bio$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_bio", s, rbio, wbio);
            }
            mh$.invokeExact(s, rbio, wbio);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_cipher_list$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_cipher_list"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_set_cipher_list(SSL *s, const char *str)
     * }
     */
    public static int SSL_set_cipher_list(MemorySegment s, MemorySegment str) {
        var mh$ = SSL_set_cipher_list$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_cipher_list", s, str);
            }
            return (int) mh$.invokeExact(s, str);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_ciphersuites$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_ciphersuites"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_set_ciphersuites(SSL_CTX *ctx, const char *str)
     * }
     */
    public static int SSL_CTX_set_ciphersuites(MemorySegment ctx, MemorySegment str) {
        var mh$ = SSL_CTX_set_ciphersuites$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_ciphersuites", ctx, str);
            }
            return (int) mh$.invokeExact(ctx, str);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_verify$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_verify"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_set_verify(SSL *s, int mode, SSL_verify_cb callback)
     * }
     */
    public static void SSL_set_verify(MemorySegment s, int mode, MemorySegment callback) {
        var mh$ = SSL_set_verify$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_verify", s, mode, callback);
            }
            mh$.invokeExact(s, mode, callback);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_use_certificate_chain_file$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_use_certificate_chain_file"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_use_certificate_chain_file(SSL_CTX *ctx, const char *file)
     * }
     */
    public static int SSL_CTX_use_certificate_chain_file(MemorySegment ctx, MemorySegment file) {
        var mh$ = SSL_CTX_use_certificate_chain_file$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_use_certificate_chain_file", ctx, file);
            }
            return (int) mh$.invokeExact(ctx, file);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_load_client_CA_file$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_load_client_CA_file"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct stack_st_X509_NAME *SSL_load_client_CA_file(const char *file)
     * }
     */
    public static MemorySegment SSL_load_client_CA_file(MemorySegment file) {
        var mh$ = SSL_load_client_CA_file$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_load_client_CA_file", file);
            }
            return (MemorySegment) mh$.invokeExact(file);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_add_file_cert_subjects_to_stack$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_add_file_cert_subjects_to_stack"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_add_file_cert_subjects_to_stack(struct stack_st_X509_NAME *stackCAs, const char *file)
     * }
     */
    public static int SSL_add_file_cert_subjects_to_stack(MemorySegment stackCAs, MemorySegment file) {
        var mh$ = SSL_add_file_cert_subjects_to_stack$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_add_file_cert_subjects_to_stack", stackCAs, file);
            }
            return (int) mh$.invokeExact(stackCAs, file);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_SESSION_get_time$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_SESSION_get_time"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * long SSL_SESSION_get_time(const SSL_SESSION *s)
     * }
     */
    public static long SSL_SESSION_get_time(MemorySegment s) {
        var mh$ = SSL_SESSION_get_time$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_SESSION_get_time", s);
            }
            return (long) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_SESSION_get_id$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_SESSION_get_id"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const unsigned char *SSL_SESSION_get_id(const SSL_SESSION *s, unsigned int *len)
     * }
     */
    public static MemorySegment SSL_SESSION_get_id(MemorySegment s, MemorySegment len) {
        var mh$ = SSL_SESSION_get_id$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_SESSION_get_id", s, len);
            }
            return (MemorySegment) mh$.invokeExact(s, len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get1_peer_certificate$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get1_peer_certificate"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * X509 *SSL_get1_peer_certificate(const SSL *s)
     * }
     */
    public static MemorySegment SSL_get1_peer_certificate(MemorySegment s) {
        var mh$ = SSL_get1_peer_certificate$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get1_peer_certificate", s);
            }
            return (MemorySegment) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_peer_cert_chain$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_peer_cert_chain"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct stack_st_X509 *SSL_get_peer_cert_chain(const SSL *s)
     * }
     */
    public static MemorySegment SSL_get_peer_cert_chain(MemorySegment s) {
        var mh$ = SSL_get_peer_cert_chain$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_peer_cert_chain", s);
            }
            return (MemorySegment) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_verify$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_verify"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_set_verify(SSL_CTX *ctx, int mode, SSL_verify_cb callback)
     * }
     */
    public static void SSL_CTX_set_verify(MemorySegment ctx, int mode, MemorySegment callback) {
        var mh$ = SSL_CTX_set_verify$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_verify", ctx, mode, callback);
            }
            mh$.invokeExact(ctx, mode, callback);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_cert_verify_callback$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_cert_verify_callback"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_set_cert_verify_callback(SSL_CTX *ctx, int (*cb)(X509_STORE_CTX *, void *), void *arg)
     * }
     */
    public static void SSL_CTX_set_cert_verify_callback(MemorySegment ctx, MemorySegment cb, MemorySegment arg) {
        var mh$ = SSL_CTX_set_cert_verify_callback$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_cert_verify_callback", ctx, cb, arg);
            }
            mh$.invokeExact(ctx, cb, arg);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_use_PrivateKey$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_use_PrivateKey"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_use_PrivateKey(SSL_CTX *ctx, EVP_PKEY *pkey)
     * }
     */
    public static int SSL_CTX_use_PrivateKey(MemorySegment ctx, MemorySegment pkey) {
        var mh$ = SSL_CTX_use_PrivateKey$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_use_PrivateKey", ctx, pkey);
            }
            return (int) mh$.invokeExact(ctx, pkey);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_use_certificate$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_use_certificate"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_use_certificate(SSL_CTX *ctx, X509 *x)
     * }
     */
    public static int SSL_CTX_use_certificate(MemorySegment ctx, MemorySegment x) {
        var mh$ = SSL_CTX_use_certificate$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_use_certificate", ctx, x);
            }
            return (int) mh$.invokeExact(ctx, x);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_default_passwd_cb$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_default_passwd_cb"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_set_default_passwd_cb(SSL_CTX *ctx, pem_password_cb *cb)
     * }
     */
    public static void SSL_CTX_set_default_passwd_cb(MemorySegment ctx, MemorySegment cb) {
        var mh$ = SSL_CTX_set_default_passwd_cb$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_default_passwd_cb", ctx, cb);
            }
            mh$.invokeExact(ctx, cb);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_check_private_key$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_check_private_key"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_check_private_key(const SSL_CTX *ctx)
     * }
     */
    public static int SSL_CTX_check_private_key(MemorySegment ctx) {
        var mh$ = SSL_CTX_check_private_key$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_check_private_key", ctx);
            }
            return (int) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_session_id_context$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_session_id_context"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_set_session_id_context(SSL_CTX *ctx, const unsigned char *sid_ctx, unsigned int sid_ctx_len)
     * }
     */
    public static int SSL_CTX_set_session_id_context(MemorySegment ctx, MemorySegment sid_ctx, int sid_ctx_len) {
        var mh$ = SSL_CTX_set_session_id_context$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_session_id_context", ctx, sid_ctx, sid_ctx_len);
            }
            return (int) mh$.invokeExact(ctx, sid_ctx, sid_ctx_len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * SSL *SSL_new(SSL_CTX *ctx)
     * }
     */
    public static MemorySegment SSL_new(MemorySegment ctx) {
        var mh$ = SSL_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_new", ctx);
            }
            return (MemorySegment) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_free(SSL *ssl)
     * }
     */
    public static void SSL_free(MemorySegment ssl) {
        var mh$ = SSL_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_free", ssl);
            }
            mh$.invokeExact(ssl);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_read$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_read"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_read(SSL *ssl, void *buf, int num)
     * }
     */
    public static int SSL_read(MemorySegment ssl, MemorySegment buf, int num) {
        var mh$ = SSL_read$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_read", ssl, buf, num);
            }
            return (int) mh$.invokeExact(ssl, buf, num);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_write$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_write"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_write(SSL *ssl, const void *buf, int num)
     * }
     */
    public static int SSL_write(MemorySegment ssl, MemorySegment buf, int num) {
        var mh$ = SSL_write$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_write", ssl, buf, num);
            }
            return (int) mh$.invokeExact(ssl, buf, num);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_ctrl$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_ctrl"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * long SSL_CTX_ctrl(SSL_CTX *ctx, int cmd, long larg, void *parg)
     * }
     */
    public static long SSL_CTX_ctrl(MemorySegment ctx, int cmd, long larg, MemorySegment parg) {
        var mh$ = SSL_CTX_ctrl$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_ctrl", ctx, cmd, larg, parg);
            }
            return (long) mh$.invokeExact(ctx, cmd, larg, parg);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_ctrl$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_INT,
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_ctrl"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * long SSL_ctrl(SSL *ssl, int cmd, long larg, void *parg)
     * }
     */
    public static long SSL_ctrl(MemorySegment ssl, int cmd, long larg, MemorySegment parg) {
        var mh$ = SSL_ctrl$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_ctrl", ssl, cmd, larg, parg);
            }
            return (long) mh$.invokeExact(ssl, cmd, larg, parg);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_version$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_version"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const char *SSL_get_version(const SSL *s)
     * }
     */
    public static MemorySegment SSL_get_version(MemorySegment s) {
        var mh$ = SSL_get_version$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_version", s);
            }
            return (MemorySegment) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle TLS_server_method$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("TLS_server_method"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const SSL_METHOD *TLS_server_method(void)
     * }
     */
    public static MemorySegment TLS_server_method() {
        var mh$ = TLS_server_method$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("TLS_server_method");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_ciphers$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_ciphers"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct stack_st_SSL_CIPHER *SSL_get_ciphers(const SSL *s)
     * }
     */
    public static MemorySegment SSL_get_ciphers(MemorySegment s) {
        var mh$ = SSL_get_ciphers$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_ciphers", s);
            }
            return (MemorySegment) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_get_ciphers$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_get_ciphers"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct stack_st_SSL_CIPHER *SSL_CTX_get_ciphers(const SSL_CTX *ctx)
     * }
     */
    public static MemorySegment SSL_CTX_get_ciphers(MemorySegment ctx) {
        var mh$ = SSL_CTX_get_ciphers$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_get_ciphers", ctx);
            }
            return (MemorySegment) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_do_handshake$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_do_handshake"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_do_handshake(SSL *s)
     * }
     */
    public static int SSL_do_handshake(MemorySegment s) {
        var mh$ = SSL_do_handshake$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_do_handshake", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_renegotiate$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_renegotiate"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_renegotiate(SSL *s)
     * }
     */
    public static int SSL_renegotiate(MemorySegment s) {
        var mh$ = SSL_renegotiate$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_renegotiate", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_renegotiate_pending$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_renegotiate_pending"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_renegotiate_pending(const SSL *s)
     * }
     */
    public static int SSL_renegotiate_pending(MemorySegment s) {
        var mh$ = SSL_renegotiate_pending$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_renegotiate_pending", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_shutdown$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_shutdown"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_shutdown(SSL *s)
     * }
     */
    public static int SSL_shutdown(MemorySegment s) {
        var mh$ = SSL_shutdown$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_shutdown", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_verify_client_post_handshake$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_verify_client_post_handshake"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_verify_client_post_handshake(SSL *s)
     * }
     */
    public static int SSL_verify_client_post_handshake(MemorySegment s) {
        var mh$ = SSL_verify_client_post_handshake$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_verify_client_post_handshake", s);
            }
            return (int) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_client_CA_list$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_client_CA_list"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_set_client_CA_list(SSL_CTX *ctx, struct stack_st_X509_NAME *name_list)
     * }
     */
    public static void SSL_CTX_set_client_CA_list(MemorySegment ctx, MemorySegment name_list) {
        var mh$ = SSL_CTX_set_client_CA_list$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_client_CA_list", ctx, name_list);
            }
            mh$.invokeExact(ctx, name_list);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_get_client_CA_list$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_get_client_CA_list"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct stack_st_X509_NAME *SSL_CTX_get_client_CA_list(const SSL_CTX *s)
     * }
     */
    public static MemorySegment SSL_CTX_get_client_CA_list(MemorySegment s) {
        var mh$ = SSL_CTX_get_client_CA_list$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_get_client_CA_list", s);
            }
            return (MemorySegment) mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_add_client_CA$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_add_client_CA"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_add_client_CA(SSL_CTX *ctx, X509 *x)
     * }
     */
    public static int SSL_CTX_add_client_CA(MemorySegment ctx, MemorySegment x) {
        var mh$ = SSL_CTX_add_client_CA$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_add_client_CA", ctx, x);
            }
            return (int) mh$.invokeExact(ctx, x);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_connect_state$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_connect_state"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_set_connect_state(SSL *s)
     * }
     */
    public static void SSL_set_connect_state(MemorySegment s) {
        var mh$ = SSL_set_connect_state$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_connect_state", s);
            }
            mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_accept_state$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_accept_state"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_set_accept_state(SSL *s)
     * }
     */
    public static void SSL_set_accept_state(MemorySegment s) {
        var mh$ = SSL_set_accept_state$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_accept_state", s);
            }
            mh$.invokeExact(s);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_privatekey$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_privatekey"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * struct evp_pkey_st *SSL_get_privatekey(const SSL *ssl)
     * }
     */
    public static MemorySegment SSL_get_privatekey(MemorySegment ssl) {
        var mh$ = SSL_get_privatekey$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_privatekey", ssl);
            }
            return (MemorySegment) mh$.invokeExact(ssl);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_shutdown$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_shutdown"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_get_shutdown(const SSL *ssl)
     * }
     */
    public static int SSL_get_shutdown(MemorySegment ssl) {
        var mh$ = SSL_get_shutdown$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_shutdown", ssl);
            }
            return (int) mh$.invokeExact(ssl);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_default_verify_paths$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_default_verify_paths"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_set_default_verify_paths(SSL_CTX *ctx)
     * }
     */
    public static int SSL_CTX_set_default_verify_paths(MemorySegment ctx) {
        var mh$ = SSL_CTX_set_default_verify_paths$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_default_verify_paths", ctx);
            }
            return (int) mh$.invokeExact(ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_load_verify_locations$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_load_verify_locations"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CTX_load_verify_locations(SSL_CTX *ctx, const char *CAfile, const char *CApath)
     * }
     */
    public static int SSL_CTX_load_verify_locations(MemorySegment ctx, MemorySegment CAfile, MemorySegment CApath) {
        var mh$ = SSL_CTX_load_verify_locations$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_load_verify_locations", ctx, CAfile, CApath);
            }
            return (int) mh$.invokeExact(ctx, CAfile, CApath);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_session$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_session"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * SSL_SESSION *SSL_get_session(const SSL *ssl)
     * }
     */
    public static MemorySegment SSL_get_session(MemorySegment ssl) {
        var mh$ = SSL_get_session$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_session", ssl);
            }
            return (MemorySegment) mh$.invokeExact(ssl);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_info_callback$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_info_callback"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_set_info_callback(SSL *ssl, void (*cb)(const SSL *, int, int))
     * }
     */
    public static void SSL_set_info_callback(MemorySegment ssl, MemorySegment cb) {
        var mh$ = SSL_set_info_callback$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_info_callback", ssl, cb);
            }
            mh$.invokeExact(ssl, cb);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_set_verify_result$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_set_verify_result"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_set_verify_result(SSL *ssl, long v)
     * }
     */
    public static void SSL_set_verify_result(MemorySegment ssl, long v) {
        var mh$ = SSL_set_verify_result$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_set_verify_result", ssl, v);
            }
            mh$.invokeExact(ssl, v);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_get_ex_data_X509_STORE_CTX_idx$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_get_ex_data_X509_STORE_CTX_idx"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_get_ex_data_X509_STORE_CTX_idx(void)
     * }
     */
    public static int SSL_get_ex_data_X509_STORE_CTX_idx() {
        var mh$ = SSL_get_ex_data_X509_STORE_CTX_idx$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_get_ex_data_X509_STORE_CTX_idx");
            }
            return (int) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CTX_set_tmp_dh_callback$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CTX_set_tmp_dh_callback"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CTX_set_tmp_dh_callback(SSL_CTX *ctx, DH *(*dh)(SSL *, int, int))
     * }
     */
    public static void SSL_CTX_set_tmp_dh_callback(MemorySegment ctx, MemorySegment dh) {
        var mh$ = SSL_CTX_set_tmp_dh_callback$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CTX_set_tmp_dh_callback", ctx, dh);
            }
            mh$.invokeExact(ctx, dh);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_CTX_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_CTX_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * SSL_CONF_CTX *SSL_CONF_CTX_new(void)
     * }
     */
    public static MemorySegment SSL_CONF_CTX_new() {
        var mh$ = SSL_CONF_CTX_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_CTX_new");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_CTX_finish$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_CTX_finish"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CONF_CTX_finish(SSL_CONF_CTX *cctx)
     * }
     */
    public static int SSL_CONF_CTX_finish(MemorySegment cctx) {
        var mh$ = SSL_CONF_CTX_finish$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_CTX_finish", cctx);
            }
            return (int) mh$.invokeExact(cctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_CTX_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_CTX_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CONF_CTX_free(SSL_CONF_CTX *cctx)
     * }
     */
    public static void SSL_CONF_CTX_free(MemorySegment cctx) {
        var mh$ = SSL_CONF_CTX_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_CTX_free", cctx);
            }
            mh$.invokeExact(cctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_CTX_set_flags$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_CTX_set_flags"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * unsigned int SSL_CONF_CTX_set_flags(SSL_CONF_CTX *cctx, unsigned int flags)
     * }
     */
    public static int SSL_CONF_CTX_set_flags(MemorySegment cctx, int flags) {
        var mh$ = SSL_CONF_CTX_set_flags$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_CTX_set_flags", cctx, flags);
            }
            return (int) mh$.invokeExact(cctx, flags);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_CTX_set_ssl_ctx$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_CTX_set_ssl_ctx"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void SSL_CONF_CTX_set_ssl_ctx(SSL_CONF_CTX *cctx, SSL_CTX *ctx)
     * }
     */
    public static void SSL_CONF_CTX_set_ssl_ctx(MemorySegment cctx, MemorySegment ctx) {
        var mh$ = SSL_CONF_CTX_set_ssl_ctx$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_CTX_set_ssl_ctx", cctx, ctx);
            }
            mh$.invokeExact(cctx, ctx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_cmd$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_cmd"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CONF_cmd(SSL_CONF_CTX *cctx, const char *cmd, const char *value)
     * }
     */
    public static int SSL_CONF_cmd(MemorySegment cctx, MemorySegment cmd, MemorySegment value) {
        var mh$ = SSL_CONF_cmd$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_cmd", cctx, cmd, value);
            }
            return (int) mh$.invokeExact(cctx, cmd, value);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle SSL_CONF_cmd_value_type$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("SSL_CONF_cmd_value_type"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int SSL_CONF_cmd_value_type(SSL_CONF_CTX *cctx, const char *cmd)
     * }
     */
    public static int SSL_CONF_cmd_value_type(MemorySegment cctx, MemorySegment cmd) {
        var mh$ = SSL_CONF_cmd_value_type$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("SSL_CONF_cmd_value_type", cctx, cmd);
            }
            return (int) mh$.invokeExact(cctx, cmd);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OPENSSL_init_ssl$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OPENSSL_init_ssl"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int OPENSSL_init_ssl(uint64_t opts, const OPENSSL_INIT_SETTINGS *settings)
     * }
     */
    public static int OPENSSL_init_ssl(long opts, MemorySegment settings) {
        var mh$ = OPENSSL_init_ssl$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OPENSSL_init_ssl", opts, settings);
            }
            return (int) mh$.invokeExact(opts, settings);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ERR_get_error$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ERR_get_error"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * unsigned long ERR_get_error(void)
     * }
     */
    public static long ERR_get_error() {
        var mh$ = ERR_get_error$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ERR_get_error");
            }
            return (long) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ERR_peek_last_error$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_LONG        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ERR_peek_last_error"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * unsigned long ERR_peek_last_error(void)
     * }
     */
    public static long ERR_peek_last_error() {
        var mh$ = ERR_peek_last_error$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ERR_peek_last_error");
            }
            return (long) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ERR_clear_error$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ERR_clear_error"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void ERR_clear_error(void)
     * }
     */
    public static void ERR_clear_error() {
        var mh$ = ERR_clear_error$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ERR_clear_error");
            }
            mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ERR_error_string$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_LONG,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ERR_error_string"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * char *ERR_error_string(unsigned long e, char *buf)
     * }
     */
    public static MemorySegment ERR_error_string(long e, MemorySegment buf) {
        var mh$ = ERR_error_string$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ERR_error_string", e, buf);
            }
            return (MemorySegment) mh$.invokeExact(e, buf);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ERR_error_string_n$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_LONG,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ERR_error_string_n"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * char *ERR_error_string_n(unsigned long e, char *buf, size_t len)
     * }
     */
    public static MemorySegment ERR_error_string_n(long e, MemorySegment buf, int len) {
        var mh$ = ERR_error_string_n$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ERR_error_string_n", e, buf, len);
            }
            return (MemorySegment) mh$.invokeExact(e, buf, len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PKCS12_verify_mac$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PKCS12_verify_mac"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int PKCS12_verify_mac(PKCS12 *p12, const char *pass, int passlen)
     * }
     */
    public static int PKCS12_verify_mac(MemorySegment p12, MemorySegment pass, int passlen) {
        var mh$ = PKCS12_verify_mac$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PKCS12_verify_mac", p12, pass, passlen);
            }
            return (int) mh$.invokeExact(p12, pass, passlen);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PKCS12_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PKCS12_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern void PKCS12_free(PKCS12 *a)
     * }
     */
    public static void PKCS12_free(MemorySegment a) {
        var mh$ = PKCS12_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PKCS12_free", a);
            }
            mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle PKCS12_parse$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("PKCS12_parse"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int PKCS12_parse(PKCS12 *p12, const char *pass, EVP_PKEY **pkey, X509 **cert, struct stack_st_X509 **ca)
     * }
     */
    public static int PKCS12_parse(MemorySegment p12, MemorySegment pass, MemorySegment pkey, MemorySegment cert, MemorySegment ca) {
        var mh$ = PKCS12_parse$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("PKCS12_parse", p12, pass, pkey, cert, ca);
            }
            return (int) mh$.invokeExact(p12, pass, pkey, cert, ca);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle d2i_PKCS12_bio$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("d2i_PKCS12_bio"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * PKCS12 *d2i_PKCS12_bio(BIO *bp, PKCS12 **p12)
     * }
     */
    public static MemorySegment d2i_PKCS12_bio(MemorySegment bp, MemorySegment p12) {
        var mh$ = d2i_PKCS12_bio$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("d2i_PKCS12_bio", bp, p12);
            }
            return (MemorySegment) mh$.invokeExact(bp, p12);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle RAND_seed$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("RAND_seed"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * void RAND_seed(const void *buf, int num)
     * }
     */
    public static void RAND_seed(MemorySegment buf, int num) {
        var mh$ = RAND_seed$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("RAND_seed", buf, num);
            }
            mh$.invokeExact(buf, num);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle RAND_load_file$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("RAND_load_file"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int RAND_load_file(const char *file, long max_bytes)
     * }
     */
    public static int RAND_load_file(MemorySegment file, long max_bytes) {
        var mh$ = RAND_load_file$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("RAND_load_file", file, max_bytes);
            }
            return (int) mh$.invokeExact(file, max_bytes);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle X509_check_issued$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("X509_check_issued"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int X509_check_issued(X509 *issuer, X509 *subject)
     * }
     */
    public static int X509_check_issued(MemorySegment issuer, MemorySegment subject) {
        var mh$ = X509_check_issued$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("X509_check_issued", issuer, subject);
            }
            return (int) mh$.invokeExact(issuer, subject);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ENGINE_by_id$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ENGINE_by_id"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * ENGINE *ENGINE_by_id(const char *id)
     * }
     */
    public static MemorySegment ENGINE_by_id(MemorySegment id) {
        var mh$ = ENGINE_by_id$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ENGINE_by_id", id);
            }
            return (MemorySegment) mh$.invokeExact(id);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ENGINE_register_all_complete$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ENGINE_register_all_complete"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int ENGINE_register_all_complete(void)
     * }
     */
    public static int ENGINE_register_all_complete() {
        var mh$ = ENGINE_register_all_complete$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ENGINE_register_all_complete");
            }
            return (int) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ENGINE_ctrl_cmd_string$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ENGINE_ctrl_cmd_string"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int ENGINE_ctrl_cmd_string(ENGINE *e, const char *cmd_name, const char *arg, int cmd_optional)
     * }
     */
    public static int ENGINE_ctrl_cmd_string(MemorySegment e, MemorySegment cmd_name, MemorySegment arg, int cmd_optional) {
        var mh$ = ENGINE_ctrl_cmd_string$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ENGINE_ctrl_cmd_string", e, cmd_name, arg, cmd_optional);
            }
            return (int) mh$.invokeExact(e, cmd_name, arg, cmd_optional);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ENGINE_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ENGINE_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int ENGINE_free(ENGINE *e)
     * }
     */
    public static int ENGINE_free(MemorySegment e) {
        var mh$ = ENGINE_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ENGINE_free", e);
            }
            return (int) mh$.invokeExact(e);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ENGINE_load_private_key$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ENGINE_load_private_key"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * EVP_PKEY *ENGINE_load_private_key(ENGINE *e, const char *key_id, UI_METHOD *ui_method, void *callback_data)
     * }
     */
    public static MemorySegment ENGINE_load_private_key(MemorySegment e, MemorySegment key_id, MemorySegment ui_method, MemorySegment callback_data) {
        var mh$ = ENGINE_load_private_key$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ENGINE_load_private_key", e, key_id, ui_method, callback_data);
            }
            return (MemorySegment) mh$.invokeExact(e, key_id, ui_method, callback_data);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle ENGINE_set_default$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("ENGINE_set_default"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int ENGINE_set_default(ENGINE *e, unsigned int flags)
     * }
     */
    public static int ENGINE_set_default(MemorySegment e, int flags) {
        var mh$ = ENGINE_set_default$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("ENGINE_set_default", e, flags);
            }
            return (int) mh$.invokeExact(e, flags);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_cert_to_id$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_cert_to_id"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * OCSP_CERTID *OCSP_cert_to_id(const EVP_MD *dgst, const X509 *subject, const X509 *issuer)
     * }
     */
    public static MemorySegment OCSP_cert_to_id(MemorySegment dgst, MemorySegment subject, MemorySegment issuer) {
        var mh$ = OCSP_cert_to_id$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_cert_to_id", dgst, subject, issuer);
            }
            return (MemorySegment) mh$.invokeExact(dgst, subject, issuer);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_request_add0_id$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_request_add0_id"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * OCSP_ONEREQ *OCSP_request_add0_id(OCSP_REQUEST *req, OCSP_CERTID *cid)
     * }
     */
    public static MemorySegment OCSP_request_add0_id(MemorySegment req, MemorySegment cid) {
        var mh$ = OCSP_request_add0_id$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_request_add0_id", req, cid);
            }
            return (MemorySegment) mh$.invokeExact(req, cid);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_response_status$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_response_status"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int OCSP_response_status(OCSP_RESPONSE *resp)
     * }
     */
    public static int OCSP_response_status(MemorySegment resp) {
        var mh$ = OCSP_response_status$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_response_status", resp);
            }
            return (int) mh$.invokeExact(resp);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_response_get1_basic$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_response_get1_basic"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * OCSP_BASICRESP *OCSP_response_get1_basic(OCSP_RESPONSE *resp)
     * }
     */
    public static MemorySegment OCSP_response_get1_basic(MemorySegment resp) {
        var mh$ = OCSP_response_get1_basic$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_response_get1_basic", resp);
            }
            return (MemorySegment) mh$.invokeExact(resp);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_resp_get0$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_resp_get0"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * OCSP_SINGLERESP *OCSP_resp_get0(OCSP_BASICRESP *bs, int idx)
     * }
     */
    public static MemorySegment OCSP_resp_get0(MemorySegment bs, int idx) {
        var mh$ = OCSP_resp_get0$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_resp_get0", bs, idx);
            }
            return (MemorySegment) mh$.invokeExact(bs, idx);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_resp_find$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_INT
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_resp_find"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int OCSP_resp_find(OCSP_BASICRESP *bs, OCSP_CERTID *id, int last)
     * }
     */
    public static int OCSP_resp_find(MemorySegment bs, MemorySegment id, int last) {
        var mh$ = OCSP_resp_find$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_resp_find", bs, id, last);
            }
            return (int) mh$.invokeExact(bs, id, last);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_single_get0_status$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_single_get0_status"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * int OCSP_single_get0_status(OCSP_SINGLERESP *single, int *reason, ASN1_GENERALIZEDTIME **revtime, ASN1_GENERALIZEDTIME **thisupd, ASN1_GENERALIZEDTIME **nextupd)
     * }
     */
    public static int OCSP_single_get0_status(MemorySegment single, MemorySegment reason, MemorySegment revtime, MemorySegment thisupd, MemorySegment nextupd) {
        var mh$ = OCSP_single_get0_status$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_single_get0_status", single, reason, revtime, thisupd, nextupd);
            }
            return (int) mh$.invokeExact(single, reason, revtime, thisupd, nextupd);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_BASICRESP_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_BASICRESP_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern void OCSP_BASICRESP_free(OCSP_BASICRESP *a)
     * }
     */
    public static void OCSP_BASICRESP_free(MemorySegment a) {
        var mh$ = OCSP_BASICRESP_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_BASICRESP_free", a);
            }
            mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_RESPONSE_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_RESPONSE_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern void OCSP_RESPONSE_free(OCSP_RESPONSE *a)
     * }
     */
    public static void OCSP_RESPONSE_free(MemorySegment a) {
        var mh$ = OCSP_RESPONSE_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_RESPONSE_free", a);
            }
            mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle d2i_OCSP_RESPONSE$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER,
                openssl_h.C_LONG
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("d2i_OCSP_RESPONSE"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern OCSP_RESPONSE *d2i_OCSP_RESPONSE(OCSP_RESPONSE **a, const unsigned char **in, long len)
     * }
     */
    public static MemorySegment d2i_OCSP_RESPONSE(MemorySegment a, MemorySegment in, long len) {
        var mh$ = d2i_OCSP_RESPONSE$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("d2i_OCSP_RESPONSE", a, in, len);
            }
            return (MemorySegment) mh$.invokeExact(a, in, len);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_CERTID_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_CERTID_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern void OCSP_CERTID_free(OCSP_CERTID *a)
     * }
     */
    public static void OCSP_CERTID_free(MemorySegment a) {
        var mh$ = OCSP_CERTID_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_CERTID_free", a);
            }
            mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_REQUEST_new$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER        );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_REQUEST_new"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern OCSP_REQUEST *OCSP_REQUEST_new(void)
     * }
     */
    public static MemorySegment OCSP_REQUEST_new() {
        var mh$ = OCSP_REQUEST_new$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_REQUEST_new");
            }
            return (MemorySegment) mh$.invokeExact();
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OCSP_REQUEST_free$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OCSP_REQUEST_free"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern void OCSP_REQUEST_free(OCSP_REQUEST *a)
     * }
     */
    public static void OCSP_REQUEST_free(MemorySegment a) {
        var mh$ = OCSP_REQUEST_free$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OCSP_REQUEST_free", a);
            }
            mh$.invokeExact(a);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle i2d_OCSP_REQUEST$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_INT,
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("i2d_OCSP_REQUEST"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * extern int i2d_OCSP_REQUEST(const OCSP_REQUEST *a, unsigned char **out)
     * }
     */
    public static int i2d_OCSP_REQUEST(MemorySegment a, MemorySegment out) {
        var mh$ = i2d_OCSP_REQUEST$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("i2d_OCSP_REQUEST", a, out);
            }
            return (int) mh$.invokeExact(a, out);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static MethodHandle OSSL_PROVIDER_get0_name$MH() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(
                openssl_h.C_POINTER,
                openssl_h.C_POINTER
            );

            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(
                    openssl_h.findOrThrow("OSSL_PROVIDER_get0_name"),
                    DESC);
        }
        return Holder.MH;
    }

    /**
     * {@snippet lang=c :
     * const char *OSSL_PROVIDER_get0_name(const OSSL_PROVIDER *prov)
     * }
     */
    public static MemorySegment OSSL_PROVIDER_get0_name(MemorySegment prov) {
        var mh$ = OSSL_PROVIDER_get0_name$MH();
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("OSSL_PROVIDER_get0_name", prov);
            }
            return (MemorySegment) mh$.invokeExact(prov);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }
    /**
     * {@snippet lang=c :
     * #define OPENSSL_FILE "/tmp/jextract$7967504926277577155.h"
     * }
     */
    public static MemorySegment OPENSSL_FILE() {
        class Holder {
            static final MemorySegment OPENSSL_FILE
                = openssl_h.LIBRARY_ARENA.allocateFrom("/tmp/jextract$7967504926277577155.h");
        }
        return Holder.OPENSSL_FILE;
    }
    private static final int OPENSSL_LINE = (int)50L;
    /**
     * {@snippet lang=c :
     * #define OPENSSL_LINE 50
     * }
     */
    public static int OPENSSL_LINE() {
        return OPENSSL_LINE;
    }
    private static final long OPENSSL_INIT_ENGINE_ALL_BUILTIN = 30208L;
    /**
     * {@snippet lang=c :
     * #define OPENSSL_INIT_ENGINE_ALL_BUILTIN 30208
     * }
     */
    public static long OPENSSL_INIT_ENGINE_ALL_BUILTIN() {
        return OPENSSL_INIT_ENGINE_ALL_BUILTIN;
    }
    private static final int EVP_PKEY_NONE = (int)0L;
    /**
     * {@snippet lang=c :
     * #define EVP_PKEY_NONE 0
     * }
     */
    public static int EVP_PKEY_NONE() {
        return EVP_PKEY_NONE;
    }
    private static final int EVP_PKEY_RSA = (int)6L;
    /**
     * {@snippet lang=c :
     * #define EVP_PKEY_RSA 6
     * }
     */
    public static int EVP_PKEY_RSA() {
        return EVP_PKEY_RSA;
    }
    private static final int EVP_PKEY_DSA = (int)116L;
    /**
     * {@snippet lang=c :
     * #define EVP_PKEY_DSA 116
     * }
     */
    public static int EVP_PKEY_DSA() {
        return EVP_PKEY_DSA;
    }
    /**
     * {@snippet lang=c :
     * #define PEM_STRING_ECPARAMETERS "EC PARAMETERS"
     * }
     */
    public static MemorySegment PEM_STRING_ECPARAMETERS() {
        class Holder {
            static final MemorySegment PEM_STRING_ECPARAMETERS
                = openssl_h.LIBRARY_ARENA.allocateFrom("EC PARAMETERS");
        }
        return Holder.PEM_STRING_ECPARAMETERS;
    }
    private static final long SSL_OP_NO_TICKET = 16384L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_TICKET 16384
     * }
     */
    public static long SSL_OP_NO_TICKET() {
        return SSL_OP_NO_TICKET;
    }
    private static final long SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION 65536
     * }
     */
    public static long SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION() {
        return SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION;
    }
    private static final long SSL_OP_NO_COMPRESSION = 131072L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_COMPRESSION 131072
     * }
     */
    public static long SSL_OP_NO_COMPRESSION() {
        return SSL_OP_NO_COMPRESSION;
    }
    private static final long SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION = 262144L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION 262144
     * }
     */
    public static long SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION() {
        return SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION;
    }
    private static final long SSL_OP_CIPHER_SERVER_PREFERENCE = 4194304L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_CIPHER_SERVER_PREFERENCE 4194304
     * }
     */
    public static long SSL_OP_CIPHER_SERVER_PREFERENCE() {
        return SSL_OP_CIPHER_SERVER_PREFERENCE;
    }
    private static final long SSL_OP_NO_SSLv3 = 33554432L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_SSLv3 33554432
     * }
     */
    public static long SSL_OP_NO_SSLv3() {
        return SSL_OP_NO_SSLv3;
    }
    private static final long SSL_OP_NO_TLSv1 = 67108864L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_TLSv1 67108864
     * }
     */
    public static long SSL_OP_NO_TLSv1() {
        return SSL_OP_NO_TLSv1;
    }
    private static final long SSL_OP_NO_TLSv1_2 = 134217728L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_TLSv1_2 134217728
     * }
     */
    public static long SSL_OP_NO_TLSv1_2() {
        return SSL_OP_NO_TLSv1_2;
    }
    private static final long SSL_OP_NO_TLSv1_1 = 268435456L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_TLSv1_1 268435456
     * }
     */
    public static long SSL_OP_NO_TLSv1_1() {
        return SSL_OP_NO_TLSv1_1;
    }
    private static final long SSL_OP_NO_TLSv1_3 = 536870912L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_NO_TLSv1_3 536870912
     * }
     */
    public static long SSL_OP_NO_TLSv1_3() {
        return SSL_OP_NO_TLSv1_3;
    }
    private static final long SSL_OP_ALL = 2147485776L;
    /**
     * {@snippet lang=c :
     * #define SSL_OP_ALL 2147485776
     * }
     */
    public static long SSL_OP_ALL() {
        return SSL_OP_ALL;
    }
    private static final int ENGINE_METHOD_ALL = (int)65535L;
    /**
     * {@snippet lang=c :
     * #define ENGINE_METHOD_ALL 65535
     * }
     */
    public static int ENGINE_METHOD_ALL() {
        return ENGINE_METHOD_ALL;
    }
}

