#version 3.1;
//
// pov file for rendering all players in all animations
//
// based on code (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
#include "colors.inc"
#include "textures.inc"
#include "frame_defaults.inc"

#declare myClock = int((3 * 5 * 4  - 1)* clock + 0.5);
//#warning concat("Internal Clock: ",str(myClock,4,3),"\n")
// - 3 shots of each animation A,B,C,D
// - 5 : 1 animation frame standing
//       4 animation frames walking
// - 4 angles

#declare angleClock = mod(div(myClock,15),4);
#declare playerAngle = y*angleClock*90;

#declare frameClock = mod(div(myClock,3),5);

#if (frameClock = 0)
  #declare playerStanding = 1;
#else
  #declare playerWalking = 1;
  #declare playerAnimationClock = frameClock-1;
  #if ((angleClock=1) | (angleClock=2))
    #declare playerWalkingClock = 3-playerAnimationClock;
  #else
    #declare playerWalkingClock = playerAnimationClock;
  #end
  #declare playerWalkingTime = playerWalkingClock/4;
#end

#declare playerClock = mod(myClock,3);

#include "chooseColors.inc"
#include "XBlast Robot.inc"
#include "world.inc"

