      SUBROUTINE FBS (ZS,ZD)
C
C     GIVEN A LOWER TRIANGULAR FACTOR WITH DIAGONAL SUPERIMPOSED, AND
C     WRITTEN WITH TRAILING STRING DEFINITION WORDS, FBS WILL PERFORM
C     THE FORWARD-BACKWARD SUBSTITUTION NECESSARY TO SOLVE A LINEAR
C     SYSTEM OF EQUATIONS.
C   
C     THE ARE TWO METHODS AVAILABLE FOR THIS PROCESS.
C     METHOD 1 - THIS METHOD READS AS MANY RIGHT HAND VECTORS INTO MEMORY
C                AS POSSIBLE, AND THEN READS THE LOWER TRIANGULAR MATRIX
C                USING GETSTR AND GETSTB TO SOLVE FOR THE SOLUTION VECTORS.
C                MORE THAN ONE PASS MAY BE REQUIRED IF INSUFFICIENT MEMORY
C                EXISTS FOR LOADING ALL RIGHT HAND VECTORS AT ONE TIME.
C                THIS METHOD IS THE OLDER OF THE TWO METHODS.
C                (SEE SUBROUTINES FBSF, FBSF1, FBSF2, FBSF3 AND FBSF4)
C     METHOD 2 - THIS METHOD IS THE SAME AS METHOD 1 WITH THE EXCEPTION
C                THAT MEMORY EXISTS FOR LOADING PART OR ALL OF THE LOWER
C                TRIANGULAR MATRIX INTO OPEN CORE AFTER LOADING ALL OF 
C                THE RIGHT HAND VECTORS INTO OPEN CORE.  THIS METHOD
C                WILL ELIMINATE THE NEED TO READ THE LOWER TRIANGULAR
C                MATRIX TWICE (ONCE FORWARD AND ONCE BACKWARD).
C                (SEE SUBROUTINES FBSI, FBSI1, FBSI2, FBSI3 AND FBSI4)
C
C     THE SELECTION OF METHOD 1 OR 2 IS DEPENDENT UPON WHETHER
C     MEMORY EXISTS FOR READING THE LOWER TRIANGULAR MATRIX INTO MEMORY
C
C     SEE SUBROUTINES FBSF AND FBSI FOR OPEN CORE LAYOUTS
C
      INTEGER                    DBL      ,DBB      ,SYSBUF
     &,                          WORDS    ,RLCMPX   ,RC       
     &,                          TYPEL    ,TYPEB
      REAL                       ZS(1)    
      DOUBLE  PRECISION          ZD(1) 
      COMMON /FBSX  / DBL(7)    ,DBU(7)   ,DBB(7)   ,DBX(7)   ,LCORE   
     1,               PREC      ,SIGN     ,SCRX
      COMMON /SYSTEM/ SYSBUF    ,NOUT   
      COMMON /TYPE  / PRC(2)    ,WORDS(4) ,RLCMPX(4)
C
C     GENERAL INITIALIZATION
C
C   DIAG 46 FORCES METHOD ONE
C
      CALL SSWTCH ( 46, L46 )
      IF ( L46 .NE. 0 ) GO TO 1000
      NCOL    = DBL( 2 )
      TYPEL   = DBL( 5 )
      TYPEB   = DBB( 5 )
      RC      = RLCMPX( TYPEB )
C
C     NRHVWD = NUMBER OF WORDS REQUIRED FOR EACH RIGHT HAND VECTOR
C     NRHV   = NUMBER OF RIGHT HAND VECTORS
C  
      NRHVWD    = WORDS(TYPEL) * NCOL
      NRHV      = DBB(2)
C
C CHECK FOR RIGHT HAND VECTORS BEING THE IDENTITY MATRIX
C
      IF ( DBB( 4 ) .EQ. 8 ) NRHV = NCOL
C
C COMPUTE THE MEMORY TO READ ALL OF THE RIGHT HAND VECTORS INTO MEMORY
C
      NEED      = NRHV * NRHVWD
      IREMAIN   = LCORE - 2 * SYSBUF - NEED
C
C IF LESS THAN ONE COLUMN WORTH OF MEMORY AVAILABLE, USE METHOD ONE
C
      IF ( IREMAIN .GE. NRHVWD ) GO TO 2000
C
C  METHOD ONE - FIRST, CHECK FOR SUFFICIENT MEMORY FOR PROCESS
C
1000  MEMAVL = LCORE - 2*SYSBUF - NRHVWD
      IF ( MEMAVL .LE. 0 ) CALL MESAGE ( -8, -MEMAVL, SUBNAM )
      CALL FBSF ( ZS, ZD )
      GO TO 7000
C
C  METHOD TWO
C
2000  CALL FBSI ( ZS, ZD )
7000  CONTINUE
      RETURN
      END
