
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseitem.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseitem.h>
#include        <bse/bsecontainer.h>


#line 28 "bseitem.proc"


/* --- get-type --- */
static GType type_id_get_type = 0;
static void
get_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bseitem.proc"
 {
#line 32 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_ulong ("type_id", "Type ID", NULL,
			      0, G_MAXULONG, 0,
			      BSE_PARAM_DEFAULT);
#line 31 "bseitem.proc"
  proc->help = "Retrive an item's type ID.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 37 "bseitem.proc"
}  }
static BseErrorType
#line 37 "bseitem.proc"
get_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 40 "bseitem.proc"
{
#line 41 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 44 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 48 "bseitem.proc"
  
  g_value_set_ulong (out_values++, G_OBJECT_TYPE (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-name --- */
static GType type_id_get_type_name = 0;
static void
get_type_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 54 "bseitem.proc"
 {
#line 56 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("type_name", "Type Name", NULL,
			       NULL,
			       BSE_PARAM_DEFAULT);
#line 55 "bseitem.proc"
  proc->help = "Retrieve an item's type name.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 61 "bseitem.proc"
}  }
static BseErrorType
#line 61 "bseitem.proc"
get_type_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 64 "bseitem.proc"
{
#line 65 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 68 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 72 "bseitem.proc"
  
  g_value_set_string (out_values++, g_type_name (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-blurb --- */
static GType type_id_get_type_blurb = 0;
static void
get_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 78 "bseitem.proc"
 {
#line 80 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("type_blurb", "Type Blurb", NULL,
			       NULL,
			       BSE_PARAM_DEFAULT);
#line 79 "bseitem.proc"
  proc->help = "Retrieve an item's type description.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 85 "bseitem.proc"
}  }
static BseErrorType
#line 85 "bseitem.proc"
get_type_blurb_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 88 "bseitem.proc"
{
#line 89 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 92 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 96 "bseitem.proc"
  
  g_value_set_string (out_values++, bse_type_blurb (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-parent --- */
static GType type_id_get_parent = 0;
static void
get_parent_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bseitem.proc"
 {
#line 104 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("parent", "Parent", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 103 "bseitem.proc"
  proc->help = "Retrive an item's parent.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 108 "bseitem.proc"
}  }
static BseErrorType
#line 108 "bseitem.proc"
get_parent_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 111 "bseitem.proc"
{
#line 112 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 115 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 119 "bseitem.proc"
  
  g_value_set_object (out_values++, item->parent);
  
  return BSE_ERROR_NONE;
}

/* --- get-project --- */
static GType type_id_get_project = 0;
static void
get_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 125 "bseitem.proc"
 {
#line 127 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("project", "Project", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 126 "bseitem.proc"
  proc->help = "Retrive an item's project.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 131 "bseitem.proc"
}  }
static BseErrorType
#line 131 "bseitem.proc"
get_project_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 134 "bseitem.proc"
{
#line 135 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 138 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 142 "bseitem.proc"
  
  g_value_set_object (out_values++, bse_item_get_project (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-uname-path --- */
static GType type_id_get_uname_path = 0;
static void
get_uname_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 148 "bseitem.proc"
 {
#line 150 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", NULL, NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("uloc_path", NULL, NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 149 "bseitem.proc"
  proc->help = "Retrieve the project relative uname path for this item.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 154 "bseitem.proc"
}  }
static BseErrorType
#line 154 "bseitem.proc"
get_uname_path_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 157 "bseitem.proc"
{
#line 158 "bseitem.proc"
  
  BseItem *item = g_value_get_object (in_values++);
  BseProject *project;

#line 162 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (item);

#line 168 "bseitem.proc"
  
  g_value_set_string_take_ownership (out_values++,
				     project ? bse_container_make_upath (BSE_CONTAINER (project), item) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- use --- */
static GType type_id_use = 0;
static void
use_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 175 "bseitem.proc"
 {
#line 177 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("used_item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 176 "bseitem.proc"
  proc->help = "Increment use count to keep an item alive.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 181 "bseitem.proc"
}  }
static BseErrorType
#line 181 "bseitem.proc"
use_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 184 "bseitem.proc"
{
#line 185 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 188 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 192 "bseitem.proc"
  
  bse_item_use (item);

#line 195 "bseitem.proc"
  
  g_value_set_object (out_values++, item);
				     
  return BSE_ERROR_NONE;
}

/* --- unuse --- */
static GType type_id_unuse = 0;
static void
unuse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 201 "bseitem.proc"
 {
#line 203 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 202 "bseitem.proc"
  proc->help = "Decrement use count for when an item is not needed anymore.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 205 "bseitem.proc"
}  }
static BseErrorType
#line 205 "bseitem.proc"
unuse_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 208 "bseitem.proc"
{
#line 209 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 212 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 216 "bseitem.proc"
  
  if (item->use_count < 1)
    return BSE_ERROR_NOT_OWNER;

  item->use_count--;
  if (!item->use_count)
    bse_object_unref (item);

#line 224 "bseitem.proc"
  
  
  return BSE_ERROR_NONE;
}

/* --- get-name --- */
static GType type_id_get_name = 0;
static void
get_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 229 "bseitem.proc"
 {
#line 231 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("name", "Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 230 "bseitem.proc"
  proc->help = "Retrive an item's name.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 235 "bseitem.proc"
}  }
static BseErrorType
#line 235 "bseitem.proc"
get_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 238 "bseitem.proc"
{
#line 239 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);

#line 242 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 246 "bseitem.proc"
  
  g_value_set_string (out_values++, BSE_OBJECT_UNAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-name-or-type --- */
static GType type_id_get_name_or_type = 0;
static void
get_name_or_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 252 "bseitem.proc"
 {
#line 254 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("name", "Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 253 "bseitem.proc"
  proc->help = "Retrive an item's name or type if it has no name.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 258 "bseitem.proc"
}  }
static BseErrorType
#line 258 "bseitem.proc"
get_name_or_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 261 "bseitem.proc"
{
#line 262 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  gchar *name = NULL;

#line 266 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 270 "bseitem.proc"
  
  name = BSE_OBJECT_UNAME (item);
  if (name)
    g_value_set_string (out_values++, name);
  else
    g_value_set_string (out_values++, BSE_OBJECT_TYPE_NAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- common-ancestor --- */
static GType type_id_common_ancestor = 0;
static void
common_ancestor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 280 "bseitem.proc"
 {
#line 282 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", "First item",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("item2", "Item2", "Second item",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("ancestor", "ancestor", "Common ancestor of both items",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 281 "bseitem.proc"
  proc->help = "Retrive the common ancestor of two items if there's any.";
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 288 "bseitem.proc"
}  }
static BseErrorType
#line 288 "bseitem.proc"
common_ancestor_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 291 "bseitem.proc"
{
#line 292 "bseitem.proc"
  
  BseItem *item  = g_value_get_object (in_values++);
  BseItem *item2 = g_value_get_object (in_values++);
  
#line 296 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item) || !BSE_IS_ITEM (item2))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 300 "bseitem.proc"
  
  g_value_set_object (out_values++, bse_item_common_ancestor (item, item2));
  
  return BSE_ERROR_NONE;
}

/* --- get-seqid --- */
static GType type_id_get_seqid = 0;
static void
get_seqid_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 306 "bseitem.proc"
 {
#line 310 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("seqid", "Sequential ID", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
#line 307 "bseitem.proc"
  proc->help = ("Retrive an item's sequential ID. The sequential ID depends "
	   "on the item's type an it's position inbetween siblings "
	   "of the same type within it's immediate container.");
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 314 "bseitem.proc"
}  }
static BseErrorType
#line 314 "bseitem.proc"
get_seqid_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 317 "bseitem.proc"
{
#line 318 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 321 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 325 "bseitem.proc"
  
  g_value_set_uint (out_values++, bse_item_get_seqid (item));
  
  return BSE_ERROR_NONE;
}

/* --- check-is-a --- */
static GType type_id_check_is_a = 0;
static void
check_is_a_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 331 "bseitem.proc"
 {
#line 333 "bseitem.proc"
  *(in_pspecs++)    = g_param_spec_object ("item", "Item", "The Item",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("type_name", "Type Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("is_a", NULL, NULL,
				FALSE, BSE_PARAM_DEFAULT);
#line 25 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseitem.proc"
  proc->date = "2001";
#line 339 "bseitem.proc"
}  }
static BseErrorType
#line 339 "bseitem.proc"
check_is_a_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 342 "bseitem.proc"
{
#line 343 "bseitem.proc"
  
  BseItem *item    = g_value_get_object (in_values++);
  gchar *type_name = g_value_get_string (in_values++);
  GType type;
  gboolean is_a;

#line 349 "bseitem.proc"
  
  if (!type_name)
    type_name = "";

#line 353 "bseitem.proc"
  
  type = g_type_from_name (type_name);
  is_a = item && g_type_is_a (G_OBJECT_TYPE (item), type);

#line 357 "bseitem.proc"
  
  g_value_set_boolean (out_values++, is_a);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_get_type, "BseItem+get-type", NULL, 0, get_type_setup, get_type_exec, NULL, "/Method/BseItem/General/Get Type", { 0, }, },
  { &type_id_get_type_name, "BseItem+get-type-name", NULL, 0, get_type_name_setup, get_type_name_exec, NULL, "/Method/BseItem/General/Get Type Name", { 0, }, },
  { &type_id_get_type_blurb, "BseItem+get-type-blurb", NULL, 0, get_type_blurb_setup, get_type_blurb_exec, NULL, "/Method/BseItem/General/Get Type Blurb", { 0, }, },
  { &type_id_get_parent, "BseItem+get-parent", NULL, 0, get_parent_setup, get_parent_exec, NULL, "/Method/BseItem/General/Get Parent", { 0, }, },
  { &type_id_get_project, "BseItem+get-project", NULL, 0, get_project_setup, get_project_exec, NULL, "/Method/BseItem/General/Get Project", { 0, }, },
  { &type_id_get_uname_path, "BseItem+get-uname-path", NULL, 0, get_uname_path_setup, get_uname_path_exec, NULL, "/Method/BseItem/General/Get Uname Path", { 0, }, },
  { &type_id_use, "BseItem+use", NULL, 0, use_setup, use_exec, NULL, "/Method/BseItem/General/Use", { 0, }, },
  { &type_id_unuse, "BseItem+unuse", NULL, 0, unuse_setup, unuse_exec, NULL, "/Method/BseItem/General/Unuse", { 0, }, },
  { &type_id_get_name, "BseItem+get-name", NULL, 0, get_name_setup, get_name_exec, NULL, "/Method/BseItem/General/Get Name", { 0, }, },
  { &type_id_get_name_or_type, "BseItem+get-name-or-type", NULL, 0, get_name_or_type_setup, get_name_or_type_exec, NULL, "/Method/BseItem/General/Get Name Or Type", { 0, }, },
  { &type_id_common_ancestor, "BseItem+common-ancestor", NULL, 0, common_ancestor_setup, common_ancestor_exec, NULL, "/Method/BseItem/General/Common Ancestor", { 0, }, },
  { &type_id_get_seqid, "BseItem+get-seqid", NULL, 0, get_seqid_setup, get_seqid_exec, NULL, "/Method/BseItem/General/Get Seqid", { 0, }, },
  { &type_id_check_is_a, "BseItem+check-is-a", "Check whether an item has a certain type.", 0, check_is_a_setup, check_is_a_exec, NULL, "/Method/BseItem/General/Check Is A", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
