
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseproject.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseproject.h>
#include        <bse/bsestorage.h>
#include        <bse/bsesong.h>
#include        <bse/bsewaverepo.h>
#include        <bse/bsesnet.h>
#include        <bse/bsemidisynth.h>
#include        <bse/bsedatapocket.h>
#include        <bse/bswprivate.h>


#line 33 "bseproject.proc"


/* --- is-playing --- */
static GType type_id_is_playing = 0;
static void
is_playing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 35 "bseproject.proc"
 {
#line 37 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_boolean ("is_playing", "Is Playing", "Whether the project is currently producing sound",
				FALSE, BSE_PARAM_DEFAULT);
#line 36 "bseproject.proc"
  proc->help = "Check whether a project is currently playing";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 41 "bseproject.proc"
}  }
static BseErrorType
#line 41 "bseproject.proc"
is_playing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 44 "bseproject.proc"
{
#line 45 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  
#line 48 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 52 "bseproject.proc"
  

#line 54 "bseproject.proc"
  
  g_value_set_boolean (out_values++, BSE_SOURCE_PREPARED (project));
  
  return BSE_ERROR_NONE;
}

/* --- restore-from-file --- */
static GType type_id_restore_from_file = 0;
static void
restore_from_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 60 "bseproject.proc"
 {
#line 62 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("file-name", "File", "Source file name",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_enum ("error", "Error", "Error indicating possible failures",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 61 "bseproject.proc"
  proc->help = "Load a project from file";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 69 "bseproject.proc"
}  }
static BseErrorType
#line 69 "bseproject.proc"
restore_from_file_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 72 "bseproject.proc"
{
#line 73 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  gchar *file_name = g_value_get_string (in_values++);
  BseStorage *storage;
  BseErrorType error;
  
#line 79 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 83 "bseproject.proc"
  
  storage = bse_storage_new ();
  
  error = bse_storage_input_file (storage, file_name);
  if (!error)
    {
      // bse_storage_set_upath_resolver (storage, bse_project_upath_resolver, project);
      error = bse_project_restore (project, storage);
    }
  bse_storage_destroy (storage);

#line 94 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- store-bse --- */
static GType type_id_store_bse = 0;
static void
store_bse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 100 "bseproject.proc"
 {
#line 102 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("file-name", "File", "Destination file name",
			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_boolean ("self-contained", "Self Contained",
				"Whether references to other objects (e.g. samples) should "
				"be stored or whether to include everything in a self-contained .bse file",
				FALSE, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_enum ("error", "Error", "Error indicating possible failures",
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 101 "bseproject.proc"
  proc->help = "Save a project into a BSE file";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 113 "bseproject.proc"
}  }
static BseErrorType
#line 113 "bseproject.proc"
store_bse_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 116 "bseproject.proc"
{
#line 117 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  gchar *file_name = g_value_get_string (in_values++);
  gboolean self_contained = g_value_get_boolean (in_values++);
  BseErrorType error;
  
#line 123 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_project_store_bse (project, file_name, self_contained);

#line 129 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-song --- */
static GType type_id_create_song = 0;
static void
create_song_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 135 "bseproject.proc"
 {
#line 137 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("name", "Name", "Song name",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("song", "Song", "The new song",
			       BSE_TYPE_SONG, BSE_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 143 "bseproject.proc"
}  }
static BseErrorType
#line 143 "bseproject.proc"
create_song_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 146 "bseproject.proc"
{
#line 147 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  gchar *name         = g_value_get_string (in_values++);
  BseSong *song;
  
#line 152 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 156 "bseproject.proc"
  
  song = bse_object_new (BSE_TYPE_SONG,
			 name ? "uname" : NULL, name,
			 NULL);
  bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (song));

#line 162 "bseproject.proc"
  
  g_value_set_object (out_values++, G_OBJECT (song));
  g_object_unref (song);

  return BSE_ERROR_NONE;
}

/* --- ensure-wave-repo --- */
static GType type_id_ensure_wave_repo = 0;
static void
ensure_wave_repo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 169 "bseproject.proc"
 {
#line 171 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("wrepo", "Wave Repo", "The project's unique wave repo",
			       BSE_TYPE_WAVE_REPO, BSE_PARAM_DEFAULT);
#line 170 "bseproject.proc"
  proc->help = "Ensure the project has a wave repository";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 175 "bseproject.proc"
}  }
static BseErrorType
#line 175 "bseproject.proc"
ensure_wave_repo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 178 "bseproject.proc"
{
#line 179 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  BseWaveRepo *wrepo = NULL;
  GSList *slist;

#line 184 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 188 "bseproject.proc"
  
  for (slist = project->supers; slist; slist = slist->next)
    if (BSE_IS_WAVE_REPO (slist->data))
      {
	wrepo = slist->data;
	break;
      }
  if (!wrepo)
    {
      wrepo = bse_object_new (BSE_TYPE_WAVE_REPO, NULL);
      bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (wrepo));
      g_object_unref (wrepo);
    }

#line 202 "bseproject.proc"
  
  g_value_set_object (out_values++, G_OBJECT (wrepo));
  
  return BSE_ERROR_NONE;
}

/* --- get-data-pocket --- */
static GType type_id_get_data_pocket = 0;
static void
get_data_pocket_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 208 "bseproject.proc"
 {
#line 210 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", "Name of the data pocket",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("data_pocket", "Data Pocket", "The data pocket",
			       BSE_TYPE_DATA_POCKET, BSE_PARAM_DEFAULT);
#line 209 "bseproject.proc"
  proc->help = "Retrive a specifically named data pocket for this project";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 216 "bseproject.proc"
}  }
static BseErrorType
#line 216 "bseproject.proc"
get_data_pocket_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 219 "bseproject.proc"
{
#line 220 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  gchar *name = g_value_get_string (in_values++);
  BseItem *item;

#line 225 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 229 "bseproject.proc"
  
  item = bse_project_lookup_typed_item (project, BSE_TYPE_DATA_POCKET, name);
  if (!item)
    {
      item = g_object_new (BSE_TYPE_DATA_POCKET, "uname", name, NULL);
      bse_container_add_item (BSE_CONTAINER (project), item);
      g_object_unref (item);
    }

#line 238 "bseproject.proc"
  
  g_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- create-snet --- */
static GType type_id_create_snet = 0;
static void
create_snet_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 244 "bseproject.proc"
 {
#line 246 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("name", "Name", "Synth network name",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("snet", "Synthesizer Network", "New synth network",
			       BSE_TYPE_SNET, BSE_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 252 "bseproject.proc"
}  }
static BseErrorType
#line 252 "bseproject.proc"
create_snet_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 255 "bseproject.proc"
{
#line 256 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  gchar *name         = g_value_get_string (in_values++);
  BseSNet *snet;
  
#line 261 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 265 "bseproject.proc"
  
  snet = bse_object_new (BSE_TYPE_SNET,
                         name ? "uname" : NULL, name,
			 NULL);
  bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (snet));
  
#line 271 "bseproject.proc"
  
  g_value_set_object (out_values++, G_OBJECT (snet));
  g_object_unref (snet);
  
  return BSE_ERROR_NONE;
}

/* --- create-midi-synth --- */
static GType type_id_create_midi_synth = 0;
static void
create_midi_synth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 278 "bseproject.proc"
 {
#line 280 "bseproject.proc"
  *(in_pspecs++) = g_param_spec_object ("project", "Project", "The project",
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("name", "Name", "MIDI synth name",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("midi_synth", "MIDI Synthesizer", "New MIDI synth",
			       BSE_TYPE_MIDI_SYNTH, BSE_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 286 "bseproject.proc"
}  }
static BseErrorType
#line 286 "bseproject.proc"
create_midi_synth_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 289 "bseproject.proc"
{
#line 290 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  gchar *name         = g_value_get_string (in_values++);
  BseMidiSynth *midi_synth;
  
#line 295 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 299 "bseproject.proc"
  
  midi_synth = bse_object_new (BSE_TYPE_MIDI_SYNTH,
			       name ? "uname" : NULL, name,
			       NULL);
  bse_container_add_item (BSE_CONTAINER (project), BSE_ITEM (midi_synth));

#line 305 "bseproject.proc"
  
  g_value_set_object (out_values++, G_OBJECT (midi_synth));
  g_object_unref (midi_synth);
  
  return BSE_ERROR_NONE;
}

/* --- list-uname-paths --- */
static GType type_id_list_uname_paths = 0;
static void
list_uname_paths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 312 "bseproject.proc"
 {
#line 315 "bseproject.proc"
  *(in_pspecs++)    = g_param_spec_object ("project", NULL, NULL,
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_ulong ("item_type", NULL, NULL,
			      0, G_MAXLONG, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("uname_paths", NULL, NULL,
			      BSW_TYPE_ITER_STRING,
			      BSE_PARAM_DEFAULT);
#line 313 "bseproject.proc"
  proc->help = ("List uname paths for all items of a specified type within this project. "
	   "By their uname paths, items are uniquely identifyable within a project.");
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 322 "bseproject.proc"
}  }
static BseErrorType
#line 322 "bseproject.proc"
list_uname_paths_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 325 "bseproject.proc"
{
#line 326 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  GType type          = g_value_get_ulong (in_values++);

#line 330 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 334 "bseproject.proc"
  
  g_value_set_boxed_take_ownership (out_values++, bse_project_list_upaths (project, type));

  return BSE_ERROR_NONE;
}

/* --- find-item --- */
static GType type_id_find_item = 0;
static void
find_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 340 "bseproject.proc"
 {
#line 342 "bseproject.proc"
  *(in_pspecs++)    = g_param_spec_object ("project", NULL, NULL,
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("uname_path", NULL, NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("item", NULL, NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 341 "bseproject.proc"
  proc->help = "Find an item within a project, given its uname path.";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 348 "bseproject.proc"
}  }
static BseErrorType
#line 348 "bseproject.proc"
find_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 351 "bseproject.proc"
{
#line 352 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  const gchar *string = g_value_get_string (in_values++);

#line 356 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 360 "bseproject.proc"
  
  g_value_set_object (out_values++, bse_container_resolve_upath (BSE_CONTAINER (project), string));

  return BSE_ERROR_NONE;
}

/* --- match-items-by-uname --- */
static GType type_id_match_items_by_uname = 0;
static void
match_items_by_uname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 366 "bseproject.proc"
 {
#line 368 "bseproject.proc"
  *(in_pspecs++)    = g_param_spec_object ("project", NULL, NULL,
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_ulong ("item_type", NULL, NULL,
			      0, G_MAXLONG, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("uname", NULL, NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("item_list", NULL, NULL,
			      BSW_TYPE_ITER_PROXY,
			      BSE_PARAM_DEFAULT);
#line 367 "bseproject.proc"
  proc->help = "Retrive all items of a specific type within a project with matching uname";
#line 30 "bseproject.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseproject.proc"
  proc->date = "2001";
#line 377 "bseproject.proc"
}  }
static BseErrorType
#line 377 "bseproject.proc"
match_items_by_uname_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 380 "bseproject.proc"
{
#line 381 "bseproject.proc"
  
  BseProject *project = g_value_get_object (in_values++);
  GType type          = g_value_get_ulong (in_values++);
  const gchar *string = g_value_get_string (in_values++);
  GList *list, *free_list;
  BswIterProxy *iter;

#line 388 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 392 "bseproject.proc"
  
  iter = bsw_iter_create (BSW_TYPE_ITER_PROXY, 1);
  free_list = bse_objects_list_by_uname (type, string);	// FIXME: type as string and >= BSE_TYPE_ITEM
  for (list = free_list; list; list = list->next)
    if (bse_item_get_project (list->data) == project)
      {
	bsw_iter_add_object (iter, list->data);
	break;
      }
  g_list_free (free_list);

#line 403 "bseproject.proc"
  
  g_value_set_boxed_take_ownership (out_values++, iter);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_is_playing, "BseProject+is-playing", NULL, 0, is_playing_setup, is_playing_exec, NULL, "/Method/BseProject/General/Is Playing", { 0, }, },
  { &type_id_restore_from_file, "BseProject+restore-from-file", NULL, 0, restore_from_file_setup, restore_from_file_exec, NULL, "/Method/BseProject/File/Restore", { 0, }, },
  { &type_id_store_bse, "BseProject+store-bse", NULL, 0, store_bse_setup, store_bse_exec, NULL, "/Method/BseProject/File/Store", { 0, }, },
  { &type_id_create_song, "BseProject+create-song", "Create a song for this project.", 0, create_song_setup, create_song_exec, NULL, "/Method/BseProject/General/Create Song", { 0, }, },
  { &type_id_ensure_wave_repo, "BseProject+ensure-wave-repo", NULL, 0, ensure_wave_repo_setup, ensure_wave_repo_exec, NULL, "/Method/BseProject/General/Ensure Wave Repo", { 0, }, },
  { &type_id_get_data_pocket, "BseProject+get-data-pocket", NULL, 0, get_data_pocket_setup, get_data_pocket_exec, NULL, "/Method/BseProject/General/Get Data Pocket", { 0, }, },
  { &type_id_create_snet, "BseProject+create-snet", "Create a synthsizer network for this project.", 0, create_snet_setup, create_snet_exec, NULL, "/Method/BseProject/General/Create Snet", { 0, }, },
  { &type_id_create_midi_synth, "BseProject+create-midi-synth", "Create a MIDI synthesizer network for this project.", 0, create_midi_synth_setup, create_midi_synth_exec, NULL, "/Method/BseProject/General/Create Midi Synth", { 0, }, },
  { &type_id_list_uname_paths, "BseProject+list-uname-paths", NULL, 0, list_uname_paths_setup, list_uname_paths_exec, NULL, "/Method/BseProject/General/List Uname Paths", { 0, }, },
  { &type_id_find_item, "BseProject+find-item", NULL, 0, find_item_setup, find_item_exec, NULL, "/Method/BseProject/General/Find Item", { 0, }, },
  { &type_id_match_items_by_uname, "BseProject+match-items-by-uname", NULL, 0, match_items_by_uname_setup, match_items_by_uname_exec, NULL, "/Method/BseProject/General/Match Items By Uname", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
