
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsewave.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsewave.h>
#include        <bse/bseeditablesample.h>


#line 26 "bsewave.proc"


/* --- load-wave --- */
static GType type_id_load_wave = 0;
static void
load_wave_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsewave.proc"
 {
#line 30 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", "Wave object to store loaded contents",
				 BSE_TYPE_WAVE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("file_name", "File Name", "The wave file to read wave chunks from",
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("wave_name", "Wave Name", "The name of the wave to read wave chunks from",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error type",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 29 "bsewave.proc"
  proc->help = "Load sample chunks from a wave file";
#line 24 "bsewave.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 40 "bsewave.proc"
 }
static BseErrorType
#line 40 "bsewave.proc"
load_wave_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 43 "bsewave.proc"
{
#line 44 "bsewave.proc"
  
  BseWave *wave           = (BseWave*) bse_value_get_object (in_values++);
  gchar *file_name        = sfi_value_get_string (in_values++);
  gchar *wave_name        = sfi_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 50 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave) || !file_name || !wave_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  error = bse_wave_load_wave_file (wave, file_name, wave_name, NULL, NULL);
  
#line 56 "bsewave.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- n-wave-chunks --- */
static GType type_id_n_wave_chunks = 0;
static void
n_wave_chunks_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 62 "bsewave.proc"
 {
#line 64 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_chunks", "Number of Wave Chunks", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 63 "bsewave.proc"
  proc->help = "Get the number of wave chunks of a wave";
#line 24 "bsewave.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 69 "bsewave.proc"
 }
static BseErrorType
#line 69 "bsewave.proc"
n_wave_chunks_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 72 "bsewave.proc"
{
#line 73 "bsewave.proc"
  
  BseWave *wave = bse_value_get_object (in_values++);
  
#line 76 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 80 "bsewave.proc"
  
  sfi_value_set_int (out_values++, wave->n_wchunks);
  
  return BSE_ERROR_NONE;
}

/* --- use-editable --- */
static GType type_id_use_editable = 0;
static void
use_editable_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 86 "bsewave.proc"
 {
#line 88 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("chunk_index", NULL, "Index of chunk to edit",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("esample", NULL, "Editable sample",
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_DEFAULT);
}
#line 87 "bsewave.proc"
  proc->help = "Retrieve an editable sample object for a wave chunk.";
#line 24 "bsewave.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 95 "bsewave.proc"
 }
static BseErrorType
#line 95 "bsewave.proc"
use_editable_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 98 "bsewave.proc"
{
#line 99 "bsewave.proc"
  
  BseWave *wave     = bse_value_get_object (in_values++);
  guint chunk_index = sfi_value_get_int (in_values++);
  BseEditableSample *esample = NULL;
  GslWaveChunk *wchunk = NULL;
  
#line 105 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  wchunk = g_slist_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    {
      esample = g_object_new (BSE_TYPE_EDITABLE_SAMPLE, NULL);
      bse_editable_sample_set_wchunk (esample, wchunk);
      bse_item_use (BSE_ITEM (esample));
      g_object_unref (esample);
    }
  
#line 118 "bsewave.proc"
  
  bse_value_set_object (out_values++, esample);
  
  return BSE_ERROR_NONE;
}

/* --- chunk-get-osc-freq --- */
static GType type_id_chunk_get_osc_freq = 0;
static void
chunk_get_osc_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 124 "bsewave.proc"
 {
#line 126 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("chunk_index", "Chunk Index", "Index of chunk",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_real ("osc_freq", NULL, NULL,
			  BSE_KAMMER_FREQUENCY_f, BSE_MIN_OSC_FREQUENCY_f, BSE_MAX_OSC_FREQUENCY_f, 10.0,
			  SFI_PARAM_DEFAULT);
}
#line 125 "bsewave.proc"
  proc->help = "Retrieve oscillating frequency of a wave chunk.";
#line 24 "bsewave.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 134 "bsewave.proc"
 }
static BseErrorType
#line 134 "bsewave.proc"
chunk_get_osc_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 137 "bsewave.proc"
{
#line 138 "bsewave.proc"
  
  BseWave *wave     = bse_value_get_object (in_values++);
  guint chunk_index = sfi_value_get_int (in_values++);
  GslWaveChunk *wchunk = NULL;
  
#line 143 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  wchunk = g_slist_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    sfi_value_set_real (out_values++, wchunk->osc_freq);

  return BSE_ERROR_NONE;
}

/* --- chunk-get-mix-freq --- */
static GType type_id_chunk_get_mix_freq = 0;
static void
chunk_get_mix_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 154 "bsewave.proc"
 {
#line 156 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("chunk_index", "Chunk Index", "Index of chunk",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_real ("mix_freq", NULL, NULL,
#line 161 "bsewave.proc"
			  0, 0, 44100 * 16 , 10.0,
			  SFI_PARAM_DEFAULT);
}
#line 155 "bsewave.proc"
  proc->help = "Retrieve mixing frequency of a wave chunk.";
#line 24 "bsewave.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsewave.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 164 "bsewave.proc"
 }
static BseErrorType
#line 164 "bsewave.proc"
chunk_get_mix_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 167 "bsewave.proc"
{
#line 168 "bsewave.proc"
  
  BseWave *wave     = bse_value_get_object (in_values++);
  guint chunk_index = sfi_value_get_int (in_values++);
  GslWaveChunk *wchunk = NULL;
  
#line 173 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  wchunk = g_slist_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    sfi_value_set_real (out_values++, wchunk->mix_freq);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_load_wave, "BseWave+load-wave", NULL, 0, load_wave_setup, load_wave_exec, NULL, "/Method/BseWave/General/Load Wave", { 0, }, },
  { &type_id_n_wave_chunks, "BseWave+n-wave-chunks", NULL, 0, n_wave_chunks_setup, n_wave_chunks_exec, NULL, "/Method/BseWave/General/N Wave Chunks", { 0, }, },
  { &type_id_use_editable, "BseWave+use-editable", NULL, 0, use_editable_setup, use_editable_exec, NULL, "/Method/BseWave/General/Use Editable", { 0, }, },
  { &type_id_chunk_get_osc_freq, "BseWave+chunk-get-osc-freq", NULL, 0, chunk_get_osc_freq_setup, chunk_get_osc_freq_exec, NULL, "/Method/BseWave/General/Chunk Get Osc Freq", { 0, }, },
  { &type_id_chunk_get_mix_freq, "BseWave+chunk-get-mix-freq", NULL, 0, chunk_get_mix_freq_setup, chunk_get_mix_freq_exec, NULL, "/Method/BseWave/General/Chunk Get Mix Freq", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
