
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseproject.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseproject.h>
#include <bse/bsestorage.h>
#include <bse/bsesong.h>
#include <bse/bseundostack.h>
#include <bse/bsewaverepo.h>
#include <bse/bsecsynth.h>
#include <bse/bsemidisynth.h>
#include <bse/bsedatapocket.h>
#include <bse/bsemidifile.h>


#line 33 "bseproject.proc"


/* --- is-playing --- */
static void
is_playing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 35 "bseproject.proc"
 {
#line 37 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_playing", "Is Playing", "Whether the project is currently playing songs or synths",
                          FALSE, SFI_PARAM_STANDARD);
#line 41 "bseproject.proc"
}  }
static BseErrorType
#line 41 "bseproject.proc"
is_playing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 44 "bseproject.proc"
{
#line 45 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 48 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 52 "bseproject.proc"
  
  
#line 54 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state == BSE_PROJECT_PLAYING);
  
  return BSE_ERROR_NONE;
}

/* --- is-active --- */
static void
is_active_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 60 "bseproject.proc"
 {
#line 62 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_active", NULL, "Whether the project is currently producing sound",
                          FALSE, SFI_PARAM_STANDARD);
#line 66 "bseproject.proc"
}  }
static BseErrorType
#line 66 "bseproject.proc"
is_active_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 69 "bseproject.proc"
{
#line 70 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 73 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 77 "bseproject.proc"
  
  
#line 79 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state != BSE_PROJECT_INACTIVE);
  
  return BSE_ERROR_NONE;
}

/* --- import-midi-file --- */
static void
import_midi_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 85 "bseproject.proc"
 {
#line 87 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "MIDI File", "MIDI file name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_STANDARD);
#line 94 "bseproject.proc"
}  }
static BseErrorType
#line 94 "bseproject.proc"
import_midi_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 97 "bseproject.proc"
{
#line 98 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseMidiFile *smf;
  BseErrorType error;
  
#line 104 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 108 "bseproject.proc"
  
  smf = bse_midi_file_load (file_name, &error);
  if (!error)
    {
      BseUndoStack *ustack = bse_item_undo_open (project, "import-midi-file");
      gchar *basename = g_path_get_basename (file_name);
      BseSong *song;
      bse_item_exec (project, "create-song", basename, &song);
      g_free (basename);
      bse_midi_file_setup_song (smf, song);
      bse_item_undo_close (ustack);
#if 1
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
#endif
    }
  if (smf)
    bse_midi_file_free (smf);
  g_printerr ("error: %u\n", error);
  
#line 129 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- restore-from-file --- */
static void
restore_from_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 135 "bseproject.proc"
 {
#line 137 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Source file name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_STANDARD);
#line 144 "bseproject.proc"
}  }
static BseErrorType
#line 144 "bseproject.proc"
restore_from_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 147 "bseproject.proc"
{
#line 148 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseErrorType error;
  
#line 153 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 157 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      BseStorage *storage = g_object_new (BSE_TYPE_STORAGE, NULL);
      error = bse_storage_input_file (storage, file_name);
      if (!error)
        error = bse_project_restore (project, storage);
      bse_storage_reset (storage);
      g_object_unref (storage);
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
    }
  else
    error = BSE_ERROR_PROC_BUSY;

#line 173 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- store-bse --- */
static void
store_bse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 179 "bseproject.proc"
 {
#line 182 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("super", "Super", NULL,
                                 BSE_TYPE_SUPER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Destination file name",
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_bool ("self-contained", "Self Contained",
                          "Whether references to other objects (e.g. samples) should "
                          "be stored or whether to include everything in a self-contained .bse file",
                          FALSE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "Error indicating possible failures",
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 195 "bseproject.proc"
}  }
static BseErrorType
#line 195 "bseproject.proc"
store_bse_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 198 "bseproject.proc"
{
#line 199 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseSuper *super = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  gboolean self_contained = sfi_value_get_bool (in_values++);
  BseErrorType error;
  
#line 206 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (super && BSE_ITEM (super)->parent != BSE_ITEM (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_project_store_bse (project, super, file_name, self_contained);
  
#line 214 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-song --- */
static void
create_song_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 220 "bseproject.proc"
 {
#line 222 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Song name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("song", "Song", "The new song",
                                 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 228 "bseproject.proc"
}  }
static BseErrorType
#line 228 "bseproject.proc"
create_song_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 231 "bseproject.proc"
{
#line 232 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 238 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 242 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-song");
  child = bse_container_new_child (container, BSE_TYPE_SONG, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 250 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);

  return BSE_ERROR_NONE;
}

/* --- get-wave-repo --- */
static void
get_wave_repo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 256 "bseproject.proc"
 {
#line 258 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("wrepo", "Wave Repo", "The project's unique wave repo",
                                 BSE_TYPE_WAVE_REPO, SFI_PARAM_STANDARD);
#line 262 "bseproject.proc"
}  }
static BseErrorType
#line 262 "bseproject.proc"
get_wave_repo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 265 "bseproject.proc"
{
#line 266 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseWaveRepo *wrepo = NULL;
  
#line 270 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 274 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  
#line 277 "bseproject.proc"
  
  bse_value_set_object (out_values++, wrepo);
  
  return BSE_ERROR_NONE;
}

/* --- get-data-pocket --- */
static void
get_data_pocket_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 283 "bseproject.proc"
 {
#line 285 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Name of the data pocket",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket",
                                 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
#line 291 "bseproject.proc"
}  }
static BseErrorType
#line 291 "bseproject.proc"
get_data_pocket_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 294 "bseproject.proc"
{
#line 295 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name = sfi_value_get_string (in_values++);
  BseItem *item;
  
#line 300 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 304 "bseproject.proc"
  
  item = bse_project_lookup_typed_item (project, BSE_TYPE_DATA_POCKET, name);
  if (!item)
    item = bse_container_new_child (BSE_CONTAINER (project), BSE_TYPE_DATA_POCKET,
                                    "uname", name,
                                    NULL);
  
#line 311 "bseproject.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- create-csynth --- */
static void
create_csynth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 317 "bseproject.proc"
 {
#line 319 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Synth network name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("csynth", "Synthesizer Network", "New synth network",
                                 BSE_TYPE_CSYNTH, SFI_PARAM_STANDARD);
#line 325 "bseproject.proc"
}  }
static BseErrorType
#line 325 "bseproject.proc"
create_csynth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 328 "bseproject.proc"
{
#line 329 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;
  
#line 335 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 339 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-csynth");
  child = bse_container_new_child (container, BSE_TYPE_CSYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);
  
#line 347 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- create-midi-synth --- */
static void
create_midi_synth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 353 "bseproject.proc"
 {
#line 355 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "MIDI synth name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("midi_synth", "MIDI Synthesizer", "New MIDI synth",
                                 BSE_TYPE_MIDI_SYNTH, SFI_PARAM_STANDARD);
#line 361 "bseproject.proc"
}  }
static BseErrorType
#line 361 "bseproject.proc"
create_midi_synth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 364 "bseproject.proc"
{
#line 365 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  gchar *name             = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 371 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 375 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-midi-synth");
  child = bse_container_new_child (container, BSE_TYPE_MIDI_SYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 383 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-snet --- */
static void
remove_snet_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 389 "bseproject.proc"
 {
#line 391 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("snet", "SNet", "Synthesizer Network",
                                 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
#line 395 "bseproject.proc"
}  }
static BseErrorType
#line 395 "bseproject.proc"
remove_snet_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 398 "bseproject.proc"
{
#line 399 "bseproject.proc"
  
  BseContainer *self  = bse_value_get_object (in_values++);
  BseItem      *child = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 404 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self) || !BSE_IS_SNET (child) || child->parent != (BseItem*) self)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 408 "bseproject.proc"
  
  if (!BSE_SOURCE_PREPARED (self))
    {
      ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 412 "bseproject.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 414 "bseproject.proc"
      
      bse_item_push_redo_proc (self, "remove-snet", child);
#line 416 "bseproject.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 418 "bseproject.proc"
      
      bse_item_undo_close (ustack);
    }
  
  return BSE_ERROR_NONE;
}

/* --- list-uname-paths --- */
static void
list_uname_paths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 425 "bseproject.proc"
 {
#line 428 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("uname_paths", "Uname Paths", NULL, BSE_TYPE_STRING_SEQ, SFI_PARAM_STANDARD);
#line 433 "bseproject.proc"
}  }
static BseErrorType
#line 433 "bseproject.proc"
list_uname_paths_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 436 "bseproject.proc"
{
#line 437 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  
#line 442 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 446 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, bse_project_list_upaths (project, type));
  
  return BSE_ERROR_NONE;
}

/* --- find-item --- */
static void
find_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 452 "bseproject.proc"
 {
#line 454 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname_path", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, NULL,
                                 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 460 "bseproject.proc"
}  }
static BseErrorType
#line 460 "bseproject.proc"
find_item_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 463 "bseproject.proc"
{
#line 464 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  
#line 468 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 472 "bseproject.proc"
  
  bse_value_set_object (out_values++, bse_container_resolve_upath (BSE_CONTAINER (project), string));
  
  return BSE_ERROR_NONE;
}

/* --- match-items-by-uname --- */
static void
match_items_by_uname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 478 "bseproject.proc"
 {
#line 480 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("item_list", "Item List", NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 487 "bseproject.proc"
}  }
static BseErrorType
#line 487 "bseproject.proc"
match_items_by_uname_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 490 "bseproject.proc"
{
#line 491 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  GList *list, *free_list;
  BseItemSeq *iseq;
  
#line 499 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 503 "bseproject.proc"
  
  iseq = bse_item_seq_new ();
  free_list = bse_objects_list_by_uname (type, string);
  for (list = free_list; list; list = list->next)
    if (bse_item_get_project (list->data) == project)
      {
        bse_item_seq_append (iseq, list->data);
        break;
      }
  g_list_free (free_list);
  
#line 514 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, iseq);
  
  return BSE_ERROR_NONE;
}

/* --- get-supers --- */
static void
get_supers_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 520 "bseproject.proc"
 {
#line 522 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("super_list", NULL, NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 525 "bseproject.proc"
}  }
static BseErrorType
#line 525 "bseproject.proc"
get_supers_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 528 "bseproject.proc"
{
#line 529 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseItemSeq *iseq;
  GSList *slist;
  
#line 534 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 538 "bseproject.proc"
  
  iseq = bse_item_seq_new ();
  for (slist = project->supers; slist; slist = slist->next)
    bse_item_seq_append (iseq, slist->data);
  
#line 543 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, iseq);
  
  return BSE_ERROR_NONE;
}

/* --- can-play --- */
static void
can_play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 549 "bseproject.proc"
 {
#line 551 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("can_play", "Can Play", "Whether project playback makes sense",
                          FALSE, SFI_PARAM_STANDARD);
#line 555 "bseproject.proc"
}  }
static BseErrorType
#line 555 "bseproject.proc"
can_play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 558 "bseproject.proc"
{
#line 559 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gpointer wrepo;
  
#line 563 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 567 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  sfi_value_set_bool (out_values++, project->supers->data != wrepo || project->supers->next);
  
  return BSE_ERROR_NONE;
}

/* --- get-state --- */
static void
get_state_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 574 "bseproject.proc"
 {
#line 576 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("state", "State", "Project playback/activation state",
                                BSE_TYPE_PROJECT_STATE, BSE_PROJECT_INACTIVE, SFI_PARAM_STANDARD);
#line 580 "bseproject.proc"
}  }
static BseErrorType
#line 580 "bseproject.proc"
get_state_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 583 "bseproject.proc"
{
#line 584 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  
#line 587 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 591 "bseproject.proc"
  
  g_value_set_enum (out_values++, self->state);
  
  return BSE_ERROR_NONE;
}

static void
undo_do_deactivate (BseUndoStep  *ustep,
                    BseUndoStack *ustack)
{
  BseProject *self = bse_undo_pointer_unpack (ustep->data[0].v_pointer, ustack);
  bse_project_deactivate (self);
}

static void
undo_do_deactivate_free (BseUndoStep *ustep)
{
  g_free (ustep->data[0].v_pointer);
}

static void
project_push_undo_silent_deactivate (BseProject *self)
{
#line 614 "bseproject.proc"
  
  BseUndoStack *ustack = bse_item_undo_open (self, "deactivate-project");
  BseUndoStep *ustep = bse_undo_step_new (undo_do_deactivate, undo_do_deactivate_free, 1);
  ustep->data[0].v_pointer = bse_undo_pointer_pack (self, ustack);
  bse_undo_stack_push_add_on (ustack, ustep);
  bse_item_undo_close (ustack);

  gboolean in_undo = self->in_undo;
#line 628 "bseproject.proc"
  self->in_undo = !in_undo;             
  ustack = bse_item_undo_open (self, "deactivate-project");
  ustep = bse_undo_step_new (undo_do_deactivate, undo_do_deactivate_free, 1);
  ustep->data[0].v_pointer = bse_undo_pointer_pack (self, ustack);
  bse_undo_stack_push_add_on (ustack, ustep);
  bse_item_undo_close (ustack);
#line 634 "bseproject.proc"
  self->in_undo = in_undo;              
}

/* --- activate --- */
static void
activate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 637 "bseproject.proc"
 {
#line 639 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 644 "bseproject.proc"
}  }
static BseErrorType
#line 644 "bseproject.proc"
activate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 647 "bseproject.proc"
{
#line 648 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;
  BseErrorType error;

#line 653 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 661 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- start-playback --- */
static void
start_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 670 "bseproject.proc"
 {
#line 672 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 674 "bseproject.proc"
}  }
static BseErrorType
#line 674 "bseproject.proc"
start_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 677 "bseproject.proc"
{
#line 678 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;

#line 682 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  bse_project_start_playback (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 690 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }

  return BSE_ERROR_NONE;
}

/* --- play --- */
static void
play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 697 "bseproject.proc"
 {
#line 699 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 704 "bseproject.proc"
}  }
static BseErrorType
#line 704 "bseproject.proc"
play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 707 "bseproject.proc"
{
#line 708 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseErrorType error;
  BseProjectState state_before;
  
#line 713 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (!error)
    {
      if (self->state == BSE_PROJECT_PLAYING)
        bse_project_stop_playback (self);
      bse_project_start_playback (self);
    }
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 727 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }

  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- deactivate --- */
static void
deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 736 "bseproject.proc"
 {
#line 738 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 740 "bseproject.proc"
}  }
static BseErrorType
#line 740 "bseproject.proc"
deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 743 "bseproject.proc"
{
#line 744 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 747 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- stop-playback --- */
static void
stop_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 756 "bseproject.proc"
 {
#line 758 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 760 "bseproject.proc"
}  }
static BseErrorType
#line 760 "bseproject.proc"
stop_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 763 "bseproject.proc"
{
#line 764 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 767 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_stop_playback (self);

  return BSE_ERROR_NONE;
}

/* --- stop --- */
static void
stop_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 776 "bseproject.proc"
 {
#line 778 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 780 "bseproject.proc"
}  }
static BseErrorType
#line 780 "bseproject.proc"
stop_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 783 "bseproject.proc"
{
#line 784 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 787 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- auto-deactivate --- */
static void
auto_deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 796 "bseproject.proc"
 {
#line 798 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("msec_delay", NULL, "Delay for deactivation in milliseconds",
                         0, -1, G_MAXINT, 1000, SFI_PARAM_STANDARD);
#line 802 "bseproject.proc"
}  }
static BseErrorType
#line 802 "bseproject.proc"
auto_deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 805 "bseproject.proc"
{
#line 806 "bseproject.proc"
  
  BseProject *self  = bse_value_get_object (in_values++);
  gint64      msecs = sfi_value_get_int (in_values++);

#line 810 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  self->deactivate_usecs = msecs < 0 ? -1 : msecs * 1000;

  return BSE_ERROR_NONE;
}

/* --- undo-depth --- */
static void
undo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 819 "bseproject.proc"
 {
#line 821 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("undo_depth", NULL, "Number of times undo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 825 "bseproject.proc"
}  }
static BseErrorType
#line 825 "bseproject.proc"
undo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 828 "bseproject.proc"
{
#line 829 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 832 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 836 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->undo_stack));

  return BSE_ERROR_NONE;
}

/* --- undo --- */
static void
undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 842 "bseproject.proc"
 {
#line 844 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 846 "bseproject.proc"
}  }
static BseErrorType
#line 846 "bseproject.proc"
undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 849 "bseproject.proc"
{
#line 850 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);

#line 853 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 857 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->undo_stack);
      if (name)
        {
#line 863 "bseproject.proc"
          project->in_undo = TRUE;      
          bse_undo_group_open (project->redo_stack, name);
          bse_undo_stack_undo (project->undo_stack);
          bse_undo_group_close (project->redo_stack);
#line 867 "bseproject.proc"
          project->in_undo = FALSE;     
        }
    }

  return BSE_ERROR_NONE;
}

/* --- redo-depth --- */
static void
redo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 874 "bseproject.proc"
 {
#line 876 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("redo_depth", NULL, "Number of times redo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 880 "bseproject.proc"
}  }
static BseErrorType
#line 880 "bseproject.proc"
redo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 883 "bseproject.proc"
{
#line 884 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 887 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 891 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->redo_stack));

  return BSE_ERROR_NONE;
}

/* --- redo --- */
static void
redo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 897 "bseproject.proc"
 {
#line 899 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 901 "bseproject.proc"
}  }
static BseErrorType
#line 901 "bseproject.proc"
redo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 904 "bseproject.proc"
{
#line 905 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 908 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 912 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->redo_stack);
      if (name)
        {
#line 918 "bseproject.proc"
          project->in_redo = TRUE;      
          bse_undo_group_open (project->undo_stack, name);
          bse_undo_stack_undo (project->redo_stack);
          bse_undo_group_close (project->undo_stack);
#line 922 "bseproject.proc"
          project->in_redo = FALSE;     
        }
    }

  return BSE_ERROR_NONE;
}

/* --- clear-undo --- */
static void
clear_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 929 "bseproject.proc"
 {
#line 931 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 933 "bseproject.proc"
}  }
static BseErrorType
#line 933 "bseproject.proc"
clear_undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 936 "bseproject.proc"
{
#line 937 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 940 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 944 "bseproject.proc"
  
  bse_project_clear_undo (project);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_is_playing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project is currently playing";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_is_playing = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseProject+is-playing", 
    NULL,
    "/Methods/BseProject/General/Is Playing",
    NULL,
    __enode_is_playing__fill_strings,
  },
  0, is_playing_setup, is_playing_exec, 
};
static void
__enode_is_active__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project is active";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_is_active = {
  { (BseExportNode*) &__enode_is_playing, BSE_EXPORT_NODE_PROC,
    "BseProject+is-active", 
    NULL,
    "/Methods/BseProject/General/Is Active",
    NULL,
    __enode_is_active__fill_strings,
  },
  0, is_active_setup, is_active_exec, 
};
static void
__enode_import_midi_file__fill_strings (BseExportStrings *es)
{
  es->blurb = "Import a song from a MIDI file.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_import_midi_file = {
  { (BseExportNode*) &__enode_is_active, BSE_EXPORT_NODE_PROC,
    "BseProject+import-midi-file", 
    NULL,
    "/Methods/BseProject/File/Import MIDI",
    NULL,
    __enode_import_midi_file__fill_strings,
  },
  0, import_midi_file_setup, import_midi_file_exec, 
};
static void
__enode_restore_from_file__fill_strings (BseExportStrings *es)
{
  es->blurb = "Load a project from file";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_restore_from_file = {
  { (BseExportNode*) &__enode_import_midi_file, BSE_EXPORT_NODE_PROC,
    "BseProject+restore-from-file", 
    NULL,
    "/Methods/BseProject/File/Restore",
    NULL,
    __enode_restore_from_file__fill_strings,
  },
  0, restore_from_file_setup, restore_from_file_exec, 
};
static void
__enode_store_bse__fill_strings (BseExportStrings *es)
{
  es->blurb = "Save supers of a project into a BSE file. "
          "If no super is specified, the project itself is stored.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_store_bse = {
  { (BseExportNode*) &__enode_restore_from_file, BSE_EXPORT_NODE_PROC,
    "BseProject+store-bse", 
    NULL,
    "/Methods/BseProject/File/Store",
    NULL,
    __enode_store_bse__fill_strings,
  },
  0, store_bse_setup, store_bse_exec, 
};
static void
__enode_create_song__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a song for this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_song = {
  { (BseExportNode*) &__enode_store_bse, BSE_EXPORT_NODE_PROC,
    "BseProject+create-song", 
    NULL,
    "/Methods/BseProject/General/Create Song",
    NULL,
    __enode_create_song__fill_strings,
  },
  0, create_song_setup, create_song_exec, 
};
static void
__enode_get_wave_repo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Ensure the project has a wave repository";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_wave_repo = {
  { (BseExportNode*) &__enode_create_song, BSE_EXPORT_NODE_PROC,
    "BseProject+get-wave-repo", 
    NULL,
    "/Methods/BseProject/General/Get Wave Repo",
    NULL,
    __enode_get_wave_repo__fill_strings,
  },
  0, get_wave_repo_setup, get_wave_repo_exec, 
};
static void
__enode_get_data_pocket__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a specifically named data pocket for this project";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_data_pocket = {
  { (BseExportNode*) &__enode_get_wave_repo, BSE_EXPORT_NODE_PROC,
    "BseProject+get-data-pocket", 
    NULL,
    "/Methods/BseProject/General/Get Data Pocket",
    NULL,
    __enode_get_data_pocket__fill_strings,
  },
  0, get_data_pocket_setup, get_data_pocket_exec, 
};
static void
__enode_create_csynth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a synthsizer network for this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_csynth = {
  { (BseExportNode*) &__enode_get_data_pocket, BSE_EXPORT_NODE_PROC,
    "BseProject+create-csynth", 
    NULL,
    "/Methods/BseProject/General/Create Csynth",
    NULL,
    __enode_create_csynth__fill_strings,
  },
  0, create_csynth_setup, create_csynth_exec, 
};
static void
__enode_create_midi_synth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a MIDI synthesizer network for this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_midi_synth = {
  { (BseExportNode*) &__enode_create_csynth, BSE_EXPORT_NODE_PROC,
    "BseProject+create-midi-synth", 
    NULL,
    "/Methods/BseProject/General/Create Midi Synth",
    NULL,
    __enode_create_midi_synth__fill_strings,
  },
  0, create_midi_synth_setup, create_midi_synth_exec, 
};
static void
__enode_remove_snet__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove an existing synthesizer network from this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_remove_snet = {
  { (BseExportNode*) &__enode_create_midi_synth, BSE_EXPORT_NODE_PROC,
    "BseProject+remove-snet", 
    NULL,
    "/Methods/BseProject/General/Remove Snet",
    NULL,
    __enode_remove_snet__fill_strings,
  },
  0, remove_snet_setup, remove_snet_exec, 
};
static void
__enode_list_uname_paths__fill_strings (BseExportStrings *es)
{
  es->blurb = ("List uname paths for all items of a specified type within this project. "
           "By their uname paths, items are uniquely identifyable within a project.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_uname_paths = {
  { (BseExportNode*) &__enode_remove_snet, BSE_EXPORT_NODE_PROC,
    "BseProject+list-uname-paths", 
    NULL,
    "/Methods/BseProject/General/List Uname Paths",
    NULL,
    __enode_list_uname_paths__fill_strings,
  },
  0, list_uname_paths_setup, list_uname_paths_exec, 
};
static void
__enode_find_item__fill_strings (BseExportStrings *es)
{
  es->blurb = "Find an item within a project, given its uname path.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_find_item = {
  { (BseExportNode*) &__enode_list_uname_paths, BSE_EXPORT_NODE_PROC,
    "BseProject+find-item", 
    NULL,
    "/Methods/BseProject/General/Find Item",
    NULL,
    __enode_find_item__fill_strings,
  },
  0, find_item_setup, find_item_exec, 
};
static void
__enode_match_items_by_uname__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all items of a specific type within a project with matching uname";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_match_items_by_uname = {
  { (BseExportNode*) &__enode_find_item, BSE_EXPORT_NODE_PROC,
    "BseProject+match-items-by-uname", 
    NULL,
    "/Methods/BseProject/General/Match Items By Uname",
    NULL,
    __enode_match_items_by_uname__fill_strings,
  },
  0, match_items_by_uname_setup, match_items_by_uname_exec, 
};
static void
__enode_get_supers__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all supers of this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_supers = {
  { (BseExportNode*) &__enode_match_items_by_uname, BSE_EXPORT_NODE_PROC,
    "BseProject+get-supers", 
    NULL,
    "/Methods/BseProject/General/Get Supers",
    NULL,
    __enode_get_supers__fill_strings,
  },
  0, get_supers_setup, get_supers_exec, 
};
static void
__enode_can_play__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether project playback would makes sense.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_can_play = {
  { (BseExportNode*) &__enode_get_supers, BSE_EXPORT_NODE_PROC,
    "BseProject+can-play", 
    NULL,
    "/Methods/BseProject/General/Can Play",
    NULL,
    __enode_can_play__fill_strings,
  },
  0, can_play_setup, can_play_exec, 
};
static void
__enode_get_state__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the current project state.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_state = {
  { (BseExportNode*) &__enode_can_play, BSE_EXPORT_NODE_PROC,
    "BseProject+get-state", 
    NULL,
    "/Methods/BseProject/General/Get State",
    NULL,
    __enode_get_state__fill_strings,
  },
  0, get_state_setup, get_state_exec, 
};
static void
__enode_activate__fill_strings (BseExportStrings *es)
{
  es->blurb = "Activate a project, precondition to start playback.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_activate = {
  { (BseExportNode*) &__enode_get_state, BSE_EXPORT_NODE_PROC,
    "BseProject+activate", 
    NULL,
    "/Methods/BseProject/General/Activate",
    NULL,
    __enode_activate__fill_strings,
  },
  0, activate_setup, activate_exec, 
};
static void
__enode_start_playback__fill_strings (BseExportStrings *es)
{
  es->blurb = "Start playback in an activated project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_start_playback = {
  { (BseExportNode*) &__enode_activate, BSE_EXPORT_NODE_PROC,
    "BseProject+start-playback", 
    NULL,
    "/Methods/BseProject/General/Start Playback",
    NULL,
    __enode_start_playback__fill_strings,
  },
  0, start_playback_setup, start_playback_exec, 
};
static void
__enode_play__fill_strings (BseExportStrings *es)
{
  es->blurb = "Activate a project and start project playback (and already playing project is first halted).";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_play = {
  { (BseExportNode*) &__enode_start_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+play", 
    NULL,
    "/Methods/BseProject/General/Play",
    NULL,
    __enode_play__fill_strings,
  },
  0, play_setup, play_exec, 
};
static void
__enode_deactivate__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deactivate the project, automatically stop playback.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_deactivate = {
  { (BseExportNode*) &__enode_play, BSE_EXPORT_NODE_PROC,
    "BseProject+deactivate", 
    NULL,
    "/Methods/BseProject/General/Deactivate",
    NULL,
    __enode_deactivate__fill_strings,
  },
  0, deactivate_setup, deactivate_exec, 
};
static void
__enode_stop_playback__fill_strings (BseExportStrings *es)
{
  es->blurb = "Stop project playback.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_stop_playback = {
  { (BseExportNode*) &__enode_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+stop-playback", 
    NULL,
    "/Methods/BseProject/General/Stop Playback",
    NULL,
    __enode_stop_playback__fill_strings,
  },
  0, stop_playback_setup, stop_playback_exec, 
};
static void
__enode_stop__fill_strings (BseExportStrings *es)
{
  es->blurb = "Stop project playback and deactivate project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_stop = {
  { (BseExportNode*) &__enode_stop_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+stop", 
    NULL,
    "/Methods/BseProject/General/Stop",
    NULL,
    __enode_stop__fill_strings,
  },
  0, stop_setup, stop_exec, 
};
static void
__enode_auto_deactivate__fill_strings (BseExportStrings *es)
{
  es->blurb = "Automatically deactivate a project once playback stopped.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_auto_deactivate = {
  { (BseExportNode*) &__enode_stop, BSE_EXPORT_NODE_PROC,
    "BseProject+auto-deactivate", 
    NULL,
    "/Methods/BseProject/General/Auto Deactivate",
    NULL,
    __enode_auto_deactivate__fill_strings,
  },
  0, auto_deactivate_setup, auto_deactivate_exec, 
};
static void
__enode_undo_depth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project can perform undo steps";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_undo_depth = {
  { (BseExportNode*) &__enode_auto_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+undo-depth", 
    NULL,
    "/Methods/BseProject/General/Undo Depth",
    NULL,
    __enode_undo_depth__fill_strings,
  },
  0, undo_depth_setup, undo_depth_exec, 
};
static void
__enode_undo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Undo a previous operation in a project";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_undo = {
  { (BseExportNode*) &__enode_undo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+undo", 
    NULL,
    "/Methods/BseProject/General/Undo",
    NULL,
    __enode_undo__fill_strings,
  },
  0, undo_setup, undo_exec, 
};
static void
__enode_redo_depth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project can perform redo steps";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_redo_depth = {
  { (BseExportNode*) &__enode_undo, BSE_EXPORT_NODE_PROC,
    "BseProject+redo-depth", 
    NULL,
    "/Methods/BseProject/General/Redo Depth",
    NULL,
    __enode_redo_depth__fill_strings,
  },
  0, redo_depth_setup, redo_depth_exec, 
};
static void
__enode_redo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Redo a previously undone operaiton in a project";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_redo = {
  { (BseExportNode*) &__enode_redo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+redo", 
    NULL,
    "/Methods/BseProject/General/Redo",
    NULL,
    __enode_redo__fill_strings,
  },
  0, redo_setup, redo_exec, 
};
static void
__enode_clear_undo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete all recorded undo or redo steps.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_clear_undo = {
  { (BseExportNode*) &__enode_redo, BSE_EXPORT_NODE_PROC,
    "BseProject+clear-undo", 
    NULL,
    "/Methods/BseProject/General/Clear Undo",
    NULL,
    __enode_clear_undo__fill_strings,
  },
  0, clear_undo_setup, clear_undo_exec, 
};
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_clear_undo;
}

/*
 * Generated data ends here
 */
