
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsetrack.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsetrack.h>
#include <bse/bsepart.h>
#include <bse/bsesong.h>
#include <bse/bseundostack.h>


#line 28 "bsetrack.proc"


/* --- insert-part --- */
static void
insert_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bsetrack.proc"
 {
#line 32 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("id", "Link ID", NULL,
                         0, 0, SFI_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 41 "bsetrack.proc"
 }
static BseErrorType
#line 41 "bsetrack.proc"
insert_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 44 "bsetrack.proc"
{
#line 45 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BsePart  *part = bse_value_get_object (in_values++);
  guint id;

#line 51 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self) || !BSE_IS_PART (part) ||
      !BSE_ITEM (self)->parent ||
      BSE_ITEM (self)->parent != BSE_ITEM (part)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 57 "bsetrack.proc"
  
  id = bse_track_insert_part (self, tick, part);
  if (id)
    {
#line 61 "bsetrack.proc"
      
      bse_item_push_undo_proc (self, "remove-tick", tick);
    }

#line 65 "bsetrack.proc"
  
  g_value_set_int (out_values++, id);

  return BSE_ERROR_NONE;
}

/* --- remove-tick --- */
static void
remove_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 71 "bsetrack.proc"
 {
#line 73 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
}
#line 78 "bsetrack.proc"
 }
static BseErrorType
#line 78 "bsetrack.proc"
remove_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 81 "bsetrack.proc"
{
#line 82 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;

#line 87 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 91 "bsetrack.proc"
  
  entry = bse_track_lookup_tick (self, tick);
  if (entry)
    {
      bse_item_push_undo_proc (self, "insert-part", entry->tick, entry->part);
      bse_track_remove_tick (self, tick);
    }

  return BSE_ERROR_NONE;
}

/* --- remove-link --- */
static void
remove_link_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bsetrack.proc"
 {
#line 104 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("id", "Link ID", NULL,
			 0, 0, SFI_MAXINT, 384, SFI_PARAM_STANDARD);
}
#line 109 "bsetrack.proc"
 }
static BseErrorType
#line 109 "bsetrack.proc"
remove_link_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 112 "bsetrack.proc"
{
#line 113 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     id   = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;

#line 118 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  entry = bse_track_find_link (self, id);
  if (!entry)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 125 "bsetrack.proc"
  
  bse_item_push_undo_proc (self, "insert-part", entry->tick, entry->part);
  bse_track_remove_tick (self, entry->tick);
  
  return BSE_ERROR_NONE;
}

/* --- list-parts --- */
static void
list_parts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 132 "bsetrack.proc"
 {
#line 134 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("part_list", "Part List", NULL,
				BSE_TYPE_TRACK_PART_SEQ, SFI_PARAM_STANDARD);
}
#line 139 "bsetrack.proc"
 }
static BseErrorType
#line 139 "bsetrack.proc"
list_parts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 142 "bsetrack.proc"
{
#line 143 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);

#line 146 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 150 "bsetrack.proc"
  
  bse_value_take_boxed (out_values++, bse_track_list_parts (self));

  return BSE_ERROR_NONE;
}

/* --- get-part --- */
static void
get_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 156 "bsetrack.proc"
 {
#line 158 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
}
#line 165 "bsetrack.proc"
 }
static BseErrorType
#line 165 "bsetrack.proc"
get_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 168 "bsetrack.proc"
{
#line 169 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;
  
#line 174 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 178 "bsetrack.proc"
  
  entry = bse_track_lookup_tick (self, tick);
  bse_value_set_object (out_values++, entry ? entry->part : NULL);

  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 185 "bsetrack.proc"
 {
#line 187 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL, BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 190 "bsetrack.proc"
}  }
static BseErrorType
#line 190 "bsetrack.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 193 "bsetrack.proc"
{
#line 194 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  SfiInt    tick = sfi_value_get_int (in_values++);
  BseItem  *parent;
  BseSongTiming timing = { 0, };

#line 200 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 204 "bsetrack.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 211 "bsetrack.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- create-sniffer --- */
static void
create_sniffer_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 217 "bsetrack.proc"
 {
#line 219 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
                                 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("sniffer", "Sniffer", NULL,
                                 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
#line 223 "bsetrack.proc"
}  }
static BseErrorType
#line 223 "bsetrack.proc"
create_sniffer_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 226 "bsetrack.proc"
{
#line 227 "bsetrack.proc"
  
  BseTrack *track = bse_value_get_object (in_values++);
  BseItem *song;
  BseUndoStack *ustack;
  BseSource *child = NULL;

#line 233 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (track))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 237 "bsetrack.proc"
  
  song = BSE_ITEM (track)->parent;
  if (BSE_IS_SONG (song))
    {
      ustack = bse_item_undo_open (song, "SKIP");
      bse_undo_stack_ignore_steps (ustack);
      child = bse_container_new_child (BSE_CONTAINER (song), g_type_from_name ("BseSniffer"), NULL);
      bse_item_set_internal (child, TRUE);
      bse_track_connect_sniffer (track, child);
      bse_undo_stack_unignore_steps (ustack);
      bse_item_undo_close (ustack);
    }

#line 250 "bsetrack.proc"
  
  bse_value_set_object (out_values++, child);

  return BSE_ERROR_NONE;
}

/* --- get-last-tick --- */
static void
get_last_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 256 "bsetrack.proc"
 {
#line 258 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
                                 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("last_tick", "Last Tick", NULL,
                         0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
#line 262 "bsetrack.proc"
}  }
static BseErrorType
#line 262 "bsetrack.proc"
get_last_tick_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 265 "bsetrack.proc"
{
#line 266 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  int last_tick = 0;

#line 270 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 274 "bsetrack.proc"
  
  BsePart *part = NULL;
  guint i, offset = 0;
  for (i = 0; i < self->n_entries_SL; i++)
    if (self->entries_SL[i].part)
      {
        part = self->entries_SL[i].part;
        offset = self->entries_SL[i].tick;
      }
  if (part)
    {
      BseItem *item = BSE_ITEM (self);
      BseSongTiming timing;
      g_object_get (part, "last-tick", &last_tick, NULL);
      if (BSE_IS_SONG (item->parent))
        bse_song_get_timing (BSE_SONG (item->parent), offset, &timing);
      else
        bse_song_timing_get_default (&timing);
#line 292 "bsetrack.proc"
      last_tick = MAX (last_tick, timing.tpt);  
      last_tick += offset;
    }
  else
#line 296 "bsetrack.proc"
    last_tick += 1;     
  
#line 298 "bsetrack.proc"
  
  sfi_value_set_int (out_values++, last_tick);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_insert_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a part into a track and retrieve the corresponding link id.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_insert_part = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseTrack+insert-part", 
    NULL,
    "/Methods/BseTrack/General/Insert Part",
    NULL,
    __enode_insert_part__fill_strings,
  },
  0, insert_part_setup, insert_part_exec, 
};
static void
__enode_remove_tick__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a part at specified tick from a track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_remove_tick = {
  { (BseExportNode*) &__enode_insert_part, BSE_EXPORT_NODE_PROC,
    "BseTrack+remove-tick", 
    NULL,
    "/Methods/BseTrack/General/Remove Tick",
    NULL,
    __enode_remove_tick__fill_strings,
  },
  0, remove_tick_setup, remove_tick_exec, 
};
static void
__enode_remove_link__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a specific part link by ID from a track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_remove_link = {
  { (BseExportNode*) &__enode_remove_tick, BSE_EXPORT_NODE_PROC,
    "BseTrack+remove-link", 
    NULL,
    "/Methods/BseTrack/General/Remove Link",
    NULL,
    __enode_remove_link__fill_strings,
  },
  0, remove_link_setup, remove_link_exec, 
};
static void
__enode_list_parts__fill_strings (BseExportStrings *es)
{
  es->blurb = "List parts scheduled in a track, sorted by tick.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_list_parts = {
  { (BseExportNode*) &__enode_remove_link, BSE_EXPORT_NODE_PROC,
    "BseTrack+list-parts", 
    NULL,
    "/Methods/BseTrack/General/List Parts",
    NULL,
    __enode_list_parts__fill_strings,
  },
  0, list_parts_setup, list_parts_exec, 
};
static void
__enode_get_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the part starting at a specific tick position.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_part = {
  { (BseExportNode*) &__enode_list_parts, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-part", 
    NULL,
    "/Methods/BseTrack/General/Get Part",
    NULL,
    __enode_get_part__fill_strings,
  },
  0, get_part_setup, get_part_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve song timing information at a specific tick.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_get_part, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-timing", 
    NULL,
    "/Methods/BseTrack/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
static void
__enode_create_sniffer__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a new sniffer for this track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_create_sniffer = {
  { (BseExportNode*) &__enode_get_timing, BSE_EXPORT_NODE_PROC,
    "BseTrack+create-sniffer", 
    NULL,
    "/Methods/BseTrack/General/Create Sniffer",
    NULL,
    __enode_create_sniffer__fill_strings,
  },
  0, create_sniffer_setup, create_sniffer_exec, 
};
static void
__enode_get_last_tick__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the last tick for this track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_last_tick = {
  { (BseExportNode*) &__enode_create_sniffer, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-last-tick", 
    NULL,
    "/Methods/BseTrack/General/Get Last Tick",
    NULL,
    __enode_get_last_tick__fill_strings,
  },
  0, get_last_tick_setup, get_last_tick_exec, 
};
BseExportNode* bse__builtin_init_bsetrack_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsetrack_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_last_tick;
}

/**
 ** Generated data ends here
 **/
