/* Signal Variants -- Generated from: birnetsignalslot.hh birnetsignaltemplate.hh mksignals.sh */

# 0 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3>
struct Trampoline3 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3>
class FunctionTrampoline3 : public Trampoline3 <R0, A1, A2, A3> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3)
  { return callback (a1, a2, a3); }
  ~FunctionTrampoline3() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline3 *other = dynamic_cast<const FunctionTrampoline3*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline3 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3>
class MethodTrampoline3 : public Trampoline3 <R0, A1, A2, A3> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3)
  { return (instance->*method) (a1, a2, a3); }
  ~MethodTrampoline3() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline3 *other = dynamic_cast<const MethodTrampoline3*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline3 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename Data>
class DataFunctionTrampoline3 : public Trampoline3 <R0, A1, A2, A3> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3)
  { return callback (a1, a2, a3, data); }
  ~DataFunctionTrampoline3() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline3 *other = dynamic_cast<const DataFunctionTrampoline3*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline3 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename Data>
class DataMethodTrampoline3 : public Trampoline3 <R0, A1, A2, A3> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3)
  { return (instance->*method) (a1, a2, a3, data); }
  ~DataMethodTrampoline3() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline3 *other = dynamic_cast<const DataMethodTrampoline3*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline3 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, class Emitter = void>
struct Slot3 : SlotBase {
  Slot3 (Trampoline3<R0, A1, A2, A3> *trampoline) : SlotBase (trampoline) {}
  Trampoline3<R0, A1, A2, A3>* get_trampoline() const
  { return trampoline_cast< Trampoline3<R0, A1, A2, A3>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3> Slot3<R0, A1, A2, A3>
slot (R0 (*callback) (A1, A2, A3))
{
  return Slot3<R0, A1, A2, A3> (new FunctionTrampoline3<R0, A1, A2, A3> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename Data> Slot3<R0, A1, A2, A3>
slot (R0 (*callback) (A1, A2, A3, Data), const Data &data)
{
  return Slot3<R0, A1, A2, A3> (new DataFunctionTrampoline3<R0, A1, A2, A3, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3> Slot3<R0, A1, A2, A3>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3))
{
  return Slot3<R0, A1, A2, A3> (new MethodTrampoline3<Class, R0, A1, A2, A3> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename Data> Slot3<R0, A1, A2, A3>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, Data), const Data &data)
{
  return Slot3<R0, A1, A2, A3> (new DataMethodTrampoline3<Class, R0, A1, A2, A3, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3> Slot3<R0, A1, A2, A3>
slot (Signal<Obj, R0 (A1, A2, A3)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3)> CustomSignal;
  return Slot3<R0, A1, A2, A3> (new MethodTrampoline3<CustomSignal, R0, A1, A2, A3> (sigref, &CustomSignal::emit));
}
# 99000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0>
struct Trampoline0 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() () = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0>
class FunctionTrampoline0 : public Trampoline0 <R0> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) ();
  Callback callback;
  virtual R0 operator() ()
  { return callback (); }
  ~FunctionTrampoline0() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline0 *other = dynamic_cast<const FunctionTrampoline0*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline0 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0>
class MethodTrampoline0 : public Trampoline0 <R0> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) ();
  Class *instance;
  Method method;
  virtual R0 operator() ()
  { return (instance->*method) (); }
  ~MethodTrampoline0() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline0 *other = dynamic_cast<const MethodTrampoline0*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline0 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename Data>
class DataFunctionTrampoline0 : public Trampoline0 <R0> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) ( Data);
  Callback callback; Data data;
  virtual R0 operator() ()
  { return callback ( data); }
  ~DataFunctionTrampoline0() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline0 *other = dynamic_cast<const DataFunctionTrampoline0*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline0 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename Data>
class DataMethodTrampoline0 : public Trampoline0 <R0> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) ( Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() ()
  { return (instance->*method) ( data); }
  ~DataMethodTrampoline0() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline0 *other = dynamic_cast<const DataMethodTrampoline0*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline0 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, class Emitter = void>
struct Slot0 : SlotBase {
  Slot0 (Trampoline0<R0> *trampoline) : SlotBase (trampoline) {}
  Trampoline0<R0>* get_trampoline() const
  { return trampoline_cast< Trampoline0<R0>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0> Slot0<R0>
slot (R0 (*callback) ())
{
  return Slot0<R0> (new FunctionTrampoline0<R0> (callback));
}
template<typename R0, typename Data> Slot0<R0>
slot (R0 (*callback) ( Data), const Data &data)
{
  return Slot0<R0> (new DataFunctionTrampoline0<R0, Data> (callback, data));
}
template<class Class, typename R0> Slot0<R0>
slot (Class &obj, R0 (Class::*method) ())
{
  return Slot0<R0> (new MethodTrampoline0<Class, R0> (obj, method));
}
template<class Class, typename R0, typename Data> Slot0<R0>
slot (Class &obj, R0 (Class::*method) ( Data), const Data &data)
{
  return Slot0<R0> (new DataMethodTrampoline0<Class, R0, Data> (obj, method, data));
}
template<typename Obj, typename R0> Slot0<R0>
slot (Signal<Obj, R0 ()> &sigref)
{
  typedef Signal<Obj, R0 ()> CustomSignal;
  return Slot0<R0> (new MethodTrampoline0<CustomSignal, R0> (sigref, &CustomSignal::emit));
}
# 10000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1>
struct Trampoline1 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1>
class FunctionTrampoline1 : public Trampoline1 <R0, A1> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1);
  Callback callback;
  virtual R0 operator() (A1 a1)
  { return callback (a1); }
  ~FunctionTrampoline1() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline1 *other = dynamic_cast<const FunctionTrampoline1*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline1 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1>
class MethodTrampoline1 : public Trampoline1 <R0, A1> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1)
  { return (instance->*method) (a1); }
  ~MethodTrampoline1() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline1 *other = dynamic_cast<const MethodTrampoline1*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline1 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename Data>
class DataFunctionTrampoline1 : public Trampoline1 <R0, A1> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1)
  { return callback (a1, data); }
  ~DataFunctionTrampoline1() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline1 *other = dynamic_cast<const DataFunctionTrampoline1*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline1 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename Data>
class DataMethodTrampoline1 : public Trampoline1 <R0, A1> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1)
  { return (instance->*method) (a1, data); }
  ~DataMethodTrampoline1() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline1 *other = dynamic_cast<const DataMethodTrampoline1*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline1 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, class Emitter = void>
struct Slot1 : SlotBase {
  Slot1 (Trampoline1<R0, A1> *trampoline) : SlotBase (trampoline) {}
  Trampoline1<R0, A1>* get_trampoline() const
  { return trampoline_cast< Trampoline1<R0, A1>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1> Slot1<R0, A1>
slot (R0 (*callback) (A1))
{
  return Slot1<R0, A1> (new FunctionTrampoline1<R0, A1> (callback));
}
template<typename R0, typename A1, typename Data> Slot1<R0, A1>
slot (R0 (*callback) (A1, Data), const Data &data)
{
  return Slot1<R0, A1> (new DataFunctionTrampoline1<R0, A1, Data> (callback, data));
}
template<class Class, typename R0, typename A1> Slot1<R0, A1>
slot (Class &obj, R0 (Class::*method) (A1))
{
  return Slot1<R0, A1> (new MethodTrampoline1<Class, R0, A1> (obj, method));
}
template<class Class, typename R0, typename A1, typename Data> Slot1<R0, A1>
slot (Class &obj, R0 (Class::*method) (A1, Data), const Data &data)
{
  return Slot1<R0, A1> (new DataMethodTrampoline1<Class, R0, A1, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1> Slot1<R0, A1>
slot (Signal<Obj, R0 (A1)> &sigref)
{
  typedef Signal<Obj, R0 (A1)> CustomSignal;
  return Slot1<R0, A1> (new MethodTrampoline1<CustomSignal, R0, A1> (sigref, &CustomSignal::emit));
}
# 20000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2>
struct Trampoline2 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2>
class FunctionTrampoline2 : public Trampoline2 <R0, A1, A2> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2)
  { return callback (a1, a2); }
  ~FunctionTrampoline2() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline2 *other = dynamic_cast<const FunctionTrampoline2*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline2 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2>
class MethodTrampoline2 : public Trampoline2 <R0, A1, A2> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2)
  { return (instance->*method) (a1, a2); }
  ~MethodTrampoline2() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline2 *other = dynamic_cast<const MethodTrampoline2*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline2 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename Data>
class DataFunctionTrampoline2 : public Trampoline2 <R0, A1, A2> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2)
  { return callback (a1, a2, data); }
  ~DataFunctionTrampoline2() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline2 *other = dynamic_cast<const DataFunctionTrampoline2*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline2 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename Data>
class DataMethodTrampoline2 : public Trampoline2 <R0, A1, A2> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2)
  { return (instance->*method) (a1, a2, data); }
  ~DataMethodTrampoline2() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline2 *other = dynamic_cast<const DataMethodTrampoline2*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline2 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, class Emitter = void>
struct Slot2 : SlotBase {
  Slot2 (Trampoline2<R0, A1, A2> *trampoline) : SlotBase (trampoline) {}
  Trampoline2<R0, A1, A2>* get_trampoline() const
  { return trampoline_cast< Trampoline2<R0, A1, A2>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2> Slot2<R0, A1, A2>
slot (R0 (*callback) (A1, A2))
{
  return Slot2<R0, A1, A2> (new FunctionTrampoline2<R0, A1, A2> (callback));
}
template<typename R0, typename A1, typename A2, typename Data> Slot2<R0, A1, A2>
slot (R0 (*callback) (A1, A2, Data), const Data &data)
{
  return Slot2<R0, A1, A2> (new DataFunctionTrampoline2<R0, A1, A2, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2> Slot2<R0, A1, A2>
slot (Class &obj, R0 (Class::*method) (A1, A2))
{
  return Slot2<R0, A1, A2> (new MethodTrampoline2<Class, R0, A1, A2> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename Data> Slot2<R0, A1, A2>
slot (Class &obj, R0 (Class::*method) (A1, A2, Data), const Data &data)
{
  return Slot2<R0, A1, A2> (new DataMethodTrampoline2<Class, R0, A1, A2, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2> Slot2<R0, A1, A2>
slot (Signal<Obj, R0 (A1, A2)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2)> CustomSignal;
  return Slot2<R0, A1, A2> (new MethodTrampoline2<CustomSignal, R0, A1, A2> (sigref, &CustomSignal::emit));
}
# 40000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4>
struct Trampoline4 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4>
class FunctionTrampoline4 : public Trampoline4 <R0, A1, A2, A3, A4> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4)
  { return callback (a1, a2, a3, a4); }
  ~FunctionTrampoline4() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline4 *other = dynamic_cast<const FunctionTrampoline4*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline4 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4>
class MethodTrampoline4 : public Trampoline4 <R0, A1, A2, A3, A4> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4)
  { return (instance->*method) (a1, a2, a3, a4); }
  ~MethodTrampoline4() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline4 *other = dynamic_cast<const MethodTrampoline4*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline4 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename Data>
class DataFunctionTrampoline4 : public Trampoline4 <R0, A1, A2, A3, A4> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4)
  { return callback (a1, a2, a3, a4, data); }
  ~DataFunctionTrampoline4() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline4 *other = dynamic_cast<const DataFunctionTrampoline4*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline4 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename Data>
class DataMethodTrampoline4 : public Trampoline4 <R0, A1, A2, A3, A4> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4)
  { return (instance->*method) (a1, a2, a3, a4, data); }
  ~DataMethodTrampoline4() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline4 *other = dynamic_cast<const DataMethodTrampoline4*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline4 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, class Emitter = void>
struct Slot4 : SlotBase {
  Slot4 (Trampoline4<R0, A1, A2, A3, A4> *trampoline) : SlotBase (trampoline) {}
  Trampoline4<R0, A1, A2, A3, A4>* get_trampoline() const
  { return trampoline_cast< Trampoline4<R0, A1, A2, A3, A4>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4> Slot4<R0, A1, A2, A3, A4>
slot (R0 (*callback) (A1, A2, A3, A4))
{
  return Slot4<R0, A1, A2, A3, A4> (new FunctionTrampoline4<R0, A1, A2, A3, A4> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename Data> Slot4<R0, A1, A2, A3, A4>
slot (R0 (*callback) (A1, A2, A3, A4, Data), const Data &data)
{
  return Slot4<R0, A1, A2, A3, A4> (new DataFunctionTrampoline4<R0, A1, A2, A3, A4, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4> Slot4<R0, A1, A2, A3, A4>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4))
{
  return Slot4<R0, A1, A2, A3, A4> (new MethodTrampoline4<Class, R0, A1, A2, A3, A4> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename Data> Slot4<R0, A1, A2, A3, A4>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, Data), const Data &data)
{
  return Slot4<R0, A1, A2, A3, A4> (new DataMethodTrampoline4<Class, R0, A1, A2, A3, A4, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4> Slot4<R0, A1, A2, A3, A4>
slot (Signal<Obj, R0 (A1, A2, A3, A4)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4)> CustomSignal;
  return Slot4<R0, A1, A2, A3, A4> (new MethodTrampoline4<CustomSignal, R0, A1, A2, A3, A4> (sigref, &CustomSignal::emit));
}
# 50000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct Trampoline5 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5>
class FunctionTrampoline5 : public Trampoline5 <R0, A1, A2, A3, A4, A5> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
  { return callback (a1, a2, a3, a4, a5); }
  ~FunctionTrampoline5() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline5 *other = dynamic_cast<const FunctionTrampoline5*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline5 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5>
class MethodTrampoline5 : public Trampoline5 <R0, A1, A2, A3, A4, A5> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
  { return (instance->*method) (a1, a2, a3, a4, a5); }
  ~MethodTrampoline5() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline5 *other = dynamic_cast<const MethodTrampoline5*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline5 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename Data>
class DataFunctionTrampoline5 : public Trampoline5 <R0, A1, A2, A3, A4, A5> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
  { return callback (a1, a2, a3, a4, a5, data); }
  ~DataFunctionTrampoline5() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline5 *other = dynamic_cast<const DataFunctionTrampoline5*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline5 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename Data>
class DataMethodTrampoline5 : public Trampoline5 <R0, A1, A2, A3, A4, A5> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
  { return (instance->*method) (a1, a2, a3, a4, a5, data); }
  ~DataMethodTrampoline5() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline5 *other = dynamic_cast<const DataMethodTrampoline5*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline5 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, class Emitter = void>
struct Slot5 : SlotBase {
  Slot5 (Trampoline5<R0, A1, A2, A3, A4, A5> *trampoline) : SlotBase (trampoline) {}
  Trampoline5<R0, A1, A2, A3, A4, A5>* get_trampoline() const
  { return trampoline_cast< Trampoline5<R0, A1, A2, A3, A4, A5>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5> Slot5<R0, A1, A2, A3, A4, A5>
slot (R0 (*callback) (A1, A2, A3, A4, A5))
{
  return Slot5<R0, A1, A2, A3, A4, A5> (new FunctionTrampoline5<R0, A1, A2, A3, A4, A5> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename Data> Slot5<R0, A1, A2, A3, A4, A5>
slot (R0 (*callback) (A1, A2, A3, A4, A5, Data), const Data &data)
{
  return Slot5<R0, A1, A2, A3, A4, A5> (new DataFunctionTrampoline5<R0, A1, A2, A3, A4, A5, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5> Slot5<R0, A1, A2, A3, A4, A5>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5))
{
  return Slot5<R0, A1, A2, A3, A4, A5> (new MethodTrampoline5<Class, R0, A1, A2, A3, A4, A5> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename Data> Slot5<R0, A1, A2, A3, A4, A5>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, Data), const Data &data)
{
  return Slot5<R0, A1, A2, A3, A4, A5> (new DataMethodTrampoline5<Class, R0, A1, A2, A3, A4, A5, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5> Slot5<R0, A1, A2, A3, A4, A5>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5)> CustomSignal;
  return Slot5<R0, A1, A2, A3, A4, A5> (new MethodTrampoline5<CustomSignal, R0, A1, A2, A3, A4, A5> (sigref, &CustomSignal::emit));
}
# 60000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct Trampoline6 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
class FunctionTrampoline6 : public Trampoline6 <R0, A1, A2, A3, A4, A5, A6> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6)
  { return callback (a1, a2, a3, a4, a5, a6); }
  ~FunctionTrampoline6() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline6 *other = dynamic_cast<const FunctionTrampoline6*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline6 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
class MethodTrampoline6 : public Trampoline6 <R0, A1, A2, A3, A4, A5, A6> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6); }
  ~MethodTrampoline6() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline6 *other = dynamic_cast<const MethodTrampoline6*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline6 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename Data>
class DataFunctionTrampoline6 : public Trampoline6 <R0, A1, A2, A3, A4, A5, A6> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6)
  { return callback (a1, a2, a3, a4, a5, a6, data); }
  ~DataFunctionTrampoline6() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline6 *other = dynamic_cast<const DataFunctionTrampoline6*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline6 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename Data>
class DataMethodTrampoline6 : public Trampoline6 <R0, A1, A2, A3, A4, A5, A6> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, data); }
  ~DataMethodTrampoline6() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline6 *other = dynamic_cast<const DataMethodTrampoline6*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline6 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, class Emitter = void>
struct Slot6 : SlotBase {
  Slot6 (Trampoline6<R0, A1, A2, A3, A4, A5, A6> *trampoline) : SlotBase (trampoline) {}
  Trampoline6<R0, A1, A2, A3, A4, A5, A6>* get_trampoline() const
  { return trampoline_cast< Trampoline6<R0, A1, A2, A3, A4, A5, A6>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6> Slot6<R0, A1, A2, A3, A4, A5, A6>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6))
{
  return Slot6<R0, A1, A2, A3, A4, A5, A6> (new FunctionTrampoline6<R0, A1, A2, A3, A4, A5, A6> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename Data> Slot6<R0, A1, A2, A3, A4, A5, A6>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, Data), const Data &data)
{
  return Slot6<R0, A1, A2, A3, A4, A5, A6> (new DataFunctionTrampoline6<R0, A1, A2, A3, A4, A5, A6, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6> Slot6<R0, A1, A2, A3, A4, A5, A6>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6))
{
  return Slot6<R0, A1, A2, A3, A4, A5, A6> (new MethodTrampoline6<Class, R0, A1, A2, A3, A4, A5, A6> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename Data> Slot6<R0, A1, A2, A3, A4, A5, A6>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, Data), const Data &data)
{
  return Slot6<R0, A1, A2, A3, A4, A5, A6> (new DataMethodTrampoline6<Class, R0, A1, A2, A3, A4, A5, A6, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6> Slot6<R0, A1, A2, A3, A4, A5, A6>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6)> CustomSignal;
  return Slot6<R0, A1, A2, A3, A4, A5, A6> (new MethodTrampoline6<CustomSignal, R0, A1, A2, A3, A4, A5, A6> (sigref, &CustomSignal::emit));
}
# 70000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct Trampoline7 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
class FunctionTrampoline7 : public Trampoline7 <R0, A1, A2, A3, A4, A5, A6, A7> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7)
  { return callback (a1, a2, a3, a4, a5, a6, a7); }
  ~FunctionTrampoline7() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline7 *other = dynamic_cast<const FunctionTrampoline7*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline7 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
class MethodTrampoline7 : public Trampoline7 <R0, A1, A2, A3, A4, A5, A6, A7> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7); }
  ~MethodTrampoline7() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline7 *other = dynamic_cast<const MethodTrampoline7*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline7 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename Data>
class DataFunctionTrampoline7 : public Trampoline7 <R0, A1, A2, A3, A4, A5, A6, A7> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7)
  { return callback (a1, a2, a3, a4, a5, a6, a7, data); }
  ~DataFunctionTrampoline7() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline7 *other = dynamic_cast<const DataFunctionTrampoline7*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline7 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename Data>
class DataMethodTrampoline7 : public Trampoline7 <R0, A1, A2, A3, A4, A5, A6, A7> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, data); }
  ~DataMethodTrampoline7() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline7 *other = dynamic_cast<const DataMethodTrampoline7*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline7 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, class Emitter = void>
struct Slot7 : SlotBase {
  Slot7 (Trampoline7<R0, A1, A2, A3, A4, A5, A6, A7> *trampoline) : SlotBase (trampoline) {}
  Trampoline7<R0, A1, A2, A3, A4, A5, A6, A7>* get_trampoline() const
  { return trampoline_cast< Trampoline7<R0, A1, A2, A3, A4, A5, A6, A7>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7> Slot7<R0, A1, A2, A3, A4, A5, A6, A7>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7))
{
  return Slot7<R0, A1, A2, A3, A4, A5, A6, A7> (new FunctionTrampoline7<R0, A1, A2, A3, A4, A5, A6, A7> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename Data> Slot7<R0, A1, A2, A3, A4, A5, A6, A7>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, Data), const Data &data)
{
  return Slot7<R0, A1, A2, A3, A4, A5, A6, A7> (new DataFunctionTrampoline7<R0, A1, A2, A3, A4, A5, A6, A7, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7> Slot7<R0, A1, A2, A3, A4, A5, A6, A7>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7))
{
  return Slot7<R0, A1, A2, A3, A4, A5, A6, A7> (new MethodTrampoline7<Class, R0, A1, A2, A3, A4, A5, A6, A7> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename Data> Slot7<R0, A1, A2, A3, A4, A5, A6, A7>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, Data), const Data &data)
{
  return Slot7<R0, A1, A2, A3, A4, A5, A6, A7> (new DataMethodTrampoline7<Class, R0, A1, A2, A3, A4, A5, A6, A7, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7> Slot7<R0, A1, A2, A3, A4, A5, A6, A7>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7)> CustomSignal;
  return Slot7<R0, A1, A2, A3, A4, A5, A6, A7> (new MethodTrampoline7<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7> (sigref, &CustomSignal::emit));
}
# 80000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct Trampoline8 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
class FunctionTrampoline8 : public Trampoline8 <R0, A1, A2, A3, A4, A5, A6, A7, A8> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8); }
  ~FunctionTrampoline8() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline8 *other = dynamic_cast<const FunctionTrampoline8*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline8 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
class MethodTrampoline8 : public Trampoline8 <R0, A1, A2, A3, A4, A5, A6, A7, A8> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8); }
  ~MethodTrampoline8() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline8 *other = dynamic_cast<const MethodTrampoline8*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline8 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename Data>
class DataFunctionTrampoline8 : public Trampoline8 <R0, A1, A2, A3, A4, A5, A6, A7, A8> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, data); }
  ~DataFunctionTrampoline8() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline8 *other = dynamic_cast<const DataFunctionTrampoline8*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline8 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename Data>
class DataMethodTrampoline8 : public Trampoline8 <R0, A1, A2, A3, A4, A5, A6, A7, A8> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, data); }
  ~DataMethodTrampoline8() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline8 *other = dynamic_cast<const DataMethodTrampoline8*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline8 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, class Emitter = void>
struct Slot8 : SlotBase {
  Slot8 (Trampoline8<R0, A1, A2, A3, A4, A5, A6, A7, A8> *trampoline) : SlotBase (trampoline) {}
  Trampoline8<R0, A1, A2, A3, A4, A5, A6, A7, A8>* get_trampoline() const
  { return trampoline_cast< Trampoline8<R0, A1, A2, A3, A4, A5, A6, A7, A8>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8> Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8))
{
  return Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8> (new FunctionTrampoline8<R0, A1, A2, A3, A4, A5, A6, A7, A8> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename Data> Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, Data), const Data &data)
{
  return Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8> (new DataFunctionTrampoline8<R0, A1, A2, A3, A4, A5, A6, A7, A8, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8> Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8))
{
  return Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8> (new MethodTrampoline8<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename Data> Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, Data), const Data &data)
{
  return Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8> (new DataMethodTrampoline8<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8> Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8)> CustomSignal;
  return Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8> (new MethodTrampoline8<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8> (sigref, &CustomSignal::emit));
}
# 90000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct Trampoline9 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
class FunctionTrampoline9 : public Trampoline9 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9); }
  ~FunctionTrampoline9() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline9 *other = dynamic_cast<const FunctionTrampoline9*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline9 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
class MethodTrampoline9 : public Trampoline9 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9); }
  ~MethodTrampoline9() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline9 *other = dynamic_cast<const MethodTrampoline9*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline9 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename Data>
class DataFunctionTrampoline9 : public Trampoline9 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, data); }
  ~DataFunctionTrampoline9() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline9 *other = dynamic_cast<const DataFunctionTrampoline9*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline9 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename Data>
class DataMethodTrampoline9 : public Trampoline9 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, data); }
  ~DataMethodTrampoline9() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline9 *other = dynamic_cast<const DataMethodTrampoline9*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline9 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, class Emitter = void>
struct Slot9 : SlotBase {
  Slot9 (Trampoline9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> *trampoline) : SlotBase (trampoline) {}
  Trampoline9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>* get_trampoline() const
  { return trampoline_cast< Trampoline9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9> Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9))
{
  return Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (new FunctionTrampoline9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename Data> Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, Data), const Data &data)
{
  return Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (new DataFunctionTrampoline9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9> Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9))
{
  return Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (new MethodTrampoline9<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename Data> Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, Data), const Data &data)
{
  return Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (new DataMethodTrampoline9<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9> Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9)> CustomSignal;
  return Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (new MethodTrampoline9<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> (sigref, &CustomSignal::emit));
}
# 100000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct Trampoline10 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
class FunctionTrampoline10 : public Trampoline10 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10); }
  ~FunctionTrampoline10() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline10 *other = dynamic_cast<const FunctionTrampoline10*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline10 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
class MethodTrampoline10 : public Trampoline10 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10); }
  ~MethodTrampoline10() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline10 *other = dynamic_cast<const MethodTrampoline10*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline10 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename Data>
class DataFunctionTrampoline10 : public Trampoline10 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, data); }
  ~DataFunctionTrampoline10() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline10 *other = dynamic_cast<const DataFunctionTrampoline10*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline10 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename Data>
class DataMethodTrampoline10 : public Trampoline10 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, data); }
  ~DataMethodTrampoline10() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline10 *other = dynamic_cast<const DataMethodTrampoline10*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline10 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, class Emitter = void>
struct Slot10 : SlotBase {
  Slot10 (Trampoline10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> *trampoline) : SlotBase (trampoline) {}
  Trampoline10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>* get_trampoline() const
  { return trampoline_cast< Trampoline10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10> Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))
{
  return Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (new FunctionTrampoline10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename Data> Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Data), const Data &data)
{
  return Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (new DataFunctionTrampoline10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10> Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))
{
  return Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (new MethodTrampoline10<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename Data> Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Data), const Data &data)
{
  return Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (new DataMethodTrampoline10<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10> Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)> CustomSignal;
  return Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (new MethodTrampoline10<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> (sigref, &CustomSignal::emit));
}
# 110000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct Trampoline11 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
class FunctionTrampoline11 : public Trampoline11 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11); }
  ~FunctionTrampoline11() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline11 *other = dynamic_cast<const FunctionTrampoline11*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline11 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
class MethodTrampoline11 : public Trampoline11 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11); }
  ~MethodTrampoline11() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline11 *other = dynamic_cast<const MethodTrampoline11*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline11 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename Data>
class DataFunctionTrampoline11 : public Trampoline11 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, data); }
  ~DataFunctionTrampoline11() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline11 *other = dynamic_cast<const DataFunctionTrampoline11*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline11 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename Data>
class DataMethodTrampoline11 : public Trampoline11 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, data); }
  ~DataMethodTrampoline11() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline11 *other = dynamic_cast<const DataMethodTrampoline11*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline11 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, class Emitter = void>
struct Slot11 : SlotBase {
  Slot11 (Trampoline11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> *trampoline) : SlotBase (trampoline) {}
  Trampoline11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>* get_trampoline() const
  { return trampoline_cast< Trampoline11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11> Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))
{
  return Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (new FunctionTrampoline11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename Data> Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Data), const Data &data)
{
  return Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (new DataFunctionTrampoline11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11> Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))
{
  return Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (new MethodTrampoline11<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename Data> Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Data), const Data &data)
{
  return Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (new DataMethodTrampoline11<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11> Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)> CustomSignal;
  return Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (new MethodTrampoline11<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> (sigref, &CustomSignal::emit));
}
# 120000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct Trampoline12 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
class FunctionTrampoline12 : public Trampoline12 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12); }
  ~FunctionTrampoline12() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline12 *other = dynamic_cast<const FunctionTrampoline12*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline12 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
class MethodTrampoline12 : public Trampoline12 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12); }
  ~MethodTrampoline12() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline12 *other = dynamic_cast<const MethodTrampoline12*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline12 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename Data>
class DataFunctionTrampoline12 : public Trampoline12 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, data); }
  ~DataFunctionTrampoline12() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline12 *other = dynamic_cast<const DataFunctionTrampoline12*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline12 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename Data>
class DataMethodTrampoline12 : public Trampoline12 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, data); }
  ~DataMethodTrampoline12() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline12 *other = dynamic_cast<const DataMethodTrampoline12*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline12 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, class Emitter = void>
struct Slot12 : SlotBase {
  Slot12 (Trampoline12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> *trampoline) : SlotBase (trampoline) {}
  Trampoline12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>* get_trampoline() const
  { return trampoline_cast< Trampoline12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12> Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))
{
  return Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (new FunctionTrampoline12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename Data> Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Data), const Data &data)
{
  return Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (new DataFunctionTrampoline12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12> Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))
{
  return Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (new MethodTrampoline12<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename Data> Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Data), const Data &data)
{
  return Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (new DataMethodTrampoline12<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12> Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)> CustomSignal;
  return Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (new MethodTrampoline12<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> (sigref, &CustomSignal::emit));
}
# 130000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct Trampoline13 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
class FunctionTrampoline13 : public Trampoline13 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13); }
  ~FunctionTrampoline13() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline13 *other = dynamic_cast<const FunctionTrampoline13*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline13 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
class MethodTrampoline13 : public Trampoline13 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13); }
  ~MethodTrampoline13() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline13 *other = dynamic_cast<const MethodTrampoline13*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline13 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename Data>
class DataFunctionTrampoline13 : public Trampoline13 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, data); }
  ~DataFunctionTrampoline13() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline13 *other = dynamic_cast<const DataFunctionTrampoline13*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline13 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename Data>
class DataMethodTrampoline13 : public Trampoline13 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, data); }
  ~DataMethodTrampoline13() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline13 *other = dynamic_cast<const DataMethodTrampoline13*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline13 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, class Emitter = void>
struct Slot13 : SlotBase {
  Slot13 (Trampoline13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> *trampoline) : SlotBase (trampoline) {}
  Trampoline13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>* get_trampoline() const
  { return trampoline_cast< Trampoline13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13> Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))
{
  return Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (new FunctionTrampoline13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename Data> Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Data), const Data &data)
{
  return Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (new DataFunctionTrampoline13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13> Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))
{
  return Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (new MethodTrampoline13<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename Data> Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Data), const Data &data)
{
  return Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (new DataMethodTrampoline13<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13> Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)> CustomSignal;
  return Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (new MethodTrampoline13<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> (sigref, &CustomSignal::emit));
}
# 140000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct Trampoline14 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
class FunctionTrampoline14 : public Trampoline14 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14); }
  ~FunctionTrampoline14() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline14 *other = dynamic_cast<const FunctionTrampoline14*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline14 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
class MethodTrampoline14 : public Trampoline14 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14); }
  ~MethodTrampoline14() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline14 *other = dynamic_cast<const MethodTrampoline14*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline14 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename Data>
class DataFunctionTrampoline14 : public Trampoline14 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, data); }
  ~DataFunctionTrampoline14() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline14 *other = dynamic_cast<const DataFunctionTrampoline14*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline14 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename Data>
class DataMethodTrampoline14 : public Trampoline14 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, data); }
  ~DataMethodTrampoline14() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline14 *other = dynamic_cast<const DataMethodTrampoline14*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline14 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, class Emitter = void>
struct Slot14 : SlotBase {
  Slot14 (Trampoline14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> *trampoline) : SlotBase (trampoline) {}
  Trampoline14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>* get_trampoline() const
  { return trampoline_cast< Trampoline14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14> Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))
{
  return Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (new FunctionTrampoline14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename Data> Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Data), const Data &data)
{
  return Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (new DataFunctionTrampoline14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14> Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))
{
  return Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (new MethodTrampoline14<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename Data> Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Data), const Data &data)
{
  return Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (new DataMethodTrampoline14<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14> Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)> CustomSignal;
  return Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (new MethodTrampoline14<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> (sigref, &CustomSignal::emit));
}
# 150000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct Trampoline15 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
class FunctionTrampoline15 : public Trampoline15 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15); }
  ~FunctionTrampoline15() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline15 *other = dynamic_cast<const FunctionTrampoline15*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline15 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
class MethodTrampoline15 : public Trampoline15 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15); }
  ~MethodTrampoline15() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline15 *other = dynamic_cast<const MethodTrampoline15*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline15 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename Data>
class DataFunctionTrampoline15 : public Trampoline15 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, data); }
  ~DataFunctionTrampoline15() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline15 *other = dynamic_cast<const DataFunctionTrampoline15*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline15 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename Data>
class DataMethodTrampoline15 : public Trampoline15 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, data); }
  ~DataMethodTrampoline15() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline15 *other = dynamic_cast<const DataMethodTrampoline15*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline15 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, class Emitter = void>
struct Slot15 : SlotBase {
  Slot15 (Trampoline15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> *trampoline) : SlotBase (trampoline) {}
  Trampoline15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>* get_trampoline() const
  { return trampoline_cast< Trampoline15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15> Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))
{
  return Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (new FunctionTrampoline15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename Data> Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Data), const Data &data)
{
  return Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (new DataFunctionTrampoline15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15> Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))
{
  return Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (new MethodTrampoline15<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename Data> Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Data), const Data &data)
{
  return Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (new DataMethodTrampoline15<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15> Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)> CustomSignal;
  return Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (new MethodTrampoline15<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> (sigref, &CustomSignal::emit));
}
# 160000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct Trampoline16 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
class FunctionTrampoline16 : public Trampoline16 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16); }
  ~FunctionTrampoline16() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline16 *other = dynamic_cast<const FunctionTrampoline16*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline16 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
class MethodTrampoline16 : public Trampoline16 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16); }
  ~MethodTrampoline16() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline16 *other = dynamic_cast<const MethodTrampoline16*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline16 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename Data>
class DataFunctionTrampoline16 : public Trampoline16 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, data); }
  ~DataFunctionTrampoline16() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline16 *other = dynamic_cast<const DataFunctionTrampoline16*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline16 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename Data>
class DataMethodTrampoline16 : public Trampoline16 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, data); }
  ~DataMethodTrampoline16() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline16 *other = dynamic_cast<const DataMethodTrampoline16*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline16 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, class Emitter = void>
struct Slot16 : SlotBase {
  Slot16 (Trampoline16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> *trampoline) : SlotBase (trampoline) {}
  Trampoline16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>* get_trampoline() const
  { return trampoline_cast< Trampoline16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16> Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))
{
  return Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (new FunctionTrampoline16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename Data> Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Data), const Data &data)
{
  return Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (new DataFunctionTrampoline16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16> Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))
{
  return Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (new MethodTrampoline16<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename Data> Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Data), const Data &data)
{
  return Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (new DataMethodTrampoline16<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16> Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)> CustomSignal;
  return Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (new MethodTrampoline16<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> (sigref, &CustomSignal::emit));
}
# 170000 "./birnetsignalslot.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Trampoline (basis signature) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct Trampoline17 : public TrampolineLink {
  /* signature type for all signal trampolines, used for trampoline invocations by Emission */
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16, A17 a17) = 0;
};

/* --- Trampoline (plain) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
class FunctionTrampoline17 : public Trampoline17 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17);
  Callback callback;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16, A17 a17)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17); }
  ~FunctionTrampoline17() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const FunctionTrampoline17 *other = dynamic_cast<const FunctionTrampoline17*> (&bother);
    return other and other->callback == callback; }
public:
  FunctionTrampoline17 (Callback c) :
    callback (c)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
class MethodTrampoline17 : public Trampoline17 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17);
  Class *instance;
  Method method;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16, A17 a17)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17); }
  ~MethodTrampoline17() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const MethodTrampoline17 *other = dynamic_cast<const MethodTrampoline17*> (&bother);
    return other and other->instance == instance and other->method == method; }
public:
  MethodTrampoline17 (Class &obj, Method m) :
    instance (&obj), method (m)
  {}
};

/* --- Trampoline with Data --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename Data>
class DataFunctionTrampoline17 : public Trampoline17 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (*Callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Data);
  Callback callback; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16, A17 a17)
  { return callback (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, data); }
  ~DataFunctionTrampoline17() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataFunctionTrampoline17 *other = dynamic_cast<const DataFunctionTrampoline17*> (&bother);
    return other and other->callback == callback and other->data == data; }
public:
  DataFunctionTrampoline17 (Callback c, const Data &d) :
    callback (c), data (d)
  {}
};
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename Data>
class DataMethodTrampoline17 : public Trampoline17 <R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> {
  friend void FIXME_dummy_friend_for_gcc33();
  typedef R0 (Class::*Method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Data);
  Class *instance; Method method; Data data;
  virtual R0 operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16, A17 a17)
  { return (instance->*method) (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, data); }
  ~DataMethodTrampoline17() {}
  virtual bool operator== (const TrampolineLink &bother) const {
    const DataMethodTrampoline17 *other = dynamic_cast<const DataMethodTrampoline17*> (&bother);
    return other and other->instance == instance and other->method == method and other->data == data; }
public:
  DataMethodTrampoline17 (Class &obj, Method m, const Data &d) :
    instance (&obj), method (m), data (d)
  {}
};

/* --- Slots (Trampoline wrappers) --- */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, class Emitter = void>
struct Slot17 : SlotBase {
  Slot17 (Trampoline17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> *trampoline) : SlotBase (trampoline) {}
  Trampoline17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>* get_trampoline() const
  { return trampoline_cast< Trampoline17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>* > (get_trampoline_link()); }
};
/* slot constructors */
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17> Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17))
{
  return Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (new FunctionTrampoline17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (callback));
}
template<typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename Data> Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>
slot (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Data), const Data &data)
{
  return Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (new DataFunctionTrampoline17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Data> (callback, data));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17> Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17))
{
  return Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (new MethodTrampoline17<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (obj, method));
}
template<class Class, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename Data> Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>
slot (Class &obj, R0 (Class::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Data), const Data &data)
{
  return Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (new DataMethodTrampoline17<Class, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Data> (obj, method, data));
}
template<typename Obj, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17> Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>
slot (Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)> &sigref)
{
  typedef Signal<Obj, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)> CustomSignal;
  return Slot17<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (new MethodTrampoline17<CustomSignal, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> (sigref, &CustomSignal::emit));
}
# 0 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3>
struct Emission3 : public EmissionBase {
  typedef Trampoline3<R0, A1, A2, A3>           Trampoline;
  typedef Trampoline4<R0, Emitter&, A1, A2, A3> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3;
  TrampolineLink *m_last_link;
  Emission3 (Emitter *emitter, A1 a1, A2 a2, A3 a3) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3>
struct Emission3 <Emitter, void, A1, A2, A3> : public EmissionBase {
  typedef Trampoline3<void, A1, A2, A3>           Trampoline;
  typedef Trampoline4<void, Emitter&, A1, A2, A3> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3;
  Emission3 (Emitter *emitter, A1 a1, A2 a2, A3 a3) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3);
      }
  }
};

/* --- SignalEmittable3 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, class Collector>
struct SignalEmittable3 : SignalBase {
  typedef Emission3 <Emitter, R0, A1, A2, A3> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable3 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable3 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, class Collector>
struct SignalEmittable3 <Emitter, void, A1, A2, A3, Collector> : SignalBase {
  typedef Emission3 <Emitter, void, A1, A2, A3> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable3 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal3 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, class Collector = CollectorDefault<R0> >
struct Signal3 : SignalEmittable3<Emitter, R0, A1, A2, A3, Collector>
{
  typedef Emission3 <Emitter, R0, A1, A2, A3> Emission;
  typedef Slot3<R0, A1, A2, A3>               Slot;
  typedef Slot4<R0, Emitter&, A1, A2, A3>     SlotE;
  typedef SignalEmittable3<Emitter, R0, A1, A2, A3, Collector> SignalEmittable;
  explicit Signal3 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal3 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal3&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal3&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal3&    operator+= (R0 (*callback) (A1, A2, A3))            { connect (slot (callback)); return *this; }
  Signal3&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3))  { connect (slot (callback)); return *this; }
  Signal3&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal3&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal3&    operator-= (R0 (*callback) (A1, A2, A3))            { disconnect (slot (callback)); return *this; }
  Signal3&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal3);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3), Collector> : Signal3<Emitter, R0, A1, A2, A3, Collector>
{
  typedef Signal3<Emitter, R0, A1, A2, A3, Collector> Signal3;
  explicit Signal (Emitter &emitter) :
    Signal3 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3)) :
    Signal3 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 99000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0>
struct Emission0 : public EmissionBase {
  typedef Trampoline0<R0>           Trampoline;
  typedef Trampoline1<R0, Emitter&> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; 
  TrampolineLink *m_last_link;
  Emission0 (Emitter *emitter) :
    m_emitter (emitter), m_result(), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) ();
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter>
struct Emission0 <Emitter, void> : public EmissionBase {
  typedef Trampoline0<void>           Trampoline;
  typedef Trampoline1<void, Emitter&> TrampolineE;
  Emitter *m_emitter;
  
  Emission0 (Emitter *emitter) :
    m_emitter (emitter)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) ();
      }
  }
};

/* --- SignalEmittable0 --- */
template<class Emitter, typename R0, class Collector>
struct SignalEmittable0 : SignalBase {
  typedef Emission0 <Emitter, R0> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable0 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit ()
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable0 for void returns */
template<class Emitter, class Collector>
struct SignalEmittable0 <Emitter, void, Collector> : SignalBase {
  typedef Emission0 <Emitter, void> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable0 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit ()
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal0 --- */
/* Signal* */
template<class Emitter, typename R0, class Collector = CollectorDefault<R0> >
struct Signal0 : SignalEmittable0<Emitter, R0, Collector>
{
  typedef Emission0 <Emitter, R0> Emission;
  typedef Slot0<R0>               Slot;
  typedef Slot1<R0, Emitter&>     SlotE;
  typedef SignalEmittable0<Emitter, R0, Collector> SignalEmittable;
  explicit Signal0 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal0 (Emitter &emitter, R0 (Emitter::*method) ()) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal0&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal0&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal0&    operator+= (R0 (*callback) ())            { connect (slot (callback)); return *this; }
  Signal0&    operator+= (R0 (*callback) (Emitter&))  { connect (slot (callback)); return *this; }
  Signal0&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal0&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal0&    operator-= (R0 (*callback) ())            { disconnect (slot (callback)); return *this; }
  Signal0&    operator-= (R0 (*callback) (Emitter&))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal0);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, class Collector>
struct Signal<Emitter, R0 (), Collector> : Signal0<Emitter, R0, Collector>
{
  typedef Signal0<Emitter, R0, Collector> Signal0;
  explicit Signal (Emitter &emitter) :
    Signal0 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) ()) :
    Signal0 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 10000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1>
struct Emission1 : public EmissionBase {
  typedef Trampoline1<R0, A1>           Trampoline;
  typedef Trampoline2<R0, Emitter&, A1> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1;
  TrampolineLink *m_last_link;
  Emission1 (Emitter *emitter, A1 a1) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1>
struct Emission1 <Emitter, void, A1> : public EmissionBase {
  typedef Trampoline1<void, A1>           Trampoline;
  typedef Trampoline2<void, Emitter&, A1> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1;
  Emission1 (Emitter *emitter, A1 a1) :
    m_emitter (emitter), m_a1 (a1)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1);
      }
  }
};

/* --- SignalEmittable1 --- */
template<class Emitter, typename R0, typename A1, class Collector>
struct SignalEmittable1 : SignalBase {
  typedef Emission1 <Emitter, R0, A1> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable1 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable1 for void returns */
template<class Emitter, typename A1, class Collector>
struct SignalEmittable1 <Emitter, void, A1, Collector> : SignalBase {
  typedef Emission1 <Emitter, void, A1> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable1 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal1 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, class Collector = CollectorDefault<R0> >
struct Signal1 : SignalEmittable1<Emitter, R0, A1, Collector>
{
  typedef Emission1 <Emitter, R0, A1> Emission;
  typedef Slot1<R0, A1>               Slot;
  typedef Slot2<R0, Emitter&, A1>     SlotE;
  typedef SignalEmittable1<Emitter, R0, A1, Collector> SignalEmittable;
  explicit Signal1 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal1 (Emitter &emitter, R0 (Emitter::*method) (A1)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal1&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal1&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal1&    operator+= (R0 (*callback) (A1))            { connect (slot (callback)); return *this; }
  Signal1&    operator+= (R0 (*callback) (Emitter&, A1))  { connect (slot (callback)); return *this; }
  Signal1&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal1&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal1&    operator-= (R0 (*callback) (A1))            { disconnect (slot (callback)); return *this; }
  Signal1&    operator-= (R0 (*callback) (Emitter&, A1))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal1);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, class Collector>
struct Signal<Emitter, R0 (A1), Collector> : Signal1<Emitter, R0, A1, Collector>
{
  typedef Signal1<Emitter, R0, A1, Collector> Signal1;
  explicit Signal (Emitter &emitter) :
    Signal1 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1)) :
    Signal1 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 20000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2>
struct Emission2 : public EmissionBase {
  typedef Trampoline2<R0, A1, A2>           Trampoline;
  typedef Trampoline3<R0, Emitter&, A1, A2> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2;
  TrampolineLink *m_last_link;
  Emission2 (Emitter *emitter, A1 a1, A2 a2) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2>
struct Emission2 <Emitter, void, A1, A2> : public EmissionBase {
  typedef Trampoline2<void, A1, A2>           Trampoline;
  typedef Trampoline3<void, Emitter&, A1, A2> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2;
  Emission2 (Emitter *emitter, A1 a1, A2 a2) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2);
      }
  }
};

/* --- SignalEmittable2 --- */
template<class Emitter, typename R0, typename A1, typename A2, class Collector>
struct SignalEmittable2 : SignalBase {
  typedef Emission2 <Emitter, R0, A1, A2> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable2 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable2 for void returns */
template<class Emitter, typename A1, typename A2, class Collector>
struct SignalEmittable2 <Emitter, void, A1, A2, Collector> : SignalBase {
  typedef Emission2 <Emitter, void, A1, A2> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable2 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal2 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, class Collector = CollectorDefault<R0> >
struct Signal2 : SignalEmittable2<Emitter, R0, A1, A2, Collector>
{
  typedef Emission2 <Emitter, R0, A1, A2> Emission;
  typedef Slot2<R0, A1, A2>               Slot;
  typedef Slot3<R0, Emitter&, A1, A2>     SlotE;
  typedef SignalEmittable2<Emitter, R0, A1, A2, Collector> SignalEmittable;
  explicit Signal2 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal2 (Emitter &emitter, R0 (Emitter::*method) (A1, A2)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal2&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal2&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal2&    operator+= (R0 (*callback) (A1, A2))            { connect (slot (callback)); return *this; }
  Signal2&    operator+= (R0 (*callback) (Emitter&, A1, A2))  { connect (slot (callback)); return *this; }
  Signal2&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal2&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal2&    operator-= (R0 (*callback) (A1, A2))            { disconnect (slot (callback)); return *this; }
  Signal2&    operator-= (R0 (*callback) (Emitter&, A1, A2))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal2);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, class Collector>
struct Signal<Emitter, R0 (A1, A2), Collector> : Signal2<Emitter, R0, A1, A2, Collector>
{
  typedef Signal2<Emitter, R0, A1, A2, Collector> Signal2;
  explicit Signal (Emitter &emitter) :
    Signal2 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2)) :
    Signal2 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 40000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4>
struct Emission4 : public EmissionBase {
  typedef Trampoline4<R0, A1, A2, A3, A4>           Trampoline;
  typedef Trampoline5<R0, Emitter&, A1, A2, A3, A4> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4;
  TrampolineLink *m_last_link;
  Emission4 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4>
struct Emission4 <Emitter, void, A1, A2, A3, A4> : public EmissionBase {
  typedef Trampoline4<void, A1, A2, A3, A4>           Trampoline;
  typedef Trampoline5<void, Emitter&, A1, A2, A3, A4> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4;
  Emission4 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4);
      }
  }
};

/* --- SignalEmittable4 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, class Collector>
struct SignalEmittable4 : SignalBase {
  typedef Emission4 <Emitter, R0, A1, A2, A3, A4> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable4 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable4 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, class Collector>
struct SignalEmittable4 <Emitter, void, A1, A2, A3, A4, Collector> : SignalBase {
  typedef Emission4 <Emitter, void, A1, A2, A3, A4> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable4 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal4 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, class Collector = CollectorDefault<R0> >
struct Signal4 : SignalEmittable4<Emitter, R0, A1, A2, A3, A4, Collector>
{
  typedef Emission4 <Emitter, R0, A1, A2, A3, A4> Emission;
  typedef Slot4<R0, A1, A2, A3, A4>               Slot;
  typedef Slot5<R0, Emitter&, A1, A2, A3, A4>     SlotE;
  typedef SignalEmittable4<Emitter, R0, A1, A2, A3, A4, Collector> SignalEmittable;
  explicit Signal4 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal4 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal4&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal4&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal4&    operator+= (R0 (*callback) (A1, A2, A3, A4))            { connect (slot (callback)); return *this; }
  Signal4&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4))  { connect (slot (callback)); return *this; }
  Signal4&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal4&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal4&    operator-= (R0 (*callback) (A1, A2, A3, A4))            { disconnect (slot (callback)); return *this; }
  Signal4&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal4);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4), Collector> : Signal4<Emitter, R0, A1, A2, A3, A4, Collector>
{
  typedef Signal4<Emitter, R0, A1, A2, A3, A4, Collector> Signal4;
  explicit Signal (Emitter &emitter) :
    Signal4 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4)) :
    Signal4 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 50000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct Emission5 : public EmissionBase {
  typedef Trampoline5<R0, A1, A2, A3, A4, A5>           Trampoline;
  typedef Trampoline6<R0, Emitter&, A1, A2, A3, A4, A5> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5;
  TrampolineLink *m_last_link;
  Emission5 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5>
struct Emission5 <Emitter, void, A1, A2, A3, A4, A5> : public EmissionBase {
  typedef Trampoline5<void, A1, A2, A3, A4, A5>           Trampoline;
  typedef Trampoline6<void, Emitter&, A1, A2, A3, A4, A5> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5;
  Emission5 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5);
      }
  }
};

/* --- SignalEmittable5 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, class Collector>
struct SignalEmittable5 : SignalBase {
  typedef Emission5 <Emitter, R0, A1, A2, A3, A4, A5> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable5 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable5 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, class Collector>
struct SignalEmittable5 <Emitter, void, A1, A2, A3, A4, A5, Collector> : SignalBase {
  typedef Emission5 <Emitter, void, A1, A2, A3, A4, A5> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable5 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal5 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, class Collector = CollectorDefault<R0> >
struct Signal5 : SignalEmittable5<Emitter, R0, A1, A2, A3, A4, A5, Collector>
{
  typedef Emission5 <Emitter, R0, A1, A2, A3, A4, A5> Emission;
  typedef Slot5<R0, A1, A2, A3, A4, A5>               Slot;
  typedef Slot6<R0, Emitter&, A1, A2, A3, A4, A5>     SlotE;
  typedef SignalEmittable5<Emitter, R0, A1, A2, A3, A4, A5, Collector> SignalEmittable;
  explicit Signal5 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal5 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal5&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal5&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal5&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5))            { connect (slot (callback)); return *this; }
  Signal5&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5))  { connect (slot (callback)); return *this; }
  Signal5&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal5&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal5&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5))            { disconnect (slot (callback)); return *this; }
  Signal5&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal5);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5), Collector> : Signal5<Emitter, R0, A1, A2, A3, A4, A5, Collector>
{
  typedef Signal5<Emitter, R0, A1, A2, A3, A4, A5, Collector> Signal5;
  explicit Signal (Emitter &emitter) :
    Signal5 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5)) :
    Signal5 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 60000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct Emission6 : public EmissionBase {
  typedef Trampoline6<R0, A1, A2, A3, A4, A5, A6>           Trampoline;
  typedef Trampoline7<R0, Emitter&, A1, A2, A3, A4, A5, A6> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6;
  TrampolineLink *m_last_link;
  Emission6 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct Emission6 <Emitter, void, A1, A2, A3, A4, A5, A6> : public EmissionBase {
  typedef Trampoline6<void, A1, A2, A3, A4, A5, A6>           Trampoline;
  typedef Trampoline7<void, Emitter&, A1, A2, A3, A4, A5, A6> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6;
  Emission6 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6);
      }
  }
};

/* --- SignalEmittable6 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, class Collector>
struct SignalEmittable6 : SignalBase {
  typedef Emission6 <Emitter, R0, A1, A2, A3, A4, A5, A6> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable6 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable6 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, class Collector>
struct SignalEmittable6 <Emitter, void, A1, A2, A3, A4, A5, A6, Collector> : SignalBase {
  typedef Emission6 <Emitter, void, A1, A2, A3, A4, A5, A6> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable6 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal6 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, class Collector = CollectorDefault<R0> >
struct Signal6 : SignalEmittable6<Emitter, R0, A1, A2, A3, A4, A5, A6, Collector>
{
  typedef Emission6 <Emitter, R0, A1, A2, A3, A4, A5, A6> Emission;
  typedef Slot6<R0, A1, A2, A3, A4, A5, A6>               Slot;
  typedef Slot7<R0, Emitter&, A1, A2, A3, A4, A5, A6>     SlotE;
  typedef SignalEmittable6<Emitter, R0, A1, A2, A3, A4, A5, A6, Collector> SignalEmittable;
  explicit Signal6 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal6 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal6&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal6&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal6&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6))            { connect (slot (callback)); return *this; }
  Signal6&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6))  { connect (slot (callback)); return *this; }
  Signal6&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal6&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal6&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6))            { disconnect (slot (callback)); return *this; }
  Signal6&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal6);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6), Collector> : Signal6<Emitter, R0, A1, A2, A3, A4, A5, A6, Collector>
{
  typedef Signal6<Emitter, R0, A1, A2, A3, A4, A5, A6, Collector> Signal6;
  explicit Signal (Emitter &emitter) :
    Signal6 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6)) :
    Signal6 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 70000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct Emission7 : public EmissionBase {
  typedef Trampoline7<R0, A1, A2, A3, A4, A5, A6, A7>           Trampoline;
  typedef Trampoline8<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7;
  TrampolineLink *m_last_link;
  Emission7 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct Emission7 <Emitter, void, A1, A2, A3, A4, A5, A6, A7> : public EmissionBase {
  typedef Trampoline7<void, A1, A2, A3, A4, A5, A6, A7>           Trampoline;
  typedef Trampoline8<void, Emitter&, A1, A2, A3, A4, A5, A6, A7> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7;
  Emission7 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7);
      }
  }
};

/* --- SignalEmittable7 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, class Collector>
struct SignalEmittable7 : SignalBase {
  typedef Emission7 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable7 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable7 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, class Collector>
struct SignalEmittable7 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, Collector> : SignalBase {
  typedef Emission7 <Emitter, void, A1, A2, A3, A4, A5, A6, A7> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable7 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal7 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, class Collector = CollectorDefault<R0> >
struct Signal7 : SignalEmittable7<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, Collector>
{
  typedef Emission7 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7> Emission;
  typedef Slot7<R0, A1, A2, A3, A4, A5, A6, A7>               Slot;
  typedef Slot8<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7>     SlotE;
  typedef SignalEmittable7<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, Collector> SignalEmittable;
  explicit Signal7 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal7 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal7&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal7&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal7&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7))            { connect (slot (callback)); return *this; }
  Signal7&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7))  { connect (slot (callback)); return *this; }
  Signal7&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal7&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal7&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7))            { disconnect (slot (callback)); return *this; }
  Signal7&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal7);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7), Collector> : Signal7<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, Collector>
{
  typedef Signal7<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, Collector> Signal7;
  explicit Signal (Emitter &emitter) :
    Signal7 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7)) :
    Signal7 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 80000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct Emission8 : public EmissionBase {
  typedef Trampoline8<R0, A1, A2, A3, A4, A5, A6, A7, A8>           Trampoline;
  typedef Trampoline9<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8;
  TrampolineLink *m_last_link;
  Emission8 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct Emission8 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8> : public EmissionBase {
  typedef Trampoline8<void, A1, A2, A3, A4, A5, A6, A7, A8>           Trampoline;
  typedef Trampoline9<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8;
  Emission8 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8);
      }
  }
};

/* --- SignalEmittable8 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, class Collector>
struct SignalEmittable8 : SignalBase {
  typedef Emission8 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable8 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable8 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, class Collector>
struct SignalEmittable8 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, Collector> : SignalBase {
  typedef Emission8 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable8 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal8 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, class Collector = CollectorDefault<R0> >
struct Signal8 : SignalEmittable8<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, Collector>
{
  typedef Emission8 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8> Emission;
  typedef Slot8<R0, A1, A2, A3, A4, A5, A6, A7, A8>               Slot;
  typedef Slot9<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8>     SlotE;
  typedef SignalEmittable8<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, Collector> SignalEmittable;
  explicit Signal8 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal8 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal8&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal8&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal8&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8))            { connect (slot (callback)); return *this; }
  Signal8&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8))  { connect (slot (callback)); return *this; }
  Signal8&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal8&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal8&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8))            { disconnect (slot (callback)); return *this; }
  Signal8&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal8);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8), Collector> : Signal8<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, Collector>
{
  typedef Signal8<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, Collector> Signal8;
  explicit Signal (Emitter &emitter) :
    Signal8 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8)) :
    Signal8 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 90000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct Emission9 : public EmissionBase {
  typedef Trampoline9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>           Trampoline;
  typedef Trampoline10<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9;
  TrampolineLink *m_last_link;
  Emission9 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct Emission9 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9> : public EmissionBase {
  typedef Trampoline9<void, A1, A2, A3, A4, A5, A6, A7, A8, A9>           Trampoline;
  typedef Trampoline10<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9;
  Emission9 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9);
      }
  }
};

/* --- SignalEmittable9 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, class Collector>
struct SignalEmittable9 : SignalBase {
  typedef Emission9 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable9 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable9 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, class Collector>
struct SignalEmittable9 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, Collector> : SignalBase {
  typedef Emission9 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable9 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal9 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, class Collector = CollectorDefault<R0> >
struct Signal9 : SignalEmittable9<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, Collector>
{
  typedef Emission9 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9> Emission;
  typedef Slot9<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9>               Slot;
  typedef Slot10<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9>     SlotE;
  typedef SignalEmittable9<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, Collector> SignalEmittable;
  explicit Signal9 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal9 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal9&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal9&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal9&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9))            { connect (slot (callback)); return *this; }
  Signal9&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9))  { connect (slot (callback)); return *this; }
  Signal9&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal9&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal9&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9))            { disconnect (slot (callback)); return *this; }
  Signal9&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal9);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9), Collector> : Signal9<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, Collector>
{
  typedef Signal9<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, Collector> Signal9;
  explicit Signal (Emitter &emitter) :
    Signal9 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9)) :
    Signal9 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 100000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct Emission10 : public EmissionBase {
  typedef Trampoline10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>           Trampoline;
  typedef Trampoline11<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10;;
  TrampolineLink *m_last_link;
  Emission10 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct Emission10 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> : public EmissionBase {
  typedef Trampoline10<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>           Trampoline;
  typedef Trampoline11<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10;;
  Emission10 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10);
      }
  }
};

/* --- SignalEmittable10 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, class Collector>
struct SignalEmittable10 : SignalBase {
  typedef Emission10 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable10 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable10 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, class Collector>
struct SignalEmittable10 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Collector> : SignalBase {
  typedef Emission10 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable10 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal10 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, class Collector = CollectorDefault<R0> >
struct Signal10 : SignalEmittable10<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Collector>
{
  typedef Emission10 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> Emission;
  typedef Slot10<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>               Slot;
  typedef Slot11<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>     SlotE;
  typedef SignalEmittable10<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Collector> SignalEmittable;
  explicit Signal10 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal10 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal10&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal10&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal10&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))            { connect (slot (callback)); return *this; }
  Signal10&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))  { connect (slot (callback)); return *this; }
  Signal10&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal10&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal10&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))            { disconnect (slot (callback)); return *this; }
  Signal10&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal10);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10), Collector> : Signal10<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Collector>
{
  typedef Signal10<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Collector> Signal10;
  explicit Signal (Emitter &emitter) :
    Signal10 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)) :
    Signal10 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 110000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct Emission11 : public EmissionBase {
  typedef Trampoline11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>           Trampoline;
  typedef Trampoline12<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11;
  TrampolineLink *m_last_link;
  Emission11 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct Emission11 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> : public EmissionBase {
  typedef Trampoline11<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>           Trampoline;
  typedef Trampoline12<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11;
  Emission11 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11);
      }
  }
};

/* --- SignalEmittable11 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, class Collector>
struct SignalEmittable11 : SignalBase {
  typedef Emission11 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable11 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable11 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, class Collector>
struct SignalEmittable11 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Collector> : SignalBase {
  typedef Emission11 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable11 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal11 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, class Collector = CollectorDefault<R0> >
struct Signal11 : SignalEmittable11<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Collector>
{
  typedef Emission11 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> Emission;
  typedef Slot11<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>               Slot;
  typedef Slot12<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>     SlotE;
  typedef SignalEmittable11<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Collector> SignalEmittable;
  explicit Signal11 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal11 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal11&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal11&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal11&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))            { connect (slot (callback)); return *this; }
  Signal11&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))  { connect (slot (callback)); return *this; }
  Signal11&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal11&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal11&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))            { disconnect (slot (callback)); return *this; }
  Signal11&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal11);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11), Collector> : Signal11<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Collector>
{
  typedef Signal11<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Collector> Signal11;
  explicit Signal (Emitter &emitter) :
    Signal11 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)) :
    Signal11 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 120000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct Emission12 : public EmissionBase {
  typedef Trampoline12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>           Trampoline;
  typedef Trampoline13<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12;
  TrampolineLink *m_last_link;
  Emission12 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct Emission12 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> : public EmissionBase {
  typedef Trampoline12<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>           Trampoline;
  typedef Trampoline13<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12;
  Emission12 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12);
      }
  }
};

/* --- SignalEmittable12 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, class Collector>
struct SignalEmittable12 : SignalBase {
  typedef Emission12 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable12 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable12 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, class Collector>
struct SignalEmittable12 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Collector> : SignalBase {
  typedef Emission12 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable12 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal12 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, class Collector = CollectorDefault<R0> >
struct Signal12 : SignalEmittable12<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Collector>
{
  typedef Emission12 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> Emission;
  typedef Slot12<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>               Slot;
  typedef Slot13<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>     SlotE;
  typedef SignalEmittable12<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Collector> SignalEmittable;
  explicit Signal12 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal12 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal12&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal12&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal12&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))            { connect (slot (callback)); return *this; }
  Signal12&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))  { connect (slot (callback)); return *this; }
  Signal12&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal12&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal12&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))            { disconnect (slot (callback)); return *this; }
  Signal12&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal12);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12), Collector> : Signal12<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Collector>
{
  typedef Signal12<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Collector> Signal12;
  explicit Signal (Emitter &emitter) :
    Signal12 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)) :
    Signal12 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 130000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct Emission13 : public EmissionBase {
  typedef Trampoline13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>           Trampoline;
  typedef Trampoline14<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13;
  TrampolineLink *m_last_link;
  Emission13 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct Emission13 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> : public EmissionBase {
  typedef Trampoline13<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>           Trampoline;
  typedef Trampoline14<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13;
  Emission13 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13);
      }
  }
};

/* --- SignalEmittable13 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, class Collector>
struct SignalEmittable13 : SignalBase {
  typedef Emission13 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable13 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable13 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, class Collector>
struct SignalEmittable13 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Collector> : SignalBase {
  typedef Emission13 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable13 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal13 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, class Collector = CollectorDefault<R0> >
struct Signal13 : SignalEmittable13<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Collector>
{
  typedef Emission13 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> Emission;
  typedef Slot13<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>               Slot;
  typedef Slot14<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>     SlotE;
  typedef SignalEmittable13<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Collector> SignalEmittable;
  explicit Signal13 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal13 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal13&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal13&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal13&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))            { connect (slot (callback)); return *this; }
  Signal13&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))  { connect (slot (callback)); return *this; }
  Signal13&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal13&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal13&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))            { disconnect (slot (callback)); return *this; }
  Signal13&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal13);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13), Collector> : Signal13<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Collector>
{
  typedef Signal13<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Collector> Signal13;
  explicit Signal (Emitter &emitter) :
    Signal13 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)) :
    Signal13 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 140000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct Emission14 : public EmissionBase {
  typedef Trampoline14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>           Trampoline;
  typedef Trampoline15<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13; A14 m_a14;
  TrampolineLink *m_last_link;
  Emission14 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_a14 (a14), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct Emission14 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> : public EmissionBase {
  typedef Trampoline14<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>           Trampoline;
  typedef Trampoline15<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13; A14 m_a14;
  Emission14 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_a14 (a14)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14);
      }
  }
};

/* --- SignalEmittable14 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, class Collector>
struct SignalEmittable14 : SignalBase {
  typedef Emission14 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable14 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable14 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, class Collector>
struct SignalEmittable14 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Collector> : SignalBase {
  typedef Emission14 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable14 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal14 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, class Collector = CollectorDefault<R0> >
struct Signal14 : SignalEmittable14<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Collector>
{
  typedef Emission14 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> Emission;
  typedef Slot14<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>               Slot;
  typedef Slot15<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>     SlotE;
  typedef SignalEmittable14<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Collector> SignalEmittable;
  explicit Signal14 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal14 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal14&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal14&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal14&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))            { connect (slot (callback)); return *this; }
  Signal14&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))  { connect (slot (callback)); return *this; }
  Signal14&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal14&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal14&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))            { disconnect (slot (callback)); return *this; }
  Signal14&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal14);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14), Collector> : Signal14<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Collector>
{
  typedef Signal14<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Collector> Signal14;
  explicit Signal (Emitter &emitter) :
    Signal14 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)) :
    Signal14 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 150000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct Emission15 : public EmissionBase {
  typedef Trampoline15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>           Trampoline;
  typedef Trampoline16<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13; A14 m_a14; A15 m_a15;
  TrampolineLink *m_last_link;
  Emission15 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_a14 (a14), m_a15 (a15), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct Emission15 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> : public EmissionBase {
  typedef Trampoline15<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>           Trampoline;
  typedef Trampoline16<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13; A14 m_a14; A15 m_a15;
  Emission15 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_a14 (a14), m_a15 (a15)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15);
      }
  }
};

/* --- SignalEmittable15 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, class Collector>
struct SignalEmittable15 : SignalBase {
  typedef Emission15 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable15 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable15 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, class Collector>
struct SignalEmittable15 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Collector> : SignalBase {
  typedef Emission15 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable15 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal15 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, class Collector = CollectorDefault<R0> >
struct Signal15 : SignalEmittable15<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Collector>
{
  typedef Emission15 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> Emission;
  typedef Slot15<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>               Slot;
  typedef Slot16<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>     SlotE;
  typedef SignalEmittable15<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Collector> SignalEmittable;
  explicit Signal15 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal15 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal15&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal15&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal15&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))            { connect (slot (callback)); return *this; }
  Signal15&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))  { connect (slot (callback)); return *this; }
  Signal15&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal15&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal15&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))            { disconnect (slot (callback)); return *this; }
  Signal15&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal15);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15), Collector> : Signal15<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Collector>
{
  typedef Signal15<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Collector> Signal15;
  explicit Signal (Emitter &emitter) :
    Signal15 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)) :
    Signal15 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

# 160000 "./birnetsignaltemplate.hh"

/* BirnetSignal
 * Copyright (C) 2005 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this file is used to generate birnetsignalvariants.hh by mksignals.sh.
 * therein, certain phrases like "typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16" are
 * rewritten into 0, 1, 2, ... 16 argument variants. so make sure all phrases
 * involving the signal argument count match those from mksignals.sh.
 */

/* --- Emission --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct Emission16 : public EmissionBase {
  typedef Trampoline16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>           Trampoline;
  typedef Trampoline17<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> TrampolineE;
  Emitter *m_emitter;
  R0 m_result; A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13; A14 m_a14; A15 m_a15; A16 m_a16;
  TrampolineLink *m_last_link;
  Emission16 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16) :
    m_emitter (emitter), m_result(), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_a14 (a14), m_a15 (a15), m_a16 (a16), m_last_link (NULL)
  {}
  /* call Trampoline and store result, so trampoline templates need no <void> specialization */
  R0 call (TrampolineLink *link)
  {
    if (m_last_link != link)
      {
        if (link->with_emitter)
          {
            TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15, m_a16);
          }
        else
          {
            Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
            if (trampoline->callable)
              m_result = (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15, m_a16);
          }
        m_last_link = link;
      }
    return m_result;
  }
};
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct Emission16 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> : public EmissionBase {
  typedef Trampoline16<void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>           Trampoline;
  typedef Trampoline17<void, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> TrampolineE;
  Emitter *m_emitter;
  A1 m_a1; A2 m_a2; A3 m_a3; A4 m_a4; A5 m_a5; A6 m_a6; A7 m_a7; A8 m_a8; A9 m_a9; A10 m_a10; A11 m_a11; A12 m_a12; A13 m_a13; A14 m_a14; A15 m_a15; A16 m_a16;
  Emission16 (Emitter *emitter, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16) :
    m_emitter (emitter), m_a1 (a1), m_a2 (a2), m_a3 (a3), m_a4 (a4), m_a5 (a5), m_a6 (a6), m_a7 (a7), m_a8 (a8), m_a9 (a9), m_a10 (a10), m_a11 (a11), m_a12 (a12), m_a13 (a13), m_a14 (a14), m_a15 (a15), m_a16 (a16)
  {}
  /* call the trampoline and ignore result, so trampoline templates need no <void> specialization */
  void call (TrampolineLink *link)
  {
    if (link->with_emitter)
      {
        TrampolineE *trampoline = trampoline_cast<TrampolineE*> (link);
        if (trampoline->callable)
          (*trampoline) (*m_emitter, m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15, m_a16);
      }
    else
      {
        Trampoline *trampoline = trampoline_cast<Trampoline*> (link);
        if (trampoline->callable)
          (*trampoline) (m_a1, m_a2, m_a3, m_a4, m_a5, m_a6, m_a7, m_a8, m_a9, m_a10, m_a11, m_a12, m_a13, m_a14, m_a15, m_a16);
      }
  }
};

/* --- SignalEmittable16 --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, class Collector>
struct SignalEmittable16 : SignalBase {
  typedef Emission16 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> Emission;
  typedef typename Collector::result_type     Result;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    R0 operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable16 (Emitter *emitter) : m_emitter (emitter) {}
  inline Result emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    Result result = collector (it, last);
    return result;
  }
private:
  Emitter *m_emitter;
};
/* SignalEmittable16 for void returns */
template<class Emitter, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, class Collector>
struct SignalEmittable16 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Collector> : SignalBase {
  typedef Emission16 <Emitter, void, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> Emission;
  struct Iterator : public SignalBase::Iterator<Emission> {
    Iterator (Emission &emission, TrampolineLink *link) : SignalBase::Iterator<Emission> (emission, link) {}
    void operator* () { return this->emission.call (this->current); }
  };
  explicit SignalEmittable16 (Emitter *emitter) : m_emitter (emitter) {}
  inline void emit (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9, A10 a10, A11 a11, A12 a12, A13 a13, A14 a14, A15 a15, A16 a16)
  {
    ScopeReference<Emitter, Collector> lref (*m_emitter);
    Emission emission (m_emitter, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
    Iterator it (emission, &start), last (emission, &start);
    ++it; /* walk from start to first */
    Collector collector;
    collector (it, last);
  }
private:
  Emitter *m_emitter;
};

/* --- Signal16 --- */
/* Signal* */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, class Collector = CollectorDefault<R0> >
struct Signal16 : SignalEmittable16<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Collector>
{
  typedef Emission16 <Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> Emission;
  typedef Slot16<R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>               Slot;
  typedef Slot17<R0, Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>     SlotE;
  typedef SignalEmittable16<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Collector> SignalEmittable;
  explicit Signal16 (Emitter &emitter) :
    SignalEmittable (&emitter)
  { BIRNET_ASSERT (&emitter != NULL); }
  explicit Signal16 (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)) :
    SignalEmittable (&emitter)
  {
    BIRNET_ASSERT (&emitter != NULL);
    connect (slot (emitter, method));
  }
  inline void connect    (const Slot  &s) { connect_link (s.get_trampoline_link()); }
  inline void connect    (const SlotE &s) { connect_link (s.get_trampoline_link(), true); }
  inline uint disconnect (const Slot  &s) { return disconnect_equal_link (*s.get_trampoline_link()); }
  inline uint disconnect (const SlotE &s) { return disconnect_equal_link (*s.get_trampoline_link(), true); }
  Signal16&    operator+= (const Slot  &s) { connect (s); return *this; }
  Signal16&    operator+= (const SlotE &s) { connect (s); return *this; }
  Signal16&    operator+= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))            { connect (slot (callback)); return *this; }
  Signal16&    operator+= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))  { connect (slot (callback)); return *this; }
  Signal16&    operator-= (const Slot  &s) { disconnect (s); return *this; }
  Signal16&    operator-= (const SlotE &s) { disconnect (s); return *this; }
  Signal16&    operator-= (R0 (*callback) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))            { disconnect (slot (callback)); return *this; }
  Signal16&    operator-= (R0 (*callback) (Emitter&, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16))  { disconnect (slot (callback)); return *this; }
  BIRNET_PRIVATE_CLASS_COPY (Signal16);
};

/* --- Signal<> --- */
template<class Emitter, typename R0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, class Collector>
struct Signal<Emitter, R0 (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16), Collector> : Signal16<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Collector>
{
  typedef Signal16<Emitter, R0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Collector> Signal16;
  explicit Signal (Emitter &emitter) :
    Signal16 (emitter)
    {}
  explicit Signal (Emitter &emitter, R0 (Emitter::*method) (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)) :
    Signal16 (emitter, method)
    {}
  BIRNET_PRIVATE_CLASS_COPY (Signal);
};

