
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsejanitor.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsejanitor.h>
#include <bse/bseserver.h>
#include <string.h>


#line 26 "bsejanitor.proc"


/* --- trigger-action --- */
static void
trigger_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsejanitor.proc"
 {
#line 30 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 35 "bsejanitor.proc"
 }
static BseErrorType
#line 35 "bsejanitor.proc"
trigger_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 38 "bsejanitor.proc"
{
#line 39 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 43 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 47 "bsejanitor.proc"
  
  bse_janitor_trigger_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- get-script-name --- */
static void
get_script_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 53 "bsejanitor.proc"
 {
#line 55 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)    = sfi_pspec_string ("script_name", "Script Name", NULL,
			     NULL, SFI_PARAM_STANDARD);
}
#line 60 "bsejanitor.proc"
 }
static BseErrorType
#line 60 "bsejanitor.proc"
get_script_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 63 "bsejanitor.proc"
{
#line 64 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 67 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 71 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->script_name);
  
  return BSE_ERROR_NONE;
}

/* --- get-proc-name --- */
static void
get_proc_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 77 "bsejanitor.proc"
 {
#line 79 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)    = sfi_pspec_string ("proc_name", "Proc Name", NULL,
			     NULL, SFI_PARAM_STANDARD);
}
#line 84 "bsejanitor.proc"
 }
static BseErrorType
#line 84 "bsejanitor.proc"
get_proc_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 87 "bsejanitor.proc"
{
#line 88 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 91 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 95 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->proc_name);
  
  return BSE_ERROR_NONE;
}

/* --- n-actions --- */
static void
n_actions_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 101 "bsejanitor.proc"
 {
#line 103 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_actions", "N Actions", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 108 "bsejanitor.proc"
 }
static BseErrorType
#line 108 "bsejanitor.proc"
n_actions_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 111 "bsejanitor.proc"
{
#line 112 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 115 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 119 "bsejanitor.proc"
  
  sfi_value_set_int (out_values++, g_slist_length (self->actions));
  
  return BSE_ERROR_NONE;
}

/* --- get-action --- */
static void
get_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 125 "bsejanitor.proc"
 {
#line 127 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 134 "bsejanitor.proc"
 }
static BseErrorType
#line 134 "bsejanitor.proc"
get_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 137 "bsejanitor.proc"
{
#line 138 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 143 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 149 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? g_quark_to_string (a->action) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-name --- */
static void
get_action_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 155 "bsejanitor.proc"
 {
#line 157 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action-name", "Action Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 164 "bsejanitor.proc"
 }
static BseErrorType
#line 164 "bsejanitor.proc"
get_action_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 167 "bsejanitor.proc"
{
#line 168 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 173 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 179 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->name : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-blurb --- */
static void
get_action_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 185 "bsejanitor.proc"
 {
#line 187 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action-blurb", "Action Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 194 "bsejanitor.proc"
 }
static BseErrorType
#line 194 "bsejanitor.proc"
get_action_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 197 "bsejanitor.proc"
{
#line 198 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 203 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 209 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->blurb : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- kill --- */
static void
kill_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 215 "bsejanitor.proc"
 {
#line 217 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
}
#line 220 "bsejanitor.proc"
 }
static BseErrorType
#line 220 "bsejanitor.proc"
kill_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 223 "bsejanitor.proc"
{
#line 224 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 227 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 231 "bsejanitor.proc"
  
  bse_janitor_kill (self);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-janitor --- */
static void
bse_script_janitor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 237 "bsejanitor.proc"
 {
#line 239 "bsejanitor.proc"
  *(out_pspecs++)   = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
}
#line 242 "bsejanitor.proc"
 }
static BseErrorType
#line 242 "bsejanitor.proc"
bse_script_janitor_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 245 "bsejanitor.proc"
{
  BseJanitor *self = bse_janitor_get_current ();
  
#line 248 "bsejanitor.proc"
  
  if (!self || !self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;

#line 252 "bsejanitor.proc"
  
  bse_value_set_object (out_values++, self);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-add-action --- */
static void
bse_script_add_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 258 "bsejanitor.proc"
 {
#line 260 "bsejanitor.proc"
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("blurb", "Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 267 "bsejanitor.proc"
 }
static BseErrorType
#line 267 "bsejanitor.proc"
bse_script_add_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 270 "bsejanitor.proc"
{
#line 271 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_janitor_get_current ();
  const gchar *action = sfi_value_get_string (in_values++);
  const gchar *name   = sfi_value_get_string (in_values++);
  const gchar *blurb  = sfi_value_get_string (in_values++);
  
#line 277 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 281 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 285 "bsejanitor.proc"
  
  bse_janitor_add_action (self, action, name, blurb);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-remove-action --- */
static void
bse_script_remove_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 291 "bsejanitor.proc"
 {
#line 293 "bsejanitor.proc"
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 296 "bsejanitor.proc"
 }
static BseErrorType
#line 296 "bsejanitor.proc"
bse_script_remove_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 299 "bsejanitor.proc"
{
#line 300 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_janitor_get_current ();
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 304 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 308 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 312 "bsejanitor.proc"
  
  bse_janitor_remove_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-set-status --- */
static void
bse_script_set_status_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 318 "bsejanitor.proc"
 {
#line 320 "bsejanitor.proc"
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_STANDARD);
#line 322 "bsejanitor.proc"
}  }
static BseErrorType
#line 322 "bsejanitor.proc"
bse_script_set_status_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 325 "bsejanitor.proc"
{
#line 326 "bsejanitor.proc"
  
  BseJanitor    *self    = bse_janitor_get_current ();
  const gchar   *message = sfi_value_get_string (in_values++);
  
#line 330 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 334 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  if (!message)
    message = "";
  
#line 340 "bsejanitor.proc"
  
  bse_item_set (self, "status-message", message, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-progress --- */
static void
bse_script_progress_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 346 "bsejanitor.proc"
 {
#line 348 "bsejanitor.proc"
  *(in_pspecs++)    = sfi_pspec_real ("progress", "Progress", NULL,
			  -1, -1, 1.0, 0.1,
			  SFI_PARAM_STANDARD);
#line 351 "bsejanitor.proc"
}  }
static BseErrorType
#line 351 "bsejanitor.proc"
bse_script_progress_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 354 "bsejanitor.proc"
{
#line 355 "bsejanitor.proc"
  
  BseJanitor *self = bse_janitor_get_current ();
  gfloat progress  = sfi_value_get_real (in_values++);
  
#line 359 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 363 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 367 "bsejanitor.proc"
  
  bse_janitor_progress (self, progress);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-send-message --- */
static void
bse_script_send_message_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 373 "bsejanitor.proc"
 {
#line 375 "bsejanitor.proc"
  
  *(in_pspecs++)    = sfi_pspec_string ("domain", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("msg-type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("title", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("primary", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("secondary", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("details", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("config-check", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 383 "bsejanitor.proc"
}  }
static BseErrorType
#line 383 "bsejanitor.proc"
bse_script_send_message_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 386 "bsejanitor.proc"
{
#line 387 "bsejanitor.proc"
  
  BseJanitor *janitor = bse_janitor_get_current();
  const gchar *domain = sfi_value_get_string (in_values++);
  const gchar *mtype  = sfi_value_get_string (in_values++);
  const gchar *text0  = sfi_value_get_string (in_values++);
  const gchar *text1  = sfi_value_get_string (in_values++);
  const gchar *text2  = sfi_value_get_string (in_values++);
  const gchar *text3  = sfi_value_get_string (in_values++);
  const gchar *check  = sfi_value_get_string (in_values++);
  SfiMsgType    type  = mtype ? sfi_msg_lookup_type (mtype) : 0;

#line 398 "bsejanitor.proc"
  
  if (!mtype || !(text1 || text2))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 402 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (janitor) || !janitor->port || janitor->port_closed)
    return BSE_ERROR_PROC_EXECUTION;

#line 406 "bsejanitor.proc"
  
  bse_server_message (bse_server_get (), domain, type, text0, text1, text2, text3, check, janitor, NULL, janitor->port->remote_pid);

  return BSE_ERROR_NONE;
}

/* --- bse-script-quit --- */
static void
bse_script_quit_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 412 "bsejanitor.proc"
 {
#line 414 "bsejanitor.proc"
}  }
static BseErrorType
#line 414 "bsejanitor.proc"
bse_script_quit_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 417 "bsejanitor.proc"
{
#line 418 "bsejanitor.proc"
  
  BseJanitor *janitor = bse_janitor_get_current();

#line 421 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (janitor) || !janitor->port || janitor->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 425 "bsejanitor.proc"
  
  janitor->force_normal_exit = TRUE;
  bse_janitor_close (janitor);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_trigger_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Trigger an installed user action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 29;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_trigger_action = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseJanitor+trigger-action", 
    NULL,
    "/Methods/BseJanitor/General/Trigger Action",
    NULL,
    __enode_trigger_action__fill_strings,
  },
  0, trigger_action_setup, trigger_action_exec, 
};
static void
__enode_get_script_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the script name of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 54;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_script_name = {
  { (BseExportNode*) &__enode_trigger_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-script-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Script Name",
    NULL,
    __enode_get_script_name__fill_strings,
  },
  0, get_script_name_setup, get_script_name_exec, 
};
static void
__enode_get_proc_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the procedure name of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 78;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_proc_name = {
  { (BseExportNode*) &__enode_get_script_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-proc-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Proc Name",
    NULL,
    __enode_get_proc_name__fill_strings,
  },
  0, get_proc_name_setup, get_proc_name_exec, 
};
static void
__enode_n_actions__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve number of user actions of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 102;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_actions = {
  { (BseExportNode*) &__enode_get_proc_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+n-actions", 
    NULL,
    "/Methods/BseJanitor/General/N Actions",
    NULL,
    __enode_n_actions__fill_strings,
  },
  0, n_actions_setup, n_actions_exec, 
};
static void
__enode_get_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 126;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_action = {
  { (BseExportNode*) &__enode_n_actions, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action", 
    NULL,
    "/Methods/BseJanitor/General/Get Action",
    NULL,
    __enode_get_action__fill_strings,
  },
  0, get_action_setup, get_action_exec, 
};
static void
__enode_get_action_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the name of an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 156;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_action_name = {
  { (BseExportNode*) &__enode_get_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Action Name",
    NULL,
    __enode_get_action_name__fill_strings,
  },
  0, get_action_name_setup, get_action_name_exec, 
};
static void
__enode_get_action_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the help string of an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 186;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_action_blurb = {
  { (BseExportNode*) &__enode_get_action_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-blurb", 
    NULL,
    "/Methods/BseJanitor/General/Get Action Blurb",
    NULL,
    __enode_get_action_blurb__fill_strings,
  },
  0, get_action_blurb_setup, get_action_blurb_exec, 
};
static void
__enode_kill__fill_strings (BseExportStrings *es)
{
  es->blurb = "Kill a currently running janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 216;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_kill = {
  { (BseExportNode*) &__enode_get_action_blurb, BSE_EXPORT_NODE_PROC,
    "BseJanitor+kill", 
    NULL,
    "/Methods/BseJanitor/General/Kill",
    NULL,
    __enode_kill__fill_strings,
  },
  0, kill_setup, kill_exec, 
};
static void
__enode_bse_script_janitor__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the connection dependant janitor object.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 238;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_janitor = {
  { (BseExportNode*) &__enode_kill, BSE_EXPORT_NODE_PROC,
    "bse-script-janitor", 
    NULL,
    "/Proc/Script/Get Janitor",
    NULL,
    __enode_bse_script_janitor__fill_strings,
  },
  0, bse_script_janitor_setup, bse_script_janitor_exec, 
};
static void
__enode_bse_script_add_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Install a user action for script control.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 259;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_add_action = {
  { (BseExportNode*) &__enode_bse_script_janitor, BSE_EXPORT_NODE_PROC,
    "bse-script-add-action", 
    NULL,
    "/Proc/Script/Add Action",
    NULL,
    __enode_bse_script_add_action__fill_strings,
  },
  0, bse_script_add_action_setup, bse_script_add_action_exec, 
};
static void
__enode_bse_script_remove_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a previously installed user action from script control.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 292;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_remove_action = {
  { (BseExportNode*) &__enode_bse_script_add_action, BSE_EXPORT_NODE_PROC,
    "bse-script-remove-action", 
    NULL,
    "/Proc/Script/Remove Action",
    NULL,
    __enode_bse_script_remove_action__fill_strings,
  },
  0, bse_script_remove_action_setup, bse_script_remove_action_exec, 
};
static void
__enode_bse_script_set_status__fill_strings (BseExportStrings *es)
{
  es->blurb = "Alter script status message.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 319;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_set_status = {
  { (BseExportNode*) &__enode_bse_script_remove_action, BSE_EXPORT_NODE_PROC,
    "bse-script-set-status", 
    NULL,
    "/Proc/Script/Set Status",
    NULL,
    __enode_bse_script_set_status__fill_strings,
  },
  0, bse_script_set_status_setup, bse_script_set_status_exec, 
};
static void
__enode_bse_script_progress__fill_strings (BseExportStrings *es)
{
  es->blurb = "Indicate progress (from 0.0 to 1.0 or -1 for unknown amount).";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 347;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_progress = {
  { (BseExportNode*) &__enode_bse_script_set_status, BSE_EXPORT_NODE_PROC,
    "bse-script-progress", 
    NULL,
    "/Proc/Script/Progress",
    NULL,
    __enode_bse_script_progress__fill_strings,
  },
  0, bse_script_progress_setup, bse_script_progress_exec, 
};
static void
__enode_bse_script_send_message__fill_strings (BseExportStrings *es)
{
  es->blurb = "Send a message from a script.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 374;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_send_message = {
  { (BseExportNode*) &__enode_bse_script_progress, BSE_EXPORT_NODE_PROC,
    "bse-script-send-message", 
    NULL,
    "/Proc/Script/Message",
    NULL,
    __enode_bse_script_send_message__fill_strings,
  },
  0, bse_script_send_message_setup, bse_script_send_message_exec, 
};
static void
__enode_bse_script_quit__fill_strings (BseExportStrings *es)
{
  es->blurb = "Exit a script succesfully (server side).";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 413;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_quit = {
  { (BseExportNode*) &__enode_bse_script_send_message, BSE_EXPORT_NODE_PROC,
    "bse-script-quit", 
    NULL,
    "/Proc/Script/Quit",
    NULL,
    __enode_bse_script_quit__fill_strings,
  },
  0, bse_script_quit_setup, bse_script_quit_exec, 
};
BseExportNode* bse__builtin_init_bsejanitor_genprc_c (void);
BseExportNode* bse__builtin_init_bsejanitor_genprc_c (void)
{
  return (BseExportNode*) &__enode_bse_script_quit;
}

/*
 * Generated data ends here
 */
