/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License aint with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ARTS_CSL_ADAPTER_H__
#define __ARTS_CSL_ADAPTER_H__


#include "artsmcopmarshal.h"
#include "artsmcopdispatcher.h"
#include "cslpcm.h"	/* for CslPcmFormatType */

/* types */
typedef struct _ArtsCslAdapter ArtsCslAdapter;
typedef enum
{
  ARTS_CSL_ADAPTER_DIR_INPUT,
  ARTS_CSL_ADAPTER_DIR_OUTPUT
} ArtsCslAdapterDirection;

typedef struct
{
  int rate;
  int channels;
  CslPcmFormatType format;
} ArtsCslAdapterStreamParams;

typedef struct
{
  int streamID;

  ArtsCslAdapterStreamParams streamParams;
  int streamBufferUsed;		/* used bytes of the stream buffer */
  int streamBufferSize;		/* size of the stream buffer */

  ArtsCslAdapterStreamParams artsParams;
  int artsBufferUsed;		/* used bytes in server <-> hardware buffer */
  int artsBufferSize;		/* size of the server <-> hardware buffer */
} ArtsCslAdapterStreamStatus;


ArtsCslAdapter*	    _arts_csl_adapter_from_reference	   (ArtsMcopDispatcher *dispatcher,
							    ArtsMcopObjectReference *reference,
							    CslBool need_copy);
int		    _arts_csl_adapter_open		   (ArtsCslAdapter *adapter,
							    const char *role,
							    ArtsCslAdapterDirection dir);
CslBool		    _arts_csl_adapter_set_params	   (ArtsCslAdapter *adapter,
							    int streamID, 
							    ArtsCslAdapterStreamParams *params);
void		    _arts_csl_adapter_set_title		   (ArtsCslAdapter *adapter,
							    int             streamID,
							    const char     *title);
void		    _arts_csl_adapter_close		   (ArtsCslAdapter *adapter,
							    int streamID);
void		    _arts_csl_adapter_write		   (ArtsCslAdapter *adapter,
							    int streamID,
							    unsigned char *bytes,
							    unsigned int n_bytes);
unsigned int	    _arts_csl_adapter_read		   (ArtsCslAdapter *adapter,
							    int streamID,
							    unsigned int n_bytes,
							    unsigned char *bytes);
void		    _arts_csl_adapter_activate	   (ArtsCslAdapter *adapter,
							    int streamID);
int		    _arts_csl_adapter_wait_buffer_level (ArtsCslAdapter *adapter,
							    int streamID,
							    int bufferUsed);

#if 0 /* TODO */				
	/**
	 * Reads bytes from a stream
	 */
	sequence<byte> read(int streamID, int len);

	/**
	 * Suspends a stream (i.e. stops playing/recording data on it)
	 */
	void suspend(int streamID);

	/**
	 * Checks whether a stream is active
	 */
	boolean active(int streamID);

	/**
	 * Obtains the status for a stream
	 */
	StreamStatus status(int streamID);

/* OSS: sndctl_dsp_...
	- post:  tell driver that it is likely, that a pause in the output stream
	         is going to occur now

	- reset: reset stream, will discard any buffered bytes and reset the stream
	         to a state where it can accept new parameters

	- sync:  wait until the last byte of the stream has been played to the
	         device (is called implicitely on close)

mapped to:
	- post   => nothing (does this really make sense for us)?

	- reset  => clearBuffer(streamID);
				suspend(streamID);
	
	- sync  =>  waitPlayed(streamID);
*/

	/**
	 * clears all contents of the stream buffer
	 *
	 * note: for dOutput streams, you can't expect that silence will occur
	 *       immediately after the call of clearBuffer, as there might be
	 *       bytes already in the arts server buffer, which can't be unmixed
	 *       for dInput stream, similar thoughts are valid
	 */
	void clearBuffer(int streamID);


	/**
	 * waits until the last byte written to the stream has reached the speaker
	 *
	 * this is not equivalent to waitBufferLevel(streamID, 0), as the former
	 * only waits until the stream specific buffer is 0, but not until the
	 * data has propagated through the aRts buffer and really reached the
	 * speaker
	 *
	 * note: only works on dOutput streams
	 */
	void waitPlayed(int streamID);

	/**
	 * gets maps for a channel
	 * 
	 * <pre>
	 * #define CSL_PCM_CHANNEL_FRONT_LEFT	"<front-left>" (no const in mcopidl)
	 * #define CSL_PCM_CHANNEL_FRONT_RIGHT	"<front-right>"
	 * #define CSL_PCM_CHANNEL_CENTER		"<center>"
	 * #define CSL_PCM_CHANNEL_REAR_LEFT	"<rear-left>"
	 * #define CSL_PCM_CHANNEL_REAR_RIGHT	"<rear-right>"
	 * #define CSL_PCM_CHANNEL_SUB_WOOFER	"<sub-woofer>"
	 * </pre>
	 */
	sequence<string> channelMaps(int streamID);

	/**
	 * sets mapping for one channel
	 */
	boolean setChannelMapping(int streamID, int channel, string mapping);

	/**
	 * gets mapping for one channel
	 */
	string getChannelMapping(int streamID, int channel);
};

#endif

#endif /* __ARTS_CSL_ADAPTER_H__ */
