/* CSL - Common Sound Layer
 * Copyright (C) 2001 Jeff Tranter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* 
 * This small example illustrates how to find out which CSL back end
 * drivers are available.
 */

#include <stdio.h>
#include <csl/csl.h>

int main()
{
	int i, n;
	const char **drivers;

	drivers = csl_list_drivers(&n);

	printf("%d available CSL drivers:\n", n);
	for (i=0; i <n; i++)
	{
		printf("    %s\n", drivers[i]);
	}
	return 0;
}
