
/* !!!! AUTOGENERATED FILE generated by porter-duff.rb !!!!! 
 *
 *  Copyright 2006 Øyvind Kolås <pippin@gimp.org>
 *
 * !!!! AUTOGENERATED FILE !!!!!
 *
 */
#if GEGL_CHANT_PROPERTIES
/* no properties */
#else

#define GEGL_CHANT_POINT_COMPOSER
#define GEGL_CHANT_NAME          out_reverse
#define GEGL_CHANT_DESCRIPTION   "Porter Duff operation out_reverse (c = cB * (1.0 - aA))"
#define GEGL_CHANT_CATEGORIES    "compositors:porter duff"
#define GEGL_CHANT_SELF          "out_reverse.c"
#define GEGL_CHANT_INIT
#include "gegl-chant.h"

static void init (GeglChantOperation *self)
{
  GEGL_OPERATION_POINT_COMPOSER (self)->format = babl_format ("RaGaBaA float");
  GEGL_OPERATION_POINT_COMPOSER (self)->aux_format = babl_format ("RaGaBaA float");

}

static gboolean
process (GeglOperation *op,
          void          *in_buf,
          void          *aux_buf,
          void          *out_buf,
          glong          n_pixels)
{
  gint i;
  gfloat *in = in_buf;
  gfloat *aux = aux_buf;
  gfloat *out = out_buf;

  if (aux==NULL)
    return TRUE;

  for (i=0; i<n_pixels; i++)
    {
      int  j;
      gfloat aA, aB;

      aB=in[3];
      aA=aux[3];
      for (j=0; j<4; j++)
          {
              gfloat cA, cB;

              cB=in[j];
              cA=aux[j];
              out[j] = cB * (1.0 - aA);
          }
      in  += 4;
      aux += 4;
      out += 4;
    }
  return TRUE;
}

#endif
