static const char* pixelize_cl_source =
"__kernel void calc_block_color(__global float4 *in,                           \n"
"                             __global float4 *out,                            \n"
"                             int xsize,                                       \n"
"                             int ysize,                                       \n"
"                             int roi_x,                                       \n"
"                             int roi_y,                                       \n"
"                             int line_width,                                  \n"
"                             int block_count_x )                              \n"
"{                                                                             \n"
"    int gidx = get_global_id(0);                                              \n"
"    int gidy = get_global_id(1);                                              \n"
"    int cx = roi_x / xsize + gidx;                                            \n"
"    int cy = roi_y / ysize + gidy;                                            \n"
"                                                                              \n"
"    float weight   = 1.0f / (xsize * ysize);                                  \n"
"                                                                              \n"
"    int px = cx * xsize + xsize - roi_x;                                      \n"
"    int py = cy * ysize + ysize - roi_y;                                      \n"
"                                                                              \n"
"    int i,j;                                                                  \n"
"    float4 col = 0.0f;                                                        \n"
"    for (j = py;j < py + ysize; ++j)                                          \n"
"    {                                                                         \n"
"        for (i = px;i < px + xsize; ++i)                                      \n"
"        {                                                                     \n"
"            col += in[j * line_width + i];                                    \n"
"        }                                                                     \n"
"    }                                                                         \n"
"    out[gidy * block_count_x + gidx] = col * weight;                          \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"__kernel void kernel_pixelise (__global float4 *in,                           \n"
"                             __global float4 *out,                            \n"
"                             int xsize,                                       \n"
"                             int ysize,                                       \n"
"                             int roi_x,                                       \n"
"                             int roi_y,                                       \n"
"                             int block_count_x)                               \n"
"{                                                                             \n"
"    int gidx = get_global_id(0);                                              \n"
"    int gidy = get_global_id(1);                                              \n"
"                                                                              \n"
"    int src_width  = get_global_size(0);                                      \n"
"    int cx = (gidx + roi_x) / xsize - roi_x / xsize;                          \n"
"    int cy = (gidy + roi_y) / ysize - roi_y / ysize;                          \n"
"    out[gidx + gidy * src_width] = in[cx + cy * block_count_x];               \n"
"}                                                                             \n"
;
