static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Eric L. Hernes (erich@rrnet.com)                            \n"
" * Copyright 2011 Robert Sasu (sasu.robert@gmail.com)                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_emboss_type)                                                 \n"
"  enum_value (GEGL_EMBOSS_TYPE_EMBOSS,  \"emboss\",  N_(\"Emboss\"))          \n"
"  enum_value (GEGL_EMBOSS_TYPE_BUMPMAP, \"bumpmap\", N_(\"Bumpmap (preserve original colors)\"))\n"
"enum_end (GeglEmbossType)                                                     \n"
"                                                                              \n"
"property_enum (type, _(\"Emboss Type\"),                                      \n"
"               GeglEmbossType, gegl_emboss_type, GEGL_EMBOSS_TYPE_EMBOSS)     \n"
"    description(_(\"Rendering type\"))                                        \n"
"                                                                              \n"
"property_double (azimuth, _(\"Azimuth\"), 30.0)                               \n"
"    description (_(\"Light angle (degrees)\"))                                \n"
"    value_range (0, 360)                                                      \n"
"    ui_meta (\"unit\", \"degree\")                                            \n"
"                                                                              \n"
"property_double (elevation, _(\"Elevation\"), 45.0)                           \n"
"    description (_(\"Elevation angle (degrees)\"))                            \n"
"    value_range (0, 180)                                                      \n"
"    ui_meta (\"unit\", \"degree\")                                            \n"
"                                                                              \n"
"property_int (depth, _(\"Depth\"), 20)                                        \n"
"    description (_(\"Filter width\"))                                         \n"
"    value_range (1, 100)                                                      \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     emboss                                               \n"
"#define GEGL_OP_C_SOURCE emboss.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"#define DEG_TO_RAD(d) (((d) * G_PI) / 180.0)                                  \n"
"                                                                              \n"
"/*                                                                            \n"
" * ANSI C code from the article                                               \n"
" * \"Fast Embossing Effects on Raster Image Data\"                            \n"
" * by John Schlag, jfs@kerner.com                                             \n"
" * in \"Graphics Gems IV\", Academic Press, 1994                              \n"
" *                                                                            \n"
" * Emboss - shade 24-bit pixels using a single distant light source.          \n"
" * Normals are obtained by differentiating a monochrome 'bump' image.         \n"
" * The unary case ('texture' == NULL) uses the shading result as output.      \n"
" * The binary case multiples the optional 'texture' image by the shade.       \n"
" * Images are in row major order with interleaved color components            \n"
" * (rgbrgb...).  E.g., component c of pixel x,y of 'dst' is                   \n"
" * dst[3*(y*width + x) + c].                                                  \n"
" */                                                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"emboss (gfloat              *src_buf,                                         \n"
"        const GeglRectangle *src_rect,                                        \n"
"        gfloat              *dst_buf,                                         \n"
"        const GeglRectangle *dst_rect,                                        \n"
"        GeglEmbossType       type,                                            \n"
"        gint                 y,                                               \n"
"        gint                 floats_per_pixel,                                \n"
"        gdouble              azimuth,                                         \n"
"        gdouble              elevation,                                       \n"
"        gint                 width45)                                         \n"
"{                                                                             \n"
"  gint x;                                                                     \n"
"  gint offset, verify;                                                        \n"
"  gint bytes;                                                                 \n"
"                                                                              \n"
"  gdouble Lx, Ly, Lz;                                                         \n"
"  gdouble Nz, Nz2, NzLz;                                                      \n"
"                                                                              \n"
"  Lx = cos (azimuth) * cos (elevation);                                       \n"
"  Ly = sin (azimuth) * cos (elevation);                                       \n"
"  Lz = sin (elevation);                                                       \n"
"  Nz = 1.0 / width45;                                                         \n"
"  Nz2  = Nz * Nz;                                                             \n"
"  NzLz = Nz * Lz;                                                             \n"
"                                                                              \n"
"  bytes = floats_per_pixel - 1;                                               \n"
"                                                                              \n"
"  verify = src_rect->width * src_rect->height * floats_per_pixel;             \n"
"  offset = y * dst_rect->width * floats_per_pixel;                            \n"
"                                                                              \n"
"  for (x = 0; x < dst_rect->width; x++)                                       \n"
"    {                                                                         \n"
"      gint   i, j, b, count;                                                  \n"
"      gfloat Nx, Ny, NdotL;                                                   \n"
"      gfloat shade;                                                           \n"
"      gfloat M[3][3];                                                         \n"
"      gfloat a;                                                               \n"
"                                                                              \n"
"      for (i = 0; i < 3; i++)                                                 \n"
"        for (j = 0; j < 3; j++)                                               \n"
"          M[i][j] = 0.0;                                                      \n"
"                                                                              \n"
"      for (b = 0; b < bytes; b++)                                             \n"
"        {                                                                     \n"
"          for (i = 0; i < 3; i++)                                             \n"
"            {                                                                 \n"
"              for (j = 0; j < 3; j++)                                         \n"
"                {                                                             \n"
"                  count = ((y + i - 1) * src_rect->width + (x + j - 1)) * floats_per_pixel + bytes;\n"
"                                                                              \n"
"                  /* verify each time that we are in the source image */      \n"
"                  if (count >= 0 && count < verify)                           \n"
"                    a = src_buf[count];                                       \n"
"                  else                                                        \n"
"                    a = 1.0;                                                  \n"
"                                                                              \n"
"                  /* calculate recalculate the sorrounding pixels by          \n"
"                   * multiplication after we have that we can                 \n"
"                   * calculate new value of the pixel                         \n"
"                   */                                                         \n"
"                  if ((count - bytes + b) >= 0 && (count - bytes + b) < verify)\n"
"                    M[i][j] += a * src_buf[count - bytes + b];                \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      Nx = M[0][0] + M[1][0] + M[2][0] - M[0][2] - M[1][2] - M[2][2];         \n"
"      Ny = M[2][0] + M[2][1] + M[2][2] - M[0][0] - M[0][1] - M[0][2];         \n"
"                                                                              \n"
"      /* calculating the shading result (same as in gimp) */                  \n"
"      if (Nx == 0 && Ny == 0)                                                 \n"
"        shade = Lz;                                                           \n"
"      else if ((NdotL = Nx * Lx + Ny * Ly + NzLz) < 0)                        \n"
"        shade = 0;                                                            \n"
"      else                                                                    \n"
"        shade = NdotL / sqrt (Nx * Nx + Ny * Ny + Nz2);                       \n"
"                                                                              \n"
"      count = (y * src_rect->width + x) * floats_per_pixel;                   \n"
"                                                                              \n"
"      /* setting the value of the destination buffer */                       \n"
"      if (type == GEGL_EMBOSS_TYPE_EMBOSS)                                    \n"
"        {                                                                     \n"
"          dst_buf[offset++] = shade;                                          \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          /* recalculating every byte of a pixel by multiplying with          \n"
"           * the shading result                                               \n"
"           */                                                                 \n"
"                                                                              \n"
"          for (b = 0; b < bytes; b++)                                         \n"
"            {                                                                 \n"
"              if ((count + b) >= 0 && (count + b) < verify)                   \n"
"                dst_buf[offset++] = (src_buf[count + b] * shade);             \n"
"              else                                                            \n"
"                dst_buf[offset++] = 1.0;                                      \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* preserving alpha */                                                  \n"
"      if ((count + bytes) >= 0 && (count + bytes) < verify)                   \n"
"        dst_buf[offset++] = src_buf[count + bytes];                           \n"
"      else                                                                    \n"
"        dst_buf[offset++] = 1.0;                                              \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  op_area->left = op_area->right = op_area->top = op_area->bottom = 3;        \n"
"                                                                              \n"
"  if (o->type == GEGL_EMBOSS_TYPE_BUMPMAP)                                    \n"
"    gegl_operation_set_format (operation, \"output\",                         \n"
"                               babl_format (\"RGBA float\"));                 \n"
"  else                                                                        \n"
"    gegl_operation_set_format (operation, \"output\",                         \n"
"                               babl_format (\"YA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  GeglRectangle  rect;                                                        \n"
"  gfloat        *src_buf;                                                     \n"
"  gfloat        *dst_buf;                                                     \n"
"  const Babl    *format;                                                      \n"
"  gint           y;                                                           \n"
"  gint           floats_per_pixel;                                            \n"
"                                                                              \n"
"  /*blur-map or emboss*/                                                      \n"
"  if (o->type == GEGL_EMBOSS_TYPE_BUMPMAP)                                    \n"
"    {                                                                         \n"
"      format = babl_format (\"RGBA float\");                                  \n"
"      floats_per_pixel = 4;                                                   \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      format = babl_format (\"YA float\");                                    \n"
"      floats_per_pixel = 2;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  rect.x      = result->x - op_area->left;                                    \n"
"  rect.width  = result->width + op_area->left + op_area->right;               \n"
"  rect.y      = result->y - op_area->top;                                     \n"
"  rect.height = result->height + op_area->top + op_area->bottom;              \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, rect.width * rect.height * floats_per_pixel);     \n"
"  dst_buf = g_new0 (gfloat, rect.width * rect.height * floats_per_pixel);     \n"
"                                                                              \n"
"  gegl_buffer_get (input, &rect, 1.0, format, src_buf,                        \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  /*do for every row*/                                                        \n"
"  for (y = 0; y < rect.height; y++)                                           \n"
"    emboss (src_buf, &rect, dst_buf, &rect, o->type, y, floats_per_pixel,     \n"
"            DEG_TO_RAD (o->azimuth), DEG_TO_RAD (o->elevation), o->depth);    \n"
"                                                                              \n"
"  gegl_buffer_set (output, &rect, 0, format,                                  \n"
"                   dst_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:emboss\",                                         \n"
"    \"title\",       _(\"Emboss\"),                                           \n"
"    \"categories\",  \"light\",                                               \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Simulates an image created by embossing\"),          \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
