static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Michael Muré <batolettre@gmail.com>                        \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (scaling, _(\"Scaling\"), 1.0)                                \n"
"  description   (_(\"scaling factor of displacement, indicates how large spatial\"\n"
"              \" displacement a relative mapping value of 1.0 corresponds to.\"))\n"
"  value_range (0.0, 5000.0)                                                   \n"
"                                                                              \n"
"property_enum (sampler_type, _(\"Resampling method\"),                        \n"
"    GeglSamplerType, gegl_sampler_type, GEGL_SAMPLER_CUBIC)                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     map_relative                                         \n"
"#define GEGL_OP_C_SOURCE map-relative.c                                       \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"aux\", babl_format_n (babl_type (\"float\"), 2));\n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *region)                         \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties       *o = GEGL_PROPERTIES (operation);                      \n"
"  const Babl           *format_io, *format_coords;                            \n"
"  GeglSampler          *sampler;                                              \n"
"  GeglBufferIterator   *it;                                                   \n"
"  gint                  index_in, index_out, index_coords;                    \n"
"                                                                              \n"
"  format_io = babl_format (\"RGBA float\");                                   \n"
"  format_coords = babl_format_n (babl_type (\"float\"), 2);                   \n"
"                                                                              \n"
"  sampler = gegl_buffer_sampler_new_at_level (input, format_io, o->sampler_type, level);\n"
"                                                                              \n"
"  if (aux != NULL)                                                            \n"
"    {                                                                         \n"
"      it = gegl_buffer_iterator_new (output, result, level, format_io,        \n"
"                                     GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);     \n"
"      index_out = 0;                                                          \n"
"                                                                              \n"
"      index_coords = gegl_buffer_iterator_add (it, aux, result, level, format_coords,\n"
"                                               GEGL_ACCESS_READ, GEGL_ABYSS_NONE);\n"
"      index_in = gegl_buffer_iterator_add (it, input, result, level, format_io,\n"
"                                           GEGL_ACCESS_READ, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"      while (gegl_buffer_iterator_next (it))                                  \n"
"        {                                                                     \n"
"          gint        i;                                                      \n"
"          gint        n_pixels = it->length;                                  \n"
"          gint        x = it->roi->x; /* initial x                   */       \n"
"          gint        y = it->roi->y; /*           and y coordinates */       \n"
"          gdouble     scaling = GEGL_PROPERTIES (operation)->scaling;         \n"
"          gfloat     *in = it->data[index_in];                                \n"
"          gfloat     *out = it->data[index_out];                              \n"
"          gfloat     *coords = it->data[index_coords];                        \n"
"                                                                              \n"
"          for (i=0; i<n_pixels; i++)                                          \n"
"            {                                                                 \n"
"              /* if the coordinate asked is an exact pixel, we fetch it       \n"
"               * directly, to avoid the blur of sampling */                   \n"
"              if (coords[0] == 0 && coords[1] == 0)                           \n"
"                {                                                             \n"
"                  out[0] = in[0];                                             \n"
"                  out[1] = in[1];                                             \n"
"                  out[2] = in[2];                                             \n"
"                  out[3] = in[3];                                             \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  gegl_sampler_get (sampler, x + coords[0] * scaling + 0.5,   \n"
"                                             y + coords[1] * scaling + 0.5,   \n"
"                                             NULL, out,                       \n"
"                                             GEGL_ABYSS_NONE);                \n"
"                }                                                             \n"
"                                                                              \n"
"              coords += 2;                                                    \n"
"              in += 4;                                                        \n"
"              out += 4;                                                       \n"
"                                                                              \n"
"              /* update x and y coordinates */                                \n"
"              x++;                                                            \n"
"              if (x >= (it->roi->x + it->roi->width))                         \n"
"                {                                                             \n"
"                  x = it->roi->x;                                             \n"
"                  y++;                                                        \n"
"                }                                                             \n"
"                                                                              \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, result, GEGL_ABYSS_NONE,                       \n"
"                        output, result);                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"  gchar                      *composition =                                   \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:crop' width='200' height='200'/>\"                \n"
"    \"<node operation='gegl:over'>\"                                          \n"
"      \"<node operation='gegl:map-relative'>\"                                \n"
"      \"  <params>\"                                                          \n"
"      \"    <param name='scaling'>30</param>\"                                \n"
"      \"  </params>\"                                                         \n"
"      \"  <node operation='gegl:perlin-noise' />\"                            \n"
"      \"</node>\"                                                             \n"
"      \"<node operation='gegl:load' path='standard-input.png'/>\"             \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:checkerboard' color1='rgb(0.25,0.25,0.25)' color2='rgb(0.75,0.75,0.75)'/>\"\n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"                                                                              \n"
"  composer_class->process = process;                                          \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:map-relative\",                                   \n"
"    \"title\",       _(\"Map Relative\"),                                     \n"
"    \"categories\" , \"map\",                                                 \n"
"    \"description\", _(\"sample input with an auxiliary buffer that contain relative source coordinates\"),\n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
