static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Michael Muré <batolettre@gmail.com>                        \n"
" * Copyright 2011 Robert Sasu <sasu.robert@gmail.com>                         \n"
" * Copyright 2011 Hans Lo <hansshulo@gmail.com>                               \n"
" * Copyright 1997 Brian Degenhardt <bdegenha@ucsd.edu>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_ripple_wave_type)                                            \n"
"  enum_value (GEGL_RIPPLE_WAVE_TYPE_SINE,     \"sine\",     N_(\"Sine\"))     \n"
"  enum_value (GEGL_RIPPLE_WAVE_TYPE_SAWTOOTH, \"sawtooth\", N_(\"Sawtooth\")) \n"
"enum_end (GeglRippleWaveType)                                                 \n"
"                                                                              \n"
"property_double (amplitude, _(\"Amplitude\"), 25.0)                           \n"
"    value_range (0.0, 1000.0)                                                 \n"
"    ui_gamma    (2.0)                                                         \n"
"                                                                              \n"
"property_double (period, _(\"Period\"), 200.0)                                \n"
"    value_range (0.0, 1000.0)                                                 \n"
"    ui_gamma    (1.5)                                                         \n"
"                                                                              \n"
"property_double (phi, _(\"Phase shift\"), 0.0)                                \n"
"    value_range (-1.0, 1.0)                                                   \n"
"                                                                              \n"
"property_double (angle, _(\"Angle\"), 0.0)                                    \n"
"    value_range (-180, 180)                                                   \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_enum  (sampler_type, _(\"Resampling method\"),                       \n"
"    GeglSamplerType, gegl_sampler_type, GEGL_SAMPLER_CUBIC)                   \n"
"                                                                              \n"
"property_enum (wave_type, _(\"Wave type\"),                                   \n"
"    GeglRippleWaveType, gegl_ripple_wave_type, GEGL_RIPPLE_WAVE_TYPE_SINE)    \n"
"                                                                              \n"
"property_boolean (tileable, _(\"Tileable\"), FALSE)                           \n"
"    description(_(\"Retain tilebility\"))                                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     ripple                                               \n"
"#define GEGL_OP_C_SOURCE ripple.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties              *o;                                             \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"                                                                              \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"  o       = GEGL_PROPERTIES (operation);                                      \n"
"                                                                              \n"
"  op_area->left   = o->amplitude;                                             \n"
"  op_area->right  = o->amplitude;                                             \n"
"  op_area->top    = o->amplitude;                                             \n"
"  op_area->bottom = o->amplitude;                                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties         *o       = GEGL_PROPERTIES (operation);              \n"
"  GeglSampler        *sampler = gegl_buffer_sampler_new_at_level (input,      \n"
"                                                         babl_format (\"RGBA float\"),\n"
"                                                         o->sampler_type,     \n"
"                                                         level);              \n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  GeglAbyssPolicy abyss = o->tileable ? GEGL_ABYSS_LOOP : GEGL_ABYSS_NONE;    \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, result, 0, babl_format (\"RGBA float\"),\n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint x = result->x;                                                     \n"
"      gint y = result->y;                                                     \n"
"      gfloat *out_pixel = iter->data[0];                                      \n"
"                                                                              \n"
"      for (y = iter->roi[0].y; y < iter->roi[0].y + iter->roi[0].height; ++y) \n"
"        for (x = iter->roi[0].x; x < iter->roi[0].x + iter->roi[0].width; ++x)\n"
"          {                                                                   \n"
"            gdouble shift;                                                    \n"
"            gdouble coordsx;                                                  \n"
"            gdouble coordsy;                                                  \n"
"            gdouble lambda;                                                   \n"
"                                                                              \n"
"            gdouble angle_rad = o->angle / 180.0 * G_PI;                      \n"
"            gdouble nx = x * cos (angle_rad) + y * sin (angle_rad);           \n"
"                                                                              \n"
"            switch (o->wave_type)                                             \n"
"              {                                                               \n"
"                case GEGL_RIPPLE_WAVE_TYPE_SAWTOOTH:                          \n"
"                  lambda = div (nx,o->period).rem - o->phi * o->period;       \n"
"                  if (lambda < 0)                                             \n"
"                    lambda += o->period;                                      \n"
"                  shift = o->amplitude * (fabs (((lambda / o->period) * 4) - 2) - 1);\n"
"                  break;                                                      \n"
"                case GEGL_RIPPLE_WAVE_TYPE_SINE:                              \n"
"                default:                                                      \n"
"                  shift = o->amplitude * sin (2.0 * G_PI * nx / o->period + 2.0 * G_PI * o->phi);\n"
"                  break;                                                      \n"
"              }                                                               \n"
"                                                                              \n"
"            coordsx = x + shift * sin (angle_rad);                            \n"
"            coordsy = y + shift * cos (angle_rad);                            \n"
"                                                                              \n"
"            gegl_sampler_get (sampler,                                        \n"
"                              coordsx,                                        \n"
"                              coordsy,                                        \n"
"                              NULL,                                           \n"
"                              out_pixel,                                      \n"
"                              abyss);                                         \n"
"                                                                              \n"
"            out_pixel += 4;                                                   \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:ripple\",                                  \n"
"    \"title\",              _(\"Ripple\"),                                    \n"
"    \"categories\",         \"distort\",                                      \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\", _(\"Displace pixels in a ripple pattern\"),              \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
