static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Miroslav Talasek <miroslav.talasek@seznam.cz>               \n"
" *                                                                            \n"
" * Wavelet blur used in wavelet decompose filter                              \n"
" *  theory is from original wavelet plugin                                    \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"                                                                              \n"
"property_double (radius, _(\"Radius\"), 1.0)                                  \n"
"    description (_(\"Radius of the wavelet blur\"))                           \n"
"    value_range (0.0, 1500.0)                                                 \n"
"    ui_range    (0.0, 256.0)                                                  \n"
"    ui_gamma    (3.0)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"radius\", \"blur\")                                        \n"
"                                                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     wavelet_blur                                         \n"
"#define GEGL_OP_C_SOURCE wavelet-blur.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"                                                                              \n"
"static gint                                                                   \n"
"wav_gen_convolve_matrix (gdouble   radius,                                    \n"
"                         gdouble **cmatrix_p);                                \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"static gint                                                                   \n"
"wav_calc_convolve_matrix_length (gdouble radius)                              \n"
"{                                                                             \n"
"  return ceil (radius) * 2 + 1;                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"wav_gen_convolve_matrix (gdouble   radius,                                    \n"
"                         gdouble **cmatrix_p)                                 \n"
"{                                                                             \n"
"  gint     matrix_length;                                                     \n"
"  gdouble *cmatrix;                                                           \n"
"                                                                              \n"
"  matrix_length = wav_calc_convolve_matrix_length (radius);                   \n"
"  cmatrix = g_new (gdouble, matrix_length);                                   \n"
"                                                                              \n"
"  if (matrix_length == 1)                                                     \n"
"    {                                                                         \n"
"      cmatrix[0] = 1;                                                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"                                                                              \n"
"      for (i = 0; i < matrix_length; i++)                                     \n"
"        {                                                                     \n"
"          if (i == 0 || i == matrix_length - 1)                               \n"
"            {                                                                 \n"
"              cmatrix[i] = 0.25;                                              \n"
"            }                                                                 \n"
"          else if (i == matrix_length / 2)                                    \n"
"            {                                                                 \n"
"              cmatrix[i] = 0.5;                                               \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              cmatrix[i] = 0;                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  *cmatrix_p = cmatrix;                                                       \n"
"  return matrix_length;                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"wav_get_mean_pixel_1D (gfloat  *src,                                          \n"
"                       gfloat  *dst,                                          \n"
"                       gint     components,                                   \n"
"                       gdouble *cmatrix,                                      \n"
"                       gint     matrix_length)                                \n"
"{                                                                             \n"
"  gint    i, c;                                                               \n"
"  gint    offset;                                                             \n"
"  gdouble acc[components];                                                    \n"
"                                                                              \n"
"  for (c = 0; c < components; ++c)                                            \n"
"    acc[c] = 0;                                                               \n"
"                                                                              \n"
"  offset = 0;                                                                 \n"
"                                                                              \n"
"  for (i = 0; i < matrix_length; i++)                                         \n"
"    {                                                                         \n"
"      for (c = 0; c < components; ++c)                                        \n"
"        acc[c] += src[offset++] * cmatrix[i];                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (c = 0; c < components; ++c)                                            \n"
"    dst[c] = acc[c];                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"wav_hor_blur (GeglBuffer          *src,                                       \n"
"              GeglBuffer          *dst,                                       \n"
"              const GeglRectangle *dst_rect,                                  \n"
"              gdouble             *cmatrix,                                   \n"
"              gint                 matrix_length,                             \n"
"              const Babl          *format)                                    \n"
"{                                                                             \n"
"  gint        u, v;                                                           \n"
"  const gint  radius = matrix_length / 2;                                     \n"
"  const gint  nc = babl_format_get_n_components (format);                     \n"
"                                                                              \n"
"  GeglRectangle write_rect = {dst_rect->x, dst_rect->y, dst_rect->width, 1};  \n"
"  gfloat *dst_buf     = gegl_malloc (write_rect.width * sizeof(gfloat) * nc); \n"
"                                                                              \n"
"  GeglRectangle read_rect = {dst_rect->x - radius, dst_rect->y, dst_rect->width + matrix_length -1, 1};\n"
"  gfloat *src_buf    = gegl_malloc (read_rect.width * sizeof(gfloat) * nc);   \n"
"                                                                              \n"
"  for (v = 0; v < dst_rect->height; v++)                                      \n"
"    {                                                                         \n"
"      gint offset     = 0;                                                    \n"
"      read_rect.y     = dst_rect->y + v;                                      \n"
"      write_rect.y    = dst_rect->y + v;                                      \n"
"      gegl_buffer_get (src, &read_rect, 1.0, format, src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"      for (u = 0; u < dst_rect->width; u++)                                   \n"
"        {                                                                     \n"
"          wav_get_mean_pixel_1D (src_buf + offset,                            \n"
"                                 dst_buf + offset,                            \n"
"                                 nc,                                          \n"
"                                 cmatrix,                                     \n"
"                                 matrix_length);                              \n"
"          offset += nc;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_set (dst, &write_rect, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_free (src_buf);                                                        \n"
"  gegl_free (dst_buf);                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"wav_ver_blur (GeglBuffer          *src,                                       \n"
"              GeglBuffer          *dst,                                       \n"
"              const GeglRectangle *dst_rect,                                  \n"
"              gdouble             *cmatrix,                                   \n"
"              gint                 matrix_length,                             \n"
"              const Babl          *format)                                    \n"
"{                                                                             \n"
"  gint        u,v;                                                            \n"
"  const gint  radius = matrix_length / 2;                                     \n"
"  const gint  nc = babl_format_get_n_components (format);                     \n"
"                                                                              \n"
"  GeglRectangle write_rect = {dst_rect->x, dst_rect->y, 1, dst_rect->height}; \n"
"  gfloat *dst_buf    = gegl_malloc (write_rect.height * sizeof(gfloat) * nc); \n"
"                                                                              \n"
"  GeglRectangle read_rect  = {dst_rect->x, dst_rect->y - radius , 1, dst_rect->height + matrix_length -1};\n"
"  gfloat *src_buf    = gegl_malloc (read_rect.height * sizeof(gfloat) * nc);  \n"
"                                                                              \n"
"  for (u = 0; u < dst_rect->width; u++)                                       \n"
"    {                                                                         \n"
"      gint offset     = 0;                                                    \n"
"      read_rect.x     = dst_rect->x + u;                                      \n"
"      write_rect.x    = dst_rect->x + u;                                      \n"
"      gegl_buffer_get (src, &read_rect, 1.0, format, src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"      for (v = 0; v < dst_rect->height; v++)                                  \n"
"        {                                                                     \n"
"          wav_get_mean_pixel_1D (src_buf + offset,                            \n"
"                                 dst_buf + offset,                            \n"
"                                 nc,                                          \n"
"                                 cmatrix,                                     \n"
"                                 matrix_length);                              \n"
"          offset += nc;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_set (dst, &write_rect, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_free (src_buf);                                                        \n"
"  gegl_free (dst_buf);                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties          *o    = GEGL_PROPERTIES (operation);                \n"
"                                                                              \n"
"                                                                              \n"
"  /* XXX: these should be calculated exactly considering o->filter, but we just\n"
"   * make sure there is enough space */                                       \n"
"  area->left = area->right = ceil (o->radius);                                \n"
"  area->top = area->bottom = ceil (o->radius);                                \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"R'G'B' float\"));                 \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"R'G'B' float\"));                 \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglRectangle rect;                                                         \n"
"  GeglBuffer *temp;                                                           \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  const Babl *format = gegl_operation_get_format (operation, \"output\");     \n"
"                                                                              \n"
"  GeglRectangle temp_extend;                                                  \n"
"  gdouble      *cmatrix;                                                      \n"
"  gint          cmatrix_len;                                                  \n"
"                                                                              \n"
"  rect.x      = result->x - op_area->left;                                    \n"
"  rect.width  = result->width + op_area->left + op_area->right;               \n"
"  rect.y      = result->y - op_area->top;                                     \n"
"  rect.height = result->height + op_area->top + op_area->bottom;              \n"
"                                                                              \n"
"                                                                              \n"
"  gegl_rectangle_intersect (&temp_extend, &rect, gegl_buffer_get_extent (input));\n"
"  temp_extend.x      = result->x;                                             \n"
"  temp_extend.width  = result->width;                                         \n"
"  temp = gegl_buffer_new (&temp_extend, format);                              \n"
"                                                                              \n"
"  cmatrix_len = wav_gen_convolve_matrix (o->radius, &cmatrix);                \n"
"  wav_hor_blur (input, temp, &temp_extend, cmatrix, cmatrix_len, format);     \n"
"  wav_ver_blur (temp, output, result, cmatrix, cmatrix_len, format);          \n"
"  g_free (cmatrix);                                                           \n"
"                                                                              \n"
"  g_object_unref (temp);                                                      \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  filter_class->process           = process;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:wavelet-blur\",                                   \n"
"    \"title\",       _(\"Wavelet Blur\"),                                     \n"
"//    \"license\",     \"LGPL3+\",                                            \n"
"    \"categories\",  \"blur\",                                                \n"
"    \"description\", _(\"This blur is used for the wavelet decomposition filter, each pixel is computed from another by the HAT transform\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
