static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright (C) 2017 Ell                                                     \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (subdivisions, _(\"Subdivisions\"), 1)                           \n"
"  description(_(\"Number of subdivisions\"))                                  \n"
"  value_range (0, 15)                                                         \n"
"                                                                              \n"
"property_int (x_scale, _(\"X Scale\"), 1)                                     \n"
"  description(_(\"Horizontal pattern scale\"))                                \n"
"  value_range (1, G_MAXINT)                                                   \n"
"  ui_range    (1, 128)                                                        \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_int (y_scale, _(\"Y Scale\"), 1)                                     \n"
"  description(_(\"Vertical pattern scale\"))                                  \n"
"  value_range (1, G_MAXINT)                                                   \n"
"  ui_range    (1, 128)                                                        \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"enum_start (gegl_bayer_matrix_rotation)                                       \n"
"  enum_value (GEGL_BAYER_MATRIX_ROTATION_0,   \"0\",   N_(\"0°\"))           \n"
"  enum_value (GEGL_BAYER_MATRIX_ROTATION_90,  \"90\",  N_(\"90°\"))          \n"
"  enum_value (GEGL_BAYER_MATRIX_ROTATION_180, \"180\", N_(\"180°\"))         \n"
"  enum_value (GEGL_BAYER_MATRIX_ROTATION_270, \"270\", N_(\"270°\"))         \n"
"enum_end (GeglBayerMatrixRotation)                                            \n"
"                                                                              \n"
"property_enum (rotation, _(\"Rotation\"),                                     \n"
"               GeglBayerMatrixRotation, gegl_bayer_matrix_rotation,           \n"
"               GEGL_BAYER_MATRIX_ROTATION_0)                                  \n"
"  description (_(\"Pattern rotation angle\"))                                 \n"
"                                                                              \n"
"property_boolean (reflect, _(\"Reflect\"), FALSE)                             \n"
"  description(_(\"Reflect the pattern horizontally\"))                        \n"
"                                                                              \n"
"property_double (amplitude, _(\"Amplitude\"), 0.0)                            \n"
"  description(_(\"Pattern amplitude (logarithmic scale)\"))                   \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (offset, _(\"Offset\"), 0.0)                                  \n"
"  description(_(\"Value offset\"))                                            \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-1.0, 1.0)                                                     \n"
"                                                                              \n"
"property_double (exponent, _(\"Exponent\"), 0.0)                              \n"
"  description(_(\"Value exponent (logarithmic scale)\"))                      \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_int (x_offset, _(\"X Offset\"), 0)                                   \n"
"  description (_(\"Offset for X axis\"))                                      \n"
"  value_range (G_MININT, G_MAXINT)                                            \n"
"  ui_range    (-512, 512)                                                     \n"
"  ui_meta     (\"unit\", \"pixel-coordinate\")                                \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_int (y_offset, _(\"Y Offset\"), 0)                                   \n"
"  description (_(\"Offset for Y axis\"))                                      \n"
"  value_range (G_MININT, G_MAXINT)                                            \n"
"  ui_range    (-512, 512)                                                     \n"
"  ui_meta     (\"unit\", \"pixel-coordinate\")                                \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     bayer_matrix                                         \n"
"#define GEGL_OP_C_SOURCE bayer-matrix.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define GEGL_BAYER_MATRIX_MAX_LUT_SUBDIVISIONS 8                              \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"odd_powf (gfloat base,                                                        \n"
"          gfloat exponent)                                                    \n"
"{                                                                             \n"
"  if (base >= 0.0f)                                                           \n"
"    return  powf ( base, exponent);                                           \n"
"  else                                                                        \n"
"    return -powf (-base, exponent);                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gboolean                                                        \n"
"is_power_of_two (guint x)                                                     \n"
"{                                                                             \n"
"  return (x & (x - 1)) == 0;                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gint                                                            \n"
"log2i (guint x)                                                               \n"
"{                                                                             \n"
"  gint result = 0;                                                            \n"
"  gint shift  = 8 * sizeof (guint);                                           \n"
"                                                                              \n"
"  while (shift >>= 1)                                                         \n"
"    {                                                                         \n"
"      if (x >> shift)                                                         \n"
"        {                                                                     \n"
"          result  += shift;                                                   \n"
"          x      >>= shift;                                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gint                                                            \n"
"div_floor (gint a,                                                            \n"
"           gint b)                                                            \n"
"{                                                                             \n"
"  /* we assume b is positive */                                               \n"
"  if (a < 0) a -= b - 1;                                                      \n"
"  return a / b;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation  *op = (void*) object;                                        \n"
"  GeglProperties *o  = GEGL_PROPERTIES (op);                                  \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"value_at (GeglProperties *o,                                                  \n"
"          gint            x,                                                  \n"
"          gint            y)                                                  \n"
"{                                                                             \n"
"  gint  i;                                                                    \n"
"  guint value = 0;                                                            \n"
"                                                                              \n"
"  static const gint subdivision_value_luts[2 /* reflection */]                \n"
"                                          [4 /* rotation   */]                \n"
"                                          [2 /* row        */]                \n"
"                                          [2 /* column     */] =              \n"
"    {                                                                         \n"
"      {                                                                       \n"
"        {{0, 2},                                                              \n"
"         {3, 1}},                                                             \n"
"                                                                              \n"
"        {{2, 1},                                                              \n"
"         {0, 3}},                                                             \n"
"                                                                              \n"
"         {{1, 3},                                                             \n"
"          {2, 0}},                                                            \n"
"                                                                              \n"
"         {{3, 0},                                                             \n"
"          {1, 2}}                                                             \n"
"      },                                                                      \n"
"                                                                              \n"
"      {                                                                       \n"
"        {{2, 0},                                                              \n"
"         {1, 3}},                                                             \n"
"                                                                              \n"
"        {{1, 2},                                                              \n"
"         {3, 0}},                                                             \n"
"                                                                              \n"
"         {{3, 1},                                                             \n"
"          {0, 2}},                                                            \n"
"                                                                              \n"
"         {{0, 3},                                                             \n"
"          {2, 1}}                                                             \n"
"      }                                                                       \n"
"    };                                                                        \n"
"  const gint (* subdivision_values)[2];                                       \n"
"                                                                              \n"
"  subdivision_values = subdivision_value_luts[o->reflect][o->rotation];       \n"
"                                                                              \n"
"  for (i = 0; i < o->subdivisions; i++)                                       \n"
"    {                                                                         \n"
"      value <<= 2;                                                            \n"
"      value  |= subdivision_values[y & 1][x & 1];                             \n"
"      x     >>= 1;                                                            \n"
"      y     >>= 1;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return odd_powf (o->offset            +                                     \n"
"                   exp2f (o->amplitude) *                                     \n"
"                   (value + .5f) / (1u << (2 * o->subdivisions)),             \n"
"                   exp2f (o->exponent));                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->subdivisions <= GEGL_BAYER_MATRIX_MAX_LUT_SUBDIVISIONS)              \n"
"    {                                                                         \n"
"      gint    size;                                                           \n"
"      gint    x, y;                                                           \n"
"      gfloat *lut;                                                            \n"
"                                                                              \n"
"      size = 1 << o->subdivisions;                                            \n"
"                                                                              \n"
"      o->user_data = lut = g_renew (gfloat, o->user_data, size * size);       \n"
"                                                                              \n"
"      for (y = 0; y < size; y++)                                              \n"
"        {                                                                     \n"
"          for (x = 0; x < size; x++)                                          \n"
"            {                                                                 \n"
"              *lut++ = value_at (o, x, y);                                    \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"Y' float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o            = GEGL_PROPERTIES (operation);                 \n"
"  gint            i, j;                                                       \n"
"  gint            last_i, last_j;                                             \n"
"  gint            x, y;                                                       \n"
"  gfloat         *result       = out_buf;                                     \n"
"  const gfloat   *lut          = NULL;                                        \n"
"  const gfloat   *lut_row      = NULL;                                        \n"
"  gint            size;                                                       \n"
"  gint            coord_mask;                                                 \n"
"  gint            log2_x_scale = -1;                                          \n"
"  gboolean        log2_y_scale = -1;                                          \n"
"                                                                              \n"
"  if (o->subdivisions <= GEGL_BAYER_MATRIX_MAX_LUT_SUBDIVISIONS)              \n"
"    lut = o->user_data;                                                       \n"
"                                                                              \n"
"  size       = 1 << o->subdivisions;                                          \n"
"  coord_mask = size - 1;                                                      \n"
"                                                                              \n"
"  if (is_power_of_two (o->x_scale))                                           \n"
"    log2_x_scale = log2i (o->x_scale);                                        \n"
"  if (is_power_of_two (o->y_scale))                                           \n"
"    log2_y_scale = log2i (o->y_scale);                                        \n"
"                                                                              \n"
"  for (j = roi->y - o->y_offset, last_j = j + roi->height; j != last_j; j++)  \n"
"    {                                                                         \n"
"      if (log2_y_scale >= 0) y = j >> log2_y_scale;                           \n"
"      else                   y = div_floor (j, o->y_scale);                   \n"
"                                                                              \n"
"      y &= coord_mask;                                                        \n"
"                                                                              \n"
"      if (lut)                                                                \n"
"        lut_row = lut + size * y;                                             \n"
"                                                                              \n"
"      for (i = roi->x - o->x_offset, last_i = i + roi->width; i != last_i; i++)\n"
"        {                                                                     \n"
"          if (log2_x_scale >= 0) x = i >> log2_x_scale;                       \n"
"          else                   x = div_floor (i, o->x_scale);               \n"
"                                                                              \n"
"          x &= coord_mask;                                                    \n"
"                                                                              \n"
"          if (lut_row)                                                        \n"
"            *result = lut_row[x];                                             \n"
"          else                                                                \n"
"            *result = value_at (o, x, y);                                     \n"
"                                                                              \n"
"          result++;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  object_class       = G_OBJECT_CLASS (klass);                                \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"                                                                              \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare          = prepare;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:bayer-matrix\",                            \n"
"    \"title\",              _(\"Bayer Matrix\"),                              \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\",        _(\"Generate a Bayer matrix pattern\"),           \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
