static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2005 Øyvind Kolås <pippin@gimp.org>,                           \n"
" *           2007 Øyvind Kolås <oeyvindk@hig.no>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (radius, _(\"Radius\"), 8)                                       \n"
"    description(_(\"Radius of square pixel region, (width and height will be radius*2+1)\"))\n"
"    value_range (0, 100)                                                      \n"
"    ui_range    (0, 40)                                                       \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_int (pairs, _(\"Pairs\"), 2)                                         \n"
"  description(_(\"Number of pairs; higher number preserves more acute features\"))\n"
"  value_range (1, 2)                                                          \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     snn_mean                                             \n"
"#define GEGL_OP_C_SOURCE snn-mean.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"snn_mean (GeglBuffer          *src,                                           \n"
"          const GeglRectangle *src_rect,                                      \n"
"          GeglBuffer          *dst,                                           \n"
"          const GeglRectangle *dst_rect,                                      \n"
"          gdouble              radius,                                        \n"
"          gint                 pairs,                                         \n"
"          gint                 level);                                        \n"
"                                                                              \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties          *o    = GEGL_PROPERTIES (operation);                \n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom = ceil (o->radius);     \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result);                                     \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties      *o = GEGL_PROPERTIES (operation);                       \n"
"  GeglRectangle        compute;                                               \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, result))                        \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  compute = gegl_operation_get_required_for_output (operation, \"input\", result);\n"
"                                                                              \n"
"  if (o->radius < 1.0)                                                        \n"
"    {                                                                         \n"
"      output = g_object_ref (input);                                          \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      snn_mean (input, &compute, output, result, o->radius, o->pairs, level); \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"#define POW2(a)((a)*(a))                                                      \n"
"                                                                              \n"
"static inline gfloat colordiff (gfloat *pixA,                                 \n"
"                                gfloat *pixB)                                 \n"
"{                                                                             \n"
"  return POW2(pixA[0]-pixB[0])+                                               \n"
"         POW2(pixA[1]-pixB[1])+                                               \n"
"         POW2(pixA[2]-pixB[2]);                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"snn_mean (GeglBuffer          *src,                                           \n"
"          const GeglRectangle *src_rect,                                      \n"
"          GeglBuffer          *dst,                                           \n"
"          const GeglRectangle *dst_rect,                                      \n"
"          gdouble              dradius,                                       \n"
"          gint                 pairs,                                         \n"
"          gint                 level)                                         \n"
"{                                                                             \n"
"  gint x,y;                                                                   \n"
"  gint offset;                                                                \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"  gint radius = dradius;                                                      \n"
"  GeglRectangle src_rect_scaled, dst_rect_scaled;                             \n"
"  if (level)                                                                  \n"
"  {                                                                           \n"
"    src_rect_scaled = *src_rect;                                              \n"
"    dst_rect_scaled = *dst_rect;                                              \n"
"    src_rect_scaled.x >>= level;                                              \n"
"    src_rect_scaled.y >>= level;                                              \n"
"    src_rect_scaled.width >>= level;                                          \n"
"    src_rect_scaled.height >>= level;                                         \n"
"    dst_rect_scaled.x >>= level;                                              \n"
"    dst_rect_scaled.y >>= level;                                              \n"
"    dst_rect_scaled.width >>= level;                                          \n"
"    dst_rect_scaled.height >>= level;                                         \n"
"    src_rect = &src_rect_scaled;                                              \n"
"    dst_rect = &dst_rect_scaled;                                              \n"
"    dradius /= (1<<level);                                                    \n"
"  }                                                                           \n"
"  radius = dradius;                                                           \n"
"                                                                              \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 4);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 4);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0/(1<<level), babl_format (\"RGBA float\"), src_buf,\n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  offset = 0;                                                                 \n"
"                                                                              \n"
"  for (y=0; y<dst_rect->height; y++)                                          \n"
"    {                                                                         \n"
"      gfloat *center_pix;                                                     \n"
"                                                                              \n"
"      center_pix = src_buf + ((radius) + (y+radius)* src_rect->width)*4;      \n"
"                                                                              \n"
"      for (x=0; x<dst_rect->width; x++)                                       \n"
"        {                                                                     \n"
"          gint u,v;                                                           \n"
"                                                                              \n"
"          gfloat  accumulated[4]={0.0f, 0.0f, 0.0f, 0.0f};                    \n"
"          gint    count=0;                                                    \n"
"                                                                              \n"
"          /* iterate through the upper left quarter of pixels */              \n"
"          for (v=-radius;v<=0;v++)                                            \n"
"            for (u=-radius;u<= (pairs==1?radius:0);u++)                       \n"
"              {                                                               \n"
"                gfloat *selected_pix = center_pix;                            \n"
"                gfloat  best_diff = 1000.0;                                   \n"
"                gint    i;                                                    \n"
"                                                                              \n"
"                /* skip computations for the center pixel */                  \n"
"                if (u != 0 &&                                                 \n"
"                    v != 0)                                                   \n"
"                  {                                                           \n"
"                    /* compute the coordinates of the symmetric pairs for     \n"
"                     * this locaiton in the quadrant                          \n"
"                     */                                                       \n"
"                    gint xs[4], ys[4];                                        \n"
"                                                                              \n"
"                    xs[0] = x+u+radius;                                       \n"
"                    xs[1] = x-u+radius;                                       \n"
"                    xs[2] = x-u+radius;                                       \n"
"                    xs[3] = x+u+radius;                                       \n"
"                    ys[0] = y+v+radius;                                       \n"
"                    ys[1] = y-v+radius;                                       \n"
"                    ys[2] = y+v+radius;                                       \n"
"                    ys[3] = y-v+radius;                                       \n"
"                                                                              \n"
"                    /* check which member of the symmetric quadruple to use */\n"
"                    for (i=0;i<pairs*2;i++)                                   \n"
"                      {                                                       \n"
"                        if (xs[i] >= 0 && xs[i] < src_rect->width &&          \n"
"                            ys[i] >= 0 && ys[i] < src_rect->height)           \n"
"                          {                                                   \n"
"                            gfloat *tpix = src_buf + (xs[i]+ys[i]* src_rect->width)*4;\n"
"                            gfloat diff = colordiff (tpix, center_pix);       \n"
"                            if (diff < best_diff)                             \n"
"                              {                                               \n"
"                                best_diff = diff;                             \n"
"                                selected_pix = tpix;                          \n"
"                              }                                               \n"
"                          }                                                   \n"
"                      }                                                       \n"
"                  }                                                           \n"
"                                                                              \n"
"                /* accumulate the components of the best sample from          \n"
"                 * the symmetric quadruple                                    \n"
"                 */                                                           \n"
"                for (i=0;i<4;i++)                                             \n"
"                  {                                                           \n"
"                    accumulated[i] += selected_pix[i];                        \n"
"                  }                                                           \n"
"                count++;                                                      \n"
"                                                                              \n"
"                if (u==0 && v==0)                                             \n"
"                  break; /* to avoid doubly processing when using only 1 pair */\n"
"              }                                                               \n"
"          for (u=0; u<4; u++)                                                 \n"
"            dst_buf[offset*4+u] = accumulated[u]/count;                       \n"
"          offset++;                                                           \n"
"                                                                              \n"
"          center_pix += 4;                                                    \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  gegl_buffer_set (dst, dst_rect, level, babl_format (\"RGBA float\"), dst_buf,\n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/snn-mean.cl.h\"                                             \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_snn_mean (cl_mem                in_tex,                                    \n"
"             cl_mem                out_tex,                                   \n"
"             const GeglRectangle  *src_rect,                                  \n"
"             const GeglRectangle  *roi,                                       \n"
"             gint                  radius,                                    \n"
"             gint                  pairs)                                     \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  size_t global_ws[2];                                                        \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"snn_mean\", NULL};                       \n"
"      cl_data = gegl_cl_compile_and_build (snn_mean_cl_source, kernel_name);  \n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"                                                                              \n"
"  global_ws[0] = roi->width;                                                  \n"
"  global_ws[1] = roi->height;                                                 \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_int),   (void*)&src_rect->width);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_int),   (void*)&src_rect->height);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_int),   (void*)&radius);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_int),   (void*)&pairs);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, global_ws, NULL,                \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err;                                                                   \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err) return FALSE;                                                  \n"
"                                                                              \n"
"      err = cl_snn_mean(i->tex[read],                                         \n"
"                        i->tex[0],                                            \n"
"                        &i->roi[read],                                        \n"
"                        &i->roi[0],                                           \n"
"                        ceil(o->radius),                                      \n"
"                        o->pairs);                                            \n"
"                                                                              \n"
"      if (err) return FALSE;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:snn-mean\",                                       \n"
"    \"categories\" , \"enhance:noise-reduction\",                             \n"
"    \"title\",       _(\"Symmetric Nearest Neighbour\"),                      \n"
"    \"description\",                                                          \n"
"        _(\"Noise reducing edge preserving blur filter based \"               \n"
"          \"on Symmetric Nearest Neighbours\"),                               \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
