static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright (C) 1997 Federico Mena Quintero and David Bleecker               \n"
" * federico@nuclecu.unam.mx                                                   \n"
" * bleecker@math.hawaii.edu                                                   \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (red_frequency, _(\"Red frequency\"), 0.815)                  \n"
"    description (_(\"Light frequency (red)\"))                                \n"
"    value_range (0.0, 20.0)                                                   \n"
"                                                                              \n"
"property_double (green_frequency, _(\"Green frequency\"), 1.221)              \n"
"    description (_(\"Light frequency (green)\"))                              \n"
"    value_range (0.0, 20.0)                                                   \n"
"                                                                              \n"
"property_double (blue_frequency, _(\"Blue frequency\"), 1.123)                \n"
"    description (_(\"Light frequency (blue)\"))                               \n"
"    value_range (0.0, 20.0)                                                   \n"
"                                                                              \n"
"property_double (red_contours, _(\"Red contours\"), 0.821)                    \n"
"    description (_(\"Number of contours (red)\"))                             \n"
"    value_range (0.0, 10.0)                                                   \n"
"                                                                              \n"
"property_double (green_contours, _(\"Green contours\"), 0.821)                \n"
"    description (_(\"Number of contours (green)\"))                           \n"
"    value_range (0.0, 10.0)                                                   \n"
"                                                                              \n"
"property_double (blue_contours, _(\"Blue contours\"), 0.974)                  \n"
"    description (_(\"Number of contours (blue)\"))                            \n"
"    value_range (0.0, 10.0)                                                   \n"
"                                                                              \n"
"property_double (red_sedges, _(\"Red sharp edges\"), 0.610)                   \n"
"    description (_(\"Number of sharp edges (red)\"))                          \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (green_sedges, _(\"Green sharp edges\"), 0.677)               \n"
"    description (_(\"Number of sharp edges (green)\"))                        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (blue_sedges, _(\"Blue sharp edges\"), 0.636)                 \n"
"    description (_(\"Number of sharp edges (blue)\"))                         \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (brightness, _(\"Brightness\"), 0.066)                        \n"
"    description (_(\"Brightness and shifting/fattening of contours\"))        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (scattering, _(\"Scattering\"), 37.126)                       \n"
"    description (_(\"Scattering (speed vs. quality)\"))                       \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (polarization, _(\"Polarization\"), -0.473)                   \n"
"    description (_(\"Polarization\"))                                         \n"
"    value_range (-1.0, 1.0)                                                   \n"
"                                                                              \n"
"property_int    (width, _(\"Width\"), 200)                                    \n"
"    description (_(\"Width of the generated buffer\"))                        \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 4096)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"    ui_meta     (\"role\", \"output-extent\")                                 \n"
"                                                                              \n"
"property_int    (height, _(\"Height\"), 200)                                  \n"
"    description (_(\"Height of the generated buffer\"))                       \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 4096)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"    ui_meta     (\"role\", \"output-extent\")                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     diffraction_patterns                                 \n"
"#define GEGL_OP_C_SOURCE diffraction-patterns.c                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <gegl-buffer-cl-iterator.h>                                          \n"
"#include <gegl-debug.h>                                                       \n"
"                                                                              \n"
"#include \"opencl/diffraction-patterns.cl.h\"                                 \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"#define ITERATIONS      100                                                   \n"
"#define WEIRD_FACTOR    0.04                                                  \n"
"                                                                              \n"
"static gdouble cos_lut[ITERATIONS + 1];                                       \n"
"static gdouble lut1[ITERATIONS + 1];                                          \n"
"static gdouble lut2[ITERATIONS + 1];                                          \n"
"                                                                              \n"
"static void                                                                   \n"
"init_luts (void)                                                              \n"
"{                                                                             \n"
"  gint    i;                                                                  \n"
"  gdouble a;                                                                  \n"
"  gdouble sina;                                                               \n"
"                                                                              \n"
"  a = -G_PI;                                                                  \n"
"                                                                              \n"
"  for (i = 0; i <= ITERATIONS; i++)                                           \n"
"    {                                                                         \n"
"      sina = sin (a);                                                         \n"
"      cos_lut[i] = cos (a);                                                   \n"
"                                                                              \n"
"      lut1[i] = 0.75 * sina;                                                  \n"
"      lut2[i] = 0.5 * (4.0 * cos_lut[i] * cos_lut[i] + sina * sina);          \n"
"                                                                              \n"
"      a += (2.0 * G_PI / ITERATIONS);                                         \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gdouble                                                         \n"
"diff_intensity (gdouble         x,                                            \n"
"                gdouble         y,                                            \n"
"                gdouble         lam,                                          \n"
"                GeglProperties *o)                                            \n"
"{                                                                             \n"
"  gint    i;                                                                  \n"
"  gdouble cxy, sxy;                                                           \n"
"  gdouble p;                                                                  \n"
"  gdouble polpi2;                                                             \n"
"  gdouble cospolpi2, sinpolpi2;                                               \n"
"                                                                              \n"
"  cxy = 0.0;                                                                  \n"
"  sxy = 0.0;                                                                  \n"
"                                                                              \n"
"  lam *= 4.0;                                                                 \n"
"                                                                              \n"
"  for (i = 0; i <= ITERATIONS; i++)                                           \n"
"    {                                                                         \n"
"      p = lam * (cos_lut[i] * x + lut1[i] * y - lut2[i]);                     \n"
"                                                                              \n"
"      cxy += cos (p);                                                         \n"
"      sxy += sin (p);                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  cxy *= WEIRD_FACTOR;                                                        \n"
"  sxy *= WEIRD_FACTOR;                                                        \n"
"                                                                              \n"
"  polpi2 = o->polarization * (G_PI / 2.0);                                    \n"
"                                                                              \n"
"  cospolpi2 = cos (polpi2);                                                   \n"
"  sinpolpi2 = sin (polpi2);                                                   \n"
"                                                                              \n"
"  return o->scattering * ((cospolpi2 + sinpolpi2) * cxy * cxy +               \n"
"                          (cospolpi2 - sinpolpi2) * sxy * sxy);               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"diffract (gdouble         x,                                                  \n"
"          gdouble         y,                                                  \n"
"          gdouble        *r,                                                  \n"
"          gdouble        *g,                                                  \n"
"          gdouble        *b,                                                  \n"
"          GeglProperties *o)                                                  \n"
"{                                                                             \n"
"  *r = fabs (o->red_sedges * sin (o->red_contours * atan (o->brightness *     \n"
"                                             diff_intensity (x, y, o->red_frequency, o))));\n"
"  *g = fabs (o->green_sedges * sin (o->green_contours * atan (o->brightness * \n"
"                                             diff_intensity (x, y, o->green_frequency, o))));\n"
"  *b = fabs (o->blue_sedges * sin (o->blue_contours * atan (o->brightness *   \n"
"                                             diff_intensity (x, y, o->blue_frequency, o))));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B' float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem               out_tex,                                     \n"
"            const GeglRectangle *roi)                                         \n"
"{                                                                             \n"
"  GeglProperties   *o      = GEGL_PROPERTIES (operation);                     \n"
"  const size_t  gbl_size[] = { roi->width, roi->height };                     \n"
"  cl_int        cl_err     = 0;                                               \n"
"  cl_int offset_x;                                                            \n"
"  cl_int offset_y;                                                            \n"
"  cl_int width;                                                               \n"
"  cl_int height;                                                              \n"
"  cl_float3 sedges;                                                           \n"
"  cl_float3 contours;                                                         \n"
"  cl_float3 frequency;                                                        \n"
"  cl_float brightness;                                                        \n"
"  cl_float polarization;                                                      \n"
"  cl_float scattering;                                                        \n"
"  cl_int iterations;                                                          \n"
"  cl_float weird_factor;                                                      \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = { \"cl_diffraction_patterns\", NULL };      \n"
"      cl_data = gegl_cl_compile_and_build (diffraction_patterns_cl_source,    \n"
"                                           kernel_name);                      \n"
"                                                                              \n"
"      if (!cl_data)                                                           \n"
"        return TRUE;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  offset_x = roi->x;                                                          \n"
"  offset_y = roi->y;                                                          \n"
"  width = o->width;                                                           \n"
"  height = o->height;                                                         \n"
"  sedges.s[0] = o->red_sedges;                                                \n"
"  sedges.s[1] = o->green_sedges;                                              \n"
"  sedges.s[2] = o->blue_sedges;                                               \n"
"  contours.s[0] = o->red_contours;                                            \n"
"  contours.s[1] = o->green_contours;                                          \n"
"  contours.s[2] = o->blue_contours;                                           \n"
"  frequency.s[0] = o->red_frequency;                                          \n"
"  frequency.s[1] = o->green_frequency;                                        \n"
"  frequency.s[2] = o->blue_frequency;                                         \n"
"  brightness = o->brightness;                                                 \n"
"  polarization = o->polarization;                                             \n"
"  scattering = o->scattering;                                                 \n"
"  iterations = ITERATIONS;                                                    \n"
"  weird_factor = WEIRD_FACTOR;                                                \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem),    &out_tex,              \n"
"                                    sizeof(cl_int),    &offset_x,             \n"
"                                    sizeof(cl_int),    &offset_y,             \n"
"                                    sizeof(cl_int),    &width,                \n"
"                                    sizeof(cl_int),    &height,               \n"
"                                    sizeof(cl_float3), &sedges,               \n"
"                                    sizeof(cl_float3), &contours,             \n"
"                                    sizeof(cl_float3), &frequency,            \n"
"                                    sizeof(cl_float),  &brightness,           \n"
"                                    sizeof(cl_float),  &polarization,         \n"
"                                    sizeof(cl_float),  &scattering,           \n"
"                                    sizeof(cl_int),    &iterations,           \n"
"                                    sizeof(cl_float),  &weird_factor,         \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, gbl_size, NULL,                 \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clFinish (gegl_cl_get_command_queue ());                      \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"c_process (GeglOperation       *operation,                                    \n"
"           void                *out_buf,                                      \n"
"           const GeglRectangle *roi)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat         *out;                                                        \n"
"  gdouble         r, g, b;                                                    \n"
"  gint            x, y;                                                       \n"
"  gdouble         px, py;                                                     \n"
"  gdouble         dh, dv;                                                     \n"
"                                                                              \n"
"  dh = 10.0 / (o->width - 1);                                                 \n"
"  dv = -10.0 / (o->height - 1);                                               \n"
"  out = out_buf;                                                              \n"
"                                                                              \n"
"  for (y = roi->y; y < roi->y + roi->height; y++)                             \n"
"    {                                                                         \n"
"      for (x = roi->x; x < roi->x + roi->width; x++)                          \n"
"        {                                                                     \n"
"          px = dh * x - 5.0;                                                  \n"
"          py = dv * y + 5.0;                                                  \n"
"                                                                              \n"
"          diffract (px, py, &r, &g, &b, o);                                   \n"
"                                                                              \n"
"          out[0] = r;                                                         \n"
"          out[1] = g;                                                         \n"
"          out[2] = b;                                                         \n"
"                                                                              \n"
"          out += 3;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *out_buf,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"  const Babl         *out_format = gegl_operation_get_format (operation,      \n"
"                                                              \"output\");    \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    {                                                                         \n"
"      GeglBufferClIterator *cl_iter;                                          \n"
"      gboolean              err;                                              \n"
"                                                                              \n"
"      GEGL_NOTE (GEGL_DEBUG_OPENCL, \"GEGL_OPERATION_POINT_RENDER: %s\",      \n"
"                 GEGL_OPERATION_GET_CLASS (operation)->name);                 \n"
"                                                                              \n"
"      cl_iter = gegl_buffer_cl_iterator_new (out_buf, roi, out_format,        \n"
"                                             GEGL_CL_BUFFER_WRITE);           \n"
"                                                                              \n"
"      while (gegl_buffer_cl_iterator_next (cl_iter, &err) && !err)            \n"
"        {                                                                     \n"
"          err = cl_process (operation, cl_iter->tex[0], cl_iter->roi);        \n"
"                                                                              \n"
"          if (err)                                                            \n"
"            {                                                                 \n"
"              gegl_buffer_cl_iterator_stop (cl_iter);                         \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        GEGL_NOTE (GEGL_DEBUG_OPENCL, \"Error: %s\",                          \n"
"                   GEGL_OPERATION_GET_CLASS (operation)->name);               \n"
"      else                                                                    \n"
"        return TRUE;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (out_buf, roi, level, out_format,           \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    c_process (operation, iter->data[0], &iter->roi[0]);                      \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  init_luts();                                                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:diffraction-patterns\",                    \n"
"    \"title\",              _(\"Diffraction Patterns\"),                      \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"reference-hash\",     \"f709e421fe77197f8bd3e23212108823\",             \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\",        _(\"Generate diffraction patterns\"),             \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
