static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2017 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (wavelength, _(\"wavelength\"), 23) // 13                     \n"
"                 value_range (0.0, 100.0)                                     \n"
"                                                                              \n"
"property_double (turbulence, _(\"turbulence\"), 0.111111) // 13               \n"
"                 value_range (0.0, 1.0)                                       \n"
"                                                                              \n"
"property_double (blocksize, _(\"blocksize\"), 3.956933) // 13                 \n"
"                 value_range (0.0, 64.0)                                      \n"
"                 description (_(\"number of wavelengths per local period\"))  \n"
"                                                                              \n"
"property_double (twist, _(\"twist\"), 0.0) // 13                              \n"
"                 value_range (-2.0, 2.0)                                      \n"
"              description (_(\"angle offset for patterns\"))                  \n"
"                                                                              \n"
"property_int (aa, _(\"aa\"), 4) // 13                                         \n"
"              value_range (1, 16)                                             \n"
"              description (_(\"each side of box used for aa super sampling, 3 means 3x3=9 samples\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     patmap                                               \n"
"#define GEGL_OP_C_SOURCE patmap.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  #define factor 100.0                                                        \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"CIE LCH(ab) float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"                                                                              \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *in_pixel = in_buf;                                              \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"  gfloat      wavelength = o->wavelength;                                     \n"
"  gfloat      turbulence = o->turbulence;                                     \n"
"  gfloat      blocksize = o->blocksize;                                       \n"
"                                                                              \n"
"  gint        x = roi->x; /* initial x         */                             \n"
"  gint        y = roi->y; /* and y coordinates */                             \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      float luminance  = in_pixel[0] / factor;                                \n"
"      float chroma     = in_pixel[1] / factor;                                \n"
"      float hue        = in_pixel[2] / factor;                                \n"
"                                                                              \n"
"      float part_white = luminance;                                           \n"
"      float offset     = chroma;                                              \n"
"      float angle      = 1.0-hue + o->twist;                                  \n"
"                                                                              \n"
"      float width      = (wavelength * (1.0 - turbulence) +                   \n"
"                         (wavelength * offset) * turbulence) / (1 << level);  \n"
"                                                                              \n"
"      gfloat  acc = 0.0;                                                      \n"
"      gfloat xi, yi;                                                          \n"
"      float vec0 = cosf (-angle * G_PI / 2);                                  \n"
"      float vec1 = sinf (-angle * G_PI / 2);                                  \n"
"      int aa = level?2:o->aa;                                                 \n"
"      int aa_sq = aa * aa;                                                    \n"
"                                                                              \n"
"      for (xi = x; xi <  x+1; xi += 1.0/aa)                                   \n"
"      {                                                                       \n"
"        float u = fmodf (xi, blocksize * width);                              \n"
"        for (yi = y; yi <  y+1; yi += 1.0/aa)                                 \n"
"        {                                                                     \n"
"          float v = fmodf (yi, blocksize * width);                            \n"
"          float w = vec0 * u + vec1 * v;                                      \n"
"          float period = fmodf (w, width);                                    \n"
"          float phase  = period / width;                                      \n"
"          if (phase < 0.0)                                                    \n"
"            phase *= -1.0;                                                    \n"
"          if (phase < part_white)                                             \n"
"            acc += 1.0 / aa_sq;                                               \n"
"        }                                                                     \n"
"      }                                                                       \n"
"      for (int c = 0; c < 3; c++)                                             \n"
"        out_pixel[c] = acc;                                                   \n"
"      out_pixel[3] = 1.0;                                                     \n"
"                                                                              \n"
"      out_pixel += 4;                                                         \n"
"      in_pixel  += 3;                                                         \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      x++;                                                                    \n"
"      if (x>=roi->x + roi->width)                                             \n"
"        {                                                                     \n"
"          x=roi->x;                                                           \n"
"          y++;                                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"                                                                              \n"
"    \"name\",               \"gegl:patmap\",                                  \n"
"    \"title\",              _(\"patmap\"),                                    \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\" ,        \"render\",                                       \n"
"    \"reference-hash\",     \"cc9c401d7c8bcea7147499ecbeda9986\",             \n"
"    \"description\",        _(\"Patternmapper, mapping colors to monochrome pattern features\"),\n"
"    \"position-dependent\", \"true\",                                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
