static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2006 Geert Jordaens <geert.jordaens@telenet.be>                  \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     svg_luminancetoalpha                                 \n"
"#define GEGL_OP_C_SOURCE svg-luminancetoalpha.c                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RaGaBaA float\");                       \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gfloat      *in = in_buf;                                                   \n"
"  gfloat      *out = out_buf;                                                 \n"
"  gfloat      *m;                                                             \n"
"                                                                              \n"
"  gfloat ma[25] = { 0.0,      0.0,      0.0,     0.0, 0.0,                    \n"
"                    0.0,      0.0,      0.0,     0.0, 0.0,                    \n"
"                    0.0,      0.0,      0.0,     0.0, 0.0,                    \n"
"                    0.2125,   0.7154,   0.0721,  0.0, 0.0,                    \n"
"                    0.0,      0.0,      0.0,     0.0, 1.0};                   \n"
"  glong        i;                                                             \n"
"                                                                              \n"
"  m = ma;                                                                     \n"
"  for (i=0; i<n_pixels; i++)                                                  \n"
"    {                                                                         \n"
"      out[0] =  m[0]  * in[0] +  m[1]  * in[1] + m[2]  * in[2] + m[3]  * in[3] + m[4];\n"
"      out[1] =  m[5]  * in[0] +  m[6]  * in[1] + m[7]  * in[2] + m[8]  * in[3] + m[9];\n"
"      out[2] =  m[10] * in[0] +  m[11] * in[1] + m[12] * in[2] + m[13] * in[3] + m[14];\n"
"      out[3] =  m[15] * in[0] +  m[16] * in[1] + m[17] * in[2] + m[18] * in[3] + m[19];\n"
"      in  += 4;                                                               \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:svg-luminancetoalpha\",                           \n"
"    \"categories\" , \"compositors:svgfilter\",                               \n"
"    \"title\"      , _(\"SVG Luminance to Alpha\"),                           \n"
"    \"reference-hash\", \"6763517c5421d736b855ffa2ebd845c9\",                 \n"
"    \"description\",                                                          \n"
"       _(\"SVG color matrix operation svg_luminancetoalpha\"),                \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
