static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int    (x, _(\"Width\"), 32)                                         \n"
"    description (_(\"Horizontal width of cells pixels\"))                     \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 128)                                                      \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (y, _(\"Height\"), 32)                                        \n"
"    description (_(\"Vertical width of cells pixels\"))                       \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 128)                                                      \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_int    (x_offset, _(\"Offset X\"), 0)                                \n"
"    description (_(\"Horizontal offset (from origin) for start of grid\"))    \n"
"    ui_range    (-64, 64)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-coordinate\")                              \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (y_offset, _(\"Offset Y\"), 0)                                \n"
"    description (_(\"Vertical offset (from origin) for start of grid\"))      \n"
"    ui_range    (-64, 64)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-coordinate\")                              \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_int    (line_width, _(\"Line width\"), 4)                            \n"
"    description (_(\"Width of grid lines in pixels\"))                        \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 16)                                                       \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (line_height, _(\"Line height\"), 4)                          \n"
"    description (_(\"Height of grid lines in pixels\"))                       \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 16)                                                       \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_color (line_color, _(\"Color\"), \"black\")                          \n"
"    description (_(\"Color of the grid lines\"))                              \n"
"    ui_meta     (\"role\",    \"color-primary\")                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_C_SOURCE grid.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"  gfloat      line_color[4];                                                  \n"
"  gint        x = roi->x; /* initial x         */                             \n"
"  gint        y = roi->y; /* and y coordinates */                             \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->line_color, babl_format (\"RGBA float\"), line_color);\n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gint nx,ny;                                                             \n"
"                                                                              \n"
"      nx = (x - o->x_offset) % o->x;                                          \n"
"      ny = (y - o->y_offset) % o->y;                                          \n"
"      /* handle case where % returns a negative number */                     \n"
"      nx += nx < 0 ? o->x : 0;                                                \n"
"      ny += ny < 0 ? o->y : 0;                                                \n"
"                                                                              \n"
"      if (nx < o->line_width || ny < o->line_height)                          \n"
"        {                                                                     \n"
"          out_pixel[0]=line_color[0];                                         \n"
"          out_pixel[1]=line_color[1];                                         \n"
"          out_pixel[2]=line_color[2];                                         \n"
"          out_pixel[3]=line_color[3];                                         \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          out_pixel[0]=0.0f;                                                  \n"
"          out_pixel[1]=0.0f;                                                  \n"
"          out_pixel[2]=0.0f;                                                  \n"
"          out_pixel[3]=0.0f;                                                  \n"
"        }                                                                     \n"
"                                                                              \n"
"      out_pixel += 4;                                                         \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      x++;                                                                    \n"
"      if (x>=roi->x + roi->width)                                             \n"
"        {                                                                     \n"
"          x=roi->x;                                                           \n"
"          y++;                                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:grid\",                                    \n"
"    \"title\",              _(\"Grid\"),                                      \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\" ,        \"render\",                                       \n"
"    \"description\",        _(\"Grid renderer\"),                             \n"
"    \"position-dependent\", \"true\",                                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
