static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1995 Spencer Kimball and Peter Mattis                            \n"
" * Copyright 1996 Torsten Martinsen                                           \n"
" * Copyright 2007 Daniel Richard G.                                           \n"
" * Copyright 2011 Hans Lo <hansshulo@gmail.com>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int    (mask_radius, _(\"Mask Radius\"), 4)                          \n"
"    description (_(\"Radius of circle around pixel\"))                        \n"
"    value_range (1, 100)                                                      \n"
"    ui_range (1, 25)                                                          \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_int    (exponent, _(\"Exponent\"), 8)                                \n"
"    value_range (1, 20)                                                       \n"
"                                                                              \n"
"property_int (intensities, _(\"Number of intensities\"), 128)                 \n"
"    description(_(\"Histogram size\"))                                        \n"
"    value_range (8, 256)                                                      \n"
"                                                                              \n"
"property_boolean (use_inten, _(\"Intensity Mode\"), TRUE)                     \n"
"    description(_(\"Use pixel luminance values\"))                            \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE oilify.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define NUM_INTENSITIES       256                                             \n"
"                                                                              \n"
"/* Get the pixel from x, y offset from the center pixel src_pix */            \n"
"static void                                                                   \n"
"get_pixel (gint    x,                                                         \n"
"           gint    y,                                                         \n"
"           gint    buf_width,                                                 \n"
"           gfloat *src_begin,                                                 \n"
"           gfloat *dst)                                                       \n"
"{                                                                             \n"
"  gint b;                                                                     \n"
"  gfloat* src = src_begin + 4*(x + buf_width*y);                              \n"
"  for (b = 0; b < 4; b++)                                                     \n"
"    {                                                                         \n"
"      dst[b] = src[b];                                                        \n"
"    }                                                                         \n"
"}                                                                             \n"
"static void                                                                   \n"
"get_pixel_inten (gint    x,                                                   \n"
"                 gint    y,                                                   \n"
"                 gint    buf_width,                                           \n"
"                 gfloat *inten_begin,                                         \n"
"                 gfloat *dst)                                                 \n"
"{                                                                             \n"
"  *dst = *(inten_begin + (x + buf_width*y));                                  \n"
"}                                                                             \n"
"static void                                                                   \n"
"oilify_pixel_inten (gint     x,                                               \n"
"                    gint     y,                                               \n"
"                    gdouble  radius,                                          \n"
"                    gint     exponent,                                        \n"
"                    gint     intensities,                                     \n"
"                    gint     buf_width,                                       \n"
"                    gfloat  *src_buf,                                         \n"
"                    gfloat  *inten_buf,                                       \n"
"                    gfloat  *dst_pixel)                                       \n"
"{                                                                             \n"
"  gfloat cumulative_rgb[4][NUM_INTENSITIES];                                  \n"
"  gint   hist_inten[NUM_INTENSITIES];                                         \n"
"  gfloat mult_inten;                                                          \n"
"  gfloat temp_pixel[4];                                                       \n"
"  gint   ceil_radius = ceil (radius);                                         \n"
"  gdouble radius_sq = radius*radius;                                          \n"
"  gint i, j, b;                                                               \n"
"  gint inten_max;                                                             \n"
"  gint intensity;                                                             \n"
"  gfloat ratio, temp_inten_pixel;                                             \n"
"  gfloat weight;                                                              \n"
"  gfloat color[4];                                                            \n"
"  gfloat div;                                                                 \n"
"  for (i = 0; i < intensities; i++)                                           \n"
"    {                                                                         \n"
"      hist_inten[i] = 0;                                                      \n"
"      for (b = 0; b < 4; b++)                                                 \n"
"          cumulative_rgb[b][i] = 0.0;                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* calculate histograms */                                                  \n"
"  for (i = -ceil_radius; i <= ceil_radius; i++)                               \n"
"    {                                                                         \n"
"      for (j = -ceil_radius; j <= ceil_radius; j++)                           \n"
"        {                                                                     \n"
"          if (i*i + j*j <= radius_sq)                                         \n"
"            {                                                                 \n"
"              get_pixel (x + i,                                               \n"
"                         y + j,                                               \n"
"                         buf_width,                                           \n"
"                         src_buf,                                             \n"
"                         temp_pixel);                                         \n"
"              get_pixel_inten (x + i,                                         \n"
"                               y + j,                                         \n"
"                               buf_width,                                     \n"
"                               inten_buf,                                     \n"
"                               &temp_inten_pixel);                            \n"
"              intensity = temp_inten_pixel * (intensities - 1);               \n"
"              hist_inten[intensity]++;                                        \n"
"              for (b = 0; b < 4; b++)                                         \n"
"                {                                                             \n"
"                  cumulative_rgb[b][intensity] += temp_pixel[b];              \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  inten_max = 1;                                                              \n"
"                                                                              \n"
"  /* calculated maximums */                                                   \n"
"  for (i = 0; i < intensities; i++) {                                         \n"
"    inten_max = MAX (inten_max, hist_inten[i]);                               \n"
"  }                                                                           \n"
"                                                                              \n"
"  /* calculate weight and use it to set the pixel */                          \n"
"  div = 0.0;                                                                  \n"
"                                                                              \n"
"  for (b = 0; b < 4; b++)                                                     \n"
"    color[b] = 0.0;                                                           \n"
"  for (i = 0; i < intensities; i++)                                           \n"
"    {                                                                         \n"
"      if (hist_inten[i] > 0)                                                  \n"
"      {                                                                       \n"
"        ratio = (gfloat) hist_inten[i] / (gfloat) inten_max;                  \n"
"                                                                              \n"
"        /* using this instead of pow function gives HUGE performance improvement\n"
"           but we cannot use floating point exponent... */                    \n"
"        weight = 1.;                                                          \n"
"        for(j = 0; j < exponent; j++)                                         \n"
"          weight *= ratio;                                                    \n"
"        /* weight = powf(ratio, exponent); */                                 \n"
"        mult_inten = weight / (gfloat) hist_inten[i];                         \n"
"                                                                              \n"
"        div += weight;                                                        \n"
"        for (b = 0; b < 4; b++)                                               \n"
"          color[b] += mult_inten * cumulative_rgb[b][i];                      \n"
"      }                                                                       \n"
"    }                                                                         \n"
"  for (b = 0; b < 4; b++)                                                     \n"
"    dst_pixel[b] = color[b]/div;                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"oilify_pixel (gint           x,                                               \n"
"              gint           y,                                               \n"
"              gdouble        radius,                                          \n"
"              gint           exponent,                                        \n"
"              gint           intensities,                                     \n"
"              gint           buf_width,                                       \n"
"              gfloat        *src_buf,                                         \n"
"              gfloat        *dst_pixel)                                       \n"
"{                                                                             \n"
"  gint   hist[4][NUM_INTENSITIES];                                            \n"
"  gfloat temp_pixel[4];                                                       \n"
"  gint   ceil_radius = ceil (radius);                                         \n"
"  gdouble radius_sq = radius*radius;                                          \n"
"  gint i, j, b;                                                               \n"
"  gint hist_max[4];                                                           \n"
"  gint intensity;                                                             \n"
"  gfloat sum[4];                                                              \n"
"  gfloat ratio;                                                               \n"
"  gfloat weight;                                                              \n"
"  gfloat result[4];                                                           \n"
"  gfloat div[4];                                                              \n"
"  for (i = 0; i < intensities; i++)                                           \n"
"    {                                                                         \n"
"      for (b = 0; b < 4; b++)                                                 \n"
"        {                                                                     \n"
"          hist[b][i] = 0;                                                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* calculate histograms */                                                  \n"
"  for (i = -ceil_radius; i <= ceil_radius; i++)                               \n"
"    {                                                                         \n"
"      for (j = -ceil_radius; j <= ceil_radius; j++)                           \n"
"        {                                                                     \n"
"          if (i*i + j*j <= radius_sq)                                         \n"
"            {                                                                 \n"
"              get_pixel (x + i,                                               \n"
"                         y + j,                                               \n"
"                         buf_width,                                           \n"
"                         src_buf,                                             \n"
"                         temp_pixel);                                         \n"
"              for (b = 0; b < 4; b++)                                         \n"
"                {                                                             \n"
"                  intensity = temp_pixel[b] * (intensities - 1);              \n"
"                  hist[b][intensity]++;                                       \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"    for (b = 0; b < 4; b++)                                                   \n"
"      hist_max[b] = 1;                                                        \n"
"    for (i = 0; i < intensities; i++) {                                       \n"
"      for (b = 0; b < 4; b++)                                                 \n"
"        if(hist_max[b] < hist[b][i]) /* MAX macros too slow here */           \n"
"          hist_max[b] = hist[b][i];                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* calculate weight and use it to set the pixel */                          \n"
"                                                                              \n"
"    for (b = 0; b < 4; b++)                                                   \n"
"      {                                                                       \n"
"        sum[b] = 0.0;                                                         \n"
"        div[b] = 0.0;                                                         \n"
"      }                                                                       \n"
"    for (i = 0; i < intensities; i++)                                         \n"
"      {                                                                       \n"
"        /* UNROLL this bottleneck loop, up to 50% faster */                   \n"
"        #define DO_HIST_STEP(b) if(hist[b][i] > 0)                          \\\n"
"          {                                                                 \\\n"
"            ratio = (gfloat) hist[b][i] / (gfloat) hist_max[b];             \\\n"
"            weight = 1.;                                                    \\\n"
"            for(j = 0; j < exponent; j++)                                   \\\n"
"              weight *= ratio;                                              \\\n"
"            sum[b] += weight * (gfloat) i;                                  \\\n"
"            div[b] += weight;                                               \\\n"
"          }                                                                   \n"
"                                                                              \n"
"        DO_HIST_STEP(0)                                                       \n"
"        DO_HIST_STEP(1)                                                       \n"
"        DO_HIST_STEP(2)                                                       \n"
"        DO_HIST_STEP(3)                                                       \n"
"        #undef DO_HIST_STEP                                                   \n"
"      }                                                                       \n"
"                                                                              \n"
"    for (b = 0; b < 4; b++)                                                   \n"
"      {                                                                       \n"
"        result[b] = sum[b] / (gfloat) (intensities - 1);                      \n"
"        dst_pixel[b] = result[b]/div[b];                                      \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties              *o;                                             \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"                                                                              \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"  o       = GEGL_PROPERTIES (operation);                                      \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  =                                                           \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = o->mask_radius;                                           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/oilify.cl.h\"                                               \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_oilify (cl_mem              in_tex,                                        \n"
"           cl_mem              out_tex,                                       \n"
"           size_t              global_worksize,                               \n"
"           const GeglRectangle *roi,                                          \n"
"           gint                mask_radius,                                   \n"
"           gint                number_of_intensities,                         \n"
"           gint                exponent,                                      \n"
"           gboolean            use_inten)                                     \n"
"{                                                                             \n"
"                                                                              \n"
"  const size_t gbl_size[2] = {roi->width,roi->height};                        \n"
"  cl_int radius      = mask_radius;                                           \n"
"  cl_int intensities = number_of_intensities;                                 \n"
"  cl_float exp       = (gfloat)exponent;                                      \n"
"  cl_int cl_err      = 0;                                                     \n"
"  gint arg = 0;                                                               \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"kernel_oilify\", \"kernel_oilify_inten\", NULL};\n"
"      cl_data = gegl_cl_compile_and_build(oilify_cl_source, kernel_name);     \n"
"    }                                                                         \n"
"  if (!cl_data)  return TRUE;                                                 \n"
"                                                                              \n"
"  /* simple hack: select suitable kernel using boolean, 0 - no intensity mode, 1 - intensity mode */\n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[use_inten], arg++, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[use_inten], arg++, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[use_inten], arg++, sizeof(cl_int),   (void*)&radius);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[use_inten], arg++, sizeof(cl_int),   (void*)&intensities);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[use_inten], arg++, sizeof(cl_float), (void*)&exp);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue(),           \n"
"                                       cl_data->kernel[use_inten], 2,         \n"
"                                       NULL, gbl_size, NULL,                  \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err;                                                                   \n"
"                                                                              \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             o->mask_radius,                  \n"
"                                             o->mask_radius,                  \n"
"                                             o->mask_radius,                  \n"
"                                             o->mask_radius,                  \n"
"                                             GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err) return FALSE;                                                  \n"
"                                                                              \n"
"      err = cl_oilify(i->tex[read],                                           \n"
"                      i->tex[0],                                              \n"
"                      i->size[0],                                             \n"
"                      &i->roi[0],                                             \n"
"                      o->mask_radius,                                         \n"
"                      o->intensities,                                         \n"
"                      o->exponent,                                            \n"
"                      o->use_inten);                                          \n"
"                                                                              \n"
"      if (err) return FALSE;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o                = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  gint x = o->mask_radius; /* initial x                   */                  \n"
"  gint y = o->mask_radius; /*           and y coordinates */                  \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"  gfloat *inten_buf;                                                          \n"
"  gfloat *out_pixel;                                                          \n"
"  gint n_pixels = result->width * result->height;                             \n"
"  GeglRectangle src_rect;                                                     \n"
"  gint total_pixels;                                                          \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, result))                        \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  src_rect.x      = result->x - op_area->left;                                \n"
"  src_rect.width  = result->width + op_area->left + op_area->right;           \n"
"  src_rect.y      = result->y - op_area->top;                                 \n"
"  src_rect.height = result->height + op_area->top + op_area->bottom;          \n"
"                                                                              \n"
"  total_pixels = src_rect.width * src_rect.height;                            \n"
"                                                                              \n"
"  src_buf = gegl_malloc (4 * total_pixels * sizeof (gfloat));                 \n"
"  dst_buf = gegl_malloc (4 * n_pixels * sizeof (gfloat));                     \n"
"  if (o->use_inten)                                                           \n"
"    inten_buf = gegl_malloc (total_pixels * sizeof (gfloat));                 \n"
"  else                                                                        \n"
"    inten_buf = NULL;                                                         \n"
"                                                                              \n"
"  gegl_buffer_get (input, &src_rect, 1.0, babl_format (\"RGBA float\"),       \n"
"                   src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);           \n"
"                                                                              \n"
"  if (inten_buf)                                                              \n"
"    gegl_buffer_get (input, &src_rect, 1.0, babl_format (\"Y float\"),        \n"
"                   inten_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);         \n"
"                                                                              \n"
"  out_pixel = dst_buf;                                                        \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      if (inten_buf)                                                          \n"
"        oilify_pixel_inten (x, y, o->mask_radius, o->exponent, o->intensities,\n"
"                   src_rect.width, src_buf, inten_buf, out_pixel);            \n"
"      else                                                                    \n"
"        oilify_pixel (x, y, o->mask_radius, o->exponent, o->intensities,      \n"
"                   src_rect.width, src_buf, out_pixel);                       \n"
"      out_pixel += 4;                                                         \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      x++;                                                                    \n"
"      if (x >= result->width + o->mask_radius)                                \n"
"        {                                                                     \n"
"          x=o->mask_radius;                                                   \n"
"          y++;                                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0,                                         \n"
"                   babl_format (\"RGBA float\"),                              \n"
"                   dst_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"  gegl_free (src_buf);                                                        \n"
"  gegl_free (dst_buf);                                                        \n"
"  if (inten_buf)                                                              \n"
"    gegl_free (inten_buf);                                                    \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"                                 \"categories\" , \"artistic\",               \n"
"                                 \"name\"       , \"gegl:oilify\",            \n"
"                                 \"title\",      _(\"Oilify\"),               \n"
"                                 \"license\",     \"GPL3+\",                  \n"
"                                 \"description\",_(\"Emulate an oil painting\"),\n"
"                                 NULL);                                       \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
