#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define MAGIC             'G'
#define SCRIPT_FU_SERVER  "zarathustra"
#define SCRIPT_FU_PORT    10008

void send_command (char *);
void init_sockaddr (struct sockaddr_in *, const char *, unsigned short int);
int  dnet_connect (char *, int);
int  dnet_disconnect (void);
int  dnet_send (unsigned char *, int);
int  dnet_recv (void);
char *star_to_space (char *);

/* The name of this program, as taken from argv[0]. */
static char *progname;
static int sock;

static void
fatal_error (char *message)
{
  printf ("<head><title>Net-Fu Output</title></head>\n");
  printf ("<body bgcolor=white text=red>\n");
  printf ("<center>\n");
  printf ("<h1>Net-Fu Failure Notice</h1>\n");
  printf ("<table width=500 border=0>\n");
  printf ("<tr>\n");
  printf ("<td valign=top><img src=http://%s/net-fu/images/beavis.gif></td>\n", SCRIPT_FU_SERVER);
  printf ("<td><center>Net-Fu did not create your requested logo<br>\n"
	  "It reported: %s<br>\n"
	  "Check your arguments (especially URLs) and try again.</center></td>\n", message);
  printf ("</tr></table></center>\n");
  printf ("<br><p>\n");
  printf ("<hr>\n");
  printf ("<a href=http://www.gimp.org/>\n");
  printf ("<img align=right src=http://%s/net-fu/images/gbg.gif "
	  "width=65 height=27></a>\n", SCRIPT_FU_SERVER);
  printf ("</body>\n");

  exit (1);
}

static char *
prune_filename (char *filename)
{
  char *last_slash = filename;

  while (*filename)
    if (*filename++ == '/')
      last_slash = filename;

  return last_slash;
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  char *args;

  progname = argv[0];

  args = argv[1];
  printf ("Content-type: text/html\n\n");

  /*  This is unfortunate, but necessary on some systems  */
  unescape_shell_cmd (args);

  /*  Transform the stars to spaces!  */
  args = star_to_space (args);

  dnet_connect (SCRIPT_FU_SERVER, SCRIPT_FU_PORT);

  send_command (args);

  dnet_disconnect ();

  return 0;
}

void
send_command (command)
     char *command;
{
  char *buffer;
  int length;

  length = strlen (command);
  buffer = (unsigned char *) malloc (length + 3);

  sprintf (buffer, "%c%c%c%s",
	   MAGIC,
	   (length >> 8),
	   (length & 0xff),
	   command);

  dnet_send (buffer, length + 3);
  dnet_recv ();
}


void
init_sockaddr (struct sockaddr_in *name,
               const char *hostname,
               unsigned short int port)
{
  struct hostent *hostinfo;

  name->sin_family = AF_INET;
  name->sin_port = htons (port);
  hostinfo = gethostbyname (hostname);
  if (hostinfo == NULL)
    fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");
  name->sin_addr = *(struct in_addr *) hostinfo->h_addr;
}

int
dnet_connect (server, port)
     char *server;
     int port;
{
  struct sockaddr_in servername;

  /* Create the socket.  */
  sock = socket (PF_INET, SOCK_STREAM, 0);
  if (sock < 0)
    fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");

  /* Connect to the server.  */
  init_sockaddr (&servername, server, port);
  if (0 > connect (sock,
                   (struct sockaddr *) &servername,
                   sizeof (servername)))
    fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");

  return 0;
}

int
dnet_disconnect ()
{
  close (sock);
  return 0;
}

int
dnet_send (data, len)
     unsigned char *data;
     int len;
{
  int nbytes;

  while (len > 0)
    {
      if ((nbytes = write (sock, data, len)) < 0)
	fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");
      data += nbytes;
      len -= nbytes;
    }

  return 0;
}

int
dnet_recv ()
{
  int nbytes;
  int length;
  char header[4];
  char *message;
  char *str;

  length = 4;
  str = header;
  while (length > 0)
    {
      if ((nbytes = read (sock, str, length)) < 0)
	fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");
      str += nbytes;
      length -= nbytes;
    }

  if (header[0] != MAGIC)
    fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");

  length = (header[2] << 8) + header[3];
  message = (char *) malloc (length + 1);
  message[length] = 0;
  str = message;

  while (length > 0)
    {
      if ((nbytes = read (sock, str, length)) < 0)
	fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");
      str += nbytes;
      length -= nbytes;
    }

  if (header[1] == 0)
    {
      printf ("<head><title>Net-Fu Output</title></head>\n");
      printf ("<body bgcolor=white>\n");
      printf ("<center>\n");
      printf ("<h1>Net-Fu Logo</h1>\n<p>\n");
      printf ("<img src=http://%s/net-fu/tmp/%s>\n", SCRIPT_FU_SERVER, prune_filename (message));
      printf ("</center>\n");
      printf ("<br><p>\n");
      printf ("<hr>\n");
      printf ("<a href=http://www.gimp.org/>\n");
      printf ("<img align=right src=http://%s/net-fu/images/gbg.gif "
	      "width=65 height=27></a>\n", SCRIPT_FU_SERVER);
      printf ("</body>\n");
      return 0;
    }
  else
    fatal_error ("Net-Fu server is temporarily unavailable.  Try again later");

  return 1;
}
