package netfu.selectors;

import java.awt.*;
import java.lang.*;

import netfu.*;
import netfu.selectors.Selector;

public class ColorPicker extends Panel implements Selector, Runnable {

    boolean redraw_bar = false;
    boolean deathmatch;
    boolean rgb_model = true;
    float hsbvals[];
    Color tmpcolor = new Color(0);

    int R,G,B;
    float H,S,L;
    int SCALE = 8;

    int R_LOC = 128;
    int G_LOC = 128;
    int B_LOC = 128;

    int SLIDER_VALUE = 128;
    int OLD_SLIDER_VALUE = 128;

    int Color_Location_X = 128;
    int Color_Location_Y = 128;

    int Last_X = 128;
    int Last_Y = 128;

    colorCheckbox RED = new colorCheckbox();
    colorCheckbox GREEN = new colorCheckbox();
    colorCheckbox BLUE = new colorCheckbox();
    colorCheckbox HUE = new colorCheckbox();
    colorCheckbox SAT = new colorCheckbox();
    colorCheckbox LUM = new colorCheckbox();

    myCheckbox by2 = new myCheckbox();
    myCheckbox by4 = new myCheckbox();
    myCheckbox by8 = new myCheckbox();
    myCheckbox by16 = new myCheckbox();

    Selector caller;
    Panel panel;
    public ColorPicker (Selector _caller, int red, int green, int blue) {
	caller = _caller;
	R_LOC = red; G_LOC = green; B_LOC = blue;
//	R = (int) (red / 255); G = (int) (green / 255); B = (int) (blue / 255);
	init ();
    }

    public int red () { return R_LOC; }
    public int green () { return G_LOC; }
    public int blue () { return B_LOC; }

    public Object selectedValue () { return new Object(); }

    public void selectValue (Object o) {
	caller.selectValue (o);
    }

    public java.awt.Component component() { return this; }

    public void init() {
	CheckboxGroup GROUP = new CheckboxGroup();
	CheckboxGroup SCALE_GROUP = new CheckboxGroup();

	resize(435,255);
	setLayout(null);
	RED.reshape(315,68,16,16);
	RED.setCheckboxGroup(GROUP);
	RED.Value = 0;
	add(RED);
	GREEN.reshape(315,92,16,16);
	GREEN.setCheckboxGroup(GROUP);
	GREEN.Value = 1;
	add(GREEN);
	BLUE.reshape(315,116,16,16);
	BLUE.setCheckboxGroup(GROUP);
	BLUE.setState (true);
	BLUE.Value = 2;
	add(BLUE);

	HUE.reshape(315,140,16,16);
	HUE.setCheckboxGroup(GROUP);
	HUE.Value = 3;
	add(HUE);
	HUE.setState (true);
	SAT.reshape(315,164,16,16);
	SAT.setCheckboxGroup(GROUP);
	SAT.Value = 4;
	add(SAT);
	LUM.reshape(315,188,16,16);
	LUM.setCheckboxGroup(GROUP);
	LUM.Value = 5;
	add(LUM);

	by2.setCheckboxGroup(SCALE_GROUP);
	by2.reshape(315,230,16,16);
	by2.myvalue=2;
	add(by2);
	by4.setCheckboxGroup(SCALE_GROUP);
	by4.reshape(340,230,16,16);
	by4.myvalue=4;
	add(by4);
	by8.setCheckboxGroup(SCALE_GROUP);
	by8.reshape(365,230,16,16);
	by8.myvalue=8;
	by8.setState(true);
	add(by8);
	by16.setCheckboxGroup(SCALE_GROUP);
	by16.reshape(390,230,16,16);
	by16.myvalue=16;
	add(by16);

	redraw_bar = true;

	hsbvals = tmpcolor.RGBtoHSB (R_LOC, G_LOC, B_LOC, hsbvals);
	H = hsbvals[0];
	S = hsbvals[1];
	L = hsbvals[2];

	SLIDER_VALUE = (int) (H * 255);
	Color_Location_X = (int) (S * 255);
	Color_Location_Y = (int) (L * 255);
	rgb_model = false;

	repaint ();
	show ();
	repaint ();
    }

    public void run() {
	repaint();
	do {
	    try {
		Thread.sleep(100);
                        }
	    catch (InterruptedException e) {
		return;
                        }
	} while (!deathmatch);
        }

        public void start() {
                deathmatch=false;
                (new Thread(this)).start();
        }

        public void stop() {
                deathmatch=true;
        }

        public void set_slider_values(int val){
                if (rgb_model){
                        if (RED.getState()){
                                R_LOC = val;
                        }
                        else if (GREEN.getState()){
                                G_LOC = val;
                        }
                        else if (BLUE.getState()){
                                B_LOC = val;
                        }
                }
                else{
                        if (HUE.getState()){
                                H = (float)val / 255;
                        }
                        else if (SAT.getState()){
                                S =  (float)val / 255;
                        }
                        else if (LUM.getState()){
                                L =  (float)val / 255;
                        }
                }
        }

        public void setColorLoc(int x, int y){
                if (rgb_model){
                        if (RED.getState()){
                                G_LOC = x;
                                B_LOC = y;
                        }
                        else if (GREEN.getState()){
                                R_LOC = x;
                                B_LOC = y;
                        }
                        else if (BLUE.getState()){
                                R_LOC = x;
                                G_LOC = y;
                        }
                }
                else{
                        if (HUE.getState()){
                                S = (float)x / 255;
                                L = (float)y / 255;

                        }
                        else if (SAT.getState()){
                                H = (float)x / 255;
                                L = (float)y / 255;
                        }
                        else if (LUM.getState()){
                                H = (float)x / 255;
                                S = (float)y / 255;
                        }
                }

        }

  // Mouse Event Handlers



       public boolean mouseDrag(Event evt, int x, int y) {
                if (x < 255 && y < 255){

                        if (x < 1) x = 1;
                        if (y < 1) y = 1;

                        Color_Location_X = x;
                        Color_Location_Y = y;

                        Last_X = Color_Location_X;
                        Last_Y = Color_Location_Y;

                        setColorLoc(x,y);
                }

                else if (x > 270 && x < 295 && y < 255){
                        SLIDER_VALUE = y;
                        if (SLIDER_VALUE < 1) SLIDER_VALUE = 0;
                        set_slider_values(SLIDER_VALUE);
                }
                redraw_bar = true;
                repaint();
                return true;
        }

        public boolean mouseDown(Event evt, int x, int y) {
                if (x < 255 && y < 255){
                        Last_X = Color_Location_X;
                        Last_Y = Color_Location_Y;

                        Color_Location_X = x;
                        Color_Location_Y = y;
                        setColorLoc(x,y);
                }
                else if (x > 270 && x < 295 && y < 255){
                        SLIDER_VALUE = y;
                        set_slider_values(SLIDER_VALUE);
                }
                repaint();
                return true;
        }

  //Draw Background
        public void paint(Graphics g) {
                Dimension d=size();
                g.setColor(new Color(194,194,194));
                g.fillRect(0,0, d.width, d.height);
                repaint();
        }

  //Update is the biggie here, should be split up into smaller functions
        public void update(Graphics g) {
                float tmph, tmps, tmpl;
                String tmp = new String();

		//Erase stuff that will be redrawn
                g.setColor(new Color(194,194,194));
                g.drawLine(268,OLD_SLIDER_VALUE-5,273,OLD_SLIDER_VALUE);
                g.drawLine(268,OLD_SLIDER_VALUE+5,273,OLD_SLIDER_VALUE);
                g.drawLine(268,OLD_SLIDER_VALUE-5,268,OLD_SLIDER_VALUE+5);

                g.setColor(new Color(0,0,0));
                g.drawLine(268,SLIDER_VALUE-5,273,SLIDER_VALUE);
                g.drawLine(268,SLIDER_VALUE+5,273,SLIDER_VALUE);
                g.drawLine(268,SLIDER_VALUE-5,268,SLIDER_VALUE+5);

                OLD_SLIDER_VALUE = SLIDER_VALUE;

                for (int i = 0; i < 255; i += SCALE){
                        for (int j = 0; j < 255; j += SCALE){
                                if (rgb_model){
                                        if (RED.getState()){
                                          g.setColor(new Color(SLIDER_VALUE,i,j));
                                        }
                                        else if (GREEN.getState()){
                                          g.setColor(new Color(i,SLIDER_VALUE,j));
                                        }
                                        else if (BLUE.getState()){
                                          g.setColor(new Color(i,j,SLIDER_VALUE));
                                        }
                                }
                                else {
                                        if (HUE.getState()){
                                                tmph = (float)SLIDER_VALUE / 255;
                                                tmps = (float)i / 255;
                                                tmpl = (float)j / 255;
                                                g.setColor(new Color(tmpcolor.HSBtoRGB(tmph,tmps,tmpl)));
                                        }

                                        else if (SAT.getState()){
                                                tmph = (float)i / 255;
                                                tmps = (float)SLIDER_VALUE / 255;
                                                tmpl = (float)j / 255;
                                                g.setColor(new Color(tmpcolor.HSBtoRGB(tmph,tmps,tmpl)));
                                        }

                                        else if (LUM.getState()){
                                                tmph = (float)i / 255;
                                                tmps = (float)j / 255;
                                                tmpl = (float)SLIDER_VALUE / 255;
                                                g.setColor(new Color(tmpcolor.HSBtoRGB(tmph,tmps,tmpl)));
                                        }

                                }
                                g.fillRect(i,j,SCALE,SCALE);
                        }

                        if (rgb_model){
                                if (RED.getState()){
                                  g.setColor(new Color(i,0,0));
                                }
                                else if (GREEN.getState()){
                                  g.setColor(new Color(0,i,0));
                                }
                                else if (BLUE.getState()){
                                  g.setColor(new Color(0,0,i));
                                }
                        }
                        else{
                                        if (HUE.getState()){
                                                tmph = (float)i / 255;
                                                g.setColor(new Color(tmpcolor.HSBtoRGB(tmph,S,L)));
                                        }

                                        else if (SAT.getState()){
                                                tmps = (float)i / 255;
                                                g.setColor(new Color(tmpcolor.HSBtoRGB(H,tmps,L)));
                                        }

                                        else if (LUM.getState()){
                                                tmpl = (float)i / 255;
                                                g.setColor(new Color(tmpcolor.HSBtoRGB(H,S,tmpl)));
                                        }
                        }

                        g.fillRect(275,i,20,SCALE);
                }

		//Erase area to right of square, in case the circles have been drawn there
                if (Last_X > 249 || Last_X < 256){
                        g.setColor(new Color(194,194,194));

                        if (redraw_bar){
                                g.fillRect(256,0,6,256);
                                redraw_bar = false;
                        }

                        else{
                                g.fillRect(256,Last_Y-3,6,12);
                        }
                }

		//Draw the white circle
                g.setColor(new Color(255,255,255));
                g.drawOval(Color_Location_X,Color_Location_Y,4,4);

		//Draw the black circle
                g.setColor(new Color(0,0,0));
                g.drawOval(Color_Location_X-1,Color_Location_Y-1,6,6);

		//Draw RGB and HSL labels
                g.drawString("R:",341,79);
                g.drawString("G:",340,103);
                g.drawString("B:",342,127);
                g.drawString("H:",341,151);
                g.drawString("S:",342,175);
                g.drawString("L:",342,199);
                g.drawString("HEX:",324,223);

		//Draw the x2 x4 x8 x18 text
                g.drawString("x2",316,255);
                g.drawString("x4",343,255);
                g.drawString("x8",366,255);
                g.drawString("x16",389,255);


		//get HSB from RGB values if using the rgb_model, otherwise get RGB from HSB values
                if (rgb_model){
                        hsbvals = tmpcolor.RGBtoHSB(R_LOC,G_LOC,B_LOC,hsbvals);
                        H = hsbvals[0];
                        S = hsbvals[1];
                        L = hsbvals[2];
                }
                else{
                        tmpcolor = (new Color(tmpcolor.HSBtoRGB(H,S,L)));
                        R_LOC = tmpcolor.getRed();
                        G_LOC = tmpcolor.getGreen();
                        B_LOC = tmpcolor.getBlue();
                }

		//Undraw previous values
		g.setColor(new Color(194,194,194));
		g.fillRect(355,70,94,160);

		//Draw RGB values
                g.setColor(new Color(0,0,0));
                g.drawString(tmp.valueOf(R_LOC),355,79);
                g.drawString(tmp.valueOf(G_LOC),355,103);
                g.drawString(tmp.valueOf(B_LOC),355,127);

		//Draw HSL values
                g.drawString(tmp.valueOf((int)(H*360)),355,151);
                g.drawString(tmp.valueOf((int)(S*100)),355,175);
                g.drawString(tmp.valueOf((int)(L*100)),355,199);

		//Draw HEX value of color
                      String tmpRed, tmpGreen, tmpBlue;
                if (R_LOC < 16)
                        tmpRed = "0" + Integer.toString(R_LOC,16);
                else
                        tmpRed = Integer.toString(R_LOC,16);

                if (G_LOC < 16)
                        tmpGreen = "0" + Integer.toString(G_LOC,16);
                else
                        tmpGreen = Integer.toString(G_LOC,16);

                if (B_LOC < 16)
                        tmpBlue = "0" + Integer.toString(B_LOC,16);
                else
                        tmpBlue = Integer.toString(B_LOC,16);
                g.drawString(tmpRed + tmpBlue + tmpGreen,355,223);

		//Draw the newly selected color
                g.setColor(new Color(R_LOC,G_LOC,B_LOC));
                g.fillRect(315,0,100,50);
        }
}


class myCheckbox extends Checkbox {
        public int myvalue;
        public boolean handleEvent(Event evt) {
                ((ColorPicker)getParent()).SCALE = myvalue;
                ((ColorPicker)getParent()).repaint();
                return true;
        }
}

class colorCheckbox extends Checkbox {
        int Value;
        public boolean handleEvent(Event evt) {

                if (Value == 0){
                ((ColorPicker)getParent()).SLIDER_VALUE = ((ColorPicker)getParent()).R_LOC;
                ((ColorPicker)getParent()).Color_Location_X = ((ColorPicker)getParent()).G_LOC;
                ((ColorPicker)getParent()).Color_Location_Y = ((ColorPicker)getParent()).B_LOC;
                ((ColorPicker)getParent()).rgb_model = true;
                }

                else if(Value == 1){
                ((ColorPicker)getParent()).SLIDER_VALUE = ((ColorPicker)getParent()).G_LOC;
                ((ColorPicker)getParent()).Color_Location_X = ((ColorPicker)getParent()).R_LOC;
                ((ColorPicker)getParent()).Color_Location_Y = ((ColorPicker)getParent()).B_LOC;
                ((ColorPicker)getParent()).rgb_model = true;
                }

                else if(Value == 2){
                ((ColorPicker)getParent()).SLIDER_VALUE = ((ColorPicker)getParent()).B_LOC;
                ((ColorPicker)getParent()).Color_Location_X = ((ColorPicker)getParent()).R_LOC;
                ((ColorPicker)getParent()).Color_Location_Y = ((ColorPicker)getParent()).G_LOC;
                ((ColorPicker)getParent()).rgb_model = true;
                }

                else if (Value == 3){

                ((ColorPicker)getParent()).SLIDER_VALUE = ((int)(((ColorPicker)getParent()).H * 255));
                ((ColorPicker)getParent()).Color_Location_X = ((int)(((ColorPicker)getParent()).S * 255));
                ((ColorPicker)getParent()).Color_Location_Y = ((int)(((ColorPicker)getParent()).L * 255));
                ((ColorPicker)getParent()).rgb_model = false;
                }

                else if (Value == 4){
                ((ColorPicker)getParent()).SLIDER_VALUE = ((int)(((ColorPicker)getParent()).S * 255));
                ((ColorPicker)getParent()).Color_Location_X = ((int)(((ColorPicker)getParent()).H * 255));
                ((ColorPicker)getParent()).Color_Location_Y = ((int)(((ColorPicker)getParent()).L * 255));
                ((ColorPicker)getParent()).rgb_model = false;
                }

                else if (Value == 5){
                ((ColorPicker)getParent()).SLIDER_VALUE = ((int)(((ColorPicker)getParent()).L * 255));
                ((ColorPicker)getParent()).Color_Location_X = ((int)(((ColorPicker)getParent()).H * 255));
                ((ColorPicker)getParent()).Color_Location_Y = ((int)(((ColorPicker)getParent()).S * 255));
                ((ColorPicker)getParent()).rgb_model = false;
                }

                ((ColorPicker)getParent()).repaint();
                return true;
        }



}
