package netfu.selectors;

import java.awt.*;
import java.net.*;

public class GRGBColorSelector extends Button implements Selector {

    String selected;
    Frame colorFrame;
    boolean launched = false, launchedOnce = false;
    ColorPicker colorPicker;

    int r=128, g=128, b=128;

    public GRGBColorSelector () {
	super ("\'(128 128 128)");
	selected = "\'(128 128 128)";
    }

    public GRGBColorSelector (String s) {
	super (s);
	selected = s;
    }

    public GRGBColorSelector (int red, int green, int blue) {

    	super ("   \'(" + red + " " + green + " " + blue + ")   ");
    	selected = "\'(" + red + " " + green + " " + blue + ")";
	r = red; g = green; b = blue;
	this.setBackground (new Color (r, g, b));
    }


    public boolean handleEvent (Event e) {
	System.out.println (e);
	if ((e.id == 1001)
	    && (e.target instanceof Button))
	    return launch();
	else
	    return false;
    }

    private boolean launch () {
	if (launched) return true;
	if (launchedOnce) {
	    colorFrame.show ();
	    colorFrame.requestFocus ();
	    return true;
	}

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (3,2));
	buttonPanel.add ( new Label (" "));
	buttonPanel.add ( new Label (" "));
	buttonPanel.add ( new GButton (this, "\tOK\t"));
	buttonPanel.add ( new GButton (this, "\tCancel\t"));
	buttonPanel.add ( new Label (" "));
	buttonPanel.add ( new Label (" "));

	buttonPanel.show ();

	colorPicker = new ColorPicker(this, r, g, b);
	colorPicker.show();
	Thread colorPickerThread = new Thread (colorPicker);
	colorFrame = new Frame ();
	colorFrame.setLayout (new BorderLayout ());
	colorFrame.add ("Center", colorPicker);


	colorFrame.add ("South", buttonPanel);

	colorFrame.pack();
	colorFrame.show();
	colorPickerThread.start ();

	launched = true;
	launchedOnce = true;
	return true;
    }

    public Component component () { return this; }

    public void selectValue (Object o) {
	if (((Button)o).getLabel().equals ("\tOK\t")) {
	    r = colorPicker.red();
	    g = colorPicker.green();
	    b = colorPicker.blue();
	    selected = "'(" + r + " " + g + " " + b + ")" ;
	    this.setLabel (selected);
	    this.setBackground (new Color (r, g, b));
	}
	colorFrame.dispose ();
	launched = false;
    }

    public Object selectedValue () { return selected; }
}
