/* ----------------------------------------------------------------------
 * p_plug_in_oilify_iter_ALT 
 * ----------------------------------------------------------------------
 */
gint p_plug_in_oilify_iter_ALT(GimpRunMode run_mode, gint32 total_steps, gdouble current_step, gint32 len_struct) 
{
    typedef struct t_plug_in_oilify_Vals 
    {
      gdouble      mask_size;
      gint         mode;
      gboolean     preview;
    } t_plug_in_oilify_Vals; 

    t_plug_in_oilify_Vals  buf, *buf_from, *buf_to; 

    if(len_struct != sizeof(t_plug_in_oilify_Vals)) 
    {
      fprintf(stderr, "ERROR: p_plug_in_oilify_iter_ALT  stored Data missmatch in size %d != %d\n",   
                       (int)len_struct, sizeof(t_plug_in_oilify_Vals) ); 
      return -1;  /* ERROR */ 
    }

    gimp_get_data("plug_in_oilify_ITER_FROM", g_plugin_data_from); 
    gimp_get_data("plug_in_oilify_ITER_TO",   g_plugin_data_to); 

    buf_from = (t_plug_in_oilify_Vals *)&g_plugin_data_from[0]; 
    buf_to   = (t_plug_in_oilify_Vals *)&g_plugin_data_to[0]; 
    memcpy(&buf, buf_from, sizeof(buf));

    p_delta_gdouble(&buf.mask_size, buf_from->mask_size, buf_to->mask_size, total_steps, current_step);
    p_delta_gint(&buf.mode, buf_from->mode, buf_to->mode, total_steps, current_step);

    buf.preview = FALSE;
    gimp_set_data("plug_in_oilify", &buf, sizeof(buf)); 

    return 0; /* OK */
}
