/* L-Systems plug-in
   Utilities fuctions
   Michal Gomulinski
*/

#include<stdlib.h>
#include<string.h>
#include<gtk/gtk.h>
#include"lsystui.h"
#include"lsystem.h"
#include"callbacks.h"
#include"utils.h"

void ls_clist_add_empty_rule(GtkCList *list, gint ruleno)
{
  gint rowno;
  gchar *emptyrow[7]={ "--", "--", "--", "--", "--", "--", "--" };

  gtk_clist_freeze(list);
  rowno=gtk_clist_append(list, emptyrow);
  gtk_clist_set_row_data(list, rowno, (gpointer) ruleno);
  gtk_clist_select_row(list, rowno, 0);
  gtk_clist_moveto(list, rowno, 0, 0.0, 0.0);
  gtk_clist_thaw(list);
}

void ls_clist_update_selected_rule(GtkCList *list, gchar *rule)
{
  gint rowno;
  gpointer saved;
    
  rowno=(gint) list->selection->data;
  gtk_clist_freeze(list);
  saved=gtk_clist_get_row_data(list, rowno);

  rule[1]=0;
  gtk_clist_set_text(list, rowno, 0, rule);
  gtk_clist_set_text(list, rowno, 1, "->");
  gtk_clist_set_text(list, rowno, 2, rule+2);
  rule[1]=':';

  gtk_clist_set_row_data(list, rowno, saved);
  gtk_clist_select_row(list, rowno, 0);
  gtk_clist_moveto(list, rowno, 0, 0.0, 0.0);
  gtk_clist_thaw(list);
}

void ls_clist_update_selected_srule(GtkCList *list, Special *srule)
{
  gchar buf[MAX_LINE_LENGTH];
  gint rowno;
#ifdef CLIST_HAS_WIDGET
  GtkWidget *color_prv;
  gint pi;
  gchar pbuf[PRV_WID];
#endif

  if (!srule) return;
  gtk_clist_freeze(list);
  rowno=(gint)list->selection->data;
  memset(buf, 0, sizeof(buf));
  buf[0]=srule->lefthand; gtk_clist_set_text(list, rowno, 0, buf);
  gtk_clist_set_text(list, rowno, 1, "->");
  sprintf(buf, "%6.2f", srule->turn_angle); gtk_clist_set_text(list, rowno, 2, buf);
  gtk_clist_set_text(list, rowno, 3, srule->brush_name); 
  if (srule->brush_spc >=0)
    sprintf(buf, "%d", srule->brush_spc); 
  else
    sprintf(buf, "--");
  gtk_clist_set_text(list, rowno, 4, buf);  
  if (srule->opacity >= 0)
    sprintf(buf, "%d%%", srule->opacity); 
  else
    sprintf(buf, "--");
  gtk_clist_set_text(list, rowno, 5, buf);  
  if (srule->color_change) {
#ifdef CLIST_HAS_WIDGET
    color_prv=gtk_preview_new(GTK_PREVIEW_COLOR);
    gtk_preview_size(GTK_PREVIEW(color_prv), PRV_WID, PRV_HEI);
    for (pi=0; pi<PRV_WID; pi+=3) {
      pbuf[pi]=vals->color[0];
      pbuf[pi+1]=vals->color[1];
      pbuf[pi+2]=vals->color[2];
    }
    for (pi=0; pi<PRV_HEI; pi++)
      gtk_preview_draw_row(GTK_PREVIEW(color_prv), pbuf, 0, pi, PRV_WID);
    gtk_widget_show(color_prv);
    gtk_clist_set_widget(GTK_CLIST(lsui.srules), rowno, 5, color_prv);
#else
    sprintf(buf, "(%2X,%2X,%2X)", srule->color[0], srule->color[1], srule->color[2]); 
    gtk_clist_set_text(list, rowno, 6, buf);
#endif
  } else gtk_clist_set_text(list, rowno, 6, "--");
  gtk_clist_thaw(list);
}

gpointer ls_clist_get_selected_row_data(GtkCList *list)
{
  gint rowno;

  if (!list) return NULL;
  if (!list->selection) return NULL;

  rowno=(gint) list->selection->data;
  return gtk_clist_get_row_data(list, rowno);
}

void ls_clist_remove_selected(GtkCList *list)
{
  gint rowno;
  gint ruleno;

  if (!list) return;
  if (!list->selection) return;

  gtk_clist_freeze(list);
  rowno=(gint) list->selection->data;
  ruleno=(gint)gtk_clist_get_row_data(list, rowno);
  gtk_clist_remove(list, rowno);
  gtk_clist_thaw(list);
}

void add_button( GtkWidget *box, GtkWidget *button, 
			GtkSignalFunc h)
{
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 5);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", h, NULL);
}


void ls_box_error(gchar *text)
{
  GtkWidget *wind, *label, *button;
  
  wind=gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(wind), "Warning/Error");
  gtk_container_border_width(GTK_CONTAINER(wind), 20);
  gtk_signal_connect(GTK_OBJECT(wind), "destroy", 
		     GTK_SIGNAL_FUNC(ls_univ_close), wind);
  label=gtk_label_new(text);
  gtk_box_pack_start(GTK_BOX( GTK_DIALOG(wind)->vbox ), label, 
		     TRUE, TRUE, 5);
  gtk_widget_show(label);

  button=gtk_button_new_with_label("Ok");
  GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(ls_univ_close), wind);
  gtk_box_pack_start(GTK_BOX( GTK_DIALOG(wind)->action_area ), button, 
		     TRUE, TRUE, 10);
  gtk_widget_show(button);
  gtk_widget_grab_default(button);
  gtk_widget_show(wind);
}


gint ls_check_lsystem_name(gchar *n)
{
  GList *lss=loaded_lsystems->next;
  gint ret=OK;
  gchar *lsname;

  while (lss->next) {
    lsname=((LSinfo*)lss->data)->def.name;
    if (strcmp( lsname, n) == 0 ) {
      ret=DUPLICATE;
      break;
    }
    lss=lss->next;
  }
  return ret;
}

gint ls_check_lsystem_filename(gchar *fn)
{
  GList *lss=loaded_lsystems->next;
  gint ret=OK;
  gchar *lsfname;

  while (lss->next) {
    lsfname=((LSinfo *)lss->data)->def.fname;
    if (!lsfname) {
      lss=lss->next;
      continue;
    }
    if (strcmp( lsfname, fn)==0 ) {
      ret=DUPLICATE;
      break;
    }
    lss=lss->next;
  }
  return ret;
}
