/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2000 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <gtk/gtk.h>

#include "libgimpbase/gimpbasetypes.h"

#include "pdb-types.h"
#include "tools/tools-types.h"
#include "procedural_db.h"

#include "base/base-types.h"
#include "base/tile-manager.h"
#include "core/core-types.h"
#include "core/gimpdrawable-blend.h"
#include "core/gimpdrawable-bucket-fill.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage-mask-select.h"
#include "core/gimpimage.h"
#include "tools/gimpairbrushtool.h"
#include "tools/gimpclonetool.h"
#include "tools/gimpcolorpickertool.h"
#include "tools/gimpconvolvetool.h"
#include "tools/gimpdodgeburntool.h"
#include "tools/gimperasertool.h"
#include "tools/gimppaintbrushtool.h"
#include "tools/gimppenciltool.h"
#include "tools/gimpsmudgetool.h"

#include "libgimpcolor/gimpcolor.h"
#include "libgimpmath/gimpmath.h"

static ProcRecord airbrush_proc;
static ProcRecord airbrush_default_proc;
static ProcRecord blend_proc;
static ProcRecord bucket_fill_proc;
static ProcRecord clone_proc;
static ProcRecord clone_default_proc;
static ProcRecord color_picker_proc;
static ProcRecord convolve_proc;
static ProcRecord convolve_default_proc;
static ProcRecord dodgeburn_proc;
static ProcRecord dodgeburn_default_proc;
static ProcRecord eraser_proc;
static ProcRecord eraser_default_proc;
static ProcRecord paintbrush_proc;
static ProcRecord paintbrush_default_proc;
static ProcRecord pencil_proc;
static ProcRecord smudge_proc;
static ProcRecord smudge_default_proc;

void
register_tools_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &airbrush_proc);
  procedural_db_register (gimp, &airbrush_default_proc);
  procedural_db_register (gimp, &blend_proc);
  procedural_db_register (gimp, &bucket_fill_proc);
  procedural_db_register (gimp, &clone_proc);
  procedural_db_register (gimp, &clone_default_proc);
  procedural_db_register (gimp, &color_picker_proc);
  procedural_db_register (gimp, &convolve_proc);
  procedural_db_register (gimp, &convolve_default_proc);
  procedural_db_register (gimp, &dodgeburn_proc);
  procedural_db_register (gimp, &dodgeburn_default_proc);
  procedural_db_register (gimp, &eraser_proc);
  procedural_db_register (gimp, &eraser_default_proc);
  procedural_db_register (gimp, &paintbrush_proc);
  procedural_db_register (gimp, &paintbrush_default_proc);
  procedural_db_register (gimp, &pencil_proc);
  procedural_db_register (gimp, &smudge_proc);
  procedural_db_register (gimp, &smudge_default_proc);
}

static Argument *
airbrush_invoker (Gimp     *gimp,
                  Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  pressure = args[1].value.pdb_float;
  if (pressure < 0.0 || pressure > 100.0)
    success = FALSE;

  num_strokes = args[2].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[3].value.pdb_pointer;

  if (success)
    success = airbrush_non_gui (drawable, pressure, num_strokes, strokes);

  return procedural_db_return_args (&airbrush_proc, success);
}

static ProcArg airbrush_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "pressure",
    "The pressure of the airbrush strokes (0 <= pressure <= 100)"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord airbrush_proc =
{
  "gimp_airbrush",
  "Paint in the current brush with varying pressure. Paint application is time-dependent.",
  "This tool simulates the use of an airbrush. Paint pressure represents the relative intensity of the paint application. High pressure results in a thicker layer of paint while low pressure results in a thinner layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  4,
  airbrush_inargs,
  0,
  NULL,
  { { airbrush_invoker } }
};

static Argument *
airbrush_default_invoker (Gimp     *gimp,
                          Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = airbrush_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&airbrush_default_proc, success);
}

static ProcArg airbrush_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord airbrush_default_proc =
{
  "gimp_airbrush_default",
  "Paint in the current brush with varying pressure. Paint application is time-dependent.",
  "This tool simulates the use of an airbrush. It is similar to gimp_airbrush except that the pressure is derived from the airbrush tools options box. It the option has not been set the default for the option will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  3,
  airbrush_default_inargs,
  0,
  NULL,
  { { airbrush_default_invoker } }
};

static Argument *
blend_invoker (Gimp     *gimp,
               Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 blend_mode;
  gint32 paint_mode;
  gint32 gradient_type;
  gdouble opacity;
  gdouble offset;
  gint32 repeat;
  gboolean supersample;
  gint32 max_depth;
  gdouble threshold;
  gdouble x1;
  gdouble y1;
  gdouble x2;
  gdouble y2;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  blend_mode = args[1].value.pdb_int;
  if (blend_mode < FG_BG_RGB_MODE || blend_mode > CUSTOM_MODE)
    success = FALSE;

  paint_mode = args[2].value.pdb_int;
  if (paint_mode < NORMAL_MODE || paint_mode > COLOR_ERASE_MODE)
    success = FALSE;

  gradient_type = args[3].value.pdb_int;
  if (gradient_type < LINEAR || gradient_type > SPIRAL_ANTICLOCKWISE)
    success = FALSE;

  opacity = args[4].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  offset = args[5].value.pdb_float;
  if (offset < 0.0)
    success = FALSE;

  repeat = args[6].value.pdb_int;
  if (repeat < REPEAT_NONE || repeat > REPEAT_TRIANGULAR)
    success = FALSE;

  supersample = args[7].value.pdb_int ? TRUE : FALSE;

  max_depth = args[8].value.pdb_int;
  if (supersample && (max_depth < 1 || max_depth > 9))
    success = FALSE;

  threshold = args[9].value.pdb_float;
  if (supersample && (threshold < 0.0 || threshold > 4.0))
    success = FALSE;

  x1 = args[10].value.pdb_float;

  y1 = args[11].value.pdb_float;

  x2 = args[12].value.pdb_float;

  y2 = args[13].value.pdb_float;

  if (success)
    {
      if (! gimp_drawable_gimage (drawable))
	{
	  success = FALSE;
	}
      else
	{
	  gimp_drawable_blend (drawable,
			       blend_mode,
			       paint_mode,
			       gradient_type,
			       opacity / 100.0,
			       offset, repeat,
			       supersample, max_depth,
			       threshold,
			       x1, y1, x2, y2,
			       NULL, NULL);
	}
    }

  return procedural_db_return_args (&blend_proc, success);
}

static ProcArg blend_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "blend_mode",
    "The type of blend: { FG_BG_RGB (0), FG_BG_HSV (1), FG_TRANS (2), CUSTOM (3) }"
  },
  {
    GIMP_PDB_INT32,
    "paint_mode",
    "The paint application mode: { NORMAL_MODE (0), DISSOLVE_MODE (1), BEHIND_MODE (2), MULTIPLY_MODE (3), SCREEN_MODE (4), OVERLAY_MODE (5), DIFFERENCE_MODE (6), ADDITION_MODE (7), SUBTRACT_MODE (8), DARKEN_ONLY_MODE (9), LIGHTEN_ONLY_MODE (10), HUE_MODE (11), SATURATION_MODE (12), COLOR_MODE (13), VALUE_MODE (14), DIVIDE_MODE (15), DODGE_MODE (16), BURN_MODE (17), HARDLIGHT_MODE (18), COLOR_ERASE_MODE (19) }"
  },
  {
    GIMP_PDB_INT32,
    "gradient_type",
    "The type of gradient: { LINEAR (0), BILINEAR (1), RADIAL (2), SQUARE (3), CONICAL_SYMMETRIC (4), CONICAL_ASYMMETRIC (5), SHAPEBURST_ANGULAR (6), SHAPEBURST_SPHERICAL (7), SHAPEBURST_DIMPLED (8), SPIRAL_CLOCKWISE (9), SPIRAL_ANTICLOCKWISE (10) }"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The opacity of the final blend (0 <= opacity <= 100)"
  },
  {
    GIMP_PDB_FLOAT,
    "offset",
    "Offset relates to the starting and ending coordinates specified for the blend. This parameter is mode dependent (0 <= offset)"
  },
  {
    GIMP_PDB_INT32,
    "repeat",
    "Repeat mode: { REPEAT_NONE (0), REPEAT_SAWTOOTH (1), REPEAT_TRIANGULAR (2) }"
  },
  {
    GIMP_PDB_INT32,
    "supersample",
    "Do adaptive supersampling (TRUE or FALSE)"
  },
  {
    GIMP_PDB_INT32,
    "max_depth",
    "Maximum recursion levels for supersampling"
  },
  {
    GIMP_PDB_FLOAT,
    "threshold",
    "Supersampling threshold"
  },
  {
    GIMP_PDB_FLOAT,
    "x1",
    "The x coordinate of this blend's starting point"
  },
  {
    GIMP_PDB_FLOAT,
    "y1",
    "The y coordinate of this blend's starting point"
  },
  {
    GIMP_PDB_FLOAT,
    "x2",
    "The x coordinate of this blend's ending point"
  },
  {
    GIMP_PDB_FLOAT,
    "y2",
    "The y coordinate of this blend's ending point"
  }
};

static ProcRecord blend_proc =
{
  "gimp_blend",
  "Blend between the starting and ending coordinates with the specified blend mode and gradient type.",
  "This tool requires information on the paint application mode, the blend mode, and the gradient type. It creates the specified variety of blend using the starting and ending coordinates as defined for each gradient type.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  14,
  blend_inargs,
  0,
  NULL,
  { { blend_invoker } }
};

static Argument *
bucket_fill_invoker (Gimp     *gimp,
                     Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 fill_mode;
  gint32 paint_mode;
  gdouble opacity;
  gdouble threshold;
  gboolean sample_merged;
  gdouble x;
  gdouble y;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  fill_mode = args[1].value.pdb_int;
  if (fill_mode < FG_BUCKET_FILL || fill_mode > PATTERN_BUCKET_FILL)
    success = FALSE;

  paint_mode = args[2].value.pdb_int;
  if (paint_mode < NORMAL_MODE || paint_mode > COLOR_ERASE_MODE)
    success = FALSE;

  opacity = args[3].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  threshold = args[4].value.pdb_float;
  if (threshold < 0.0 || threshold > 255.0)
    success = FALSE;

  sample_merged = args[5].value.pdb_int ? TRUE : FALSE;

  x = args[6].value.pdb_float;

  y = args[7].value.pdb_float;

  if (success)
    {
      if (! gimp_drawable_gimage (GIMP_DRAWABLE (drawable)))
	{
	  success = FALSE;
	}
      else
	{
	  gimp_drawable_bucket_fill (drawable, fill_mode,
				     paint_mode, opacity / 100.0,
				     threshold, sample_merged, x, y);
	}
    }

  return procedural_db_return_args (&bucket_fill_proc, success);
}

static ProcArg bucket_fill_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "fill_mode",
    "The type of fill: { FG_BUCKET_FILL (0), BG_BUCKET_FILL (1), PATTERN_BUCKET_FILL (2) }"
  },
  {
    GIMP_PDB_INT32,
    "paint_mode",
    "The paint application mode: { NORMAL_MODE (0), DISSOLVE_MODE (1), BEHIND_MODE (2), MULTIPLY_MODE (3), SCREEN_MODE (4), OVERLAY_MODE (5), DIFFERENCE_MODE (6), ADDITION_MODE (7), SUBTRACT_MODE (8), DARKEN_ONLY_MODE (9), LIGHTEN_ONLY_MODE (10), HUE_MODE (11), SATURATION_MODE (12), COLOR_MODE (13), VALUE_MODE (14), DIVIDE_MODE (15), DODGE_MODE (16), BURN_MODE (17), HARDLIGHT_MODE (18), COLOR_ERASE_MODE (19) }"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The opacity of the final bucket fill (0 <= opacity <= 100)"
  },
  {
    GIMP_PDB_FLOAT,
    "threshold",
    "The threshold determines how extensive the seed fill will be. It's value is specified in terms of intensity levels (0 <= threshold <= 255). This parameter is only valid when there is no selection in the specified image."
  },
  {
    GIMP_PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "x",
    "The x coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image."
  },
  {
    GIMP_PDB_FLOAT,
    "y",
    "The y coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image."
  }
};

static ProcRecord bucket_fill_proc =
{
  "gimp_bucket_fill",
  "Fill the area specified either by the current selection if there is one, or by a seed fill starting at the specified coordinates.",
  "This tool requires information on the paint application mode, and the fill mode, which can either be in the foreground color, or in the currently active pattern. If there is no selection, a seed fill is executed at the specified coordinates and extends outward in keeping with the threshold parameter. If there is a selection in the target image, the threshold, sample merged, x, and y arguments are unused. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of merged sampling, the x,y coordinates are relative to the image's origin; otherwise, they are relative to the drawable's origin.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  8,
  bucket_fill_inargs,
  0,
  NULL,
  { { bucket_fill_invoker } }
};

static Argument *
clone_invoker (Gimp     *gimp,
               Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpDrawable *src_drawable;
  gint32 clone_type;
  gdouble src_x;
  gdouble src_y;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  src_drawable = gimp_drawable_get_by_ID (gimp, args[1].value.pdb_int);
  if (src_drawable == NULL)
    success = FALSE;

  clone_type = args[2].value.pdb_int;
  if (clone_type < IMAGE_CLONE || clone_type > PATTERN_CLONE)
    success = FALSE;

  src_x = args[3].value.pdb_float;

  src_y = args[4].value.pdb_float;

  num_strokes = args[5].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[6].value.pdb_pointer;

  if (success)
    success = clone_non_gui (drawable, src_drawable, clone_type, src_x, src_y,
			     num_strokes, strokes);

  return procedural_db_return_args (&clone_proc, success);
}

static ProcArg clone_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_DRAWABLE,
    "src_drawable",
    "The source drawable"
  },
  {
    GIMP_PDB_INT32,
    "clone_type",
    "The type of clone: { IMAGE_CLONE (0), PATTERN_CLONE (1) }"
  },
  {
    GIMP_PDB_FLOAT,
    "src_x",
    "The x coordinate in the source image"
  },
  {
    GIMP_PDB_FLOAT,
    "src_y",
    "The y coordinate in the source image"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord clone_proc =
{
  "gimp_clone",
  "Clone from the source to the dest drawable using the current brush",
  "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. If the \"clone_type\" argument is set to PATTERN-CLONE, then the current pattern is used as the source and the \"src_drawable\" argument is ignored. Pattern cloning assumes a tileable pattern and mods the sum of the src coordinates and subsequent stroke offsets with the width and height of the pattern. For image cloning, if the sum of the src coordinates and subsequent stroke offsets exceeds the extents of the src drawable, then no paint is transferred. The clone tool is capable of transforming between any image types including RGB->Indexed--although converting from any type to indexed is significantly slower.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  7,
  clone_inargs,
  0,
  NULL,
  { { clone_invoker } }
};

static Argument *
clone_default_invoker (Gimp     *gimp,
                       Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = clone_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&clone_default_proc, success);
}

static ProcArg clone_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord clone_default_proc =
{
  "gimp_clone_default",
  "Clone from the source to the dest drawable using the current brush",
  "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. This function performs exactly the same as the gimp_clone function except that the tools arguments are obtained from the clones option dialog. It this dialog has not been activated then the dialogs default values will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  3,
  clone_default_inargs,
  0,
  NULL,
  { { clone_default_invoker } }
};

static Argument *
color_picker_invoker (Gimp     *gimp,
                      Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpDrawable *drawable;
  gdouble x;
  gdouble y;
  gboolean sample_merged;
  gboolean sample_average;
  gdouble average_radius;
  gboolean save_color;
  GimpRGB color;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  drawable = gimp_drawable_get_by_ID (gimp, args[1].value.pdb_int);

  x = args[2].value.pdb_float;

  y = args[3].value.pdb_float;

  sample_merged = args[4].value.pdb_int ? TRUE : FALSE;

  sample_average = args[5].value.pdb_int ? TRUE : FALSE;

  average_radius = args[6].value.pdb_float;
  if (sample_average && (average_radius <= 0.0))
    success = FALSE;

  save_color = args[7].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      if (!sample_merged)
	if (!drawable || (gimp_drawable_gimage (drawable) != gimage))
	  success = FALSE;
    
      if (success)
	success = pick_color (gimage, drawable, (int) x, (int) y,
			      sample_merged, sample_average, average_radius,
			      save_color);
      if (success)
	{
	  gimp_rgba_set_uchar (&color, 
			       col_value[RED_PIX],
			       col_value[GREEN_PIX],
			       col_value[BLUE_PIX],
			       col_value[ALPHA_PIX]);
	}
    }

  return_args = procedural_db_return_args (&color_picker_proc, success);

  if (success)
    return_args[1].value.pdb_color = color;

  return return_args;
}

static ProcArg color_picker_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "x",
    "x coordinate of upper-left corner of rectangle"
  },
  {
    GIMP_PDB_FLOAT,
    "y",
    "y coordinate of upper-left corner of rectangle"
  },
  {
    GIMP_PDB_INT32,
    "sample_merged",
    "Use the composite image, not the drawable"
  },
  {
    GIMP_PDB_INT32,
    "sample_average",
    "Average the color of all the pixels in a specified radius"
  },
  {
    GIMP_PDB_FLOAT,
    "average_radius",
    "The radius of pixels to average"
  },
  {
    GIMP_PDB_INT32,
    "save_color",
    "Save the color to the active palette"
  }
};

static ProcArg color_picker_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "color",
    "The return color"
  }
};

static ProcRecord color_picker_proc =
{
  "gimp_color_picker",
  "Determine the color at the given drawable coordinates",
  "This tool determines the color at the specified coordinates. The returned color is an RGB triplet even for grayscale and indexed drawables. If the coordinates lie outside of the extents of the specified drawable, then an error is returned. If the drawable has an alpha channel, the algorithm examines the alpha value of the drawable at the coordinates. If the alpha value is completely transparent (0), then an error is returned. If the sample_merged parameter is non-zero, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of a merged sampling, the supplied drawable is ignored.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  8,
  color_picker_inargs,
  1,
  color_picker_outargs,
  { { color_picker_invoker } }
};

static Argument *
convolve_invoker (Gimp     *gimp,
                  Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 convolve_type;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  pressure = args[1].value.pdb_float;
  if (pressure < 0.0 || pressure > 100.0)
    success = FALSE;

  convolve_type = args[2].value.pdb_int;
  if (convolve_type < BLUR_CONVOLVE || convolve_type > SHARPEN_CONVOLVE)
    success = FALSE;

  num_strokes = args[3].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[4].value.pdb_pointer;

  if (success)
    success = convolve_non_gui (drawable, pressure, convolve_type, num_strokes, strokes);

  return procedural_db_return_args (&convolve_proc, success);
}

static ProcArg convolve_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "pressure",
    "The pressure: 0 <= pressure <= 100"
  },
  {
    GIMP_PDB_INT32,
    "convolve_type",
    "Convolve type: { BLUR_CONVOLVE (0), SHARPEN_CONVOLVE (1) }"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord convolve_proc =
{
  "gimp_convolve",
  "Convolve (Blur, Sharpen) using the current brush.",
  "This tool convolves the specified drawable with either a sharpening or blurring kernel. The pressure parameter controls the magnitude of the operation. Like the paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  5,
  convolve_inargs,
  0,
  NULL,
  { { convolve_invoker } }
};

static Argument *
convolve_default_invoker (Gimp     *gimp,
                          Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = convolve_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&convolve_default_proc, success);
}

static ProcArg convolve_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord convolve_default_proc =
{
  "gimp_convolve_default",
  "Convolve (Blur, Sharpen) using the current brush.",
  "This tool convolves the specified drawable with either a sharpening or blurring kernel. This function performs exactly the same as the gimp_convolve function except that the tools arguments are obtained from the convolve option dialog. It this dialog has not been activated then the dialogs default values will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  3,
  convolve_default_inargs,
  0,
  NULL,
  { { convolve_default_invoker } }
};

static Argument *
dodgeburn_invoker (Gimp     *gimp,
                   Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble exposure;
  gint32 dodgeburn_type;
  gint32 dodgeburn_mode;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  exposure = args[1].value.pdb_float;
  if (exposure < 0.0 || exposure > 100.0)
    success = FALSE;

  dodgeburn_type = args[2].value.pdb_int;
  if (dodgeburn_type < DODGE || dodgeburn_type > BURN)
    success = FALSE;

  dodgeburn_mode = args[3].value.pdb_int;
  if (dodgeburn_mode < GIMP_SHADOWS || dodgeburn_mode > GIMP_HIGHLIGHTS)
    success = FALSE;

  num_strokes = args[4].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[5].value.pdb_pointer;

  if (success)
    success = gimp_dodgeburn_tool_non_gui (drawable, exposure, dodgeburn_type, dodgeburn_mode, num_strokes, strokes);

  return procedural_db_return_args (&dodgeburn_proc, success);
}

static ProcArg dodgeburn_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "exposure",
    "The exposer of the strokes (0 <= exposure <= 100)"
  },
  {
    GIMP_PDB_INT32,
    "dodgeburn_type",
    "The type either dodge or burn: { DODGE (0), BURN (1) }"
  },
  {
    GIMP_PDB_INT32,
    "dodgeburn_mode",
    "The mode: { SHADOWS (0), MIDTONES (1), HIGHLIGHTS (2) }"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord dodgeburn_proc =
{
  "gimp_dodgeburn",
  "Dodgeburn image with varying exposure.",
  "Dodgebure. More details here later.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  6,
  dodgeburn_inargs,
  0,
  NULL,
  { { dodgeburn_invoker } }
};

static Argument *
dodgeburn_default_invoker (Gimp     *gimp,
                           Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = gimp_dodgeburn_tool_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&dodgeburn_default_proc, success);
}

static ProcArg dodgeburn_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord dodgeburn_default_proc =
{
  "gimp_dodgeburn_default",
  "Dodgeburn image with varying exposure. This is the same as the gimp_dodgeburn function except that the exposure, type and mode are taken from the tools option dialog. If the dialog has not been activated then the defaults as used by the dialog will be used.",
  "Dodgeburn. More details here later.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  3,
  dodgeburn_default_inargs,
  0,
  NULL,
  { { dodgeburn_default_invoker } }
};

static Argument *
eraser_invoker (Gimp     *gimp,
                Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;
  gint32 hardness;
  gint32 method;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  hardness = args[3].value.pdb_int;
  if (hardness < HARD || hardness > SOFT)
    success = FALSE;

  method = args[4].value.pdb_int;
  if (method < CONSTANT || method > INCREMENTAL)
    success = FALSE;

  if (success)
    success = eraser_non_gui (drawable, num_strokes, strokes, hardness, method, TRUE, FALSE);

  return procedural_db_return_args (&eraser_proc, success);
}

static ProcArg eraser_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  },
  {
    GIMP_PDB_INT32,
    "hardness",
    "HARD (0) or SOFT (1)"
  },
  {
    GIMP_PDB_INT32,
    "method",
    "CONTINUOUS (0) or INCREMENTAL (1)"
  }
};

static ProcRecord eraser_proc =
{
  "gimp_eraser",
  "Erase using the current brush.",
  "This tool erases using the current brush mask. If the specified drawable contains an alpha channel, then the erased pixels will become transparent. Otherwise, the eraser tool replaces the contents of the drawable with the background color. Like paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  5,
  eraser_inargs,
  0,
  NULL,
  { { eraser_invoker } }
};

static Argument *
eraser_default_invoker (Gimp     *gimp,
                        Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = eraser_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&eraser_default_proc, success);
}

static ProcArg eraser_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord eraser_default_proc =
{
  "gimp_eraser_default",
  "Erase using the current brush.",
  "This tool erases using the current brush mask. This function performs exactly the same as the gimp_eraser function except that the tools arguments are obtained from the eraser option dialog. It this dialog has not been activated then the dialogs default values will be used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  3,
  eraser_default_inargs,
  0,
  NULL,
  { { eraser_default_invoker } }
};

static Argument *
paintbrush_invoker (Gimp     *gimp,
                    Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble fade_out;
  gint32 num_strokes;
  gdouble *strokes;
  gint32 method;
  gdouble gradient_length;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  fade_out = args[1].value.pdb_float;
  if (fade_out < 0.0)
    success = FALSE;

  num_strokes = args[2].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[3].value.pdb_pointer;

  method = args[4].value.pdb_int;
  if (method < CONSTANT || method > INCREMENTAL)
    success = FALSE;

  gradient_length = args[5].value.pdb_float;
  if (gradient_length < 0.0)
    success = FALSE;

  if (success)
    success = gimp_paintbrush_tool_non_gui (drawable, num_strokes, strokes, 
					    fade_out, method, gradient_length);

  return procedural_db_return_args (&paintbrush_proc, success);
}

static ProcArg paintbrush_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "fade_out",
    "Fade out parameter: 0 <= fade_out"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  },
  {
    GIMP_PDB_INT32,
    "method",
    "CONTINUOUS (0) or INCREMENTAL (1)"
  },
  {
    GIMP_PDB_FLOAT,
    "gradient_length",
    "Length of gradient to draw: 0 <= gradient_length"
  }
};

static ProcRecord paintbrush_proc =
{
  "gimp_paintbrush",
  "Paint in the current brush with optional fade out parameter and pull colors from a gradient.",
  "This tool is the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The \"fade_out\" parameter is measured in pixels and allows the brush stroke to linearly fall off. The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade_out value, the pressure will approach zero. The gradient_length is the distance to spread the gradient over. It is measured in pixels. If the gradient_length is 0, no gradient is used.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  6,
  paintbrush_inargs,
  0,
  NULL,
  { { paintbrush_invoker } }
};

static Argument *
paintbrush_default_invoker (Gimp     *gimp,
                            Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = gimp_paintbrush_tool_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&paintbrush_default_proc, success);
}

static ProcArg paintbrush_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord paintbrush_default_proc =
{
  "gimp_paintbrush_default",
  "Paint in the current brush. The fade out parameter and pull colors from a gradient parameter are set from the paintbrush options dialog. If this dialog has not been activated then the dialog defaults will be used.",
  "This tool is similar to the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The \"fade_out\" parameter is measured in pixels and allows the brush stroke to linearly fall off (value obtained from the option dialog). The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade_out value, the pressure will approach zero. The gradient_length (value obtained from the option dialog) is the distance to spread the gradient over. It is measured in pixels. If the gradient_length is 0, no gradient is used.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  3,
  paintbrush_default_inargs,
  0,
  NULL,
  { { paintbrush_default_invoker } }
};

static Argument *
pencil_invoker (Gimp     *gimp,
                Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = pencil_non_gui (drawable, num_strokes, strokes);

  return procedural_db_return_args (&pencil_proc, success);
}

static ProcArg pencil_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord pencil_proc =
{
  "gimp_pencil",
  "Paint in the current brush without sub-pixel sampling.",
  "This tool is the standard pencil. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The brush mask is treated as though it contains only black and white values. Any value below half is treated as black; any above half, as white.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  3,
  pencil_inargs,
  0,
  NULL,
  { { pencil_invoker } }
};

static Argument *
smudge_invoker (Gimp     *gimp,
                Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  pressure = args[1].value.pdb_float;
  if (pressure < 0.0 || pressure > 100.0)
    success = FALSE;

  num_strokes = args[2].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[3].value.pdb_pointer;

  if (success)
    success = gimp_smudge_tool_non_gui (drawable, pressure, num_strokes, strokes);

  return procedural_db_return_args (&smudge_proc, success);
}

static ProcArg smudge_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_FLOAT,
    "pressure",
    "The pressure of the smudge strokes (0 <= pressure <= 100)"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord smudge_proc =
{
  "gimp_smudge",
  "Smudge image with varying pressure.",
  "This tool simulates a smudge using the current brush. High pressure results in a greater smudge of paint while low pressure results in a lesser smudge.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  4,
  smudge_inargs,
  0,
  NULL,
  { { smudge_invoker } }
};

static Argument *
smudge_default_invoker (Gimp     *gimp,
                        Argument *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  gdouble *strokes;

  drawable = gimp_drawable_get_by_ID (gimp, args[0].value.pdb_int);
  if (drawable == NULL)
    success = FALSE;

  num_strokes = args[1].value.pdb_int;
  if (!(num_strokes < 2))
    num_strokes /= 2;
  else
    success = FALSE;

  strokes = (gdouble *) args[2].value.pdb_pointer;

  if (success)
    success = gimp_smudge_tool_non_gui_default (drawable, num_strokes, strokes);

  return procedural_db_return_args (&smudge_default_proc, success);
}

static ProcArg smudge_default_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The affected drawable"
  },
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "Number of stroke control points (count each coordinate as 2 points)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "strokes",
    "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }"
  }
};

static ProcRecord smudge_default_proc =
{
  "gimp_smudge_default",
  "Smudge image with varying pressure.",
  "This tool simulates a smudge using the current brush. It behaves exactly the same as gimp_smudge except that the pressure value is taken from the smudge tool options or the options default if the tools option dialog has not been activated.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  GIMP_INTERNAL,
  3,
  smudge_default_inargs,
  0,
  NULL,
  { { smudge_default_invoker } }
};
