/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimppreview.h
 * Copyright (C) 2001 Michael Natterer <mitch@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_PREVIEW_H__
#define __GIMP_PREVIEW_H__


#define GIMP_TYPE_PREVIEW            (gimp_preview_get_type ())
#define GIMP_PREVIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIMP_TYPE_PREVIEW, GimpPreview))
#define GIMP_PREVIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GIMP_TYPE_PREVIEW, GimpPreviewClass))
#define GIMP_IS_PREVIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GIMP_TYPE_PREVIEW))
#define GIMP_IS_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_PREVIEW))
#define GIMP_PREVIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIMP_TYPE_PREVIEW, GimpPreviewClass))


typedef struct _GimpPreviewClass  GimpPreviewClass;

struct _GimpPreview
{
  GtkWidget            parent_instance;

  GdkWindow           *event_window;

  GimpViewable        *viewable;
  GimpPreviewRenderer *renderer;

  gboolean             clickable;
  gboolean             eat_button_events;
  gboolean             show_popup;
  gboolean             expand;

  /*< private >*/
  gboolean             in_button;
  GdkModifierType      press_state;
};

struct _GimpPreviewClass
{
  GtkWidgetClass       parent_class;

  /*  signals  */
  void        (* clicked)          (GimpPreview     *preview,
                                    GdkModifierType  modifier_state);
  void        (* double_clicked)   (GimpPreview     *preview);
  void        (* context)          (GimpPreview     *preview);
};


GType       gimp_preview_get_type          (void) G_GNUC_CONST;

GtkWidget * gimp_preview_new               (GimpViewable  *viewable,
					    gint           size,
					    gint           border_width,
					    gboolean       is_popup);
GtkWidget * gimp_preview_new_full          (GimpViewable  *viewable,
					    gint           width,
					    gint           height,
					    gint           border_width,
					    gboolean       is_popup,
					    gboolean       clickable,
					    gboolean       show_popup);
GtkWidget * gimp_preview_new_by_types      (GType          preview_type,
                                            GType          viewable_type,
					    gint           size,
					    gint           border_width,
					    gboolean       is_popup);
GtkWidget * gimp_preview_new_full_by_types (GType          preview_type,
                                            GType          viewable_type,
                                            gint           width,
                                            gint           height,
                                            gint           border_width,
                                            gboolean       is_popup,
                                            gboolean       clickable,
                                            gboolean       show_popup);

void        gimp_preview_set_viewable      (GimpPreview   *preview,
					    GimpViewable  *viewable);
void        gimp_preview_set_expand        (GimpPreview   *preview,
                                            gboolean       expand);


#endif /* __GIMP_PREVIEW_H__ */
