/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalettes_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"
#undef GIMP_DISABLE_DEPRECATED
#undef __GIMP_PALETTES_PDB_H__
#include "gimppalettes_pdb.h"

/**
 * gimp_palettes_refresh:
 *
 * Refreshes current palettes. This function always succeeds.
 *
 * This procedure retrieves all palettes currently in the user's
 * palette path and updates the palette dialogs accordingly.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_palettes_refresh (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palettes-refresh",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palettes_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_palettes: The number of palettes in the list.
 *
 * Retrieves a list of all of the available palettes
 *
 * This procedure returns a complete listing of available palettes.
 * Each name returned can be used as input to the command
 * gimp_context_set_palette().
 *
 * Returns: The list of palette names.
 */
gchar **
gimp_palettes_get_list (const gchar *filter,
                        gint        *num_palettes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **palette_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-palettes-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_palettes = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_palettes = return_vals[1].data.d_int32;
      palette_list = g_new (gchar *, *num_palettes);
      for (i = 0; i < *num_palettes; i++)
        palette_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return palette_list;
}

/**
 * gimp_palettes_get_palette:
 * @num_colors: The palette num_colors.
 *
 * This procedure is deprecated! Use gimp_context_get_palette()
 * instead.
 *
 * Returns: The palette name.
 */
gchar *
gimp_palettes_get_palette (gint *num_colors)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-palettes-get-palette",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      name = g_strdup (return_vals[1].data.d_string);
      *num_colors = return_vals[2].data.d_int32;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_palettes_get_palette_entry:
 * @name: The palette name (\"\" means currently active palette).
 * @entry_num: The entry to retrieve.
 * @num_colors: The palette num_colors.
 * @color: The color requested.
 *
 * This procedure is deprecated! Use gimp_palette_entry_get_color()
 * instead.
 *
 * Returns: The palette name.
 */
gchar *
gimp_palettes_get_palette_entry (const gchar *name,
                                 gint         entry_num,
                                 gint        *num_colors,
                                 GimpRGB     *color)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *actual_name = NULL;

  return_vals = gimp_run_procedure ("gimp-palettes-get-palette-entry",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_INT32, entry_num,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      actual_name = g_strdup (return_vals[1].data.d_string);
      *num_colors = return_vals[2].data.d_int32;
      *color = return_vals[3].data.d_color;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return actual_name;
}
