/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpcontext_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpcontext
 * @title: gimpcontext
 * @short_description: Functions to manipulate a plug-in's context.
 *
 * Functions to manipulate a plug-in's context.
 **/


/**
 * gimp_context_push:
 *
 * Pushes a context to the top of the plug-in's context stack.
 *
 * This procedure creates a new context by copying the current context.
 * This copy becomes the new current context for the calling plug-in
 * until it is popped again using gimp_context_pop().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_push (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-push",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_pop:
 *
 * Pops the topmost context from the plug-in's context stack.
 *
 * This procedure removes the topmost context from the plug-in's
 * context stack. The context that was active before the corresponding
 * call to gimp_context_push() becomes the new current context of the
 * plug-in.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_pop (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-pop",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_defaults:
 *
 * Reset context settings to their default values.
 *
 * This procedure resets context settings used by various procedures to
 * their default value. This procedure will usually be called after a
 * context push so that a script which calls procedures affected by
 * context settings will not be affected by changes in the global
 * context.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_defaults (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-defaults",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_list_paint_methods:
 * @paint_methods: (out) (array zero-terminated=1) (transfer full): The names of the available paint methods.
 *
 * Lists the available paint methods.
 *
 * This procedure lists the names of the available paint methods. Any
 * of the results can be used for gimp_context_set_paint_method().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_context_list_paint_methods (gchar ***paint_methods)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-list-paint-methods",
                                              args);
  gimp_value_array_unref (args);

  *paint_methods = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *paint_methods = GIMP_VALUES_DUP_STRV (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_paint_method:
 *
 * Retrieve the currently active paint method.
 *
 * This procedure returns the name of the currently active paint
 * method.
 *
 * Returns: (transfer full): The name of the active paint method.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.4
 **/
gchar *
gimp_context_get_paint_method (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-paint-method",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_paint_method:
 * @name: The name of the paint method.
 *
 * Set the specified paint method as the active paint method.
 *
 * This procedure allows the active paint method to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the available paint methods. If there is no
 * matching method found, this procedure will return an error.
 * Otherwise, the specified method becomes active and will be used in
 * all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_context_set_paint_method (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-paint-method",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_stroke_method:
 *
 * Retrieve the currently active stroke method.
 *
 * This procedure returns the currently active stroke method.
 *
 * Returns: The active stroke method.
 *
 * Since: 2.10
 **/
GimpStrokeMethod
gimp_context_get_stroke_method (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpStrokeMethod stroke_method = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-stroke-method",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    stroke_method = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return stroke_method;
}

/**
 * gimp_context_set_stroke_method:
 * @stroke_method: The new stroke method.
 *
 * Set the specified stroke method as the active stroke method.
 *
 * This procedure set the specified stroke method as the active stroke
 * method. The new method will be used in all subsequent stroke
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_stroke_method (GimpStrokeMethod stroke_method)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_STROKE_METHOD, stroke_method,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-stroke-method",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_foreground:
 * @foreground: (out caller-allocates): The foreground color.
 *
 * Get the current GIMP foreground color.
 *
 * This procedure returns the current GIMP foreground color. The
 * foreground color is used in a variety of tools such as paint tools,
 * blending, and bucket fill.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_get_foreground (GimpRGB *foreground)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-foreground",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    GIMP_VALUES_GET_RGB (return_vals, 1, &*foreground);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_foreground:
 * @foreground: The foreground color.
 *
 * Set the current GIMP foreground color.
 *
 * This procedure sets the current GIMP foreground color. After this is
 * set, operations which use foreground such as paint tools, blending,
 * and bucket fill will use the new value.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_foreground (const GimpRGB *foreground)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_RGB, foreground,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-foreground",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_background:
 * @background: (out caller-allocates): The background color.
 *
 * Get the current GIMP background color.
 *
 * This procedure returns the current GIMP background color. The
 * background color is used in a variety of tools such as blending,
 * erasing (with non-alpha images), and image filling.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_get_background (GimpRGB *background)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-background",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    GIMP_VALUES_GET_RGB (return_vals, 1, &*background);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_background:
 * @background: The background color.
 *
 * Set the current GIMP background color.
 *
 * This procedure sets the current GIMP background color. After this is
 * set, operations which use background such as blending, filling
 * images, clearing, and erasing (in non-alpha images) will use the new
 * value.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_background (const GimpRGB *background)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_RGB, background,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-background",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_default_colors:
 *
 * Set the current GIMP foreground and background colors to black and
 * white.
 *
 * This procedure sets the current GIMP foreground and background
 * colors to their initial default values, black and white.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_default_colors (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-default-colors",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_swap_colors:
 *
 * Swap the current GIMP foreground and background colors.
 *
 * This procedure swaps the current GIMP foreground and background
 * colors, so that the new foreground color becomes the old background
 * color and vice versa.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_swap_colors (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-swap-colors",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_opacity:
 *
 * Get the opacity.
 *
 * This procedure returns the opacity setting. The return value is a
 * floating point number between 0 and 100.
 *
 * Returns: The opacity.
 *
 * Since: 2.2
 **/
gdouble
gimp_context_get_opacity (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble opacity = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-opacity",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    opacity = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return opacity;
}

/**
 * gimp_context_set_opacity:
 * @opacity: The opacity.
 *
 * Set the opacity.
 *
 * This procedure modifies the opacity setting. The value should be a
 * floating point number between 0 and 100.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_opacity (gdouble opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, opacity,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-opacity",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_paint_mode:
 *
 * Get the paint mode.
 *
 * This procedure returns the paint-mode setting. The return value is
 * an integer which corresponds to the values listed in the argument
 * description.
 *
 * Returns: The paint mode.
 *
 * Since: 2.2
 **/
GimpLayerMode
gimp_context_get_paint_mode (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpLayerMode paint_mode = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-paint-mode",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    paint_mode = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return paint_mode;
}

/**
 * gimp_context_set_paint_mode:
 * @paint_mode: The paint mode.
 *
 * Set the paint mode.
 *
 * This procedure modifies the paint_mode setting.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_paint_mode (GimpLayerMode paint_mode)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LAYER_MODE, paint_mode,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-paint-mode",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_width:
 *
 * Get the line width setting.
 *
 * This procedure returns the line width setting.
 *
 * Returns: The line width setting.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_line_width (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble line_width = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-width",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    line_width = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return line_width;
}

/**
 * gimp_context_set_line_width:
 * @line_width: The line width setting.
 *
 * Set the line width setting.
 *
 * This procedure modifies the line width setting for stroking lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_width (gdouble line_width)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, line_width,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-width",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_width_unit:
 *
 * Get the line width unit setting.
 *
 * This procedure returns the line width unit setting.
 *
 * Returns: (transfer none): The line width unit setting.
 *
 * Since: 2.10
 **/
GimpUnit
gimp_context_get_line_width_unit (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpUnit line_width_unit = GIMP_UNIT_PIXEL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-width-unit",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    line_width_unit = GIMP_VALUES_GET_INT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return line_width_unit;
}

/**
 * gimp_context_set_line_width_unit:
 * @line_width_unit: The line width setting unit.
 *
 * Set the line width unit setting.
 *
 * This procedure modifies the line width unit setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_width_unit (GimpUnit line_width_unit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_UNIT, line_width_unit,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-width-unit",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_cap_style:
 *
 * Get the line cap style setting.
 *
 * This procedure returns the line cap style setting.
 *
 * Returns: The line cap style setting.
 *
 * Since: 2.10
 **/
GimpCapStyle
gimp_context_get_line_cap_style (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpCapStyle cap_style = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-cap-style",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    cap_style = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return cap_style;
}

/**
 * gimp_context_set_line_cap_style:
 * @cap_style: The line cap style setting.
 *
 * Set the line cap style setting.
 *
 * This procedure modifies the line cap style setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_cap_style (GimpCapStyle cap_style)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CAP_STYLE, cap_style,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-cap-style",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_join_style:
 *
 * Get the line join style setting.
 *
 * This procedure returns the line join style setting.
 *
 * Returns: The line join style setting.
 *
 * Since: 2.10
 **/
GimpJoinStyle
gimp_context_get_line_join_style (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpJoinStyle join_style = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-join-style",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    join_style = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return join_style;
}

/**
 * gimp_context_set_line_join_style:
 * @join_style: The line join style setting.
 *
 * Set the line join style setting.
 *
 * This procedure modifies the line join style setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_join_style (GimpJoinStyle join_style)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_JOIN_STYLE, join_style,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-join-style",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_miter_limit:
 *
 * Get the line miter limit setting.
 *
 * This procedure returns the line miter limit setting.
 *
 * Returns: The line miter limit setting.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_line_miter_limit (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble miter_limit = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-miter-limit",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    miter_limit = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return miter_limit;
}

/**
 * gimp_context_set_line_miter_limit:
 * @miter_limit: The line miter limit setting.
 *
 * Set the line miter limit setting.
 *
 * This procedure modifies the line miter limit setting for stroking
 * lines.
 * A mitered join is converted to a bevelled join if the miter would
 * extend to a distance of more than (miter-limit * line-width) from
 * the actual join point.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_miter_limit (gdouble miter_limit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, miter_limit,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-miter-limit",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_dash_offset:
 *
 * Get the line dash offset setting.
 *
 * This procedure returns the line dash offset setting.
 *
 * Returns: The line dash offset setting.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_line_dash_offset (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble dash_offset = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-dash-offset",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    dash_offset = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return dash_offset;
}

/**
 * gimp_context_set_line_dash_offset:
 * @dash_offset: The line dash offset setting.
 *
 * Set the line dash offset setting.
 *
 * This procedure modifies the line dash offset setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_dash_offset (gdouble dash_offset)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, dash_offset,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-dash-offset",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_line_dash_pattern:
 * @num_dashes: (out): The number of dashes in the dash_pattern array.
 * @dashes: (out) (array length=num_dashes) (element-type gdouble) (transfer full): The line dash pattern setting.
 *
 * Get the line dash pattern setting.
 *
 * This procedure returns the line dash pattern setting.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_get_line_dash_pattern (gint     *num_dashes,
                                    gdouble **dashes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-line-dash-pattern",
                                              args);
  gimp_value_array_unref (args);

  *num_dashes = 0;
  *dashes = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_dashes = GIMP_VALUES_GET_INT (return_vals, 1);
      *dashes = GIMP_VALUES_DUP_FLOAT_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_line_dash_pattern:
 * @num_dashes: The number of dashes in the dash_pattern array.
 * @dashes: (array length=num_dashes) (element-type gdouble): The line dash pattern setting.
 *
 * Set the line dash pattern setting.
 *
 * This procedure modifies the line dash pattern setting for stroking
 * lines.
 *
 * The unit of the dash pattern segments is the actual line width used
 * for the stroke operation, in other words a segment length of 1.0
 * results in a square segment shape (or gap shape).
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_dash_pattern (gint           num_dashes,
                                    const gdouble *dashes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, num_dashes,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 1), dashes, num_dashes);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-line-dash-pattern",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush:
 *
 * Retrieve the currently active brush.
 *
 * This procedure returns the name of the currently active brush. All
 * paint operations and stroke operations use this brush to control the
 * application of paint to the image.
 *
 * Returns: (transfer full): The name of the active brush.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_brush (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_brush:
 * @name: The name of the brush.
 *
 * Set the specified brush as the active brush.
 *
 * This procedure allows the active brush to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed brushes. If there is no matching brush found,
 * this procedure will return an error. Otherwise, the specified brush
 * becomes active and will be used in all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_brush (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush_size:
 *
 * Get brush size in pixels.
 *
 * Get the brush size in pixels for brush based paint tools.
 *
 * Returns: Brush size in pixels.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_brush_size (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble size = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush-size",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    size = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return size;
}

/**
 * gimp_context_set_brush_size:
 * @size: Brush size in pixels.
 *
 * Set brush size in pixels.
 *
 * Set the brush size in pixels for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_size (gdouble size)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, size,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-size",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_brush_default_size:
 *
 * Set brush size to its default.
 *
 * Set the brush size to the default (max of width and height) for
 * paintbrush, airbrush, or pencil tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_default_size (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-default-size",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush_aspect_ratio:
 *
 * Get brush aspect ratio.
 *
 * Set the aspect ratio for brush based paint tools.
 *
 * Returns: Aspect ratio.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_brush_aspect_ratio (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble aspect = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush-aspect-ratio",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    aspect = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return aspect;
}

/**
 * gimp_context_set_brush_aspect_ratio:
 * @aspect: Aspect ratio.
 *
 * Set brush aspect ratio.
 *
 * Set the aspect ratio for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_aspect_ratio (gdouble aspect)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, aspect,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-aspect-ratio",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush_angle:
 *
 * Get brush angle in degrees.
 *
 * Set the angle in degrees for brush based paint tools.
 *
 * Returns: Angle in degrees.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_brush_angle (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble angle = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush-angle",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    angle = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return angle;
}

/**
 * gimp_context_set_brush_angle:
 * @angle: Angle in degrees.
 *
 * Set brush angle in degrees.
 *
 * Set the angle in degrees for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_angle (gdouble angle)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, angle,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-angle",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush_spacing:
 *
 * Get brush spacing as percent of size.
 *
 * Get the brush spacing as percent of size for brush based paint
 * tools.
 *
 * Returns: Brush spacing as fraction of size.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_brush_spacing (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble spacing = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush-spacing",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    spacing = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return spacing;
}

/**
 * gimp_context_set_brush_spacing:
 * @spacing: Brush spacing as fraction of size.
 *
 * Set brush spacing as percent of size.
 *
 * Set the brush spacing as percent of size for brush based paint
 * tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_spacing (gdouble spacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, spacing,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-spacing",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_brush_default_spacing:
 *
 * Set brush spacing to its default.
 *
 * Set the brush spacing to the default for paintbrush, airbrush, or
 * pencil tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_default_spacing (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-default-spacing",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush_hardness:
 *
 * Get brush hardness in paint options.
 *
 * Get the brush hardness for brush based paint tools.
 *
 * Returns: Brush hardness.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_brush_hardness (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble hardness = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush-hardness",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    hardness = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return hardness;
}

/**
 * gimp_context_set_brush_hardness:
 * @hardness: Brush hardness.
 *
 * Set brush hardness.
 *
 * Set the brush hardness for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_hardness (gdouble hardness)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, hardness,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-hardness",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_brush_default_hardness:
 *
 * Set brush spacing to its default.
 *
 * Set the brush spacing to the default for paintbrush, airbrush, or
 * pencil tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_default_hardness (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-default-hardness",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_brush_force:
 *
 * Get brush force in paint options.
 *
 * Get the brush application force for brush based paint tools.
 *
 * Returns: Brush application force.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_brush_force (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble force = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-brush-force",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    force = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return force;
}

/**
 * gimp_context_set_brush_force:
 * @force: Brush application force.
 *
 * Set brush application force.
 *
 * Set the brush application force for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_force (gdouble force)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, force,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-brush-force",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_dynamics:
 *
 * Retrieve the currently active paint dynamics.
 *
 * This procedure returns the name of the currently active paint
 * dynamics. If enabled, all paint operations and stroke operations use
 * this paint dynamics to control the application of paint to the
 * image. If disabled, the dynamics will be ignored during paint
 * actions.
 * See gimp_context_are_dynamics_enabled() to enquire whether dynamics
 * are used or ignored.
 *
 * Returns: (transfer full): The name of the active paint dynamics.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_context_get_dynamics (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-dynamics",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_dynamics:
 * @name: The name of the paint dynamics.
 *
 * Set the specified paint dynamics as the active paint dynamics.
 *
 * This procedure allows the active paint dynamics to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the installed paint dynamics. If there is no
 * matching paint dynamics found, this procedure will return an error.
 * Otherwise, the specified paint dynamics becomes active and will be
 * used in all subsequent paint operations as long as dynamics are
 * enabled.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_dynamics (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-dynamics",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_are_dynamics_enabled:
 *
 * Inform whether the currently active paint dynamics will be applied
 * to painting.
 *
 * This procedure returns whether the currently active paint dynamics
 * (as returned by gimp_context_get_dynamics()) is enabled.
 *
 * Returns: Whether dynamics enabled or disabled.
 *
 * Since: 3.0
 **/
gboolean
gimp_context_are_dynamics_enabled (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean enabled = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-are-dynamics-enabled",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    enabled = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return enabled;
}

/**
 * gimp_context_enable_dynamics:
 * @enable: Whether to enable or disable dynamics.
 *
 * Set the specified paint dynamics as the active paint dynamics.
 *
 * This procedure enables the active paint dynamics to be used in all
 * subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_context_enable_dynamics (gboolean enable)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, enable,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-enable-dynamics",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_mypaint_brush:
 *
 * Retrieve the currently active MyPaint brush.
 *
 * This procedure returns the name of the currently active MyPaint
 * brush.
 *
 * Returns: (transfer full): The name of the active MyPaint brush.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.10
 **/
gchar *
gimp_context_get_mypaint_brush (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-mypaint-brush",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_mypaint_brush:
 * @name: The name of the MyPaint brush.
 *
 * Set the specified MyPaint brush as the active MyPaint brush.
 *
 * This procedure allows the active MyPaint brush to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the installed MyPaint brushes. If there is no
 * matching MyPaint brush found, this procedure will return an error.
 * Otherwise, the specified MyPaint brush becomes active and will be
 * used in all subsequent MyPaint paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_mypaint_brush (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-mypaint-brush",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_pattern:
 *
 * Retrieve the currently active pattern.
 *
 * This procedure returns name of the the currently active pattern. All
 * clone and bucket-fill operations with patterns will use this pattern
 * to control the application of paint to the image.
 *
 * Returns: (transfer full): The name of the active pattern.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_pattern (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-pattern",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_pattern:
 * @name: The name of the pattern.
 *
 * Set the specified pattern as the active pattern.
 *
 * This procedure allows the active pattern to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed patterns. If there is no matching pattern
 * found, this procedure will return an error. Otherwise, the specified
 * pattern becomes active and will be used in all subsequent paint
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_pattern (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-pattern",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_gradient:
 *
 * Retrieve the currently active gradient.
 *
 * This procedure returns the name of the currently active gradient.
 *
 * Returns: (transfer full): The name of the active gradient.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_gradient (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-gradient",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_gradient:
 * @name: The name of the gradient.
 *
 * Sets the specified gradient as the active gradient.
 *
 * This procedure lets you set the specified gradient as the active or
 * \"current\" one. The name is simply a string which corresponds to
 * one of the loaded gradients. If no matching gradient is found, this
 * procedure will return an error. Otherwise, the specified gradient
 * will become active and will be used for subsequent custom gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_gradient (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_bg_rgb:
 *
 * Sets the built-in FG-BG RGB gradient as the active gradient.
 *
 * This procedure sets the built-in FG-BG RGB gradient as the active
 * gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_bg_rgb (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-fg-bg-rgb",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_bg_hsv_cw:
 *
 * Sets the built-in FG-BG HSV (cw) gradient as the active gradient.
 *
 * This procedure sets the built-in FG-BG HSV (cw) gradient as the
 * active gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_bg_hsv_cw (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-fg-bg-hsv-cw",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_bg_hsv_ccw:
 *
 * Sets the built-in FG-BG HSV (ccw) gradient as the active gradient.
 *
 * This procedure sets the built-in FG-BG HSV (ccw) gradient as the
 * active gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_bg_hsv_ccw (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-fg-bg-hsv-ccw",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_transparent:
 *
 * Sets the built-in FG-Transparent gradient as the active gradient.
 *
 * This procedure sets the built-in FG-Transparent gradient as the
 * active gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_transparent (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-fg-transparent",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_gradient_blend_color_space:
 *
 * Get the gradient blend color space.
 *
 * Get the gradient blend color space for paint tools and the gradient
 * tool.
 *
 * Returns: Color blend space.
 *
 * Since: 2.10
 **/
GimpGradientBlendColorSpace
gimp_context_get_gradient_blend_color_space (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpGradientBlendColorSpace blend_color_space = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-gradient-blend-color-space",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    blend_color_space = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return blend_color_space;
}

/**
 * gimp_context_set_gradient_blend_color_space:
 * @blend_color_space: Blend color space.
 *
 * Set the gradient blend color space.
 *
 * Set the gradient blend color space for paint tools and the gradient
 * tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_blend_color_space (GimpGradientBlendColorSpace blend_color_space)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT_BLEND_COLOR_SPACE, blend_color_space,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-blend-color-space",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_gradient_repeat_mode:
 *
 * Get the gradient repeat mode.
 *
 * Get the gradient repeat mode for paint tools and the gradient tool.
 *
 * Returns: Repeat mode.
 *
 * Since: 2.10
 **/
GimpRepeatMode
gimp_context_get_gradient_repeat_mode (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpRepeatMode repeat_mode = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-gradient-repeat-mode",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    repeat_mode = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return repeat_mode;
}

/**
 * gimp_context_set_gradient_repeat_mode:
 * @repeat_mode: Repeat mode.
 *
 * Set the gradient repeat mode.
 *
 * Set the gradient repeat mode for paint tools and the gradient tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_repeat_mode (GimpRepeatMode repeat_mode)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_REPEAT_MODE, repeat_mode,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-repeat-mode",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_gradient_reverse:
 *
 * Get the gradient reverse setting.
 *
 * Get the gradient reverse setting for paint tools and the gradient
 * tool.
 *
 * Returns: Reverse.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_get_gradient_reverse (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean reverse = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-gradient-reverse",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    reverse = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return reverse;
}

/**
 * gimp_context_set_gradient_reverse:
 * @reverse: Reverse.
 *
 * Set the gradient reverse setting.
 *
 * Set the gradient reverse setting for paint tools and the gradient
 * tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_reverse (gboolean reverse)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, reverse,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-gradient-reverse",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_palette:
 *
 * Retrieve the currently active palette.
 *
 * This procedure returns the name of the the currently active palette.
 *
 * Returns: (transfer full): The name of the active palette.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_palette (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-palette",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_palette:
 * @name: The name of the palette.
 *
 * Set the specified palette as the active palette.
 *
 * This procedure allows the active palette to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed palettes. If no matching palette is found,
 * this procedure will return an error. Otherwise, the specified
 * palette becomes active and will be used in all subsequent palette
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_palette (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-palette",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_font:
 *
 * Retrieve the currently active font.
 *
 * This procedure returns the name of the currently active font.
 *
 * Returns: (transfer full): The name of the active font.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_font (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-font",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_context_set_font:
 * @name: The name of the font.
 *
 * Set the specified font as the active font.
 *
 * This procedure allows the active font to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed fonts. If no matching font is found, this
 * procedure will return an error. Otherwise, the specified font
 * becomes active and will be used in all subsequent font operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_font (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-font",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_antialias:
 *
 * Get the antialias setting.
 *
 * This procedure returns the antialias setting.
 *
 * Returns: The antialias setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_antialias (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean antialias = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-antialias",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    antialias = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return antialias;
}

/**
 * gimp_context_set_antialias:
 * @antialias: The antialias setting.
 *
 * Set the antialias setting.
 *
 * This procedure modifies the antialias setting. If antialiasing is
 * turned on, the edges of selected region will contain intermediate
 * values which give the appearance of a sharper, less pixelized edge.
 * This should be set as TRUE most of the time unless a binary-only
 * selection is wanted.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_image_select_round_rectangle(), gimp_image_select_ellipse(),
 * gimp_image_select_polygon(), gimp_image_select_item(),
 * gimp_drawable_edit_bucket_fill(), gimp_drawable_edit_stroke_item(),
 * gimp_drawable_edit_stroke_selection().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_antialias (gboolean antialias)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, antialias,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-antialias",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_feather:
 *
 * Get the feather setting.
 *
 * This procedure returns the feather setting.
 *
 * Returns: The feather setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_feather (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean feather = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-feather",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    feather = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return feather;
}

/**
 * gimp_context_set_feather:
 * @feather: The feather setting.
 *
 * Set the feather setting.
 *
 * This procedure modifies the feather setting. If the feather option
 * is enabled, selections will be blurred before combining. The blur is
 * a gaussian blur; its radii can be controlled using
 * gimp_context_set_feather_radius().
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_image_select_rectangle(), gimp_image_select_round_rectangle(),
 * gimp_image_select_ellipse(), gimp_image_select_polygon(),
 * gimp_image_select_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_feather (gboolean feather)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, feather,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-feather",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_feather_radius:
 * @feather_radius_x: (out): The horizontal feather radius.
 * @feather_radius_y: (out): The vertical feather radius.
 *
 * Get the feather radius setting.
 *
 * This procedure returns the feather radius setting.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_feather_radius (gdouble *feather_radius_x,
                                 gdouble *feather_radius_y)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-feather-radius",
                                              args);
  gimp_value_array_unref (args);

  *feather_radius_x = 0.0;
  *feather_radius_y = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *feather_radius_x = GIMP_VALUES_GET_DOUBLE (return_vals, 1);
      *feather_radius_y = GIMP_VALUES_GET_DOUBLE (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_set_feather_radius:
 * @feather_radius_x: The horizontal feather radius.
 * @feather_radius_y: The vertical feather radius.
 *
 * Set the feather radius setting.
 *
 * This procedure modifies the feather radius setting.
 *
 * This setting affects all procedures that are affected by
 * gimp_context_set_feather().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_feather_radius (gdouble feather_radius_x,
                                 gdouble feather_radius_y)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, feather_radius_x,
                                          G_TYPE_DOUBLE, feather_radius_y,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-feather-radius",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_sample_merged:
 *
 * Get the sample merged setting.
 *
 * This procedure returns the sample merged setting.
 *
 * Returns: The sample merged setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_sample_merged (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean sample_merged = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-sample-merged",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    sample_merged = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return sample_merged;
}

/**
 * gimp_context_set_sample_merged:
 * @sample_merged: The sample merged setting.
 *
 * Set the sample merged setting.
 *
 * This procedure modifies the sample merged setting. If an operation
 * depends on the colors of the pixels present in a drawable, like when
 * doing a seed fill, this setting controls whether the pixel data from
 * the specified drawable is used ('sample-merged' is FALSE), or the
 * pixel data from the composite image ('sample-merged' is TRUE. This
 * is equivalent to sampling for colors after merging all visible
 * layers).
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_merged (gboolean sample_merged)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, sample_merged,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-sample-merged",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_sample_criterion:
 *
 * Get the sample criterion setting.
 *
 * This procedure returns the sample criterion setting.
 *
 * Returns: The sample criterion setting.
 *
 * Since: 2.8
 **/
GimpSelectCriterion
gimp_context_get_sample_criterion (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpSelectCriterion sample_criterion = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-sample-criterion",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    sample_criterion = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return sample_criterion;
}

/**
 * gimp_context_set_sample_criterion:
 * @sample_criterion: The sample criterion setting.
 *
 * Set the sample criterion setting.
 *
 * This procedure modifies the sample criterion setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls how color
 * similarity is determined. SELECT_CRITERION_COMPOSITE is the default
 * value.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_criterion (GimpSelectCriterion sample_criterion)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_SELECT_CRITERION, sample_criterion,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-sample-criterion",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_sample_threshold:
 *
 * Get the sample threshold setting.
 *
 * This procedure returns the sample threshold setting.
 *
 * Returns: The sample threshold setting.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_sample_threshold (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble sample_threshold = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-sample-threshold",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    sample_threshold = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return sample_threshold;
}

/**
 * gimp_context_set_sample_threshold:
 * @sample_threshold: The sample threshold setting.
 *
 * Set the sample threshold setting.
 *
 * This procedure modifies the sample threshold setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls what is
 * \"sufficiently close\" to be considered a similar color. If the
 * sample threshold has not been set explicitly, the default threshold
 * set in gimprc will be used.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_threshold (gdouble sample_threshold)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, sample_threshold,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-sample-threshold",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_sample_threshold_int:
 *
 * Get the sample threshold setting as an integer value.
 *
 * This procedure returns the sample threshold setting as an integer
 * value. See gimp_context_get_sample_threshold().
 *
 * Returns: The sample threshold setting.
 *
 * Since: 2.8
 **/
gint
gimp_context_get_sample_threshold_int (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint sample_threshold = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-sample-threshold-int",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    sample_threshold = GIMP_VALUES_GET_INT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return sample_threshold;
}

/**
 * gimp_context_set_sample_threshold_int:
 * @sample_threshold: The sample threshold setting.
 *
 * Set the sample threshold setting as an integer value.
 *
 * This procedure modifies the sample threshold setting as an integer
 * value. See gimp_context_set_sample_threshold().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_threshold_int (gint sample_threshold)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, sample_threshold,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-sample-threshold-int",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_sample_transparent:
 *
 * Get the sample transparent setting.
 *
 * This procedure returns the sample transparent setting.
 *
 * Returns: The sample transparent setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_sample_transparent (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean sample_transparent = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-sample-transparent",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    sample_transparent = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return sample_transparent;
}

/**
 * gimp_context_set_sample_transparent:
 * @sample_transparent: The sample transparent setting.
 *
 * Set the sample transparent setting.
 *
 * This procedure modifies the sample transparent setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls whether
 * transparency is considered to be a unique selectable color. When
 * this setting is TRUE, transparent areas can be selected or filled.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_transparent (gboolean sample_transparent)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, sample_transparent,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-sample-transparent",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_diagonal_neighbors:
 *
 * Get the diagonal neighbors setting.
 *
 * This procedure returns the diagonal neighbors setting.
 *
 * Returns: The diagonal neighbors setting.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_get_diagonal_neighbors (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean diagonal_neighbors = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-diagonal-neighbors",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    diagonal_neighbors = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return diagonal_neighbors;
}

/**
 * gimp_context_set_diagonal_neighbors:
 * @diagonal_neighbors: The diagonal neighbors setting.
 *
 * Set the diagonal neighbors setting.
 *
 * This procedure modifies the diagonal neighbors setting. If the
 * affected region of an operation is based on a seed point, like when
 * doing a seed fill, then, when this setting is TRUE, all eight
 * neighbors of each pixel are considered when calculating the affected
 * region; in contrast, when this setting is FALSE, only the four
 * orthogonal neighbors of each pixel are considered.
 *
 * This setting affects the following procedures:
 * gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_diagonal_neighbors (gboolean diagonal_neighbors)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_BOOLEAN, diagonal_neighbors,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-diagonal-neighbors",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_distance_metric:
 *
 * Get the distance metric used in some computations.
 *
 * This procedure returns the distance metric in the current context.
 * See gimp_context_set_distance_metric() to know more about its usage.
 *
 * Returns: The distance metric.
 *
 * Since: 2.10
 **/
GeglDistanceMetric
gimp_context_get_distance_metric (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GeglDistanceMetric metric = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-distance-metric",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    metric = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return metric;
}

/**
 * gimp_context_set_distance_metric:
 * @metric: The distance metric.
 *
 * Set the distance metric used in some computations.
 *
 * This procedure modifies the distance metric used in some
 * computations, such as gimp_drawable_edit_gradient_fill(). In
 * particular, it does not change the metric used in generic distance
 * computation on canvas, as in the Measure tool.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_gradient_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_distance_metric (GeglDistanceMetric metric)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GEGL_TYPE_DISTANCE_METRIC, metric,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-distance-metric",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_interpolation:
 *
 * Get the interpolation type.
 *
 * This procedure returns the interpolation setting. The return value
 * is an integer which corresponds to the values listed in the argument
 * description. If the interpolation has not been set explicitly by
 * gimp_context_set_interpolation(), the default interpolation set in
 * gimprc will be used.
 *
 * Returns: The interpolation type.
 *
 * Since: 2.8
 **/
GimpInterpolationType
gimp_context_get_interpolation (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpInterpolationType interpolation = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-interpolation",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    interpolation = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return interpolation;
}

/**
 * gimp_context_set_interpolation:
 * @interpolation: The interpolation type.
 *
 * Set the interpolation type.
 *
 * This procedure modifies the interpolation setting.
 *
 * This setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_perspective(),
 * gimp_item_transform_rotate(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix(), gimp_image_scale(),
 * gimp_layer_scale().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_interpolation (GimpInterpolationType interpolation)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_INTERPOLATION_TYPE, interpolation,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-interpolation",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_transform_direction:
 *
 * Get the transform direction.
 *
 * This procedure returns the transform direction. The return value is
 * an integer which corresponds to the values listed in the argument
 * description.
 *
 * Returns: The transform direction.
 *
 * Since: 2.8
 **/
GimpTransformDirection
gimp_context_get_transform_direction (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpTransformDirection transform_direction = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-transform-direction",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    transform_direction = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return transform_direction;
}

/**
 * gimp_context_set_transform_direction:
 * @transform_direction: The transform direction.
 *
 * Set the transform direction.
 *
 * This procedure modifies the transform direction setting.
 *
 * This setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_perspective(),
 * gimp_item_transform_rotate(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_transform_direction (GimpTransformDirection transform_direction)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TRANSFORM_DIRECTION, transform_direction,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-transform-direction",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_transform_resize:
 *
 * Get the transform resize type.
 *
 * This procedure returns the transform resize setting. The return
 * value is an integer which corresponds to the values listed in the
 * argument description.
 *
 * Returns: The transform resize type.
 *
 * Since: 2.8
 **/
GimpTransformResize
gimp_context_get_transform_resize (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpTransformResize transform_resize = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-transform-resize",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    transform_resize = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return transform_resize;
}

/**
 * gimp_context_set_transform_resize:
 * @transform_resize: The transform resize type.
 *
 * Set the transform resize type.
 *
 * This procedure modifies the transform resize setting. When
 * transforming pixels, if the result of a transform operation has a
 * different size than the original area, this setting determines how
 * the resulting area is sized.
 *
 * This setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_flip_simple(),
 * gimp_item_transform_perspective(), gimp_item_transform_rotate(),
 * gimp_item_transform_rotate_simple(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_transform_resize (GimpTransformResize transform_resize)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TRANSFORM_RESIZE, transform_resize,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-transform-resize",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_size:
 *
 * Get ink blob size in pixels.
 *
 * Get the ink blob size in pixels for ink tool.
 *
 * Returns: ink blob size in pixels.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_size (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble size = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-size",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    size = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return size;
}

/**
 * gimp_context_set_ink_size:
 * @size: ink blob size in pixels.
 *
 * Set ink blob size in pixels.
 *
 * Set the ink blob size in pixels for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_size (gdouble size)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, size,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-size",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_angle:
 *
 * Get ink angle in degrees.
 *
 * Get the ink angle in degrees for ink tool.
 *
 * Returns: ink angle in degrees.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_angle (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble angle = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-angle",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    angle = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return angle;
}

/**
 * gimp_context_set_ink_angle:
 * @angle: ink angle in degrees.
 *
 * Set ink angle in degrees.
 *
 * Set the ink angle in degrees for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_angle (gdouble angle)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, angle,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-angle",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_size_sensitivity:
 *
 * Get ink size sensitivity.
 *
 * Get the ink size sensitivity for ink tool.
 *
 * Returns: ink size sensitivity.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_size_sensitivity (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble size = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-size-sensitivity",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    size = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return size;
}

/**
 * gimp_context_set_ink_size_sensitivity:
 * @size: ink size sensitivity.
 *
 * Set ink size sensitivity.
 *
 * Set the ink size sensitivity for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_size_sensitivity (gdouble size)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, size,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-size-sensitivity",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_tilt_sensitivity:
 *
 * Get ink tilt sensitivity.
 *
 * Get the ink tilt sensitivity for ink tool.
 *
 * Returns: ink tilt sensitivity.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_tilt_sensitivity (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble tilt = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-tilt-sensitivity",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    tilt = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return tilt;
}

/**
 * gimp_context_set_ink_tilt_sensitivity:
 * @tilt: ink tilt sensitivity.
 *
 * Set ink tilt sensitivity.
 *
 * Set the ink tilt sensitivity for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_tilt_sensitivity (gdouble tilt)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, tilt,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-tilt-sensitivity",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_speed_sensitivity:
 *
 * Get ink speed sensitivity.
 *
 * Get the ink speed sensitivity for ink tool.
 *
 * Returns: ink speed sensitivity.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_speed_sensitivity (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble speed = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-speed-sensitivity",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    speed = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return speed;
}

/**
 * gimp_context_set_ink_speed_sensitivity:
 * @speed: ink speed sensitivity.
 *
 * Set ink speed sensitivity.
 *
 * Set the ink speed sensitivity for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_speed_sensitivity (gdouble speed)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, speed,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-speed-sensitivity",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_blob_type:
 *
 * Get ink blob type.
 *
 * Get the ink blob type for ink tool.
 *
 * Returns: Ink blob type.
 *
 * Since: 2.8
 **/
GimpInkBlobType
gimp_context_get_ink_blob_type (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpInkBlobType type = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-blob-type",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    type = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return type;
}

/**
 * gimp_context_set_ink_blob_type:
 * @type: Ink blob type.
 *
 * Set ink blob type.
 *
 * Set the ink blob type for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_blob_type (GimpInkBlobType type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_INK_BLOB_TYPE, type,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-blob-type",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_blob_aspect_ratio:
 *
 * Get ink blob aspect ratio.
 *
 * Get the ink blob aspect ratio for ink tool.
 *
 * Returns: ink blob aspect ratio.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_blob_aspect_ratio (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble aspect = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-blob-aspect-ratio",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    aspect = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return aspect;
}

/**
 * gimp_context_set_ink_blob_aspect_ratio:
 * @aspect: ink blob aspect ratio.
 *
 * Set ink blob aspect ratio.
 *
 * Set the ink blob aspect ratio for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_blob_aspect_ratio (gdouble aspect)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, aspect,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-blob-aspect-ratio",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_context_get_ink_blob_angle:
 *
 * Get ink blob angle in degrees.
 *
 * Get the ink blob angle in degrees for ink tool.
 *
 * Returns: ink blob angle in degrees.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_blob_angle (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble angle = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-get-ink-blob-angle",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    angle = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return angle;
}

/**
 * gimp_context_set_ink_blob_angle:
 * @angle: ink blob angle in degrees.
 *
 * Set ink blob angle in degrees.
 *
 * Set the ink blob angle in degrees for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_blob_angle (gdouble angle)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_DOUBLE, angle,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-context-set-ink-blob-angle",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
