/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <cairo.h>
#include <string.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpcolor/gimpcolor.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimppalette.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GimpValueArray *
palette_new_invoker (GimpProcedure         *procedure,
                     Gimp                  *gimp,
                     GimpContext           *context,
                     GimpProgress          *progress,
                     const GimpValueArray  *args,
                     GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gchar *actual_name = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpData *data = gimp_data_factory_data_new (gimp->palette_factory,
                                                   context, name);

      if (data)
        actual_name = g_strdup (gimp_object_get_name (data));
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), actual_name);

  return return_vals;
}

static GimpValueArray *
palette_duplicate_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gchar *copy_name = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        {
          GimpPalette *palette_copy = (GimpPalette *)
            gimp_data_factory_data_duplicate (gimp->palette_factory,
                                              GIMP_DATA (palette));

          if (palette_copy)
            copy_name = g_strdup (gimp_object_get_name (palette_copy));
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), copy_name);

  return return_vals;
}

static GimpValueArray *
palette_rename_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  const gchar *new_name;
  gchar *actual_name = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  new_name = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_RENAME, error);

      if (palette)
        {
          gimp_object_set_name (GIMP_OBJECT (palette), new_name);
          actual_name = g_strdup (gimp_object_get_name (palette));
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), actual_name);

  return return_vals;
}

static GimpValueArray *
palette_delete_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette && gimp_data_is_deletable (GIMP_DATA (palette)))
        success = gimp_data_factory_data_delete (gimp->palette_factory,
                                                 GIMP_DATA (palette),
                                                 TRUE, error);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
palette_is_editable_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gboolean editable = FALSE;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        editable = gimp_data_is_writable (GIMP_DATA (palette));
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), editable);

  return return_vals;
}

static GimpValueArray *
palette_get_info_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gint num_colors = 0;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        num_colors = gimp_palette_get_n_colors (palette);
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), num_colors);

  return return_vals;
}

static GimpValueArray *
palette_get_colors_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gint num_colors = 0;
  GimpRGB *colors = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        {
          GList *list = gimp_palette_get_colors (palette);
          gint   i;

          num_colors = gimp_palette_get_n_colors (palette);
          colors     = g_new (GimpRGB, num_colors);

          for (i = 0; i < num_colors; i++, list = g_list_next (list))
            {
              GimpPaletteEntry *entry = list->data;

              colors[i] = entry->color;
            }
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), num_colors);
      gimp_value_take_rgb_array (gimp_value_array_index (return_vals, 2), colors, num_colors);
    }

  return return_vals;
}

static GimpValueArray *
palette_get_columns_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gint num_columns = 0;

  name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        num_columns = gimp_palette_get_columns (palette);
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), num_columns);

  return return_vals;
}

static GimpValueArray *
palette_set_columns_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;
  gint columns;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  columns = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_WRITE, error);

      if (palette)
        gimp_palette_set_columns (palette, columns);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
palette_add_entry_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  const gchar *entry_name;
  GimpRGB color;
  gint entry_num = 0;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  entry_name = g_value_get_string (gimp_value_array_index (args, 1));
  gimp_value_get_rgb (gimp_value_array_index (args, 2), &color);

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_WRITE, error);

      if (palette)
        {
          GimpPaletteEntry *entry =
            gimp_palette_add_entry (palette, -1, entry_name, &color);

          entry_num = gimp_palette_get_entry_position (palette, entry);
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), entry_num);

  return return_vals;
}

static GimpValueArray *
palette_delete_entry_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;
  gint entry_num;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  entry_num = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_WRITE, error);

      if (palette)
        {
          GimpPaletteEntry *entry = gimp_palette_get_entry (palette, entry_num);

          if (entry)
            gimp_palette_delete_entry (palette, entry);
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
palette_entry_get_color_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gint entry_num;
  GimpRGB color = { 0.0, 0.0, 0.0, 1.0 };

  name = g_value_get_string (gimp_value_array_index (args, 0));
  entry_num = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        {
          GimpPaletteEntry *entry = gimp_palette_get_entry (palette, entry_num);

          if (entry)
            color = entry->color;
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_rgb (gimp_value_array_index (return_vals, 1), &color);

  return return_vals;
}

static GimpValueArray *
palette_entry_set_color_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;
  gint entry_num;
  GimpRGB color;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  entry_num = g_value_get_int (gimp_value_array_index (args, 1));
  gimp_value_get_rgb (gimp_value_array_index (args, 2), &color);

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_WRITE, error);

      if (palette)
        success = gimp_palette_set_entry_color (palette, entry_num, &color);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
palette_entry_get_name_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  gint entry_num;
  gchar *entry_name = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  entry_num = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_READ, error);

      if (palette)
        {
          GimpPaletteEntry *entry = gimp_palette_get_entry (palette, entry_num);

          if (entry)
            entry_name = g_strdup (entry->name);
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), entry_name);

  return return_vals;
}

static GimpValueArray *
palette_entry_set_name_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  const gchar *name;
  gint entry_num;
  const gchar *entry_name;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  entry_num = g_value_get_int (gimp_value_array_index (args, 1));
  entry_name = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, GIMP_PDB_DATA_ACCESS_WRITE, error);

      if (palette)
        success = gimp_palette_set_entry_name (palette, entry_num, entry_name);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_palette_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-palette-new
   */
  procedure = gimp_procedure_new (palette_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-new");
  gimp_procedure_set_static_help (procedure,
                                  "Creates a new palette",
                                  "This procedure creates a new, uninitialized palette",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The requested name of the new palette",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("actual-name",
                                                           "actual name",
                                                           "The actual new palette name",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-duplicate
   */
  procedure = gimp_procedure_new (palette_duplicate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-duplicate");
  gimp_procedure_set_static_help (procedure,
                                  "Duplicates a palette",
                                  "This procedure creates an identical palette by a different name",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("copy-name",
                                                           "copy name",
                                                           "The name of the palette's copy",
                                                           FALSE, FALSE, TRUE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-rename
   */
  procedure = gimp_procedure_new (palette_rename_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-rename");
  gimp_procedure_set_static_help (procedure,
                                  "Rename a palette",
                                  "This procedure renames a palette",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("new-name",
                                                       "new name",
                                                       "The new name of the palette",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("actual-name",
                                                           "actual name",
                                                           "The actual new name of the palette",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-delete
   */
  procedure = gimp_procedure_new (palette_delete_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-delete");
  gimp_procedure_set_static_help (procedure,
                                  "Deletes a palette",
                                  "This procedure deletes a palette",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-is-editable
   */
  procedure = gimp_procedure_new (palette_is_editable_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-is-editable");
  gimp_procedure_set_static_help (procedure,
                                  "Tests if palette can be edited",
                                  "Returns TRUE if you have permission to change the palette",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                         "Bill Skaggs",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("editable",
                                                         "editable",
                                                         "TRUE if the palette can be edited",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-get-info
   */
  procedure = gimp_procedure_new (palette_get_info_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-get-info");
  gimp_procedure_set_static_help (procedure,
                                  "Retrieve information about the specified palette.",
                                  "This procedure retrieves information about the specified palette. This includes the name, and the number of colors.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-colors",
                                                     "num colors",
                                                     "The number of colors in the palette",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-get-colors
   */
  procedure = gimp_procedure_new (palette_get_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-get-colors");
  gimp_procedure_set_static_help (procedure,
                                  "Gets all colors from the specified palette.",
                                  "This procedure retrieves all color entries of the specified palette.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2006");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-colors",
                                                     "num colors",
                                                     "Length of the colors array",
                                                     0, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb_array ("colors",
                                                              "colors",
                                                              "The colors in the palette",
                                                              GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-get-columns
   */
  procedure = gimp_procedure_new (palette_get_columns_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-get-columns");
  gimp_procedure_set_static_help (procedure,
                                  "Retrieves the number of columns to use to display this palette",
                                  "This procedures retrieves the preferred number of columns to use when the palette is being displayed.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2005");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-columns",
                                                     "num columns",
                                                     "The number of columns used to display this palette",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-set-columns
   */
  procedure = gimp_procedure_new (palette_set_columns_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-set-columns");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the number of columns to use when displaying the palette",
                                  "This procedures controls how many colors are shown per row when the palette is being displayed. This value can only be changed if the palette is writable. The maximum allowed value is 64.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2005");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("columns",
                                                 "columns",
                                                 "The new number of columns",
                                                 0, 64, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-add-entry
   */
  procedure = gimp_procedure_new (palette_add_entry_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-add-entry");
  gimp_procedure_set_static_help (procedure,
                                  "Adds a palette entry to the specified palette.",
                                  "This procedure adds an entry to the specified palette. It returns an error if the entry palette does not exist.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("entry-name",
                                                       "entry name",
                                                       "The name of the entry",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("color",
                                                    "color",
                                                    "The new entry's color color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("entry-num",
                                                     "entry num",
                                                     "The index of the added entry",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-delete-entry
   */
  procedure = gimp_procedure_new (palette_delete_entry_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-delete-entry");
  gimp_procedure_set_static_help (procedure,
                                  "Deletes a palette entry from the specified palette.",
                                  "This procedure deletes an entry from the specified palette. It returns an error if the entry palette does not exist.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("entry-num",
                                                 "entry num",
                                                 "The index of the added entry",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-get-color
   */
  procedure = gimp_procedure_new (palette_entry_get_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-entry-get-color");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the specified palette entry from the specified palette.",
                                  "This procedure retrieves the color of the zero-based entry specified for the specified palette. It returns an error if the entry does not exist.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("entry-num",
                                                 "entry num",
                                                 "The entry to retrieve",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("color",
                                                        "color",
                                                        "The color requested",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-set-color
   */
  procedure = gimp_procedure_new (palette_entry_set_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-entry-set-color");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the specified palette entry in the specified palette.",
                                  "This procedure sets the color of the zero-based entry specified for the specified palette. It returns an error if the entry does not exist.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("entry-num",
                                                 "entry num",
                                                 "The entry to retrieve",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("color",
                                                    "color",
                                                    "The new color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-get-name
   */
  procedure = gimp_procedure_new (palette_entry_get_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-entry-get-name");
  gimp_procedure_set_static_help (procedure,
                                  "Gets the specified palette entry from the specified palette.",
                                  "This procedure retrieves the name of the zero-based entry specified for the specified palette. It returns an error if the entry does not exist.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("entry-num",
                                                 "entry num",
                                                 "The entry to retrieve",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("entry-name",
                                                           "entry name",
                                                           "The name requested",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-set-name
   */
  procedure = gimp_procedure_new (palette_entry_set_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-palette-entry-set-name");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the specified palette entry in the specified palette.",
                                  "This procedure sets the name of the zero-based entry specified for the specified palette. It returns an error if the entry does not exist.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("entry-num",
                                                 "entry num",
                                                 "The entry to retrieve",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("entry-name",
                                                       "entry name",
                                                       "The new name",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
