/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppattern_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimppattern
 * @title: gimppattern
 * @short_description: Installable object used by fill and clone tools.
 *
 * Installable object used by fill and clone tools.
 **/


/**
 * gimp_pattern_get_by_name:
 * @name: The name of the pattern.
 *
 * Returns the pattern with the given name.
 *
 * Returns the pattern with the given name.
 *
 * Returns: (transfer full): The pattern.
 *
 * Since: 3.0
 **/
GimpPattern *
gimp_pattern_get_by_name (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpPattern *pattern = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-pattern-get-by-name",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    pattern = GIMP_VALUES_GET_PATTERN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return pattern;
}

/**
 * gimp_pattern_get_info:
 * @pattern: The pattern.
 * @width: (out): The pattern width.
 * @height: (out): The pattern height.
 * @bpp: (out): The pattern bpp.
 *
 * Gets information about the pattern.
 *
 * Gets information about the pattern: the pattern extents (width and
 * height) and bytes per pixel.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_pattern_get_info (GimpPattern *pattern,
                       gint        *width,
                       gint        *height,
                       gint        *bpp)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_PATTERN, pattern,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-pattern-get-info",
                                              args);
  gimp_value_array_unref (args);

  *width = 0;
  *height = 0;
  *bpp = 0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = GIMP_VALUES_GET_INT (return_vals, 1);
      *height = GIMP_VALUES_GET_INT (return_vals, 2);
      *bpp = GIMP_VALUES_GET_INT (return_vals, 3);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_pattern_get_pixels:
 * @pattern: The pattern.
 * @width: (out): The pattern width.
 * @height: (out): The pattern height.
 * @bpp: (out): The pattern bpp.
 * @color_bytes: (out) (transfer full): The pattern data.
 *
 * Gets information about the pattern (including pixels).
 *
 * Gets information about the pattern: the pattern extents (width and
 * height), its bpp, and its pixel data. The pixel data is an array in
 * C or a list in some languages.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_pattern_get_pixels (GimpPattern  *pattern,
                         gint         *width,
                         gint         *height,
                         gint         *bpp,
                         GBytes      **color_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_PATTERN, pattern,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-pattern-get-pixels",
                                              args);
  gimp_value_array_unref (args);

  *width = 0;
  *height = 0;
  *bpp = 0;
  *color_bytes = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = GIMP_VALUES_GET_INT (return_vals, 1);
      *height = GIMP_VALUES_GET_INT (return_vals, 2);
      *bpp = GIMP_VALUES_GET_INT (return_vals, 3);
      *color_bytes = GIMP_VALUES_DUP_BYTES (return_vals, 4);
    }

  gimp_value_array_unref (return_vals);

  return success;
}
