/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#if !defined (__GTK_H_INSIDE__) && !defined (GTK_COMPILATION)
#error "Only <gtk/gtk.h> can be included directly."
#endif

#ifndef __GTK_TYPE_UTILS_H__
#define __GTK_TYPE_UTILS_H__

/* enum types generated by glib-mkenums
 */
#include <gtk/gtktypebuiltins.h>

G_BEGIN_DECLS

/* urg */
#define GTK_TYPE_IDENTIFIER (gtk_identifier_get_type ())
GType gtk_identifier_get_type (void) G_GNUC_CONST;

/* --- typedefs --- */
/* here we come with some necessary forward declarations for structures and
 * provide some fundamental function signatures
 */
typedef struct _GtkArg	       	     GtkArg;
typedef struct _GtkObject   	     GtkObject; /* object forward declaration */
typedef gboolean (*GtkFunction)	    (gpointer      data);
typedef void (*GtkCallbackMarshal)  (GtkObject    *object,
				     gpointer      data,
				     guint         n_args,
				     GtkArg       *args);

/* This used to be defined in gtkitemfactory.h, but moved over here after
 * the complete deprecation of that header
 */
typedef gchar * (*GtkTranslateFunc) (const gchar  *path,
				     gpointer      func_data);

#if defined (GTK_COMPILATION)
/* GtkArg, used to hold differently typed values */
struct _GtkArg
{
  GType type;
  gchar *name;

  /* this union only defines the required storage types for
   * the possibile values, thus there is no gint enum_data field,
   * because that would just be a mere alias for gint int_data.
   * use the GTK_VALUE_*() and GTK_RETLOC_*() macros to access
   * the discrete memebers.
   */
  union {
    /* flat values */
    gchar char_data;
    guchar uchar_data;
    gboolean bool_data;
    gint int_data;
    guint uint_data;
    glong long_data;
    gulong ulong_data;
    gfloat float_data;
    gdouble double_data;
    gchar *string_data;
    GtkObject *object_data;
    gpointer pointer_data;

    /* structured values */
    struct {
      GCallback f;
      gpointer d;
    } signal_data;
  } d;
};
#endif /* GTK_COMPILATION */

G_END_DECLS

#endif /* __GTK_TYPE_UTILS_H__ */
