/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtktreefork.h"


static void gtk_tree_fork_class_init (GtkTreeForkClass *klass);
static void gtk_tree_fork_init       (GtkTreeFork      *tree_fork);


guint
gtk_tree_fork_get_type ()
{
  static guint tree_fork_type = 0;

  if (!tree_fork_type)
    {
      GtkTypeInfo tree_fork_info =
      {
	"GtkTreeFork",
	sizeof (GtkTreeFork),
	sizeof (GtkTreeForkClass),
	(GtkClassInitFunc) gtk_tree_fork_class_init,
	(GtkObjectInitFunc) gtk_tree_fork_init,
	(GtkArgFunc) NULL,
      };

      tree_fork_type
	  = gtk_type_unique (gtk_widget_get_type (), &tree_fork_info);
    }

  return tree_fork_type;
}

static void
gtk_tree_fork_class_init (GtkTreeForkClass *class)
{
  class->_xxx_expand = NULL;
  class->_xxx_collapse = NULL;
}

static void
gtk_tree_fork_init (GtkTreeFork *tree_fork)
{
  GTK_WIDGET_SET_FLAGS (tree_fork, GTK_NO_WINDOW | GTK_BASIC);
}

void
gtk_tree_fork__xxx_expand (GtkTreeFork *tree_fork) /* XXX rename me ! */
{
  GtkTreeForkClass *tree_fork_class;
    
  g_return_if_fail (tree_fork != NULL);
  g_return_if_fail (GTK_IS_TREE_FORK (tree_fork));

  tree_fork_class = GTK_TREE_FORK_CLASS (GTK_OBJECT (tree_fork)->klass);

  if (tree_fork_class->_xxx_expand)
    (* tree_fork_class->_xxx_expand) (tree_fork);
}

void
gtk_tree_fork__xxx_collapse (GtkTreeFork *tree_fork) /* XXX rename me ! */
{
  GtkTreeForkClass *tree_fork_class;
    
  g_return_if_fail (tree_fork != NULL);
  g_return_if_fail (GTK_IS_TREE_FORK (tree_fork));

  tree_fork_class = GTK_TREE_FORK_CLASS (GTK_OBJECT (tree_fork)->klass);

  if (tree_fork_class->_xxx_collapse)
    (* tree_fork_class->_xxx_collapse) (tree_fork);
}
