/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTKACTION_H
#define GTOOLKIT_GTKACTION_H

#include <Foundation/NSObject.h>
#include <gtk/gtktypeutils.h>

/*
 * The GTKAction class manages connections between objects.
 * Instances of this class can be passed as arguments to @GTK's
 * @GTK#-connectSignal:withAction: methods.
 */
@interface GTKAction : NSObject
{
    id target;		// target object of this action
    SEL selector;	// target selector to perform
    IMP method;		// target function pointer
    void *data;		// optional user data
    BOOL retained;	// user data should be retained
}

/* creating actions */
+ (id) actionWithTarget:(id) target selector:(SEL) selector;
+ (id) actionWithTarget:(id) target selector:(SEL) selector
       data:(const void *) data;
- (id) initWithTarget:(id) target selector:(SEL) selector;
- (id) initWithTarget:(id) target selector:(SEL) selector
       data:(const void *) data;
- (void) setTarget:(id) target selector:(SEL) selector;
- (void) setData:(const void *) data;
- (void) retainData;

/* inspecting action values */
- (id) target;
- (SEL) selector;
- (void *) data;
- (BOOL) dataRetained;

/* invoking an action */
- (void) performWithSender:(id) sender args:(GtkArg *) args
	 count:(unsigned) count;
@end

#endif /* GTOOLKIT_GTKACTION_H */
