/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtknotebook.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKNOTEBOOK_H
#define GTOOLKIT_GTKNOTEBOOK_H

#include <GToolKit/GTKContainer.h>
#include <gtk/gtknotebook.h>

@class GTKWidget;

@interface GTKNotebook : GTKContainer
+ (GtkType) getType;
+ (id) notebook;
- (id) init;
- (void) appendPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label;
- (void) appendPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label;
- (void) prependPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label;
- (void) prependPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label;
- (void) insertPage:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label position:(gint) position;
- (void) insertPageMenu:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label menuLabel:(GTKWidget *) menu_label position:(gint) position;
- (void) removePage:(gint) page_num;
- (gint) getCurrentPage;
- (GTKWidget*) getNthPage:(gint) page_num;
- (gint) pageNum:(GTKWidget *) child;
- (void) setPage:(gint) page_num;
- (void) nextPage;
- (void) prevPage;
- (void) setShowBorder:(gboolean) show_border;
- (void) setShowTabs:(gboolean) show_tabs;
- (void) setTabPos:(GtkPositionType) pos;
- (void) setHomogeneousTabs:(gboolean) homogeneous;
- (void) setTabBorder:(guint) border_width;
- (void) setTabHborder:(guint) tab_hborder;
- (void) setTabVborder:(guint) tab_vborder;
- (void) setScrollable:(gboolean) scrollable;
- (void) popupEnable;
- (void) popupDisable;
- (GTKWidget *) getTabLabel:(GTKWidget *) child;
- (void) setTabLabel:(GTKWidget *) child tabLabel:(GTKWidget *) tab_label;
- (void) setTabLabelText:(GTKWidget *) child tabText:(NSString *) tab_text;
- (GTKWidget *) getMenuLabel:(GTKWidget *) child;
- (void) setMenuLabel:(GTKWidget *) child menuLabel:(GTKWidget *) menu_label;
- (void) setMenuLabelText:(GTKWidget *) child menuText:(NSString *) menu_text;
- (void) queryTabLabelPacking:(GTKWidget *) child expand:(gboolean *) expand fill:(gboolean *) fill packType:(GtkPackType *) pack_type;
- (void) setTabLabelPacking:(GTKWidget *) child expand:(gboolean) expand fill:(gboolean) fill packType:(GtkPackType) pack_type;
- (void) reorderChild:(GTKWidget *) child position:(gint) position;
@end

#endif /* GTOOLKIT_GTKNOTEBOOK_H */
