/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * BeOS Port
 * Copyright (C) 1999 EventLoop, Inc.
 *   Shawn T. Amundson <amundson@gtk.org>
 *   James Mitchell <mitchell@eventloop.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#include <Window.h>

#include "gdk_bview.h"
#include "gdkprivate.h"
#include "gdk/gdk.h"
#include <stdio.h>

extern GdkWindow *p_grab_window;
extern gboolean  *p_grab_owner_events;
extern GdkEventMask p_grab_event_mask;

gboolean do_motion_hints = 1;

GdkBViewPrivate::GdkBViewPrivate(BRect frame, const char *name, 
                   uint32 resizeMask, uint32 flags)
  : BView(frame, name, resizeMask, flags)
{
}

void
GdkBViewPrivate::Draw(BRect rect)
{
  GdkEvent event;
  GdkWindow *window;

  window = gdk_window_lookup(this); 

  g_return_if_fail(window != NULL);

  /* printf("draw %#x, %#x\n", this, window); */

  event.expose.type = GDK_EXPOSE;
  event.expose.window = window; 
  event.expose.area.x = (int) rect.left;
  event.expose.area.y = (int) rect.top;
  event.expose.area.width = (int) rect.Width() + 1;
  event.expose.area.height = (int) rect.Height() + 1;
  event.expose.count = 0;

  GDK_NOTE (EVENTS, g_print("Event: Expose: window %p  x,y %d,%d  wxh %dx%d\n", 
                            window, 
                            event.expose.area.x,
                            event.expose.area.y,
                            event.expose.area.width,
                            event.expose.area.height));

  gdk_event_put(&event);
}

void
GdkBViewPrivate::MouseMoved(BPoint unused_point, uint32 transit, const BMessage *msg)
{
  GdkEvent event;
  GdkWindow *window;
  GdkWindow *topwin;
  GdkWindowPrivate *window_private;
  GdkEventMask mask;
  uint32 buttons;
  int32 root_x;
  int32 root_y;
  BPoint point;
  BView *view;
  
  window = gdk_window_lookup(this);
  topwin = gdk_window_lookup(Window());

  g_return_if_fail(window != NULL);
  g_return_if_fail(topwin != NULL);

  window_private = (GdkWindowPrivate*) window;
  mask = (GdkEventMask) window_private->event_mask;

  if (Window()->Lock())
    {
      GdkWindowPrivate *topwin_private;
      BView *topwin_view;
      BWindow *topwin_window;
      BPoint topwin_mouse;
      BRect win_frame;

      GetMouse(&point, &buttons);

      topwin_private = (GdkWindowPrivate*)topwin;
      topwin_view = (BView*) topwin_private->xwindow;
      if (topwin_view->Window()->Lock())
        {
          topwin_view->GetMouse(&topwin_mouse, &buttons);
          topwin_view->Window()->Unlock();
        }

      topwin_window = (BWindow*) topwin_private->bewindow;
      win_frame = topwin_window->Frame();

      root_x = (int32) (win_frame.left + topwin_mouse.x);
      root_y = (int32) (win_frame.top + topwin_mouse.y);

      Window()->Unlock();
    }

  switch (transit)
    {
      case B_ENTERED_VIEW:
        event.crossing.type = GDK_ENTER_NOTIFY;
        event.crossing.window = window;
        event.crossing.subwindow = NULL;
        event.crossing.time = time(NULL);
        event.crossing.x = (gdouble) point.x;
        event.crossing.y = (gdouble) point.y;
        event.crossing.x_root = (gdouble) root_x;
        event.crossing.y_root = (gdouble) root_y;
        event.crossing.mode = GDK_CROSSING_NORMAL;
        event.crossing.detail = GDK_NOTIFY_UNKNOWN;
        event.crossing.focus = 0;
        event.crossing.state = 0;

        GDK_NOTE (EVENTS, g_print("Event: EnterNotify: window %p  x,y %dx%d\n", 
                                  window, 
                                  (gint) event.crossing.x,
                                  (gint) event.crossing.y));

        gdk_event_put(&event);

        do_motion_hints = 1;

        break;
      case B_EXITED_VIEW:
        event.crossing.type = GDK_LEAVE_NOTIFY;
        event.crossing.window = window;
        event.crossing.subwindow = NULL;
        event.crossing.time = time(NULL);
        event.crossing.x = (gdouble) point.x;
        event.crossing.y = (gdouble) point.y;
        event.crossing.x_root = (gdouble) root_x;
        event.crossing.y_root = (gdouble) root_y;
        event.crossing.mode = GDK_CROSSING_NORMAL;
        event.crossing.detail = GDK_NOTIFY_UNKNOWN;
        event.crossing.focus = 0;
        event.crossing.state = 0;

        GDK_NOTE (EVENTS, g_print("Event: LeaveNotify: window %p  x,y %d,%d\n", 
                                  window, 
                                  (gint) event.crossing.x,
                                  (gint) event.crossing.y));

        gdk_event_put(&event);

        do_motion_hints = 1;

        break;
      case B_INSIDE_VIEW:

        view = (BView*) ((GdkWindowPrivate*) window)->xwindow;
        
        if (view->Window()->Lock())
          {
            view->GetMouse(&point, &buttons);
            view->Window()->Unlock();
          }

        event.motion.window = window;

        if (p_grab_window
            && !p_grab_owner_events)
          {   
            GDK_NOTE (EVENTS, 
                      g_print("Event: MotionNotify: ...grabbed, owner_events FALSE\n"));
            mask = p_grab_event_mask;
            if (!((mask & GDK_POINTER_MOTION_MASK)
                  || ((buttons & (B_PRIMARY_MOUSE_BUTTON
                                  |B_SECONDARY_MOUSE_BUTTON
                                  |B_TERTIARY_MOUSE_BUTTON))
                      && (mask & GDK_BUTTON_MOTION_MASK))
                  || ((buttons & B_PRIMARY_MOUSE_BUTTON)
                      && (mask & GDK_BUTTON1_MOTION_MASK))
                  || ((buttons & B_SECONDARY_MOUSE_BUTTON)
                      && (mask & GDK_BUTTON2_MOTION_MASK))
                  || ((buttons & B_TERTIARY_MOUSE_BUTTON)
                      && (mask & GDK_BUTTON3_MOTION_MASK))))
              break;
            else
              event.motion.window = p_grab_window;
          }
        else if (window_private
                 && (!((mask & GDK_POINTER_MOTION_MASK)
                       || ((buttons & (B_PRIMARY_MOUSE_BUTTON
                                       |B_SECONDARY_MOUSE_BUTTON
                                       |B_TERTIARY_MOUSE_BUTTON))
                           && (mask & GDK_BUTTON_MOTION_MASK))
                       || ((buttons & B_PRIMARY_MOUSE_BUTTON)
                           && (mask & GDK_BUTTON1_MOTION_MASK))
                       || ((buttons & B_SECONDARY_MOUSE_BUTTON)
                           && (mask & GDK_BUTTON2_MOTION_MASK))
                       || ((buttons & B_TERTIARY_MOUSE_BUTTON)
                           && (mask & GDK_BUTTON3_MOTION_MASK)))))
                     
          {


            if (p_grab_window != NULL
                && p_grab_owner_events)
              {
                GDK_NOTE (EVENTS, 
                          g_print("Event: MotionNotify: ...grabbed, owner_events TRUE\n"));
                mask = p_grab_event_mask;
                if (!((mask & GDK_POINTER_MOTION_MASK)
                    || ((buttons & (B_PRIMARY_MOUSE_BUTTON
                                    |B_SECONDARY_MOUSE_BUTTON
                                    |B_TERTIARY_MOUSE_BUTTON))
                        && (mask & GDK_BUTTON_MOTION_MASK))
                    || ((buttons & B_PRIMARY_MOUSE_BUTTON)
                        && (mask & GDK_BUTTON1_MOTION_MASK))
                    || ((buttons & B_SECONDARY_MOUSE_BUTTON)
                        && (mask & GDK_BUTTON2_MOTION_MASK))
                    || ((buttons & B_TERTIARY_MOUSE_BUTTON)
                        && (mask & GDK_BUTTON3_MOTION_MASK))))
                   break;
                 else
                   event.motion.window = p_grab_window;
              }
            else
              {
                GDK_NOTE (EVENTS, g_print("Event: MotionNotify: no one wants it, should propogate (unimplemented)\n"));
                return;
              }
          }

        mask = ((GdkWindowPrivate*) event.motion.window)->event_mask;
        if ((mask & GDK_POINTER_MOTION_HINT_MASK)
            && !do_motion_hints)
          {
            GDK_NOTE (EVENTS, g_print ("Event: Motion: ignoring, do_motion_hints==0\n"));
            return;
          }

        view = (BView*) ((GdkWindowPrivate*) event.motion.window)->xwindow;
        
        if (view->Window()->Lock())
          {
            view->GetMouse(&point, &buttons);
            view->Window()->Unlock();
          }

        event.motion.type = GDK_MOTION_NOTIFY;
        event.motion.time = time(NULL);
        event.motion.x = (gdouble) point.x;
        event.motion.y = (gdouble) point.y;
        event.motion.x_root = (gdouble) root_x;
        event.motion.y_root = (gdouble) root_y; 
        event.motion.pressure = 0.5;
        event.motion.xtilt = 0;
        event.motion.ytilt = 0;
        event.motion.state = 0;
        if (buttons & B_PRIMARY_MOUSE_BUTTON)
          event.motion.state |= GDK_BUTTON1_MASK;
        if (buttons & B_SECONDARY_MOUSE_BUTTON)
          event.motion.state |= GDK_BUTTON2_MASK;
        if (buttons & B_TERTIARY_MOUSE_BUTTON)
          event.motion.state |= GDK_BUTTON3_MASK;
        if (mask & GDK_POINTER_MOTION_HINT_MASK)
          {
            event.motion.is_hint = 1;
            do_motion_hints = 0;
          }
        else
          event.motion.is_hint = 0;
        event.motion.source = GDK_SOURCE_MOUSE;
        event.motion.deviceid = GDK_CORE_POINTER;

        GDK_NOTE (EVENTS, 
                 g_print("Event: MotionNotify: window %p  x,y %dx%d  hint %d  buttons: %s %s %s\n", 
                         window, 
                         (gint) event.motion.x,
                         (gint) event.motion.y,
                         (gint) event.motion.is_hint,
                         (event.motion.state & GDK_BUTTON1_MASK ? "1" : "."),
                         (event.motion.state & GDK_BUTTON2_MASK ? "2" : "."),
                         (event.motion.state & GDK_BUTTON3_MASK ? "3" : ".")));

        gdk_event_put(&event);

        break;
    }
}
